		include 	stdlib.a
		includelib	stdlib.lib
		include		lists.a

NodeSize	equ	(size Node)
NodeTyp		struc
		db	NodeSize dup (0)
NodeString	db	"     "
		db	0
NodeTyp		ends


dseg		segment	para public 'data'

MyList		list	<(size NodeTyp) - NodeSize>
Node1		NodeTyp	<," -1- ">
Node2		NodeTyp	<," -2- ">
Node3		NodeTyp	<," -3- ">
Node4		NodeTyp	<," -4- ">

Data5		db	" -5- ",0

dseg		ends




cseg		segment	para public 'code'
		assume	cs:cseg, ds:dseg

;
		public	PSP
PSP		dw	?


; PrintDXSI- Prints the string pointed at by DX:SI.

PrintDXSI	proc
		push	es
		push	di
		mov	es, dx
		mov	di, si
		puts
		pop	di
		pop	es
		ret
PrintDXSI	endp


; PrintList- Prints the list whose list variable is pointed at by ES:DI

PrintList	proc
		push	es
		push	di
		push	dx
		push	si

		les	di, es:[di].List.Head
PrintLp:	mov	dx, es
		cmp	dx, 0
		jz	PrtDone
		lea	si, [di+NodeSize]
		call	PrintDXSI
		les	di, es:[di].Node.Next
		jmp	PrintLp

PrtDone:	putcr
		pop	si
		pop	dx
		pop	di
		pop	es
		ret
PrintList	endp


;
;
;
Main		proc
		mov	cs:PSP, es		;Save pgm seg prefix
		mov	ax, seg dseg		;Set up the segment registers
		mov	ds, ax
		mov	es, ax
;
		mov	dx, 0
		meminit
		jnc	GoodMemInit

		print
		db	"Error initializing memory manager",cr,lf,0
		jmp	Quit
GoodMemInit:


;****************************************************************
;
; FIFO Queue routines test code
;
;****************************************************************

		print
		db	"Testing the FIFO Queue Stuff: appendLast, appendlastm"
		db	cr,lf,0

		lesi	MyList
		ldxi	Node1
		AppendLast
		call	PrintList

		ldxi	Node2
		lesi	MyList
		AppendLast
		call	PrintList

		ldxi	Node3
		lesi	MyList
		AppendLast
		call	PrintList

		ldxi	Node4
		lesi	MyList
		AppendLast
		call	PrintList

		ldxi	Data5
		lesi	MyList
		AppendLastm
		call	PrintList

		print
		db	cr,lf,lf
		db	"Testing: Peek1st, Remove1st",cr,lf,lf,0

EmptyTheList:	lesi MyList
		Peek1st
		jc	EndOfFIFO
		print
		db	"Removing: ",0
		mov	es, dx
		lea	di, NodeSize[si]
		puts
		putcr

		lesi	MyList
		call	PrintList
		Remove1st
		call	PrintList

; If this node was allocated on the heap (Node5 above), free it here.

		mov	es, dx
		mov	di, si
		IsInHeap
		jnc	NotInHeap
		free

NotInHeap:	putcr
		jmp	EmptyTheList

EndOfFIFO:	putcr



;****************************************************************
;
; Deque routines test code
;
;****************************************************************

		print
		db	cr,lf
		db	"Testing the Deque routines:"
		db	"Insert1st, Insert1stm, AppendLast",cr,lf
		db	0

		lesi	MyList
		ldxi	Node1
		Insert1st
		call	PrintList
		putcr

		ldxi	Node2
		Insert1st
		call	PrintList
		ldxi	Node2
		AppendLast
		call	PrintList
		putcr

		ldxi	Node3
		Insert1st
		call	PrintList
		ldxi	Node3
		AppendLast
		call	PrintList
		putcr

		ldxi	Node4
		Insert1st
		call	PrintList
		ldxi	Node4
		AppendLast
		call	PrintList
		putcr

		ldxi	Data5
		Insert1stm
		call	PrintList

		print
		db	cr,lf,lf
		db	"Testing PeekLast, RemoveLast, Remove1st",cr,lf,0

EmptyTheList2:	lesi	MyList
		PeekLast
		jc	EndOfDeque
		mov	es, dx
		lea	di, NodeSize[si]
		puts
		print
		db	"-- Removed: ",0

		lesi	MyList
		RemoveLast

; If this node was allocated on the heap (Node5 above), free it here.

		mov	es, dx
		mov	di, si
		IsInHeap
		jnc	NotInHeap2
		free

NotInHeap2:	lea	di, NodeSize[si]
		puts
		putcr

		cmp	word ptr  MyList.CurrentNode+2, 0
		je	NoNext2

		print
		db	"Next: ",0
		les	di, MyList.CurrentNode
		add	di, NodeSize
		puts

NoNext2:	putcr
		putcr
		jmp	EmptyTheList2

EndOfDeque:



;****************************************************************
;
; General List Manipulation Routines:
;
;****************************************************************

		print
		db	cr,lf
		db	"Testing the general list routines:",cr,lf
		db	0

; The list is currently empty, so inserting at the current node should
; put a new entry into the list.

		lesi	MyList
		ldxi	Node1
		InsertCur
		print
		db	"Node1: ",0
		peekcur
		mov	es, dx
		lea	di, NodeSize[si]
		puts
		putcr

		lesi	MyList
		ldxi	Node2
		InsertCur
		print
		db	"Node2: ",0
		peekcur
		mov	es, dx
		lea	di, NodeSize[si]
		puts
		putcr

		ldxi	Node3
		lesi	MyList
		InsertCur
		print
		db	"Node3: ",0
		peekcur
		mov	es, dx
		lea	di, NodeSize[si]
		puts
		putcr

		ldxi	Node4
		lesi	MyList
		InsertCur
		print
		db	"Node4: ",0
		peekcur
		mov	es, dx
		lea	di, NodeSize[si]
		puts
		putcr

		ldxi	Data5
		lesi	MyList
		InsertCurm
		print
		db	"Node5: ",0
		peekcur
		mov	es, dx
		lea	di, NodeSize[si]
		puts
		putcr

EmptyTheList3:	lesi	MyList
		RemoveCur
		jc	EndofList

; If this node was allocated on the heap (Node5 above), free it here.

		mov	es, dx
		mov	di, si
		IsInHeap
		jnc	NotInHeap3
		free

NotInHeap3:	print
		db	"Removed: ",0
		lea	di, NodeSize[si]
		puts
		putcr
		jmp	EmptyTheList3

EndOfList:

Quit:		ExitPgm
Main		endp

cseg            ends



; Allocate a reasonable amount of space for the stack (2k).

sseg		segment	para stack 'stack'
stk		db	256 dup ("stack   ")
sseg		ends


; zzzzzzseg must be the last segment that gets loaded into memory!

zzzzzzseg	segment	para public 'zzzzzz'
LastBytes	db	16 dup (?)
zzzzzzseg	ends
		end	Main
