'----------------------------------------------------------------------------
'                         **    B7T-DEMO.BAS    **
'      Demonstration of the capabilities of the B7Tool Library routines
'       Written for and compiled with Microsoft (R), BASIC 7.x PDS (C)
'                        By R. J. Crouch  -  May 1992
'                      Copyright  -  1992  -  CareWare
'                            All Rights Reserved
'----------------------------------------------------------------------------

REM $INCLUDE: 'B7T.BI'                            ' Contains declarations for
                                                  '  Ctr() and Delay()
DEFINT A-Z

TYPE RegType                                      ' Necessary for the CALL to
   ax    AS INTEGER                               ' QB's Interrupt() routine
   bx    AS INTEGER                               ' used to clear the screen
   cx    AS INTEGER                               ' at end of demo
   dx    AS INTEGER                               ' Generally placed in the
   bp    AS INTEGER                               ' "$INCLUDE:" file
   si    AS INTEGER                               '
   di    AS INTEGER                               '
   flags AS INTEGER                               '
END TYPE                                          '
                                                  
DIM InReg AS RegType, OutReg AS RegType               ' Typed for Interrupt()
DIM Menu(5, 4) AS STRING                        ' Array for BarMenu() routine
DIM ScrnBuf(8) AS STRING * 4000                          ' Room for 9 screens
                                                         '  w/ option base 0
FALSE = 0: TRUE = NOT FALSE                                           ' Flags
CONST CONT = "Press any key to continue..."                         ' Prompts
CONST MCONT = "Left mouse button to continue..."                    '

Menu(0, 0) = "0303020401"          '<== Contains upper limits of each 2nd dim-
                                      ' ension for each 1st dimension of any
Menu(1, 0) = " Menu Item #1 "         ' menu array.  The field for each value
Menu(1, 1) = " Select Item #1 "       ' is 2 characters in length.
Menu(1, 2) = " Do Item #2     "       '
Menu(1, 3) = " Pick Item #3   "       '     1st Dim      1   2   3   4   5
                                      '
Menu(2, 0) = " Item #2 "              '  # of level 2   03  03  02  04  01
Menu(2, 1) = " #1           "         '  menu items
Menu(2, 2) = " Level 2 - #2 "         '
Menu(2, 3) = " #3           "         ' 2nd dim. of any menu array must be as
                                      ' large as the largest 1st dim. set.
Menu(3, 0) = " Level #1 Item #3 "     ' ie.  since 1st dim. 4 of Menu() has 4
Menu(3, 1) = " Pick Item #1      "    ' 2nd dim. items - Menu() must be DIMed
Menu(3, 2) = " Show This Item #2 "    ' DIM Menu(5, 4) AS STRING
                                      '             |-- largest number of 2nd
Menu(4, 0) = " Selection #4 "         '                 dimension items
Menu(4, 1) = " Sub Menu Item #1  " '<== The window width of the level 2 menu
Menu(4, 2) = " Sub Item #2       "    ' is determined by the length of ele-
Menu(4, 3) = " Sub Level Item #3 "    ' ment 1 of the 2nd dim.  All strings
Menu(4, 4) = " Sub Menu Item #4  "    ' should be as long as the longest item
                                      ' title.  Spaces at start and end of
Menu(5, 0) = " Quit "                 ' string are not required, but present a
Menu(5, 1) = " Exit Menu Demo "       ' better looking menu when highlighting.

b1$ = CHR$(221) + " ": b2$ = " " + CHR$(222)                       ' Brackets
cpyr$ = b1$ + "Copyright - 1992 - CareWare" + b2$
mpos1$ = b1$ + "Row ## - Col ##" + b2$                         ' Formats for
mpos2$ = b1$ + "Y ###  -  X ###" + b2$                         '  PRINT USING
buttons = 0
                                    
'ON KEY(10) GOSUB Terminate                                 ' For programming
'KEY(10) ON                                                 '  purposes only

'----------------------------------------------------------------------------
'Title Screen
'----------------------------------------------------------------------------

   COLOR 7, 0, 0: CLS
   CALL DoWindow(1, 3, 25, 76, 103, 5, 0, "B7Tool Demo - Ver. 1.2", 2)
   CALL PrtScrn(cpyr$, 25, 24, 103)
   CALL DoWindow(3, 13, 16, 56, 15, 5, 3, CONT, 3)
   FOR row = 5 TO 14
      READ line$: lctr = Ctr(line$) + 1
      IF row < 8 THEN att = 12 ELSE att = 14
      CALL PrtScrn(line$, row, lctr, att)
   NEXT row
   READ line$
   CALL PrtScrn(line$, row + 1, lctr, 10)
   CALL PrtScrn("  ", 21, 11, 103)
   CALL PrtScrn("", 22, 11, 103)
   CALL PrtScrn("Software", 23, 11, 103)
   CALL PrtScrn("by  R. J. Crouch", 21, 55, 103)
   CALL PrtScrn("Member", 22, 65, 103)
   CALL PrtScrn(" ssociation of  hareware  rofessionals", 23, 33, 103)
   CALL PrtScrn("A", 23, 33, 96)
   CALL PrtScrn("S", 23, 48, 96)
   CALL PrtScrn("P", 23, 58, 96)
   CALL PutScrn(ScrnBuf(0))
   WHILE INKEY$ = "": WEND                       ' Typical wait for key press
   CALL MouseStatus(have)                         ' Check for mouse interrupt
   IF have THEN                                            ' Ask to use mouse
      CALL DoWindow(7, 16, 12, 49, 12, 1, 0, "", 0)
      CALL MouseVersion(ver$)
      FOR row = 9 TO 14
         READ line$
         lcrt = Ctr(line$)
         CALL PrtScrn(line$, row, lctr, 14)
         IF row = 10 THEN
            CALL PrtScrn(ver$, row, lctr + 26, 10)
            CALL PrtScrn(".", row, lctr + 26 + LEN(ver$), 14)
         END IF
      NEXT row
      finish! = TIMER + 30
      DO
         i$ = UCASE$(INKEY$)                                   ' Wait for key
         now! = TIMER                                          '  or 30 sec.
      LOOP UNTIL i$ = "N" OR i$ = "Y" OR now! > finish!
      IF i$ = "Y" THEN                              ' Initialize mouse driver
         prompt$ = MCONT: pctr = Ctr(MCONT)                ' Use mouse prompt
         CALL MouseReset(buttons)                       ' Return # of buttons
         Mouse = TRUE
      ELSE                                                 ' Mouse not wanted
         prompt$ = CONT: pctr = Ctr(CONT)                    ' Use key prompt
         Mouse = FALSE
      END IF
      CALL PrtScrn(prompt$, 16, pctr, 10)
      CALL Delay(30, 0, Mouse)
   ELSE                                                   ' No mouse detected
      FOR x = 1 TO 6: READ nul$: NEXT x                ' Skip mouse text data
   END IF
   CALL GetScrn(ScrnBuf(0))                         ' Retrieve opening screen
   IF Mouse THEN CALL PrtScrn(b1$ + prompt$ + b2$, 18, pctr - 2, 15)
   CALL Delay(60, 0, Mouse)
   CLS
   CALL DoWindow(8, 14, 9, 53, 13, 5, 3, prompt$, 3)
   FOR row = 11 TO 13
      READ line$: lctr = Ctr(line$)
      CALL PrtScrn(line$, row, lctr, 15)
   NEXT row
   CALL Delay(60, 0, Mouse)

'----------------------------------------------------------------------------
'Frame types and screen save/restore
'----------------------------------------------------------------------------

   COLOR 0, 0, 0: CLS
   col = 0: frm = -1: scrn = -1
   bgd = 0: fgd = 15
   FOR row = 2 TO 14 STEP 3
      col = col + 6: bgd = bgd + 1
      frm = frm + 1: fgd = fgd - 1
      watt = (bgd * 16) + fgd
      CALL DoWindow(row, col, 10, 20, watt, frm, 0, "Window", 2)
      scrn = scrn + 1
      CALL PutScrn(ScrnBuf(scrn))                   ' Screen save w/PutScrn()
   NEXT row
   FOR row = 11 TO 2 STEP -3
      col = col + 6: bgd = bgd + 1
      frm = frm + 1: fgd = fgd - 1
      IF frm = 6 THEN frm = 1
      IF bgd = 9 THEN bgd = 1
      watt = (bgd * 16) + fgd
      CALL DoWindow(row, col, 10, 20, watt, frm, 0, "B7Tool", 3)
      IF scrn < 8 THEN                             ' Save all but last screen
         scrn = scrn + 1
         CALL PutScrn(ScrnBuf(scrn))             ' Save screens for later use
      END IF
   NEXT row
   FOR row = 3 TO 9
      READ line$
      CALL PrtScrn(line$, row, col + 2, 31)
   NEXT row
   CALL PrtScrn(prompt$, 25, pctr, 10)
   CALL Delay(60, 0, Mouse)
   CALL DoWindow(9, 12, 7, 56, 15, 5, 0, "", 3)
   FOR row = 11 TO 13
      READ line$: lctr = Ctr(line$)
      CALL PrtScrn(line$, row, lctr, 10)
   NEXT row
   CALL Delay(60, 0, Mouse)
   FOR show = 7 TO 0 STEP -1
      CALL GetScrn(ScrnBuf(show))                    ' Retrieve saved screens
   NEXT show
   FOR row = 5 TO 7
      CALL PrtScrn("*  Fast  *", row, 11, 16)
   NEXT row
   CALL Delay(2, 0, Mouse)
   CALL DoWindow(10, 12, 7, 56, 15, 5, 0, prompt$, 3)
   FOR row = 12 TO 13
      READ line$: lctr = Ctr(line$)
      CALL PrtScrn(line$, row, lctr, 10)
   NEXT row
   CALL Delay(60, 0, Mouse)
   FOR show = 1 TO 8
      CALL GetScrn(ScrnBuf(show))                ' Screen restore w/GetScrn()
      CALL Delay(.33, 0, Mouse)                        '  .33 second delay added
   NEXT show
   CALL PrtScrn("Now a three", 5, 58, 31)
   CALL PrtScrn("second pause", 7, 58, 31)
   CALL Delay(3, 0, Mouse)
   FOR show = 8 TO 0 STEP -1
      CALL GetScrn(ScrnBuf(show))
      CALL Delay(.33, 0, Mouse)
   NEXT show
   CALL DoWindow(2, 6, 10, 20, 116, 5, 0, "B7Tool", 2)
   CALL PrtScrn("*  Next  *", 5, 11, 112)
   CALL PrtScrn("Shadow Styles", 7, 10, 112)
   CALL PrtScrn(prompt$, 25, pctr, 10)
   CALL Delay(60, 0, Mouse)

'----------------------------------------------------------------------------
'Shadowing
'----------------------------------------------------------------------------

   CLS
   CALL DoWindow(1, 1, 25, 80, 57, 5, 0, prompt$, 3)
   CALL DoWindow(2, 21, 3, 38, 112, 1, 0, "", 0)
   CALL DoWindow(6, 41, 18, 35, 17, 0, 0, "", 0)
   READ line$: lctr = Ctr(line$)
   CALL PrtScrn(line$, 3, lctr, 117)
   FOR row = 7 TO 19 STEP 6                           ' print boxes w/shadows
      FOR col = 8 TO 43 STEP 35
         shadow = shadow + 1
         back = back + 1
         watt = (back * 16) + 14
         IF row = 19 THEN                                         ' print x's
            IF col = 8 THEN
               FOR r = row TO row + 4
                  CALL PrtScrn(STRING$(34, "x"), r, col - 3, 62)
               NEXT r
            ELSE
               FOR r = row TO row + 4
                  CALL PrtScrn(STRING$(34, "x"), r, col - 1, 30)
               NEXT r
               back = 3
               watt = (back * 16) + 14
            END IF
         END IF
         CALL DoWindow(row, col, 4, 30, watt, frame, shadow, "", 0)
         frame = frame + 1
         FOR x = row + 1 TO row + 2
            READ line$
            CALL PrtScrn(line$, x, col + 5, back * 16)
         NEXT x
      NEXT col
      back = back + 1
   NEXT row
   CALL PutScrn(ScrnBuf(0))
   CALL Delay(60, 0, Mouse)
   CALL DoWindow(8, 9, 10, 62, 14, 5, 0, prompt$, 3)
   FOR row = 10 TO 14
      READ line$: lctr = Ctr(line$)
      IF row < 12 THEN att = 15 ELSE att = 10
      CALL PrtScrn(line$, row, lctr, att)
   NEXT row
   CALL Delay(60, 0, Mouse)
   CALL GetScrn(ScrnBuf(0))
   CALL DoWindow(11, 12, 7, 57, 11, 5, 0, prompt$, 3)
   FOR row = 13 TO 14
      READ line$
      CALL PrtScrn(line$, row, 18, 15)
   NEXT row
   CALL Delay(60, 0, Mouse)

'----------------------------------------------------------------------------
'MenuDemo
'----------------------------------------------------------------------------

   COLOR 1, 1, 0: CLS
   DO
      R1 = 2: R2 = 0
      CALL PrtScrn("Use the arrow keys to highlight and press <ENTER> to select.", 12, 10, 31)
      IF Mouse THEN
         CALL PrtScrn("or", 13, 39, 31)
         CALL PrtScrn("Roll your mouse to highlight and press the LEFT button to select.", 14, 8, 31)
      END IF
      CALL BarMenu(Menu(), 11, 4, 120, 112, 79, 6, Mouse, R1, R2)

      ' Generally placed after this CALL is some type of selectional
      ' trapping.  The following remarked section outlines a brief example
      ' of one type of system.  The number of CASEs required depends on the
      ' number of items per menu level.
      '
      ' SELECT CASE R1                     Level #1
      '    CASE 0
      '       SELECT CASE R2               Level #2
      '          CASE 0
      '             <ESC> key or RIGHT mouse button pressed
      '          CASE ELSE
      '       END SELECT
      '    CASE 1
      '       SELECT CASE R2               Level #2
      '          CASE 1
      '             Do this
      '          CASE 2
      '             Do this instead
      '          Etc...
      '          CASE ELSE
      '       END SELECT
      '    CASE 2
      '       SELECT CASE R2
      '          CASE 1
      '             Now do this
      '          CASE 2
      '             Do this instead
      '          Etc...
      '          CASE ELSE
      '       END SELECT
      '    Etc...
      '    Etc...
      '    CASE ELSE
      ' END SELECT

      IF Mouse THEN CALL MouseVisible(0)
      CALL DoWindow(8, 12, 11, 57, 6, 5, 0, prompt$, 3)
      CALL PrtScrn("The following values were returned.", 11, 23, 14)
      CALL PrtScrn("Level 1 menu item is ==>" + STR$(R1), 13, 27, 11)
      CALL PrtScrn("Level 2 menu item is ==>" + STR$(R2), 15, 27, 11)
      CALL Delay(0, 0, Mouse)
      CALL DoWindow(8, 12, 11, 57, 17, 0, 0, "", 0)
   LOOP UNTIL (R1 = 5 AND R2 = 1)
   CLS
   CALL DoWindow(9, 12, 7, 57, 13, 5, 0, prompt$, 3)
   FOR row = 11 TO 12
      READ line$
      CALL PrtScrn(line$, row, 21, 15)
   NEXT row
   CALL Delay(60, 0, Mouse)
 
'----------------------------------------------------------------------------
'Equipment and System Information
'----------------------------------------------------------------------------

   CALL GetDrive(DrvTot, CurDrv)
   Avail& = CurDrv
   CALL DriveSpc(Avail&)
   CALL GetVideo(VMode, VPage, VCol, CStrt, CStp, CAtt)
   CALL GetDOS(Dver$)
   usefile$ = "B7T-DEMO.EXE"
   CALL GetSize(usefile$, FSize&)
   CALL GetComPorts(ComP)
   CALL Get87(ins)
   IF ins THEN CP$ = "Yes" ELSE CP$ = "No"
   CALL DoWindow(3, 8, 20, 65, 7, 5, 0, "Equipment and System Information", 2)
   CALL PrtScrn(b1$ + prompt$ + b2$, 22, pctr - 2, 7)
   CALL PrtScrn("     The Current Drive:  " + CHR$(CurDrv + 64) + ":", 6, 21, 11)
   CALL PrtScrn("Total Drives Installed: " + STR$(DrvTot), 7, 21, 11)
   CALL PrtScrn("     Current Directory:  " + CURDIR$, 8, 21, 11)
   CALL PrtScrn("  Disk Space Available: " + STR$(Avail&) + " Bytes", 9, 21, 11)
   CALL PrtScrn("    Current Video Mode: " + STR$(VMode), 10, 21, 11)
   CALL PrtScrn("    Current Video Page: " + STR$(VPage), 11, 21, 11)
   CALL PrtScrn("     Number of Columns: " + STR$(VCol), 12, 21, 11)
   CALL PrtScrn("     Cursor Start Line: " + STR$(CStrt), 13, 21, 11)
   CALL PrtScrn("      Cursor Stop Line: " + STR$(CStp), 14, 21, 11)
   CALL PrtScrn("      Cursor Attribute: " + STR$(CAtt), 15, 21, 11)
   CALL PrtScrn("   Current DOS Version:  " + Dver$, 16, 21, 11)
   CALL PrtScrn("  Size of B7T-DEMO.EXE: " + STR$(FSize&) + " Bytes", 17, 21, 11)
   CALL PrtScrn("Number of Serial Ports: " + STR$(ComP), 18, 21, 11)
   CALL PrtScrn(" Coprocessor Installed:  " + CP$, 19, 21, 11)
   CALL Delay(60, 0, Mouse)
   CALL DoWindow(9, 12, 7, 57, 13, 5, 0, prompt$, 3)
   FOR row = 11 TO 12
      READ line$
      CALL PrtScrn(line$, row, 18, 15)
   NEXT row
   CALL Delay(60, 0, Mouse)
   
'----------------------------------------------------------------------------
'Mouse Services
'----------------------------------------------------------------------------

   mver$ = b1$ + "Mouse Driver ver. " + ver$ + "  -  "
   mstat$ = mver$ + "With" + STR$(buttons) + " buttons installed" + b2$
   sctr = Ctr(mstat$)

   CLS
   CALL DoWindow(1, 1, 25, 80, 30, 5, 0, "B7Tool", 2)
   CALL DoWindow(2, 31, 3, 20, 31, 1, 0, "", 0)
   CALL PrtScrn("Mouse Services", 3, 34, 31)
   CALL DoWindow(5, 5, 10, 35, 12, 5, 0, "Mouse State #1", 2)
   CALL DoWindow(7, 14, 3, 18, 12, 1, 0, "", 0)
   CALL DoWindow(5, 42, 10, 35, 12, 5, 0, "Mouse State #2", 2)
   CALL DoWindow(16, 7, 6, 68, 115, 5, 3, "", 0)
   FOR row = 17 TO 20
      READ line$
      CALL PrtScrn(line$, row, 10, 112)
   NEXT row
   CALL PutScrn(ScrnBuf(0))
   IF Mouse THEN
      CALL PrtScrn(mstat$, 25, sctr, 30)
      CALL MouseLimits(6, 6, 13, 38, 1)                 ' -------------------
      CALL MouseLocate(11, 22, 1)                       '
      CALL MouseCursor(9, 7, 30)                        '
      CALL MouseReset(2)                                ' Save mouse state #1
      CALL MouseVisible(1)                              ' Mouse pointer on
      DO
         CALL MouseClick(lft, mid, rgt)                 ' Typical wait for a
      LOOP UNTIL lft OR rgt                             ' mouse button
      IF rgt THEN
         CALL MouseLimits(6, 43, 13, 75, 1)             ' -------------------
         CALL MouseLocate(11, 59, 1)                    '
         CALL MouseCursor(14, 0, 24)                    '
         CALL MouseReset(4)                             ' Save mouse state #2

         pos$ = mpos1$: Mode = 1
         DO                                             ' Loop conditional to
            CALL MouseClick(lft, mid, rgt)              ' mouse button
            IF rgt AND switch THEN
               CALL MouseVisible(0)                   ' Turn old cursor off
               CALL MouseReset(5)                     ' Recall mouse state #2
               CALL MouseVisible(1)                   ' Turn new cursor on
               switch = FALSE
            ELSEIF rgt THEN
               CALL MouseVisible(0)                   ' Turn old cursor off
               CALL MouseReset(3)                     ' Recall mouse state #1
               CALL MouseVisible(1)                   ' Turn new cursor on
               CALL PrtScrn("Black Hole", 8, 18, 12)
               switch = TRUE
            END IF
            IF switch THEN                                   ' Mouse state #1
               CALL MouseExclude(7, 14, 9, 31, 1)           ' Black hole area
               CALL MousePosition(mr, mc, 1)                 ' Turn cursor on
               IF mr < 7 OR mr > 9 OR mc < 14 OR mc > 31 THEN ' outside of
                  CALL MouseVisible(1)                        ' excluded area
               END IF
            ELSE                                             ' Mouse state #2
               IF lft THEN                                     ' Toggle modes
                  IF Mode = 0 THEN
                     pos$ = mpos1$: Mode = 1
                  ELSE
                     pos$ = mpos2$: Mode = 0
                  END IF
               END IF
               CALL MousePosition(r, c, Mode)         ' Return mouse position
               LOCATE 14, 50: COLOR 12, 0: PRINT USING pos$; r; c
            END IF
         LOOP UNTIL lft AND switch
      END IF
      CALL MouseVisible(0)
      READ line$, line$
   ELSE                                                 ' Print no mouse text
      CALL PrtScrn("Black Hole", 8, 18, 12)
      CALL DoWindow(21, 7, 4, 68, 12, 1, 0, CONT$, 3)
      FOR row = 22 TO 23
         READ line$: lctr = Ctr(line$)
         CALL PrtScrn(line$, row, lctr, 14)
      NEXT row
      CALL Delay(60, 0, Mouse)
      CALL GetScrn(ScrnBuf(0))
   END IF
   CALL DoWindow(8, 12, 11, 56, 6, 5, 0, prompt$, 3)
   FOR row = 10 TO 16
      READ line$: lctr = Ctr(line$)
      IF row < 12 THEN att = 15 ELSE att = 10
      CALL PrtScrn(line$, row, lctr, att)
   NEXT row
   CALL Delay(60, 0, Mouse)

'----------------------------------------------------------------------------
'Closing
'----------------------------------------------------------------------------

   CLS
   CALL DoWindow(1, 1, 25, 80, 71, 5, 0, "B7Tool Demo - Ver. 1.2", 2)
   CALL DoWindow(3, 6, 21, 69, 15, 5, 0, "", 3)
   CALL PrtScrn(cpyr$, 25, 24, 71)
   READ line$: lctr = Ctr(line$)
   CALL PrtScrn(line$, 5, lctr, 12)
   FOR row = 7 TO 19
      READ line$: lctr = Ctr(line$)
      CALL PrtScrn(line$, row, lctr, 14)
   NEXT row
   CALL PrtScrn(prompt$, 21, pctr, 10)
   CALL Delay(90, 0, Mouse)

'----------------------------------------------------------------------------
Terminate:
'----------------------------------------------------------------------------
  
   IF Mouse THEN CALL MouseReset(0)

   ah = 7: al = 0                               ' Example of system Interrupt
   bh = 7: bl = 0                               '  to clear a screen (ie. CLS)
   ch = 0: cl = 0                               '  with int 10h function 7h
   dh = 24: dl = 79                             '  (ah = scroll down)
   InReg.ax = (ah * 256) + al                   ' Conversion of high and low
   InReg.bx = (bh * 256) + bl                   '  byte for acceptance by PDS
   InReg.cx = (ch * 256) + cl                   '
   InReg.dx = (dh * 256) + dl                   '
   CALL Interrupt(&H10, InReg, OutReg)          ' Returns nothing

   END


   DATA "Welcome to the world of the"
   DATA "B7Tool Library [B7T]"
   DATA ""," "
   DATA "This program is set up to demonstrate  the"
   DATA "features of the B7T Library.  This library"
   DATA "is  designed  to  work with Microsoft (R),"
   DATA "BASIC 7.x, PDS (C).   The source code  for"
   DATA "this demo is provided so you  can  examine"
   DATA "the  actual  usage  of these B7T routines."
   DATA "             Shall we begin?"
   DATA "This  program  detects  the presence of a"
   DATA "mouse driver; version no."
   DATA "Do  you wish to use your mouse throughout"
   DATA "this demonstration?"," "
   DATA "               (Y)  -  (N)"
   DATA "First you will see the various windowing"
   DATA "frame  styles and a demonstration of the"
   DATA "screen save and restore routines.       "
   DATA "B7Tool  offers a"
   DATA "wide variety  of"
   DATA "frame styles."
   DATA "----------------"
   DATA "The window title"
   DATA "can be placed at"
   DATA "top or bottom.  "
   DATA "Each window screen was saved with PutScrn()."
   DATA "We will now use  GetScrn()  and recall those"
   DATA "nine screens.                               "
   DATA "Now  we will add a .33 second delay  and"
   DATA "again recycle through the saved screens."
   DATA "**  Window Shadow Styles  **"
   DATA "left side and bottom"
   DATA "*  black in color  *"
   DATA "right side and bottom"
   DATA "*  black in  color  *"
   DATA "left side and bottom"
   DATA "*   tinted black   *"
   DATA "right side and bottom"
   DATA "*   tinted  black   *"
   DATA "left side and bottom"
   DATA "* shadow character *"
   DATA "right side and bottom"
   DATA "* shadow  character *"
   DATA "So far this demonstration has used  the  following"
   DATA "routines with a combined number of 72 occurrences."," "
   DATA "   MouseStatus() - DoWindow() - PrtScrn()   "
   DATA "   Delay() - PutScrn() - GetScrn() - Ctr()  "
   DATA "Next is a demonstration of the mouse and key"
   DATA "driven pull-down bar menu routine of B7Tool."
   DATA "Next is a list of equipment and system"
   DATA "information returned by B7Tool routines."
   DATA "Next will be a demonstration of  the  various"
   DATA "mouse services offered in the B7Tool Library."
   DATA "The right mouse button will toggle between the separate mouse"
   DATA "states.  While in mouse state #2,  the left mouse button will"
   DATA "toggle  between  modes  for  MousePosition().  While in mouse"
   DATA "state #1, the left mouse button will exit Mouse Services.    "
   DATA "Sorry, but a mouse driver is not detected by this program."
   DATA "A demonstration of the mouse services will not be done."
   DATA "The following routines are used in the mouse"
   DATA "services demonstration.                     ", " "
   DATA "MouseStatus()    MouseReset()     MousePosition()"
   DATA "MouseLocate()    MouseLimits()    MouseVersion() "
   DATA "MouseVisible()   MouseExclude()   MouseCursor()  "
   DATA "MouseClick()                                     "
   DATA "  ==   B7Tool Library (B7T)   =="
   DATA "This concludes the short demonstration of the features"
   DATA "offered by the B7Tool Library.  Nearly  every  routine"
   DATA "in  B7T  was used in this demo.  Over 2/3 of the lines"
   DATA "of code in this program contain  a  B7Tool  statement."
   DATA "The  features  offered  in  this library are common to"
   DATA "most programming needs.  The  prototypes  and  a  full"
   DATA "description  of  these  routines are documented in the"
   DATA "file B7TOOL.DOC.  Information on the object files  and"
   DATA "source codes for the routines in B7T is also available"
   DATA "in this file.                                         "," "
   DATA "Microsoft is a registered  trademark of the  Microsoft"
   DATA "Corporation.  Good Luck and Enjoy!                    "

'============================================================================
'
'      The source code for  this  demonstration  is  quite  simple.  It
'      should, however, give you a better idea as to the practical  use
'      of  the  B7Tool  library routines.  B7T is designed to be a lib-
'      rary containing the routines generally needed most.   The  mouse
'      services, DoWindow, & BarMenu are the backbone of  this library.
'      There's few programs, large  or  small,  that  couldn't  utilize
'      these features.
'
'      The   complete   B7Tool  Library  is  distributed  as  the  file
'      B7T12.EXE and contains the following files:
'
'                B7T.LIB          B7T.QLB          B7T.BI
'                B7TOOL.DOC       B7T-DEMO.BAS     B7T-DEMO.EXE
'                REGISTER.TXT     VENDOR.DOC       FILE_ID.DIZ
'
'      Information  on  the availability of the source and object codes
'      for B7Tool is found in  the  file  B7TOOL.DOC.  You  can  always
'      obtain the latest version of B7Tool from CompuServe (R), IBMPRO,
'      LIB 4 (Browse B7T) or directly from CareWare.
'
'      B7Tool is copyrighted to the author with all rights reserved and
'      is  distributed  as  a Shareware product.  If you acquire B7Tool
'      and decide to use its services beyond a  30  day  trail  period,
'      than  a  registration fee of $25.00 (US) is required.  This fee,
'      when paid, entitles you  to  full  usage  and  support  of  this
'      product,  and  the  latest  version of B7Tool and individual QBJ
'      modules on disk.
'
'                                           _______
'                                      ____|__     |                (R)
'      R. J. Crouch                 --|       |    |-------------------
'      CareWare                       |   ____|__  |  Association of
'      10217 Ridge View Dr.           |  |       |_|  Shareware
'      Grass Valley, CA  95945        |__|   o   |    Professionals
'      (916) 477-6024               -----|   |   |---------------------
'      CIS - 74270,516                   |___|___|    MEMBER
'
'
'      Microsoft is registered trademark of the Microsoft Corporation.
'
'============================================================================

