'CANEDIT is an input editor for QuickBASIC
'It is loosely based on a program from the magazine PC RESOURCES, October 1987, pg. 61
'This version was written by:   Bert Christensen
'                               Rosewood Software
'                               135-10 Livonia Place
'                               Scarborough, Ontario, Canada M1E 4W6
'                               (416) 284-6119, CompuServe 70461,2507
'                               USENET: bert.christensen@canrem.uucp
'                               I also monitor the RIME QuickBasic conference
'
'                               Copyright 1991
'
'Anyone is granted full permission to use all or part of this program without charge.
'
'Some parts of this program may look ancient with its IF..ENDs and GOTOs.
'However, I like to have the ability to cascade through the editor. See
'how scan% = 8 becomes scan% = 83 in the backspace command area. The program
'could be written using only DO..LOOP, SELECT CASE etc. but I doubt that it
'would make the program work better. It would be prettier though.
'
'Any comments would be appreciated.
'
DECLARE SUB fulledit (row%(), column%(), numentry%, inperr%(), item$(), itemlen%(), itemflag%())
COMMON SHARED /colours/ sfg%, sbg%, rfg%, rbg%
sfg% = 0        'standard foreground
sbg% = 7        'standard background
rfg% = 7        'reverse foreground
rbg% = 1
LOCATE 1, 1     'goto top left so whole screen will be "coloured"
COLOR sfg%, sbg%
CLS
COLOR rfg%, rbg%
' place prompts on the screen
LOCATE 1, 20: PRINT "`CANEDIT' Input Editor for QuickBASIC"
COLOR sfg%, sbg%
LOCATE 3, 5: PRINT "This field accepts 0 to 9 & space only"; : LOCATE 5, 5: PRINT "This field accepts all alphanumeric entries";
LOCATE 7, 5: PRINT "This field accepts `0' to `9',`-', `.' and `space' only"; : LOCATE 9, 5: PRINT "The Esc key is disabled in this field";
LOCATE 11, 5: PRINT "Edit pre-existing data"; : LOCATE 13, 5: PRINT "Field length of 1"; :   LOCATE 15, 5: PRINT "Field length of 55";
LOCATE 17, 27: PRINT "Fields can be placed anywhere on screen"
LOCATE 19, 1: PRINT STRING$(80, "*");
LOCATE 20, 5: PRINT "Use arrow keys, home, end, PgUp, PgDn, Del, Bksp, Ins to edit";
LOCATE 22, 5: PRINT "Ctrl F3 to delete line; Ctrl F4 to copy text; Ctrl F5 to paste";
LOCATE 24, 5: PRINT "Ctrl End & Ctrl Home to move to ends of field; Ctrl F10 to quit editing";
entryload$ = "Bert Christensen, Rosewood Software"      'see item$(5) below
numentry% = 8   'number of input items. can be 1 to ?? 
REDIM item$(numentry%), itemlen%(numentry%), inperr%(numentry%), row%(numentry%), column%(numentry%), itemflag%(numentry%)
'item$() = the input item. if there is data to be edited, see below at item$(5).
'if there is no data to be edited then item$() = " ".
'itemlen%() = the length of the item$().
'inperr%() is a flag to manipulate data in the sub, Fulledit
'column%() is the horizontal column position to start the editing of the particular item$()
'row%() is the vertical row to start editing the item$()
'itemflag%() is like inperr%() above (in case you should need 2)
'below is the filling of the arrray
        item$(1) = " ": itemlen%(1) = 5: inperr%(1) = 0: column%(1) = 44: row%(1) = 3: itemflag%(1) = 1
        item$(2) = " ": itemlen%(2) = 25: inperr%(2) = 0: column%(2) = 50: row%(2) = 5: itemflag%(2) = 0
        item$(3) = " ": itemlen%(3) = 10: inperr%(3) = 0: column%(3) = 64: row%(3) = 7: itemflag%(3) = 2
        item$(4) = " ": itemlen%(4) = 6: inperr%(4) = 1: column%(4) = 45: row%(4) = 9: itemflag%(4) = 0      'inperr% = 1
        item$(5) = entryload$: itemlen%(5) = 40: inperr%(5) = 0: column%(5) = 30: row%(5) = 11: itemflag%(5) = 0
        item$(6) = " ": itemlen%(6) = 1: inperr%(6) = 0: column%(6) = 25: row%(6) = 13: itemflag%(6) = 0
        item$(7) = " ": itemlen%(7) = 55: inperr%(7) = 0: column%(7) = 24: row%(7) = 15: itemflag%(7) = 0
        item$(8) = " ": itemlen%(8) = 20: inperr%(8) = 0: column%(8) = 5: row%(8) = 17: itemflag%(8) = 0
CALL fulledit(row%(), column%(), numentry%, inperr%(), item$(), itemlen%(), itemflag%())
CLS
' print out the results of the inputs
LOCATE 5, 2: PRINT "item$(1) = "; item$(1);
LOCATE 6, 2: PRINT "item$(2) = "; item$(2);
LOCATE 7, 2: PRINT "item$(3) = "; item$(3);
LOCATE 8, 2: PRINT "item$(4) = "; item$(4);
LOCATE 9, 2: PRINT "item$(5) = "; item$(5);
LOCATE 10, 2: PRINT "item$(6) = "; item$(6);
LOCATE 11, 2: PRINT "item$(7) = "; item$(7);
LOCATE 12, 2: PRINT "item$(8) = "; item$(8);
LOCATE 25, 3: PRINT "Press any key to continue....";
pause$ = INPUT$(1)
COLOR sfg%, sbg%
END

SUB fulledit (row%(), column%(), numentry%, inperr%(), item$(), itemlen%(), itemflag%()) STATIC
'there are some Wordstar type commands "scan% = 19 is Ctrl S". I hate Wordstar so I never completed all the commands.
LOCATE , , 0
insertkey% = 0     'make typeover the default
sc1% = 6           'cursor size for default typeover
sc2% = 7
        FOR menuitem% = 1 TO numentry%                  'make sure that existing entries have proper length
                IF LEN(item$(menuitem%)) < itemlen%(menuitem%) THEN
                        item$(menuitem%) = item$(menuitem%) + STRING$((itemlen%(menuitem%) - LEN(item$(menuitem))), " ") 'pad with spaces
                ELSEIF LEN(item$(menuitem%)) > itemlen%(menuitem%) THEN
                        item$(menuitem%) = LEFT$(item$(menuitem%), itemlen%(menuitem%))  'truncate if necessary
                END IF
        NEXT menuitem%
        itemnum% = 1    'start a first input entry
        FOR entry% = 1 TO numentry%                         'enter default data and/or spaces in proper places
                colm% = column%(entry%)
                FOR leng% = 1 TO itemlen%(entry%)
                        COLOR rfg%, rbg%
                        LOCATE row%(entry%), colm%
                        defaultstr$ = MID$(item$(entry%), leng%, 1)
                        PRINT defaultstr$;
                        colm% = colm% + 1
                NEXT leng%
        NEXT entry%
        printcolumn% = column%(itemnum%)     'start at leftmost column
ed1:    COLOR rfg%, rbg%: LOCATE row%(itemnum%), printcolumn%, 1, sc1%, sc2%                   'Place the cursor

ed2:    keypress$ = "": keypress$ = INKEY$: IF keypress$ = "" THEN GOTO ed2     'wait for keypress
        scan% = ASC(keypress$)     'change keypress to integer
ed4:
        IF scan% = 27 THEN                'Esc
                IF inperr%(itemnum%) = 1 THEN  ' to prevent user from escaping from sub
                        BEEP
                ELSE
                        EXIT SUB
                END IF
        END IF

        IF scan% > 31 AND scan% < 127 THEN           'Alphanum chars only
                DO
                        SELECT CASE itemflag%(itemnum%)       'determine which set of characters are acceptable
                                CASE 0          'any alpha numeric
                                CASE 1          ' 0 to 9 and space
                                        SELECT CASE scan%
                                                CASE 32, 48 TO 57   ' nothing to do. Let if "fall through" the SELECT CASE
                                                CASE ELSE
                                                        BEEP
                                                        GOTO ed2
                                        END SELECT
                                CASE 2         '0 to 9, -,., space
                                        SELECT CASE scan%
                                                CASE 32, 45, 46, 48 TO 57
                                                CASE ELSE
                                                        BEEP
                                                        GOTO ed2
                                        END SELECT
                        END SELECT

                IF insertkey% = 0 THEN                     'typeover
                        MID$(item$(itemnum%), printcolumn% - column%(itemnum%) + 1, 1) = keypress$
                        PRINT keypress$;

                ELSE
                        item$(itemnum%) = LEFT$(LEFT$(item$(itemnum%), printcolumn% - column%(itemnum%)) + CHR$(scan%) + MID$(item$(itemnum%), printcolumn% - column%(itemnum%) + 1, column%(itemnum%)), itemlen%(itemnum%))           'insert
                        'PLEASE!!! someone simplify the above line because I as the programmer cannot understand it, but it works!
                        LOCATE row%(itemnum%), column%(itemnum%), 1, sc1%, sc2%
                        item$(itemnum%) = LEFT$(item$(itemnum%), itemlen%(itemnum%))
                        PRINT item$(itemnum%);
                END IF
                scan% = 77                                   'move right 1 space
                EXIT DO
                LOOP
        END IF

        IF scan% = 0 THEN scan% = ASC(RIGHT$(keypress$, 1))             'Extended character

        IF scan% = 8 AND printcolumn% > column%(itemnum%) THEN          'Back Space
                printcolumn% = printcolumn% - 1
                LOCATE row%(itemnum%), printcolumn%, 1, sc1%, sc2%
                scan% = 83
        END IF
                                ' scan% = 4 is the Wordstar Ctrl D
        IF (scan% = 77 OR scan% = 4) AND printcolumn% < column%(itemnum%) - 1 + itemlen%(itemnum%) THEN     'Right arrow
                printcolumn% = printcolumn% + 1
                GOTO ed1
        END IF
                                 '19 = Ctrl S
        IF (scan% = 75 OR scan% = 19) AND printcolumn% > column%(itemnum%) THEN          'Left arrow
                printcolumn% = printcolumn% - 1
                GOTO ed1
        END IF

        IF scan% = 79 THEN                                  'end for    End of text
                IF LEN(RTRIM$(item$(itemnum%))) = 0 THEN
                        printcolumn% = column%(itemnum%) + itemlen%(itemnum%) - 1
                ELSE
                        printcolumn% = column%(itemnum%) + LEN(RTRIM$(item$(itemnum%)))
                        IF printcolumn% > column%(itemnum%) + itemlen%(itemnum%) - 1 THEN printcolumn% = column%(itemnum%) + itemlen%(itemnum%) - 1
                END IF
        GOTO ed1
        END IF

        IF scan% = 117 THEN                                   'ctrl +  end to go to end of line
                printcolumn% = column%(itemnum%) + itemlen%(itemnum%) - 1
                GOTO ed1
        END IF

        IF scan% = 71 THEN                                  ' Home to beginning of text
                IF LEN(RTRIM$(item$(itemnum%))) = 0 THEN
                        printcolumn% = column%(itemnum%)
                ELSE
                        printcolumn% = column%(itemnum%) + ((itemlen%(itemnum%)) - (LEN(LTRIM$(item$(itemnum%)))))
                        IF printcolumn% < column%(itemnum%) THEN printcolumn% = column%(itemnum%)
                END IF
                GOTO ed1
        END IF

        IF scan% = 119 THEN                             'ctrl + home to start of line
                printcolumn% = column%(itemnum%)
                GOTO ed1
        END IF

        IF (scan% = 80 OR scan% = 24) OR (scan% = 13 AND itemnum% <> numentry%) THEN  'Down Arrow  or Enter for next field

                itemnum% = itemnum% + 1
                        IF itemnum% > numentry% THEN itemnum% = numentry%
                                printcolumn% = column%(itemnum%)
                                GOTO ed1
                        END IF
      

        IF scan% = 81 THEN                             ' pgdn to last line
                itemnum% = numentry%
                printcolumn% = column%(itemnum%)
                GOTO ed1
        END IF

        IF scan% = 72 OR scan% = 5 THEN                      'Up Arrow
                itemnum% = itemnum% - 1
                IF itemnum% < 1 THEN itemnum% = 1
                printcolumn% = column%(itemnum%)
                GOTO ed1
        END IF

        IF scan% = 73 THEN                                 'pgup to top line
                itemnum% = 1
                printcolumn% = column%(itemnum%)
                GOTO ed1
        END IF

        IF scan% = 83 THEN                                  'Delete
                item$(itemnum%) = LEFT$(item$(itemnum%), printcolumn% - column%(itemnum%)) + MID$(item$(itemnum%), printcolumn% - column%(itemnum%) + 2, itemlen%(itemnum%) - printcolumn% + column%(itemnum%) - 1) + " "
                LOCATE row%(itemnum%), column%(itemnum%), 1, sc1%, sc2%
                PRINT item$(itemnum%);
                GOTO ed1
        END IF


        IF scan% = 96 THEN                                  ' control f3 to delete line
                item$(itemnum%) = SPACE$(itemlen%(itemnum%))
                printcolumn% = column%(itemnum%)
                LOCATE row%(itemnum%), column%(itemnum%), 1, sc1%, sc2%
                PRINT item$(itemnum%);
                GOTO ed1
        END IF

        IF scan% = 97 THEN                           'Ctrl F4 to copy
                cutline$ = item$(itemnum%)
                GOTO ed1
        END IF

        IF scan% = 98 THEN                                   'Ctrl F5 to paste
                item$(itemnum%) = cutline$
                LOCATE row%(itemnum%), column%(itemnum%), 1, sc1%, sc2%
                PRINT LEFT$(item$(itemnum%), itemlen%(itemnum%));
                GOTO ed1
        END IF

        IF scan% = 82 THEN                                     'insert toggle
                IF insertkey% = 0 THEN
                        insertkey% = 1
                        sc1% = 4       'change to 1/2 block cursor
                        sc2% = 7
                ELSE
                        insertkey% = 0
                        sc1% = 6
                        sc2% = 7
                END IF
                GOTO ed1
         END IF

         IF scan% = 103 THEN         'ctrl f10 to exit
                scan% = 13
         END IF
      
ed3:
        IF scan% <> 13 THEN GOTO ed1

        FOR entry% = 1 TO numentry%                   'get rid of any ascii 0's
        tempstring$ = ""
                FOR leng% = 1 TO LEN(item$(entry%))
                        defaultstr$ = MID$(item$(entry%), leng%, 1)
                        IF ASC(defaultstr$) = 0 THEN defaultstr$ = " "
                        tempstring$ = tempstring$ + defaultstr$
                NEXT leng%
        item$(entry%) = RTRIM$(tempstring$)
        NEXT entry%
LOCATE , , 0       'turn off cursor
END SUB

