'DECGIF.BAS & REALDIR.BAS by Rich Geldreich March 1992
'This program was made for DECGIF.BAS
'(Note: This program doesn't work with some dos versions. It was made to
'work on DOS 5.00)

'$DYNAMIC
DEFINT A-Z

DECLARE SUB ChangeDrive (Drive$, ErrorStatus)
DECLARE SUB Sort (A$(), Low, High)
DECLARE SUB GetDir (EntryName$(), Extension$(), EntryType(), DirNum, Path$, ErrorStatus)
DECLARE SUB selectfile (FileName$, Status, Filter$, Directory$)
DECLARE SUB MakeFrame (X1, Y1, X2, Y2)

DECLARE FUNCTION GetKey ()
DECLARE FUNCTION CurrentPath$ (ErrorStatus)
DECLARE FUNCTION CurrentDrive$ ()
DECLARE FUNCTION NumDrives ()
DECLARE FUNCTION RandInt (Lower, Upper)
DECLARE FUNCTION ValidDrive (Drive$)

'usefull costants
CONST True = -1, False = NOT True


CONST File = 0, Directory = 1

'keycodes
CONST Enter = 13, TabKey = 9
CONST UpArrow = -72, DownArrow = -80
CONST LeftArrow = -75, RightArrow = -77
CONST BackSpace = 8
CONST Home = -71, EndKey = -79, Esc = 27
CONST PgDn = -81, PgUp = -73

TYPE FileBuffer
    DOS            AS STRING * 19
    CreateTime     AS STRING * 1
    Attributes     AS INTEGER
    AccessTime     AS INTEGER
    AccessDate     AS INTEGER
    FileSize       AS LONG
    FileName       AS STRING * 13
END TYPE

TYPE Register
    Ax    AS INTEGER
    Bx    AS INTEGER
    Cx    AS INTEGER
    Dx    AS INTEGER
    Bp    AS INTEGER
    Si    AS INTEGER
    Di    AS INTEGER
    Flags AS INTEGER
    Ds    AS INTEGER
    Es    AS INTEGER
END TYPE


DIM SHARED DriveError


'sample usage:



SCREEN 0, , 1, 1
WIDTH 80, 25
CLS
DIM EntryName$(200), Extension$(200), EntryType(200)
'To use this program, call selectfile with the following parameters:
'selectfile FileName$, Status, Filter$, Directory$
'where FileName$ is the FileName$ (plus path) of the file selected
'Status=2 if the user pressed escape
'Filter$ is the extension of the files to be shown ("GIF" in this case)
'Directory$ is the starting directory. If this is null, then the current
'directory is used. Examine how this subprogram is called from decgif.bas
'if this isn't clear.

END

ErrorHandler:
    DriveError = True
RESUME NEXT

REM $STATIC
'Changes current drive.
SUB ChangeDrive (Drive$, ErrorStatus)
    DIM Inreg AS Register
    'Check to see if Drive$ is valid or not.
    IF NOT ValidDrive(Drive$) THEN
        ErrorStatus = True
    ELSE
        'Drive's okay, call dos and change drive.
        Inreg.Ax = &HE00
        Inreg.Dx = ASC(Drive$) - 65
        CALL interrupt(&H21, Inreg, Inreg)
        ErrorStatus = False
    END IF
END SUB

'Returns current drive.
FUNCTION CurrentDrive$
    DIM Inreg AS Register
    'Call dos and get current drive.
    Inreg.Ax = &H1900
    CALL interrupt(&H21, Inreg, Inreg)
    CurrentDrive$ = CHR$(65 + Inreg.Ax MOD 256)
END FUNCTION

'Returns current path(not a full path- the current drive must be added).
FUNCTION CurrentPath$ (ErrorStatus)
        DIM Inreg AS Register
        DIM PathSize AS STRING * 64
      
        'Check out drive to see if it is ready(let qb do
        'that because calling dos without checking may lock up
        'the computer if a drive error occurs).
      
        'Set flag to false; let error handler make it true
        'if error occurs.
        DriveError = False
        ON ERROR GOTO ErrorHandler
        CHDIR "."
      
        'Disable error checking; change this if you need your own
        'handler...
        ON ERROR GOTO 0
      
       
        IF DriveError THEN
            ErrorStatus = True
        ELSE
            'No error on current drive: call DOS and get current
            'directory
            ErrorStatus = False
            Inreg.Ax = &H4700
            Inreg.Dx = ASC(CurrentDrive$) - 64
            Inreg.Ds = VARSEG(PathSize)
            Inreg.Si = VARPTR(PathSize)
            CALL InterruptX(&H21, Inreg, Inreg)
          
            'Turn ASCII string terminated with a chr$(0) to
            'a normal string.
            CurrentPath$ = LEFT$(PathSize, INSTR(PathSize, CHR$(0)) - 1)
        END IF
END FUNCTION

'This is the backbone of this program. This calls DOS to get the
'current directory. The directory is stored in three arrays.
'
SUB GetDir (EntryName$(), Extension$(), EntryType(), DirNum, Path$, ErrorStatus)

    DIM Inreg AS Register, OutReg AS Register
    DIM Buffer AS FileBuffer
    
    DirNum = 0


    Inreg.Ax = &H1A00
    Inreg.Ds = VARSEG(Buffer)
    Inreg.Dx = VARPTR(Buffer)
    CALL interrupt(&H21, Inreg, OutReg)
  
    Inreg.Ax = &H4E00
    Inreg.Cx = 16
    Npath$ = Path$ + CHR$(0)
    Inreg.Dx = SADD(Npath$)
    CALL InterruptX(&H21, Inreg, OutReg)
  
    FirstFM = (OutReg.Ax AND &HF)
    IF OutReg.Flags AND 1 THEN
        ErrorStatus = True
        EXIT SUB
    ELSE
        ErrorStatus = False
    END IF
 
    IF FirstFM = 0 THEN
        GOSUB MakeFile
        DO
            Inreg.Ax = &H4F00
            Inreg.Dx = SADD(Npath$)
            CALL interrupt(&H21, Inreg, OutReg)
            NextFM = OutReg.Ax AND &HF
            IF NextFM = 0 THEN
                GOSUB MakeFile
            END IF
        LOOP WHILE NextFM = 0
    END IF
    EXIT SUB

MakeFile:
    IF LEFT$(Buffer.FileName, 1) = "." THEN
        RETURN
    END IF
  
    Buffer.FileName = LEFT$(Buffer.FileName, INSTR(Buffer.FileName, CHR$(0)) - 1)
   
    'Get the entry.
    Entry$ = RTRIM$(Buffer.FileName)
    'Is it a directory?
    IF Buffer.Attributes = 4096 THEN
        EntryName$ = RTRIM$(LEFT$(Entry$, 8))
        EntryType = Directory
  
    'No, it's a file then
    ELSE
        IF INSTR(Entry$, ".") = 0 THEN
            'Handle file with no extension.
            EntryName$ = RTRIM$(LEFT$(Entry$, 8))
            Extension$ = ""
        ELSE
            'File with extension.
            EntryName$ = LEFT$(Entry$, INSTR(Entry$, ".") - 1)
            Extension$ = RTRIM$(LEFT$(MID$(Entry$, INSTR(Entry$, ".") + 1), 3))
        END IF
        EntryType = File
    END IF
   
    'Put entry in array
    EntryName$(DirNum) = EntryName$
    Extension$(DirNum) = Extension$
    EntryType(DirNum) = EntryType

    DirNum = DirNum + 1

    'Clean up after ourselves to keep the natives happy!
    Buffer.Attributes = 0
    Buffer.AccessTime = 0
    Buffer.AccessDate = 0
    Buffer.FileSize = 0
    Buffer.FileName = STRING$(13, 32)
RETURN

END SUB

'This sub returns the ascii keycode- extended keycodes(ones that have
'a zero as the first character) return easy to handle negative
'values.
FUNCTION GetKey
    DO
        A$ = INKEY$
    LOOP UNTIL A$ <> ""
    IF LEN(A$) = 2 THEN
        GetKey = -ASC(RIGHT$(A$, 1))
    ELSE
        GetKey = ASC(A$)
    END IF
END FUNCTION

'Draes a frame. X1,Y1 start, X2,Y2 end
SUB MakeFrame (X1, Y1, X2, Y2)
   
    UpLeft$ = "": UpRight$ = "": LoLeft$ = "": LoRight$ = ""
    H$ = "": V$ = ""
    LOCATE Y1, X1
    PRINT UpLeft$; STRING$(X2 - X1 - 1, H$); UpRight$;
    LOCATE Y2, X1
    PRINT LoLeft$; STRING$(X2 - X1 - 1, H$); LoRight$;
    FOR Y = Y1 + 1 TO Y2 - 1
        LOCATE Y, X1
        PRINT V$;
        LOCATE Y, X2
        PRINT V$;
    NEXT
END SUB

FUNCTION NumDrives
    'Scans to find all the logical drives on the system.
    FOR A = 1 TO 26
        IF NOT ValidDrive(CHR$(A + 64)) THEN
            NumDrives = A - 1
            EXIT FUNCTION
        END IF
    NEXT
END FUNCTION

'This subroutine is for the QuickSort algoritmn only.
FUNCTION RandInt (Lower, Upper)
    'Finds a random number between Lower and Upper.
    RandInt = INT(RND(1) * (Upper - Lower) + .5) + Lower
END FUNCTION

SUB selectfile (FileName$, Status, Filter$, Directory$)
 
    'dim all arrays
    REDIM EntryName$(408), Extension$(408), EntryType(408)
    REDIM SortBuffer$(408)
    REDIM Window$(34, 12), Direct$(100)
    DIM Path$(26)

    SCREEN 0, , 1, 1
    GOSUB DrawScreen
   
  
    FOR A = 1 TO NumDrives
        Path$(A) = CHR$(64 + A) + ":\"
    NEXT
    Drive = ASC(CurrentDrive$) - 64
    OldDrive = Drive
    Path$(Drive) = Path$(Drive) + CurrentPath$(ErrorStatus)
   
    IF Directory$ <> "" THEN
        Drive = ASC(Directory$) - 64
        Path$(Drive) = Directory$
    END IF
   
    FirstTime = True
    Position = 1
   
    Filter$ = UCASE$(LEFT$(LTRIM$(RTRIM$(Filter$)), 3))
    DO
     
        'fast way of clearing arrays
        ERASE Window$, Direct$
        REDIM Window$(34, 12), Direct$(100)
     
        UseLast1 = False
        UseLast2 = False
      
        IF FirstTime AND ErrorStatus THEN
            FullPath$ = ""
            Root = True
        ELSE
            FullPath$ = Path$(Drive)
            IF LEN(FullPath$) = 3 THEN
                Root = True
            ELSE
                Root = False
                FullPath$ = FullPath$ + "\"
            END IF
        END IF
        PrintPath$ = FullPath$
        FullPath$ = FullPath$ + "*.*"
        IF Filter$ = "" THEN
            PrintPath$ = FullPath$
        ELSE
            PrintPath$ = PrintPath$ + "*." + Filter$
        END IF

        LOCATE 5, 5
        PRINT PrintPath$; STRING$(79 - POS(0), 32)
      
        'alert user if drive not ready; otherwise
        'get the directory
        IF ErrorStatus THEN
            SOUND 1000, 3
            Num = 0
            LOCATE 25, 34
            COLOR 15 + 16
            PRINT "Drive Error";
            COLOR 15
        ELSE
            GetDir EntryName$(), Extension$(), EntryType(), Num, FullPath$, ErrorStatus
        END IF

        NoFiles = True
      
        IF Num <> 0 THEN
            SortNum = 0
          
            FOR A = 0 TO Num - 1
                IF EntryType(A) = File THEN
                    IF Filter$ = "" OR Filter$ = Extension$(A) THEN
                        SortBuffer$(SortNum) = EntryName$(A)
                        IF Extension$(A) <> "" THEN
                            SortBuffer$(SortNum) = SortBuffer$(SortNum) + "." + Extension$(A)
                        END IF
                        SortNum = SortNum + 1
                    END IF
                END IF
            NEXT
          
            IF SortNum <> 0 THEN
                Sort SortBuffer$(), 0, SortNum - 1
                X = 0
                Y = 0
                FOR A = 0 TO SortNum - 1
                    Window$(X, Y) = SortBuffer$(A)
                    LastX = X: LastY = Y
                    Y = Y + 1
                    IF Y > 11 THEN
                        Y = 0: X = X + 1
                    END IF
                NEXT
                NoFiles = False
            END IF
        END IF
      
        DirectNum = 0
        IF NOT Root THEN
            Direct$(DirectNum) = ".."
            DirectNum = DirectNum + 1
        END IF
        FOR A = 1 TO NumDrives
            Direct$(DirectNum) = "[-" + CHR$(64 + A) + "-]"
            DirectNum = DirectNum + 1
        NEXT
        FOR A = 0 TO Num - 1
            IF EntryType(A) = Directory THEN
                Direct$(DirectNum) = RTRIM$(EntryName$(A))
                DirectNum = DirectNum + 1
            END IF
        NEXT
        Sort Direct$(), 0, DirectNum - 1

        CurrentX = 0
      
        CurrentY = 0
      
        DirectNum = DirectNum - 1
      
        GOSUB Update1
        GOSUB Update2
      
        LOCATE 3, 19: PRINT STRING$(8 + 3 + 1, " ")
        LOCATE 3, 19: PRINT Window$(0, 0)
        DO
            IF NoFiles THEN Position = 2
          
            SELECT CASE Position
                CASE 1
                    GOSUB FileWindow
                CASE 2
                    GOSUB DirectWindow
            END SELECT
        LOOP WHILE Status = 3
      
        FirstTime = False
  
    LOOP UNTIL Status <> 0
    Directory$ = Path$(Drive)
    ERASE EntryName$, Extension$, EntryType, SortBuffer$
    
EXIT SUB

'updates the Files window with files
Update1:
    'switch to work screen so user gets a clean change
    SCREEN 0, , 2, 1
    COLOR 15, 0
    'copy old screen to work screen
    PCOPY 1, 2
   
    'debugging stuff...
    'LOCATE 3, 60: PRINT CurrentDrive$; ":\"; CurrentPath$(E)


    'start printing the file entries
    RealX = 7
    FOR X = CurrentX TO CurrentX + 2
        FOR Y = 0 TO 11
            LOCATE Y + 9, RealX
            PRINT STRING$(12, 32)
            LOCATE Y + 9, RealX
            PRINT Window$(X, Y)
        NEXT
        RealX = RealX + 17
    NEXT
    'Print location bar
    LOCATE 22, 7: PRINT STRING$(50, "")
    IF LastX = 0 THEN
        X = 7
    ELSE
        X = 7 + (CurrentX / LastX) * 49
    END IF
    LOCATE 22, X: PRINT "";
    'Copy work screen to display screen
    PCOPY 2, 1
    SCREEN 0, , 1, 1
    COLOR 15, 0
RETURN
'Updates the directory window
Update2:
    'Print directories
    'debugging stuff...
    'LOCATE 3, 60: PRINT CurrentDrive$; ":\"; CurrentPath$(E)
    RealY = 9
    FOR Y = CurrentY TO CurrentY + 11
        LOCATE RealY, 63
        PRINT STRING$(8, 32);
        LOCATE RealY, 63
        PRINT Direct$(Y)
        RealY = RealY + 1
    NEXT
    'Print location bar
    FOR Y = 8 TO 8 + 13
        LOCATE Y, 75
        PRINT ""
    NEXT
    LOCATE 8 + (CurrentY / DirectNum) * 13, 75
    PRINT ""
RETURN

'This sub controls the cursor when it is in the Files window
FileWindow:
    IF UseLast1 THEN
        Xpos = LastXPos1
        Ypos = LastYPos1
    ELSE
        Xpos = 0
        Ypos = 0
    END IF
    DO
      
        FileName$ = Window$(CurrentX + Xpos, Ypos)
      
        'Print the current file at top
        LOCATE 3, 19
        PRINT STRING$(13, 32)
        LOCATE 3, 19
        PRINT FileName$
      
        Ytemp = Ypos + 9
        Xtemp = 6 + Xpos * 17
      
        COLOR 0, 7
        LOCATE Ytemp, Xtemp
        PRINT STRING$(14, 32);
        LOCATE Ytemp, Xtemp + 1
        PRINT FileName$;
      

        'Wait for a key.
        A = GetKey
      
        COLOR 15, 0
        LOCATE Ytemp, Xtemp
        PRINT STRING$(14, 32);
        LOCATE Ytemp, Xtemp + 1
        PRINT FileName$;
      
      
        'process the key
        SELECT CASE A
            CASE PgDn
                
                CurrentX = CurrentX + 3
                IF Xpos + CurrentX > LastX THEN
                    CurrentX = LastX
                    Xpos = 0
                    Ypos = LastY
                ELSEIF Xpos + CurrentX = LastX AND Ypos > LastY THEN
                    Ypos = LastY
                END IF
                GOSUB Update1
            CASE PgUp
                CurrentX = CurrentX - 3
                IF CurrentX < 0 THEN
                    CurrentX = 0
                    Xpos = 0
                    Ypos = 0
                END IF
               
                GOSUB Update1
            CASE Esc
                Status = 2
                RETURN
            CASE Home
                CurrentX = 0
                Xpos = 0: Ypos = 0
                GOSUB Update1
            CASE EndKey
                CurrentX = LastX
                Ypos = LastY
                Xpos = 0
                GOSUB Update1
            CASE TabKey
                'save the cursors position
                LastXPos1 = Xpos
                LastYPos1 = Ypos
                UseLast1 = True

                Status = 3
                Position = 2
                RETURN
            CASE Enter
                IF Root THEN
                    FileName$ = Path$(Drive) + FileName$
                ELSE
                    FileName$ = Path$(Drive) + "\" + FileName$
                END IF
                Status = 1
                RETURN
            CASE DownArrow
                Ypos = Ypos + 1
                IF Xpos + CurrentX = LastX AND Ypos > LastY THEN
                    Ypos = LastY
                END IF
                IF Ypos > 11 THEN
                    Ypos = 0
                    Xpos = Xpos + 1
                    IF Xpos > 2 THEN
                        Xpos = 2
                        CurrentX = CurrentX + 1
                        IF CurrentX - 2 > LastX THEN
                            CurrentX = LastX - 2
                        END IF
                        GOSUB Update1
                    END IF
                END IF
            CASE UpArrow
                Ypos = Ypos - 1
                IF Ypos < 0 THEN
                    IF Xpos + CurrentX = 0 THEN
                        Ypos = 0
                    ELSE
                        Ypos = 11
                        Xpos = Xpos - 1
                        IF Xpos < 0 THEN
                            Xpos = 0
                            CurrentX = CurrentX - 1
                            IF CurrentX < 0 THEN
                                CurrentX = 0
                                Xpos = 2
                            END IF
                            GOSUB Update1
                        END IF
                    END IF
                END IF
            CASE LeftArrow
                Xpos = Xpos - 1
                IF Xpos < 0 THEN
                    Xpos = 0
                    IF Xpos + CurrentX = 0 THEN
                        Ypos = 0
                    ELSE
                        CurrentX = CurrentX - 1
                        GOSUB Update1
                    END IF
                END IF
            CASE RightArrow
                Xpos = Xpos + 1
                IF Xpos + CurrentX > LastX THEN
                    Xpos = LastX - CurrentX
                    Ypos = LastY
                END IF
                IF Xpos + CurrentX = LastX AND Ypos > LastY THEN
                    Ypos = LastY
                END IF
                IF Xpos > 2 THEN
                    Xpos = 2
                    CurrentX = CurrentX + 1
                    IF Xpos + CurrentX = LastX AND Ypos > LastY THEN
                        Ypos = LastY
                    END IF
                    GOSUB Update1
                END IF
            CASE 65 TO 90, 97 TO 122, 48 TO 57
                A$ = UCASE$(CHR$(A))
                RealX = CurrentX + Xpos
                RealY = CurrentY + Ypos
                StopX = RealX
                StopY = RealY
                ScanX = RealX
                ScanY = RealY + 1
                IF ScanY > 11 THEN
                    ScanY = 0
                    ScanX = ScanX + 1
                END IF
                DO UNTIL ScanX > LastX OR LEFT$(Window$(ScanX, ScanY), 1) = A$
                    ScanY = ScanY + 1
                    IF ScanY > 11 THEN
                        ScanY = 0
                        ScanX = ScanX + 1
                    END IF
                LOOP
                IF NOT ScanX > LastX THEN
                    Xpos = 0
                    Ypos = ScanY
                    CurrentX = ScanX
                    GOSUB Update1
                ELSE
                    ScanX = 0
                    ScanY = 0
                    DO UNTIL (ScanX = StopX AND ScanY = StopY) OR LEFT$(Window$(ScanX, ScanY), 1) = A$
                        ScanY = ScanY + 1
                        IF ScanY > 11 THEN
                            ScanY = 0
                            ScanX = ScanX + 1
                        END IF
                    LOOP
                    IF NOT (ScanX = StopX AND ScanY = StopY) THEN
                        Xpos = 0
                        Ypos = ScanY
                        CurrentX = ScanX
                        GOSUB Update1
                    END IF
                END IF
        END SELECT
    LOOP
'this sub controls the cursor when it is in the Directories window
DirectWindow:
    IF UseLast2 THEN
        Ypos = LastYPos2
    ELSE

        Ypos = 0
    END IF
    DO
        'highlight the cursors position
        COLOR 0, 7
        Ytemp = Ypos + 9
       
        LOCATE Ytemp, 61
        PRINT STRING$(14, 32);
        LOCATE Ytemp, 63
        PRINT Direct$(Ypos + CurrentY);

        'wait for a key
        A = GetKey
      
        'unhighlight the cursors position
        COLOR 15, 0
      
        LOCATE Ytemp, 61
        PRINT STRING$(14, 32);
        LOCATE Ytemp, 63
        PRINT Direct$(Ypos + CurrentY);
      
        'process key
        SELECT CASE A
            CASE PgDn
                CurrentY = CurrentY + 12
                IF Ypos + CurrentY > DirectNum THEN
                    CurrentY = DirectNum
                    Ypos = 0
                END IF
                GOSUB Update2
            CASE PgUp
                CurrentY = CurrentY - 12
                IF CurrentY < 0 THEN
                    CurrentY = 0
                    Ypos = 0
                END IF
                GOSUB Update2
            CASE Esc
                Status = 2
                RETURN
            CASE TabKey
                'see if it's ok to go to files window
                IF NOT NoFiles THEN
                    'save the cursors position
                    UseLast2 = True
                    LastYPos2 = Ypos
                  
                    Position = 1
                    Status = 3
                    RETURN
                END IF
            CASE Enter
                NewDirect$ = Direct$(Ypos + CurrentY)
              
                'a "cd .." change
                IF NewDirect$ = ".." THEN
                    FOR X = LEN(Path$(Drive)) TO 1 STEP -1
                        IF MID$(Path$(Drive), X, 1) = "\" THEN EXIT FOR
                    NEXT
                    Path$(Drive) = LEFT$(Path$(Drive), X - 1)
                    Status = 0
                    IF LEN(Path$(Drive)) = 2 THEN
                        Path$(Drive) = Path$(Drive) + "\"
                    END IF
                    RETURN
              
              
                'a drive change
                ELSEIF LEFT$(NewDirect$, 1) = "[" THEN
                    PCOPY 1, 2
                    NewDrive = ASC(MID$(NewDirect$, 3, 1)) - 64
                    ChangeDrive CHR$(NewDrive + 64), ErrorStatus
                  
                    DriveError = False
                    ON ERROR GOTO ErrorHandler
                    CHDIR "."
                    ON ERROR GOTO 0
                  
                    ChangeDrive CHR$(OldDrive + 64), ErrorStatus
                  
                    PCOPY 2, 1
                    IF DriveError THEN
                      
                        SOUND 1000, 3
                        LOCATE 25, 34
                        COLOR 15 + 16
                        PRINT "Drive Error";
                        COLOR 15
                    ELSE
                        LOCATE 25, 34
                        PRINT STRING$(11, 32);
                        Drive = NewDrive
                        Status = 0
                        RETURN
                    END IF
                ELSE
                    'a directory change
                    IF Root THEN
                        Path$(Drive) = Path$(Drive) + NewDirect$
                    ELSE
                        Path$(Drive) = Path$(Drive) + "\" + NewDirect$
                    END IF
                  
                    Status = 0
                    LOCATE 25, 34
                    PRINT STRING$(11, 32);
                    RETURN
                END IF
            CASE DownArrow
                Ypos = Ypos + 1
                IF Ypos + CurrentY > DirectNum THEN
                    Ypos = Ypos - 1
                END IF
                IF Ypos > 11 THEN
                    Ypos = 11
                    CurrentY = CurrentY + 1
                    IF CurrentY + 11 > DirectNum THEN
                        CurrentY = DirectNum - 11
                    END IF
                    GOSUB Update2
                END IF
            CASE UpArrow
                Ypos = Ypos - 1
                IF Ypos < 0 THEN
                    Ypos = 0
                    CurrentY = CurrentY - 1
                    IF CurrentY < 0 THEN
                        CurrentY = 0
                    END IF
                    GOSUB Update2
                END IF
            CASE Home
                Ypos = 0
                CurrentY = 0
                GOSUB Update2
            CASE EndKey
                Ypos = 0
                CurrentY = DirectNum
                GOSUB Update2
            CASE 65 TO 90, 97 TO 122, 48 TO 57
                A$ = UCASE$(CHR$(A))
                StopScan = Ypos + CurrentY
                Scan = StopScan + 1
                DO UNTIL Scan > DirectNum OR LEFT$(Direct$(Scan), 1) = A$
                    Scan = Scan + 1
                LOOP
                IF NOT Scan > DirectNum THEN
                    Ypos = 0
                    CurrentY = Scan
                    GOSUB Update2
                ELSE
                    Scan = 0
                    DO UNTIL Scan = StopScan OR LEFT$(Direct$(Scan), 1) = A$
                        Scan = Scan + 1
                    LOOP
                    IF NOT Scan = StopScan THEN
                        Ypos = 0
                        CurrentY = Scan
                        GOSUB Update2
                    END IF
                END IF
        END SELECT
    LOOP
DrawScreen:
    CLS
    COLOR 14, 0
    MakeFrame 1, 1, 80, 24
    MakeFrame 5, 7, 58, 22
    MakeFrame 60, 7, 75, 22
    MakeFrame 17, 2, 32, 4
    COLOR 15
    LOCATE 1, 33
    PRINT " Choose File "
    LOCATE 3, 5
    PRINT "File Name:"
    LOCATE 6, 29
    PRINT "Files"
    LOCATE 6, 62
    PRINT "Directories"
RETURN

END SUB

'QuickSorts a string array. Low=first entry to sort, High=last entry
SUB Sort (A$(), Low, High)

   IF Low < High THEN
      IF High - Low = 1 THEN
         IF A$(Low) > A$(High) THEN
            SWAP A$(Low), A$(High)
         END IF
      ELSE

         RandIndex = RandInt(Low, High)
         SWAP A$(High), A$(RandIndex)
         Partition$ = A$(High)
         DO

            I = Low: J = High
            DO WHILE (I < J) AND (A$(I) <= Partition$)
               I = I + 1
            LOOP
            DO WHILE (J > I) AND (A$(J) >= Partition$)
               J = J - 1
            LOOP

            IF I < J THEN
               SWAP A$(I), A$(J)
            END IF
         LOOP WHILE I < J

         SWAP A$(I), A$(High)

         IF (I - Low) < (High - I) THEN
            Sort A$(), Low, I - 1
            Sort A$(), I + 1, High
         ELSE
            Sort A$(), I + 1, High
            Sort A$(), Low, I - 1
         END IF
      END IF
   END IF
END SUB

FUNCTION ValidDrive (Drive$)
    DIM Inreg AS Register
    Inreg.Ax = &H440E
    Inreg.Bx = ASC(Drive$) - 64
    CALL interrupt(&H21, Inreg, Inreg)
    IF (Inreg.Flags AND 1) = 1 THEN
        ValidDrive = False
    ELSE
        ValidDrive = True
    END IF
END FUNCTION

