'*****************************************************************************
'	      Fast Parser  Copyright (C) 1992 by Daniel Corbier.
'			   All Rights Reserved.
'
' Here's a description of the arrays, functions, and variables
' which make up Fast Parser:
'
' VarName$[]  :  This array stores the names of variables you want
'                Fast Parser to recognize.  You may have up to 16 variable
'                names (subscripts 0 to 15).  It is not case-sensitive.
'
' VarValue![] :  A value is usually assigned to this array when inside a
'                loop, before Evaluate!() is called.  VarValue![0] matches
'                VarName$[0], VarValue![1] matches VarName$[1] etc...
'                You may also use it for a constant value like
'                VarName$[0] = "Pi" : VarValue![0] = 3.14159
'
' EqParse%( Equation$ )
'
'                This function parses the arithmetic expression in Equation$,
'                into a simple list of instructions in a structure internal to
'                Fast Parser.  The value returned is a pointer to where the
'                instructions for your equation are located.  That value is
'                the parameter you should pass to the Evaluate!() function.
'
' Evaluate!( Ptr% )
'
'                This simply goes down the list of instructions generated
'                by EqParse%(), returning the value for the expression.
'                It is generally preceded by assigning the variable
'                values to VarValue![].  See the example files.
'
' Eval!( Equation$ )
'
'                The only advantage of this function is that it evaluates an
'                expression in one step.  However, when speed is of concern,
'                use EqParse%() along with Evaluate!().  See the example files.
'
' EqError%       Returns -1 if an invalid expression was entered, or 0 if
'                the expression is valid.  Invalid expressions are those
'                with unmatching parenthesis, or which include variables
'                not present in the VarName$[] array.
'
' ReleaseEq      After using many equations, you can call this procedure
'		 to reset the equation pointer back to 0.  Previously
'		 parsed equations will be freed from memory.
'
'*****************************************************************************

$Link"calc.pbu"
$STACK       16000       ' You may reduce the stack in most cases.

Public VarValue![], VarName$[], EqError%

Declare Function Eval!( STRING )
Declare Function EqParse%( STRING )
Declare Function Evaluate!( INTEGER )
Declare Sub      ReleaseEq()