'**********************************************************************
' Fast Parser is Copyright (C) 1992 by Daniel Corbier
'
' User defined parametric equations.
'
' This example features:
'
' VarName$[]   which allows Fast parser to recognize variable name t.
'
' EqParse()    which does all the parsing before the loop is started.
'
' VarValue![]  which matches the actual value of t to the variable
'              name.  It happens inside the loop.
'
' Evaluate!()  this is what evaluates the expression.  It is preferred
'              over Eval!() for speed & efficiency.
'**********************************************************************
$include"calc.inc"

Screen 9			'  Use screen 1 if you don't have EGA
Window (-10,-7.5)-(10,7.5)

VarName$[0] = "t"

Print "Enter the x and y expressions for a parametric equation,"
Print "where variable  t  is the parameter."
Print "Press [enter] to go with defaults"
Print

Input "x: [cos(t)-cos(2*t)]  ", Xequation$
Input "y: [sin(t)-sin(2*t)]  ", Yequation$

If Xequation$ = "" then Xequation$ = "cos(t)-cos(2*t)"
If Yequation$ = "" then Yequation$ = "sin(t)-sin(2*t)"

Xptr% = EqParse%( Xequation$ )		'  Assigns a pointer to
Yptr% = EqParse%( Yequation$ )		'  the parsed expressions.

For t=-10 to 10 step .05
	VarValue![0] = t

	x = Evaluate( Xptr% )		'  Evaluates Xequation$
	y = Evaluate( Yptr% )		'  Evaluates Yequation$

	Pset( x, y ),9
Next