
'----- PCACCESS.BAS - QuickBASIC communications and file download utility
'
'Written for PC Magazine by Jay Munro
'
' Compile and Link syntax:   BC /o/x PCACCESS;
'                            LINK /ex PCACCESS;

DEFINT A-Z                              'Use integers unless over-ridden

'----- QuickBASIC Subprograms
DECLARE SUB AbortFile (FileName$)       'Clears buffer, closes file
                                        'Checks blocks for errors
DECLARE SUB CheckBlock (Message$, Status, Ptr, CRCTable%())
DECLARE SUB FlushBuf ()                 'Flushes COM buffer
DECLARE SUB Immediate (CRCTable%(), PromptData$()) 'Direct download routine
DECLARE SUB Logon (X)                   'Auto-logon routine
DECLARE SUB MakeCRCTable (CRCTable%())  'Builds CRC value table
DECLARE SUB XModemSub (CRCTable%())     'XModem handler

'----- QuickBASIC Functions
DECLARE FUNCTION CRCCalc$ (A)           'CRC value function
DECLARE FUNCTION FiltInp$ (InString$)   'Filters out special characters
DECLARE FUNCTION GetString% (SearchSt$, ExitCode) 'Finds ID/Password/Etc.

ON ERROR GOTO ErrorCheck                'Directs errors to trap area

'----- Set up shared variables
DIM SHARED ACK$, CAN$, EOT$, NAK$, SOH$, BlockOk, CurBlk&
DIM SHARED Dial$, DialCmd$, ErrCount, IDStr$, Password$, Quit$
DIM SHARED DirectFlag%, FileName$

'----- Set program constants
ACK$ = CHR$(6)                          'Acknowledge Character
CAN$ = CHR$(24)                         'Cancel transmission
EOT$ = CHR$(4)                          'End of Transmission
NAK$ = CHR$(21)                         'Negative Acknowledge
SOH$ = CHR$(1)                          'Start of Header
Quit$ = CHR$(0) + CHR$(30)              'Abort File Character ALT-A

COLOR 7, 1                              'Set colors of display

REDIM PromptData$(7, 2)                 'Array for direct download Commands
REDIM CRCTable%(255)                    'Dim an array for table

CALL MakeCRCTable(CRCTable%())          'Fill the table

'  note: change COM1 and 1200 as necessary below

ComSpec$ = "COM1:1200,E,7,1,BIN,CS0"

'  note: use the following line after joining PC Magnet and adjusting
'        your user profile for no parity. Change COM1 and 1200 as necessary.

'ComSpec$ = "COM1:1200,N,8,1,BIN,CS0"

'----- Put in your own number, ID, and Password here

Dial$ = "9,18003463247"                'String to hold phone number
DialCmd$ = "ATDT"                      'Hayes command for Tone dialing
'DialCmd$ = "ATDP"                     'Use this sequence for pulse dialing
'IDStr$ = "177000,5000"                'String to hold ID
'Password$ = "PC*MAGAZINE"             'String to hold password


'----- Clear screen and display help and logo
CLS
LOCATE 1, 1, 1                          'Print logo, help and comspec
PRINT TAB(28); "PC Magazine  -  PCACCESS"
PRINT "Alt-R: Receive File  Alt-X: Exit  Alt-D: Dial  Alt-L: Log On    ";
PRINT LEFT$(ComSpec$, 15)
PRINT STRING$(80, 205)
VIEW PRINT 4 TO 24                      'Use area between lines 4 and 24
GOSUB ScriptData                        'Load array of direct download commands

'----- Open the COM port
OpenSerialPort:
                               
OPEN ComSpec$ FOR RANDOM AS #1          'Open communications buffer
                                        'Put additional set-up here if needed
PRINT #1, "ATZ"                         'Reset modem

OK = GetString%("OK", ExitCode%)        'Hold until modem returns an OK
IF OK THEN                              'If OK then print modem ready
   PRINT "Modem Ready"
ELSE                                    'Otherwise alert user
   PRINT "Modem not responding - press ALT-X to quit"
END IF

IF INSTR(COMMAND$, "I") THEN DirectFlag% = 1    '"I" on command line
IF DirectFlag% THEN CALL Immediate(CRCTable%(), PromptData$())

'----- Main input handler
InputLoop:                              'Input/Output loop
   DO
      I$ = INKEY$                       'Get keystroke from keyboard
      IF LEN(I$) THEN                   'See if anything was entered
         I = ASC(RIGHT$(I$, 1))         'Normal keys return LEN=1, extended
         IF LEN(I$) = 2 THEN I = -I     '  keys return LEN=2
                                        'Set extended scan code to -number
         SELECT CASE I                  'Check for special keys
            CASE -23                    'Immediate mode downloads directly
               DirectFlag% = -1
               CALL Immediate(CRCTable%(), PromptData$())
            CASE -45                    'Alt-X
               EXIT DO
            CASE -32                    'Alt-D - Dial a number
               CALL Logon(0)            '  and do autologon
               PRINT
            CASE -38                    'Alt-L - Just do autologon
               CALL Logon(-1)
               PRINT
            CASE -19                    'Receive a file via XModem
               CALL XModemSub(CRCTable%())
            CASE ELSE                   'Send anything else to the modem
               PRINT #1, I$;            'Semi-colon prevents sending CR/LF
         END SELECT
      END IF

      IF NOT EOF(1) THEN                'Check the modem for characters
         MInput$ = INPUT$(LOC(1), #1)   'LOC(1) = # of characters in buffer
         PRINT FiltInp$(MInput$);       'Print filtered input
      END IF
   LOOP                                 'Keep looping until we want to end
CLOSE
END
ErrorCheck:
SELECT CASE ERR                         'Not all these error codes are needed
                                        ' Ones with * are recommended
   CASE 24                              '* Modem probably wasn't connected
      PRINT "Device Timeout!"           '  to phone line
   CASE 52                              'Probably asked for COM port that
      PRINT "Bad File Name!"            '  didn't exist (ie. COM3:)
   CASE 53                              'Use this if you modify for uploading
      PRINT "File not found! "          '  downloading doesn't need it
   CASE 57                              '* Trap I/O error
      Err57% = Err57% + 1               'and give it slack before reporting it
      IF Err57% > 5 THEN                'to avoid errors when exiting
         PRINT "Device I/O Error!"      'More than 5, report it
         Err57% = 0
      END IF
   CASE 61                              '* Bad error when downloading
      PRINT "Disk full!"                'Try to start with enough room
   CASE 68
      PRINT "Device Unavailable! "      '* COM port doesn't exist, or under
   CASE 69                              'this is a fatal error
      PRINT "Buffer Overflow - Fatal "
      CLOSE
      END
   CASE 71                              '* Tried to access disk with open
      PRINT "Drive not ready!"          '  drive door
   CASE 75
      PRINT "Path/File access error"
   CASE 76                              '*
      PRINT "Path not found"
   CASE ELSE                            '* Do it yourself error lookup
      PRINT "Error "; ERR; " Occurred"
END SELECT

IF INKEY$ <> "" THEN END                'Unconditional bail out on any error

RESUME

ScriptData:
RESTORE DirData                         '

FOR X% = 1 TO 7                         'Read download data into array
   READ PromptData$(X%, 1)              'Read 'wait for' prompt
   READ PromptData$(X%, 2)              'Read 'answer' value
NEXT X%
RETURN

DirData:                                'Direct download commands

DATA  !,GO UTILITIES,!,4,"):",,"):",Y,<CR>,,transfer!,1,complete,,

SUB AbortFile (FileName$) STATIC
    CALL FlushBuf                       'Wait for clear line
    PRINT #1, CAN$; CAN$; CAN$;         'Send Cancel signal
    PRINT "*** File transfer cancelled ***"  'Alert user
    CLOSE #2                            'Close file
END SUB

SUB CheckBlock (Message$, Status%, Ptr%, CRCTable%()) STATIC
   'Status =  1-OK get more (saved)
   '          2-Retry block
   '          3-Sender Abort
   '          4-End of file (close)

   BlockOk% = 0
   SELECT CASE LEFT$(Message$, 1)       'Check for:
      CASE EOT$                         'End of Transmission (good)
        Status% = 4
        EXIT SUB
      CASE CAN$                         'Canceled by sender (not so good)
        Status% = 3
        EXIT SUB
      CASE IS <> SOH$                   'Start Of Header bad (out of sync)
        IF Ptr% < 10 AND CurBlk& = 1 THEN 'probably start of file
           PRINT #1, "C";              'So signal again
           Status% = 2                 'Set Status for retry
           ErrCount% = ErrCount% + 1   'bump error count
           EXIT SUB
        END IF
        Status% = 1                    'Bad block
        PRINT "SOH error"              'Report type of error
        CALL FlushBuf                  'Clear modem buffer
      CASE ELSE                         'Check current block # vs sent block #
        BlockOk%=((CurBlk& AND 255)=ASC(MID$(Message$, 2, 1)))
        BlockOk%=((ASC(MID$(Message$,2,1)) XOR 255)=(ASC(MID$(Message$,3,1))))
        IF BlockOk% THEN
           CRC$ = CHR$(0) + CHR$(0)    'Message CRC created in this routine

           FOR MG% = 4 TO 131          'Each character is considered and
                                       '  CRC on total message is created
               CRCH1 = ASC(LEFT$(CRC$, 1))
               CRCL2 = CVI(CHR$(0) + RIGHT$(CRC$, 1))
               CRC1$=MKI$(CRCTable%(CRCH1 XOR ASC(MID$(Message$,MG%,1))) XOR CRCL2)
               CRC$ = RIGHT$(CRC1$, 1) + LEFT$(CRC1$, 1)
           NEXT MG%

           Status% = 1                 'Preset status to get next block
                                       'Compare calculated CRC with sent CRC
           IF CRC$ = MID$(Message$, 132, 2) THEN
              BlockOk% = -1            'It is good!
           ELSE
              PRINT "CRC error"        'It is not good
              BlockOk% = 0
              Status% = 0
           END IF
        ELSE
           Status% = 1
           PRINT "Block ID error"
        END IF
    END SELECT

   IF NOT BlockOk% THEN                 'If block is bad then
      ErrCount% = ErrCount% + 1         '  bump error count, and report the
                                        '  block number that is at fault
      PRINT "*** Error - Block #"; CurBlk&
      PRINT "*** Error count "; ErrCount%
      PLAY "L16O3EC"
   END IF

END SUB

FUNCTION CRCCalc$ (A%)                          'Don't make this SUB STATIC!
   HiCrc% = HiCrc% XOR A%
   LoCrc% = 0
   FOR CT% = 0 TO 7                             'Do the calculation
       Carry = 0                                'Clear carry bit
       IF HiCrc > 127 THEN Carry = -1           'Is High bit on in CRC?
       HiCrc = (HiCrc * 2) AND 255              'Shift High byte left 1 bit
       IF LoCrc > 127 THEN HiCrc = HiCrc + 1    'Carry bit from LoCRC to Hi
       LoCrc = (LoCrc * 2) AND 255              'Shift Low byte left 1 bit
       IF Carry THEN                            'If not carry then skip this
          HiCrc = HiCrc XOR 16                  '&H10 in hex
          LoCrc = LoCrc XOR 33                  '&H21
       END IF
   NEXT CT%                                     'Go get another shift
   CRCCalc$ = CHR$(LoCrc) + CHR$(HiCrc)         'Assign function = CRC

END FUNCTION

FUNCTION FiltInp$ (InString$) STATIC
   DO                                           'Converts backspace
      BackSpace = INSTR(InString$, CHR$(8))     'Characters to left arrows
      IF BackSpace THEN
         MID$(InString$, BackSpace) = CHR$(29)
      END IF
   LOOP WHILE BackSpace

   '----- Strip out any line feed characters
   DO
      LineFeed = INSTR(InString$, CHR$(10))
      IF LineFeed THEN
         InString$=LEFT$(InString$, LineFeed-1)+MID$(InString$, LineFeed + 1)
      END IF
   LOOP WHILE LineFeed

   FiltInp$ = InString$
END FUNCTION

SUB FlushBuf
    IF LOF(1) THEN
      DO UNTIL EOF(1)                             'Flush buffer
       Junk$ = INPUT$(1, 1)                    'Input into dummy string
      LOOP
    END IF
END SUB

FUNCTION GetString% (SearchSt$, ExitCode%) STATIC
    GetString% = 0                              'Preset function value
    Timeout! = TIMER + 5                        'Set a retry timeout
    MInput$ = ""                                'Clear input string

    DO                                          'Press any key to bail out
       IF INKEY$ <> "" THEN
          ExitCode% = -1
          EXIT FUNCTION
       END IF
       IF TIMER > Timeout! THEN EXIT FUNCTION   'Bail out on timeout
       IF LOC(1) THEN MInput$ = MInput$ + INPUT$(LOC(1), 1) 'Get modem input
    LOOP UNTIL INSTR(MInput$, SearchSt$)        'Keep getting until a match

    GetString% = -1                             'Success!!!
END FUNCTION

SUB Immediate (CRCTable%(), PromptData$())
  
   PRINT "Immediate Mode - Enter file to download: ";
   INPUT FileName$                      'Prompt user for file to download
   IF FileName$ = "" THEN GOTO OutHere  'Allow exit
   PRINT "Press ENTER to quit"
   PromptData$(3, 2) = FileName$        'Assign array element to FileName$
   IF DirectFlag% = 1 THEN              'If started with "I" on command line
      CALL Logon(0)                     '  then log on to PC MagNet
   ELSE                                 'Otherwise
      PRINT #1, "GO PCM-1"              '  go to Main screen to start
   END IF
   
FOR X% = 1 TO 7                         'Loop through commands
   DO                                   'Do this until we receive a prompt
     IF ExitCode THEN PRINT "Cancelled ": GOTO OutHere  '  or an exit code
       OK = GetString%(PromptData$(X%, 1), ExitCode)
       IF OK THEN
          PRINT PromptData$(X%, 2)      'Echo to screen to show we're active
          PRINT #1, PromptData$(X%, 2)  'Send command out modem
       END IF
   LOOP UNTIL OK                        'Keep looping until valid
NEXT X%
  
   OK = GetString%(PromptData$(7, 1), ExitCode%)
   CALL XModemSub(CRCTable%())          'Go download the file
   PRINT #1, " "                        'Print a Carriage return

OutHere:
   DirectFlag% = 0                      'Reset flag for later use

END SUB

SUB Logon (LogOnOnly%)

   ExitCode% = 0

   IF NOT LogOnOnly% THEN

      IF Dial$ = "" THEN                'Prompt if a number is not specified
         INPUT "Enter Number to Dial ", Dial$
         IF Dial$ = "" THEN EXIT SUB
      END IF

      PRINT "*** Dialing "; Dial$       'Dialing message
      PRINT #1, DialCmd$; Dial$         'Send dial command + number to modem

      DO
         IF GetString%("CONNECT", ExitCode) THEN EXIT DO  'exit on connect
         I% = I% + 1                    'Increment number of trys
         IF ExitCode THEN               'If a key was hit, exit
            PRINT "Aborted Logon"       '  with abort message
            EXIT SUB
         END IF
      LOOP WHILE I% < 10                'Loop until there are too many trys

      IF I% = 10 THEN                   'Tried too many times, exit
         PRINT "No answer"
         EXIT SUB
      END IF

      PRINT "Connected"                 'Connection detected
      PRINT "*** Logging On ***"        'Message
   END IF

   DO                                   'do this until we receive a prompt
      IF ExitCode THEN EXIT SUB         '  or an exit code
                                        'Exit if no password/id set
      IF IDStr$ = "" OR Password$ = "" THEN EXIT SUB
      PRINT #1, CHR$(3);                'Print a ^C to port

      IF INKEY$ <> "" THEN PRINT "Aborted Logon": EXIT SUB

      OK = GetString%(":", ExitCode)
      IF OK THEN
         PRINT "Sending ID"
         PRINT #1, IDStr$
      END IF
   LOOP UNTIL OK

   DO                                   'Do until we receive a prompt
      IF ExitCode THEN EXIT SUB         '  or an exit code
      OK = GetString%(":", ExitCode)
      IF OK THEN
         PRINT "Sending Password"
         PRINT #1, Password$
      END IF
   LOOP UNTIL OK

END SUB

SUB MakeCRCTable (CRCTable%()) STATIC
   FOR X% = 0 TO 255                    'Assign CRC for each possible number
      CRCTable%(X%) = CVI(CRCCalc$(X%)) ' from 0-255 (8 bits)
   NEXT X%
END SUB

SUB XModemSub (CRCTable%()) STATIC
    CurBlk& = 1                         'Set current block to 1
    BlockOk% = 0                        'Clear good block flag
    Timeout! = 10                       'Set time out (20 sec. for relaxed)
    ErrCount% = 0                       'Clear the error counter
    TBlock% = 133                       'Total block size CRC
    Abort% = 0
    PRINT FileName$

    IF DirectFlag% = 0 THEN
       INPUT ">>>> Enter file name to Receive > ", FileName$
       IF FileName$ = "" THEN EXIT SUB     'User just pressed Enter
    END IF

    OPEN FileName$ FOR OUTPUT AS #2     'Open the output file
    PRINT "*** Sending start character ***"
    PRINT #1, "C";                      '"C" requests CRC protocol

    DO
       IF ErrCount% > 14 THEN
          CALL AbortFile(FileName$)
          EXIT SUB                      'Too many errors, exit
       END IF
     
       Buffer$ = SPACE$(TBlock%)        'Pad buffer to TBlock% characters

       FOR Ptr = 1 TO LEN(Buffer$)      'Assume we fill the whole buffer
          T! = TIMER                    'Start a timer for timeout
          DO UNTIL LOC(1)               'Wait for a character to come in port
             IF INKEY$ = Quit$ THEN Abort% = -1  'User requested abort
                                        'Short timeout for EOT
             IF LEFT$(Buffer$, 1) = EOT$ AND TIMER > T! + 3 THEN EXIT FOR
                                        'short timeout to start
             IF CurBlk& = 1 AND TIMER > T! + 3 THEN EXIT FOR
                                        'If timed out, jump out of loop
             IF TIMER > T! + Timeout! THEN EXIT FOR
          LOOP
                                        'Put any characters into Buffer$
          MID$(Buffer$, Ptr, 1) = INPUT$(1, 1)
       NEXT
      
       IF INKEY$ = Quit$ OR Abort% THEN  'User requesting abort
            CALL AbortFile(FileName$)
            EXIT SUB
       END IF

       CALL CheckBlock(Buffer$, Status%, Ptr%, CRCTable%())

       SELECT CASE Status%
          CASE 1
             IF BlockOk% THEN
                PRINT #2, MID$(Buffer$, 4, 128);      'the data block
                ErrCount% = 0                         'Reset error count
                PRINT #1, ACK$;                       'Signal 'OK' to sender
                PRINT "Block "; CurBlk&, CurBlk& * 128; " Bytes" 'update user
                CurBlk& = CurBlk& + 1                 'Bump block count
             ELSE
                CALL FlushBuf
                PRINT #1, NAK$
             END IF
          CASE 3                                      'File aborted
             CALL AbortFile(FileName$)
             EXIT DO
          CASE 4                                      'File received okay
             PRINT #1, ACK$;                          'Acknowledge end of file
             CLOSE #2                                 'Close output file
             CLS
             PRINT " *** End of transfer ";           'say that we're done
                                                      'How much we received
             PRINT ((CurBlk& - 1) * 128); " Bytes received"
             PRINT " File: "; FileName$; " saved"     'What was saved
             PRINT "Press Enter"
             PLAY "L16O2ECG"                          'Use BEEP with OS/2
             EXIT DO                                  '
          CASE ELSE                                   'Either retry or resend
       END SELECT
    LOOP
END SUB

