DEFINT A - Z
DECLARE FUNCTION UpdateCRC32&(BYVAL Number&, BYVAL AddressSEG%,_
                              BYVAL AddressOffset%, BYVAL Length%)
DECLARE FUNCTION PDQEXIST%(FileName$)

BlockSize = 16384               'Set size of
Buffer$ = SPACE$(BlockSize)     'Buffer area

FileName$ = COMMAND$            'Get file name
IF FileName$ = "" THEN                    'If not given
   PRINT "Usage: CRC32BAS 'File Name'"    'print instructions
   SYSTEM                                 'and exit
END IF

IF NOT PDQEXIST(FileName$) THEN             'Does the file exist
   PRINT "File '";FileName$;"' not found!"  'no, say that
   SYSTEM                                   'and exit
END IF

Handle = FREEFILE

OPEN FileName$ FOR BINARY ACCESS READ AS Handle
NumOfLoops = LOF(Handle)\BlockSize          'How many Buffer size blocks

IF NumOfLoops = 0 THEN                      'If file less than one
   CRC& = &HFFFFFFFF                        'Buffer handle
   Remainder = LOF(Handle)                  'it
   Goto Done
ELSE
   Remainder = LOF(Handle) - (NumOfLoops * BlockSize)  'Find size of last read
END IF

CRC& = &HFFFFFFFF                 'Initialize CRC

FOR X = 1 TO NumOfLoops           'Get each Buffer
   GET Handle,,Buffer$            'size block

   CRC& = UpdateCRC32&(BYVAL CRC&, BYVAL VARSEG(Buffer$),_   'Compute CRC
                                   BYVAL SADD(Buffer$),_     'for each block
                                   BYVAL BlockSize)
NEXT

Done:
  GET Handle,,Buffer$             'Get last block

  CRC& = UpdateCRC32&(BYVAL CRC&, BYVAL VARSEG(Buffer$),_    'Compute CRC
                                  BYVAL SADD(Buffer$),_      'for last block
                                  BYVAL Remainder)

  CRC& = CRC& XOR &HFFFFFFFF      'Flip bits in CRC

  PRINT "CRC32 for ";Filename$;" is: ";Hex$(CRC&)  'Give the result
  SYSTEM                                           'Exit
