
   {$A+,B-,D-,E-,F-,I+,N-,O-,R-,S-,V+}
   {$M 1024, 0, 0}

program DisplayAttrChart;
uses
  TpCrt;

const
                   (* ReadKeyWord constant.                                 *)
  coEscapeKey       = $011B;

  BlinkOn : boolean = true;
  CGAmode : boolean = false;


                   (* Note 'ATTRCHRT.OBJ' created using BIN2OBJ program.    *)
  {$F+}
  procedure AttrChartData; external;
  {$L ATTRCHRT.OBJ}
  {$F-}


const
                   (* Packed-window pointer set to address of AttrChartData *)
    AttrScreen : PackedWindowPtr = addr(AttrChartData);

var
  woCmd : word;


                   (* Clear the keyboard-buffer.                            *)
  procedure ClearKeyBuff; assembler;
  asm
    @1: mov ah, 1
        int 16h
        jz  @2
        mov ah, 0
        int 16h
        jmp @1
    @2:
  end;             (* ClearKeyBuff                                          *)


                   (* Set the CGA blink attribute.                          *)
  procedure SetBlinkCGA(On : boolean);
  begin
    if On then
      port[$3D8] := $29
    else
      port[$3D8] := $09
  end;             (* SetBlinkCGA                                           *)


                   (* Set the EGA+ blink attribute.                         *)
  procedure SetBlinkEGA(On : boolean); assembler;
  asm
    mov bl,On
    mov ax,$1003
    int $10
  end;             (* SetBlinkEGA                                           *)


                   (* Main program block.                                   *)
BEGIN
  HiddenCursor;
  DispPackedWindow(AttrScreen);
  repeat
    ClearKeyBuff;
    woCmd := ReadKeyWord;
    BlinkOn := NOT BlinkOn;
    if BlinkOn then
      fastwrite('  BLINK-BIT ON  ', 24, 33, $1F)
    else
      fastwrite('  BLINK-BIT OFF ', 24, 33, $1F);
    if (CurrentDisplay = CGA) then
      SetBlinkCGA(BlinkOn)
    else
      SetBlinkEGA(BlinkOn)
  until (woCmd = coEscapeKey);
  SetBlink(true);
  NormalCursor;
  clrscr
END.

