Unit AnsiGr;

Interface

Uses DOS,CRT,FXGraph;

Var ClearFG,ClearBG  : Byte;
    AnsiOutputString : String;
    MakeNoise        : Boolean;

Procedure Write_Ansi(InString : String);

Implementation

Const Esc         = Chr(27);
      Ansi_Letter = 'JDCABHmfsuK'+Chr(13);

Var HiC,HiB              : Byte;
    SaveAnsiX,SaveAnsiY  : Byte;

Function GetNumbers(InString : String) : String;

Const Nums = '0123456789;';

Var TempS : String;
    I     : Byte;

   Begin
      TempS := '';
      For I := 1 To Length(InString) Do
         If Pos(InString[I],Nums) > 0 Then TempS := TempS + InString[I];
      GetNumbers := TempS;
   End;

Procedure SetAnsiColor(InString : String);

Var CountSem : Byte;
    ValueS   : Array[0..5] Of String;
    ValueI   : Array[0..5] Of Integer;
    Dumb     : Integer;
    OutColor : Byte;
    I        : Byte;
    SwapClrs : Byte;

   Begin
      For I := 0 To 5 Do
         Begin
            ValueS[I] := '';
            ValueI[I] := 255;
         End;
      CountSem := 0;
      For I := 1 To Length(InString) Do
         Begin
            If InString[I] = ';' Then
               CountSem := CountSem + 1
            Else
               ValueS[CountSem] := ValueS[CountSem] + InString[I];
         End;
      For I := 0 To CountSem Do Val(ValueS[I],ValueI[I],Dumb);
      For I := 0 To CountSem Do
         Begin
            If ValueI[I] = 0 Then
               Begin
                  FXTextColor(7);
                  FXTextBackGround(0);
                  HiC := 0;
                  HiB := 0;
               End;
            If ValueI[I] = 1 Then
               Begin
                  HiC := 8;
                  HighVideo;
               End;
            If ValueI[I] = 5 Then HiB := Blink;
            If ValueI[I] = 7 Then FXColor(FXBackground,FXForeground);
            If ValueI[I] = 8 Then FXColor(0,0);
            If ValueI[I] = 30 Then FXTextColor(0+HiC+HiB);
            If ValueI[I] = 34 Then FXTextColor(1+HiC+HiB);
            If ValueI[I] = 32 Then FXTextColor(2+HiC+HiB);
            If ValueI[I] = 36 Then FXTextColor(3+HiC+HiB);
            If ValueI[I] = 31 Then FXTextColor(4+HiC+HiB);
            If ValueI[I] = 35 Then FXTextColor(5+HiC+HiB);
            If ValueI[I] = 33 Then FXTextColor(6+HiC+HiB);
            If ValueI[I] = 37 Then FXTextColor(7+HiC+HiB);
            If ValueI[I] = 40 Then FXTextBackGround(0);
            If ValueI[I] = 44 Then FXTextBackGround(1);
            If ValueI[I] = 42 Then FXTextBackGround(2);
            If ValueI[I] = 46 Then FXTextBackGround(3);
            If ValueI[I] = 41 Then FXTextBackGround(4);
            If ValueI[I] = 45 Then FXTextBackGround(5);
            If ValueI[I] = 43 Then FXTextBackGround(6);
            If ValueI[I] = 47 Then FXTextBackGround(7);
         End;
   End;

Procedure SetAnsiCursor(InString : String);

Var CountSem : Byte;
    ValueS   : Array[0..1] Of String;
    ValueI   : Array[0..1] Of Integer;
    Dumb     : Integer;
    I        : Byte;

   Begin
      For I := 0 To 1 Do
         Begin
            ValueS[I] := '';
            ValueI[I] := 0;
         End;
      CountSem := 0;
      For I := 1 To Length(InString) Do
         Begin
            If InString[I] = ';' Then
               CountSem := CountSem + 1
            Else
               ValueS[CountSem] := ValueS[CountSem] + InString[I];
         End;
      For I := 0 To CountSem Do Val(ValueS[I],ValueI[I],Dumb);
      If ValueI[0] = 0 Then ValueI[0] := FXWhereY;
      If ValueI[1] = 0 Then ValueI[1] := FXWhereX;
      FXGotoXY(ValueI[1],ValueI[0]);
   End;

Procedure ProcessAnsi(InString : String);

Var TempS : String;
    TempI : Integer;
    Dumb  : Integer;
    Func  : Char;
    Hold  : Byte;

   Begin
      TempI := 1;
      Func := InString[Length(InString)];
      If Func = 'K' Then ClrEol;
      If Func = 'm' Then SetAnsiColor(GetNumbers(InString));
      If Func = 'f' Then SetAnsiCursor(GetNumbers(InString));
      If Func = 'H' Then
         Begin
            If Pos(';',GetNumbers(InString)) > 0 Then
               SetAnsiCursor(GetNumbers(InString))
            Else
               Begin
                  If (GetNumbers(InString) <> '') Then Val(GetNumbers(InString),TempI,Dumb);
                  FXGotoXY(1,TempI);
               End;
         End;
      If Func = 'B' Then
         Begin
            If (GetNumbers(InString) <> '') Then Val(GetNumbers(InString),TempI,Dumb);
            FXGotoXY(FXWhereX,FXWhereY+TempI);
         End;
      If Func = 'A' Then
         Begin
            If (GetNumbers(InString) <> '') Then Val(GetNumbers(InString),TempI,Dumb);
            FXGotoXY(FXWhereX,FXWhereY-TempI);
         End;
      If Func = 'C' Then
         Begin
            If (GetNumbers(InString) <> '') Then Val(GetNumbers(InString),TempI,Dumb);
            FXGotoXY(FXWhereX+TempI,FXWhereY);
         End;
      If Func = 'D' Then
         Begin
            If (GetNumbers(InString) <> '') Then Val(GetNumbers(InString),TempI,Dumb);
            FXGotoXY(FXWhereX-TempI,FXWhereY);
         End;
      If (Func = 'J') And (GetNumbers(InString) = '2') Then
         Begin
            FXTextColor(ClearFG);
            FXTextBackGround(ClearBG);
            HiC := 0;
            FXClrScr;
         End;
      If (Func = 's') Then
         Begin
            SaveAnsiX := FXWhereX;
            SaveAnsiY := FXWhereY;
         End;
      If (Func = 'u') Then FXGotoXY(SaveAnsiX,SaveAnsiY);
   End;

Procedure Write_Ansi(InString : String);

Var TempS : String;
    EscF  : Byte;
    LetF  : Byte;
    I     : Byte;
    Held  : Byte;
    NF    : Boolean;
    FndAt : Byte;

   Begin
      NF := False;
      EscF := 0;
      AnsiOutputString := AnsiOutputString + InString;
      EscF := Pos(Esc,AnsiOutputString);
      If EscF > 0 Then
         Begin
            If EscF > 1 Then
               Begin
                  TempS := Copy(AnsiOutputString,1,EscF-1);
                  Delete(AnsiOutputString,1,EscF-1);
                  FXWrite  (TempS);
               End;
            TempS := '';
            For I := 1 To Length(AnsiOutputString) Do
               Begin
                  LetF := Pos(AnsiOutputString[I],Ansi_Letter);
                  If (LetF > 0) And (Not NF) Then
                     Begin
                        TempS := Copy(AnsiOutputString,1,I);
                        ProcessAnsi(TempS);
                        NF := True;
                        FndAt := I;
                     End;
                  If NF Then Delete(AnsiOutputString,1,FndAt);
               End;
         End
      Else
         Begin
            FXWrite  (AnsiOutputString);
            AnsiOutputString := '';
         End;
   End;

   Begin
      AnsiOutputString := '';
      HiC := 0;
      HiB := 0;
      SaveAnsiX := 1;
      SaveAnsiY := 1;
      ClearFG := 7;
      ClearBG := 0;
      MakeNoise := True;
   End.

