Unit AnsiText;

Interface

Uses DOS,CRT;

Var ClearFG,ClearBG  : Byte;
    AnsiOutputString : String;
    MakeNoise        : Boolean;

Function WinLength : Byte;
Function StripAnsi(InString : String) : String;
Procedure Write_Regular(OutCh : String);
Procedure Write_Ansi(InString : String);

Implementation

Const Esc         = Chr(27);
      Ansi_Letter = 'JDCABHmfsuK'+Chr(13);

Var HiC,HiB              : Byte;
    SaveAnsiX,SaveAnsiY  : Byte;

Function WinLength : Byte;

   Begin
      WinLength := Hi(WindMax) - Hi(WindMin) + 1;
   End;

Function StripAnsi(InString : String) : String;

Var I : Byte;
    A : Byte;
    D : Boolean;

   Begin
      D := False;
      If InString = '' Then
         Begin
            StripAnsi := '';
            Exit;
         End;
      Repeat
         Begin
            A := Pos(Chr(27)+'[',InString);
            If A > 0 Then
               Begin
                  Delete(InString,A,2);
                  I := A;
                  While (I < Length(InString)) And (Pos(InString[I],Ansi_Letter) = 0) Do
                     Inc(I);
                  Delete(InString,A,I-A+1);
               End
            Else
               D := True;
         End;
      Until D Or (InString = '');
      StripAnsi := InString;
   End;

Procedure Write_Regular(OutCh : String);

Var H1,H2 : Byte;
    Wh,G  : Integer;
    HldTh : String;

   Begin
      If OutCh='' Then Exit;
      While OutCh <> '' Do
         Begin
            Wh := 256;
            G := Pos(#13,OutCh); If (G>0) And (G<Wh) Then Wh := G;
            G := Pos(#10,OutCh); If (G>0) And (G<Wh) Then Wh := G;
            G := Pos(#12,OutCh); If (G>0) And (G<Wh) Then Wh := G;
            G := Pos(#07,OutCh); If (G>0) And (G<Wh) Then Wh := G;
            G := Pos(#09,OutCh); If (G>0) And (G<Wh) Then Wh := G;
            G := Pos(#00,OutCh); If (G>0) And (G<Wh) Then Wh := G;
            If Wh=256 Then
               Begin
                  Write  (OutCh);
                  OutCh := '';
               End
            Else
               Begin
                  If Wh > 1 Then
                     Begin
                        HldTh := Copy(OutCh,1,Wh-1);
                        Write  (HldTh);
                        Delete(OutCh,1,Length(HldTh));
                     End;
                  Case OutCh[1] Of
                      #07  : If MakeNoise Then
                                Begin
                                   Sound(800);
                                   Delay(50);
                                   Sound(1600);
                                   Delay(50);
                                   NoSound;
                                End;
                      #009 : Write  ('        ');
                      #012 : ClrScr;
                      #013 : GotoXY(1,WhereY);
                      #010 : Begin
                                H1 := WhereX;
                                H2 := TextAttr;
                                TextColor(7);
                                TextBackGround(0);
                                WriteLn('');
                                GotoXY(H1,WhereY);
                                TextAttr := H2;
                             End;
                     End;
                  Delete(OutCh,1,1);
               End;
         End;
   End;

Function GetNumbers(InString : String) : String;

Const Nums = '0123456789;';

Var TempS : String;
    I     : Byte;

   Begin
      TempS := '';
      For I := 1 To Length(InString) Do
         If Pos(InString[I],Nums) > 0 Then TempS := TempS + InString[I];
      GetNumbers := TempS;
   End;

Procedure SetAnsiColor(InString : String);

Var CountSem : Byte;
    ValueS   : Array[0..5] Of String;
    ValueI   : Array[0..5] Of Integer;
    Dumb     : Integer;
    OutColor : Byte;
    I        : Byte;
    SwapClrs : Byte;

   Begin
      For I := 0 To 5 Do
         Begin
            ValueS[I] := '';
            ValueI[I] := 255;
         End;
      CountSem := 0;
      For I := 1 To Length(InString) Do
         Begin
            If InString[I] = ';' Then
               CountSem := CountSem + 1
            Else
               ValueS[CountSem] := ValueS[CountSem] + InString[I];
         End;
      For I := 0 To CountSem Do Val(ValueS[I],ValueI[I],Dumb);
      For I := 0 To CountSem Do
         Begin
            If ValueI[I] = 0 Then
               Begin
                  TextColor(7);
                  TextBackGround(0);
                  HiC := 0;
                  HiB := 0;
               End;
            If ValueI[I] = 1 Then
               Begin
                  HiC := 8;
                  HighVideo;
               End;
            If ValueI[I] = 5 Then HiB := Blink;
            If ValueI[I] = 7 Then TextAttr := Not TextAttr;
            If ValueI[I] = 8 Then
               Begin
                  TextColor(0);
                  TextBackGround(0);
               End;
            If ValueI[I] = 30 Then TextColor(0+HiC+HiB);
            If ValueI[I] = 34 Then TextColor(1+HiC+HiB);
            If ValueI[I] = 32 Then TextColor(2+HiC+HiB);
            If ValueI[I] = 36 Then TextColor(3+HiC+HiB);
            If ValueI[I] = 31 Then TextColor(4+HiC+HiB);
            If ValueI[I] = 35 Then TextColor(5+HiC+HiB);
            If ValueI[I] = 33 Then TextColor(6+HiC+HiB);
            If ValueI[I] = 37 Then TextColor(7+HiC+HiB);
            If ValueI[I] = 40 Then TextBackGround(0);
            If ValueI[I] = 44 Then TextBackGround(1);
            If ValueI[I] = 42 Then TextBackGround(2);
            If ValueI[I] = 46 Then TextBackGround(3);
            If ValueI[I] = 41 Then TextBackGround(4);
            If ValueI[I] = 45 Then TextBackGround(5);
            If ValueI[I] = 43 Then TextBackGround(6);
            If ValueI[I] = 47 Then TextBackGround(7);
         End;
   End;

Procedure SetAnsiCursor(InString : String);

Var CountSem : Byte;
    ValueS   : Array[0..1] Of String;
    ValueI   : Array[0..1] Of Integer;
    Dumb     : Integer;
    I        : Byte;

   Begin
      For I := 0 To 1 Do
         Begin
            ValueS[I] := '';
            ValueI[I] := 0;
         End;
      CountSem := 0;
      For I := 1 To Length(InString) Do
         Begin
            If InString[I] = ';' Then
               CountSem := CountSem + 1
            Else
               ValueS[CountSem] := ValueS[CountSem] + InString[I];
         End;
      For I := 0 To CountSem Do Val(ValueS[I],ValueI[I],Dumb);
      If ValueI[0] = 0 Then ValueI[0] := WhereY;
      If ValueI[1] = 0 Then ValueI[1] := WhereX;
      GotoXY(ValueI[1],ValueI[0]);
   End;

Procedure ProcessAnsi(InString : String);

Var TempS : String;
    TempI : Integer;
    Dumb  : Integer;
    Func  : Char;
    Hold  : Byte;

   Begin
      TempI := 1;
      Func := InString[Length(InString)];
      If Func = 'K' Then ClrEol;
      If Func = 'm' Then SetAnsiColor(GetNumbers(InString));
      If Func = 'f' Then SetAnsiCursor(GetNumbers(InString));
      If Func = 'H' Then
         Begin
            If Pos(';',GetNumbers(InString)) > 0 Then
               SetAnsiCursor(GetNumbers(InString))
            Else
               Begin
                  If (GetNumbers(InString) <> '') Then Val(GetNumbers(InString),TempI,Dumb);
                  If TempI <= WinLength Then
                     GotoXY(1,TempI)
                  Else
                     Begin
                        GotoXY(1,WinLength);
                        WriteLn('');
                     End;
               End;
         End;
      If Func = 'B' Then
         Begin
            If (GetNumbers(InString) <> '') Then Val(GetNumbers(InString),TempI,Dumb);
            If (TempI < 1) Or (TempI > WinLength) Then TempI := 1;
            If WhereY+TempI <= WinLength Then
               GotoXY(WhereX,WhereY+TempI)
            Else
               Begin
                  Hold := WhereX;
                  GotoXY(1,WinLength);
                  WriteLn('');
                  GotoXY(Hold,WinLength);
               End;
         End;
      If Func = 'A' Then
         Begin
            If (GetNumbers(InString) <> '') Then Val(GetNumbers(InString),TempI,Dumb);
            If (TempI < 1) Or (TempI > WinLength) Then TempI := 1;
            GotoXY(WhereX,WhereY-TempI);
         End;
      If Func = 'C' Then
         Begin
            If (GetNumbers(InString) <> '') Then Val(GetNumbers(InString),TempI,Dumb);
            If (TempI < 1) Or (TempI > 80) Then TempI := 1;
            GotoXY(WhereX+TempI,WhereY);
         End;
      If Func = 'D' Then
         Begin
            If (GetNumbers(InString) <> '') Then Val(GetNumbers(InString),TempI,Dumb);
            If (TempI < 1) Or (TempI > 80) Then TempI := 1;
            GotoXY(WhereX-TempI,WhereY);
         End;
      If (Func = 'J') And (GetNumbers(InString) = '2') Then
         Begin
            TextColor(ClearFG);
            TextBackGround(ClearBG);
            HiC := 0;
            ClrScr;
         End;
      If (Func = 's') Then
         Begin
            SaveAnsiX := WhereX;
            SaveAnsiY := WhereY;
         End;
      If (Func = 'u') Then GotoXY(SaveAnsiX,SaveAnsiY);
   End;

Procedure Write_Ansi(InString : String);

Var TempS : String;
    EscF  : Byte;
    LetF  : Byte;
    I     : Byte;
    Held  : Byte;
    NF    : Boolean;
    FndAt : Byte;

   Begin
      NF := False;
      EscF := 0;
      AnsiOutputString := AnsiOutputString + InString;
      EscF := Pos(Esc,AnsiOutputString);
      If EscF > 0 Then
         Begin
            If EscF > 1 Then
               Begin
                  TempS := Copy(AnsiOutputString,1,EscF-1);
                  Delete(AnsiOutputString,1,EscF-1);
                  Write_Regular(TempS);
               End;
            TempS := '';
            For I := 1 To Length(AnsiOutputString) Do
               Begin
                  LetF := Pos(AnsiOutputString[I],Ansi_Letter);
                  If (LetF > 0) And (Not NF) Then
                     Begin
                        TempS := Copy(AnsiOutputString,1,I);
                        ProcessAnsi(TempS);
                        NF := True;
                        FndAt := I;
                     End;
                  If NF Then Delete(AnsiOutputString,1,FndAt);
               End;
         End
      Else
         Begin
            Write_Regular(AnsiOutputString);
            AnsiOutputString := '';
         End;
   End;

   Begin
      AnsiOutputString := '';
      HiC := 0;
      HiB := 0;
      SaveAnsiX := 1;
      SaveAnsiY := 1;
      ClearFG := 7;
      ClearBG := 0;
      MakeNoise := True;
   End.

