Program ArjV;

Uses DOS;

Const Signature = $EA60;
      ARJComp   : Array[0..4] Of String[50] =
                  ('Stored   ','Compress1','Compress2','Compress3',
                   'Compress4');

Type ARJHdr1   = Record
                    HeaderID      : Word; {EA60h}
                    BasicHdrSize  : Word;
                    FirstHdrSize  : Byte;
                    ARJVersion    : Byte;
                    MinToExtract  : Byte;
                    HostOS        : Byte; {0=MSDOS,1=PRIMOS,2=UNIX,3=AMIGA,
                                           4=MAC-OS,5=OS/2,6=APPLE GS,
                                           7=ATARI ST,8=NEXT,9=VAX VMS}
                    ARJFlags      : Byte; {01h=Garbled,02h=Reserved,
                                           04h=Volume,08h=ExtFile,10h=PathSym}
                    Method        : Byte; {0=Stored,1..4=Compressed Most..Fast}
                    FileType      : Byte; {0=Binary,1=7-Bit Text,2=Comment Hdr,
                                           3=Directory,4=Volume Label}
                    Reserved      : Byte;
                    TimeStamp     : LongInt;
                    CompressedSz  : LongInt;
                    OriginalSize  : LongInt;
                    OriginalCRC   : LongInt;
                    FileSpecPos   : Word;
                    AccessMode    : Word;
                    HostData      : Word;
                 End;
     ARJHdr2   = Record  {After Filename And Comment}
                    BasicHdrCRC   : LongInt;
                    ExtHdrSize    : Word; {Not Used}
                 End;
     ARJExtraTyp = Array[1..1024] Of Char;

Var LclHdr   : ARJHdr1;
    EndHdr   : ARJHdr2;
    NameEx   : ARJExtraTyp;
    InfoEx   : ARJExtraTyp;
    CommEx   : ARJExtraTyp;
    FileSpec : String;
    InFile   : File;
    CSize    : LongInt;
    DSize    : LongInt;
    Error    : Integer;
    FTime    : DateTime;
    FName    : String;
    First    : Boolean;
    Files    : Integer;
    FDate    : LongInt;

Function FormatStr(InString : String; Len : Byte) : String;

Var Temp : String;
    I    : Byte;

   Begin
      Temp := '';
      For I := 1 To Len Do Temp := Temp + ' ';
      If Length(InString) > Len Then
         Temp := Copy(InString,1,Len)
      Else
         For I := 1 To Length(InString) Do Temp[I] := InString[I];
      FormatStr := Temp;
   End;

Function MakeDateTime(Num1,Num2,Num3 : Word; SepChar : String) : String;

Var Str1 : String;
    Str2 : String;
    Str3 : String;
    OutS : String;
    I    : Byte;

   Begin
      OutS := '';
      Str(Num1:2,Str1);
      Str(Num2:2,Str2);
      Str(Num3:2,Str3);
      If Length(Str3) = 4 Then Str3 := Copy(Str3,3,2);
      OutS := Str1+SepChar+Str2+SepChar+Str3;
      For I := 1 To Length(OutS) Do If OutS[I] = ' ' Then OutS[I] := '0';
      MakeDateTime := OutS;
   End;

Function UpperCase(InString : String) : String;

Var I : Byte;

   Begin
      For I := 1 To Length(InString) Do InString[I] := UpCase(InString[I]);
      UpperCase := InString;
   End;

Function FormatFileName(InString : String) : String;

   Begin
      If (Pos('.',InString) > 0) And (Pos('.',InString) < 9) Then
         Begin
            While (Pos('.',InString) < 9) Do
               Insert(' ',InString,Pos('.',InString));
         End;
      FormatFileName := InString;
   End;

Function MakeIntoString(InBuf : ARJExtraTyp; BufLen : Integer) : String;

Var Temp : String;
    I    : Integer;

   Begin
      Temp := '';
      For I := 1 To BufLen Do Temp := Temp + InBuf[I];
      MakeIntoString := Temp;
   End;

Function RemovePath(InString : String) : String;

   Begin
      While Pos('/',InString) > 0 Do Delete(InString,1,Pos('/',InString));
      While Pos('\',InString) > 0 Do Delete(InString,1,Pos('\',InString));
      RemovePath := InString;
   End;

Function ReadNextRecord : Boolean;

Var FileNameSz : Word;
    CommentSz  : Word;
    Ch         : Char;

   Begin
      {$I-}
      FileSpec := '';
      FillChar(NameEx,1024,0);
      FillChar(CommEx,1024,0);
      CommentSz := 0;
      FileNameSz := 0;
      Ch := Chr(255);
      Error := 0;
      BlockRead(InFile,LclHdr,SizeOf(ARJHdr1),Error);
      If Error < SizeOf(ARJHdr1) Then
         ReadNextRecord := False
      Else
         Begin
            If LclHdr.HeaderID = Signature Then
                Begin
                   ReadNextRecord := True;
                   While (Ch<>Chr(0)) Do
                      Begin
                         BlockRead(InFile,Ch,1,Error);
                         Inc(FileNameSz);
                         NameEx[FileNameSz] := Ch;
                         If (FileNameSz >= LclHdr.FileSpecPos) And (Ch<>Chr(0)) Then FileSpec := FileSpec + Ch;
                      End;
                   Ch := Chr(255);
                   While (Ch<>Chr(0)) Do
                      Begin
                         BlockRead(InFile,Ch,1,Error);
                         Inc(CommentSz);
                         CommEx[CommentSz] := Ch;
                      End;
                   BlockRead(InFile,EndHdr,SizeOf(ARJHdr2),Error);
                   If LclHdr.CompressedSz > 0 Then Seek(InFile,FilePos(InFile)+LclHdr.CompressedSz);
                   ReadNextRecord := (IOResult = 0);
                   If LclHdr.FileType > 1 Then FileSpec := '';
                End
             Else
                ReadNextRecord := False;
         End;
      {$I+}
   End;

   Begin
      First := True;
      Files := 0;
      CSize := 0;
      DSize := 0;
      WriteLn('');
      WriteLn('ARJV Ver 1.0 - By Tom Bradford');
      WriteLn('------------------------------');
      If ParamCount > 0 Then
         FName := ParamStr(1)
      Else
         FName := '';
      If FName = '' Then
         Begin
            WriteLn('Format: ARJV ARJFileName[.ARJ]');
            Halt(0);
         End;
      If Pos('.',FName) = 0 Then FName := FName + '.ARJ';
      FName := FExpand(FName);
      Assign(InFile,FName);
      {$I-}
      Reset(InFile,1);
      {$I+}
      If IOResult = 0 Then
         Begin
            WriteLn('Searching File:   '+UpperCase(FormatFileName(RemovePath(FName))));
            WriteLn('');
            While (ReadNextRecord) Do If FileSpec<>'' Then
               Begin
                  If First Then
                     Begin
                        WriteLn('Filename.Ext   Original    Current  Method     Per%  Date      Time');
                        WriteLn('------------  ---------  ---------  ---------  ----  --------  --------');
                     End;
                  Write  (FormatStr(FormatFileName(FileSpec),12)+'  ');
                  Write  (LclHdr.OriginalSize:9,'  ');
                  Write  (LclHdr.CompressedSz:9,'  ');
                  Write  (ARJComp[LclHdr.Method]+'  ');
                  Write  ((100-(100*LclHdr.CompressedSz) Div LclHdr.OriginalSize):3);
                  Write  ('%  ');
                  UnPackTime(LclHdr.TimeStamp,FTime);
                  Write  (MakeDateTime(FTime.Month,FTime.Day,FTime.Year,'-')+'  ');
                  Write  (MakeDateTime(FTime.Hour,FTime.Min,FTime.Sec,':'));
                  WriteLn('');
                  First := False;
                  CSize := CSize + LclHdr.CompressedSz;
                  DSize := DSize + LclHdr.OriginalSize;
                  Files := Files + 1;
               End;
            If First Then
               WriteLn('This File Does Not Seem To Be ARJed')
            Else
               Begin
                  WriteLn('------------  ---------  ---------  ---------  ----  --------  --------');
                  Write  (Files:3,' Files     ',DSize:9,'  ',CSize:9,'             ',(100-(100*CSize) Div DSize):3,'%  ');
                  GetFTime(InFile,FDate);
                  UnPackTime(FDate,FTime);
                  Write  (MakeDateTime(FTime.Month,FTime.Day,FTime.Year,'-')+'  ');
                  Write  (MakeDateTime(FTime.Hour,FTime.Min,FTime.Sec,':'));
                  WriteLn('');
               End;
            Close(InFile);
         End
      Else
         WriteLn('ARJ File Not Found');
   End.

