Unit FXFOSSIL;

Interface

Uses DOS,CRT;

Type FossilDriverInfo = Record
                           SizeOfStruct    : Word;
                           DriverSpecs     : Byte;
                           RevisionNumber  : Byte;
                           IDStringPtr     : ^String;
                           InputBufSize    : Word;
                           InputBytesLeft  : Word;
                           OutputBufSize   : Word;
                           OutputBytesLeft : Word;
                           ScreenWidth     : Byte;
                           ScreenLength    : Byte;
                           BaudRate        : Byte;
                        End;

Var PortNum : Word;

Procedure GetFossilInfo(PortNumber : Word; Var FossilInfo : FossilDriverInfo);
Function GetFossilID(PortNumber : Word) : String;
Function OpenFossil(PortNumber : Word) : Boolean;
Procedure CloseFossil(PortNumber : Word);
Procedure SetBaudRate(PortNumber : Word; Baud : LongInt);
Function SerialStatus(PortNumber : Word) : Word;
Procedure TransmitChar(PortNumber : Word; Ch : Char);
Procedure WriteString(PortNumber : Word; OutLine : String);
Function SerialInput(PortNumber : Word) : Boolean;
Function ReceiveChar(PortNumber : Word) : Char;
Procedure FlushOutput(PortNumber : Word);
Procedure PurgeOutput(PortNumber : Word);
Procedure PurgeInput(PortNumber : Word);
Function CarrierDetect(PortNumber : Word) : Boolean;
Procedure SetDTR(PortNumber : Word; DTR : Boolean);
Procedure HangUp(PortNumber : Word);

Implementation

Var Regs : Registers;

Procedure GetFossilInfo(PortNumber : Word; Var FossilInfo : FossilDriverInfo);

   Begin
      Regs.AH := 27;
      Regs.DX := PortNumber;
      Regs.CX := SizeOf(FossilDriverInfo);
      Regs.ES := Seg(FossilInfo);
      Regs.DI := Ofs(FossilInfo);
      Intr($14,Regs);
   End;

Function GetFossilID(PortNumber : Word) : String;

Var TempInfo : FossilDriverInfo;
    TempStr1 : String;
    TempStr2 : String;
    I        : Byte;

   Begin
      GetFossilInfo(PortNumber,TempInfo);
      If TempInfo.IDStringPtr <> Nil Then
         Begin
            TempStr1 := TempInfo.IDStringPtr^;
            TempStr2 := '';
            I := 0;
            While (I < 255) And (TempStr1[I] <> Chr(0)) Do
               Begin
                  TempStr2 := TempStr2 + TempStr1[I];
                  I := I + 1;
               End;
            GetFossilID := TempStr2;
         End
      Else
         GetFossilID := 'Fossil Not Identified';
   End;

Function OpenFossil(PortNumber : Word) : Boolean;

  Begin
     Regs.AH := 4;
     Regs.DX := PortNumber;
     Intr($14,Regs);
     If Regs.AX = $1954 Then OpenFossil := True;
     If Regs.AX <> $1954 Then OpenFossil := False;
  End;

Procedure CloseFossil(PortNumber : Word);

   Begin
      Regs.AH := 5;
      Regs.DX := PortNumber;
      Intr($14,Regs);
   End;

Procedure SetBaudRate(PortNumber : Word; Baud : LongInt);

   Begin
      Regs.AH := 0;
      Regs.DX := PortNumber;
      Regs.AL := $63;
      If Baud = 300 Then Regs.AL := $43;
      If Baud = 600 Then Regs.AL := $63;
      If Baud = 1200 Then Regs.AL := $83;
      If Baud = 2400 Then Regs.AL := $A3;
      If Baud = 4800 Then Regs.AL := $C3;
      If Baud = 9600 Then Regs.AL := $E3;
      If Baud = 19200 Then Regs.AL := $03;
      If Baud = 38400 Then Regs.AL := $23;
      Intr($14,Regs);
   End;

Function SerialStatus(PortNumber : Word) : Word;

   Begin
      Regs.AH := 3;
      Regs.DX := PortNumber;
      Intr($14,Regs);
      SerialStatus := Regs.AX;
   End;

Procedure TransmitChar(PortNumber : Word; Ch : Char);

   Begin
      Regs.AH := 1;
      Regs.DX := PortNumber;
      Regs.AL := Ord(Ch);
      Intr($14,Regs);
   End;

Procedure WriteString(PortNumber : Word; OutLine : String);

Var I : Byte;

   Begin
      For I := 1 To Length(OutLine) Do
         Begin
            TransmitChar(PortNumber,OutLine[I]);
            FlushOutput(PortNumber);
         End;
   End;

Function SerialInput(PortNumber : Word) : Boolean;

   Begin
      Regs.AH := 3;
      Regs.DX := PortNumber;
      Intr($14,Regs);
      SerialInput := ((Regs.AH And 1) <> 0);
   End;

Function ReceiveChar(PortNumber : Word) : Char;

   Begin
      Regs.AH := 2;
      Regs.DX := PortNumber;
      Intr($14,Regs);
      ReceiveChar := Chr(Regs.AL);
   End;

Procedure FlushOutput(PortNumber : Word);

   Begin
      Regs.AH := 8;
      Regs.DX := PortNumber;
      Intr($14,Regs);
   End;

Procedure PurgeOutput(PortNumber : Word);

   Begin
      Regs.AH := 9;
      Regs.DX := PortNumber;
      Intr($14,Regs);
   End;

Procedure PurgeInput(PortNumber : Word);

   Begin
      Regs.AH := $0A;
      Regs.DX := PortNumber;
      Intr($14,Regs);
   End;

Function CarrierDetect(PortNumber : Word) : Boolean;

   Begin
      Regs.AH := 3;
      Regs.DX := PortNumber;
      Intr($14,Regs);
      CarrierDetect := ((Regs.AL And $80) <> 0);
   End;

Procedure SetDTR(PortNumber : Word; DTR : Boolean);

   Begin
      Regs.AH := 6;
      Regs.DX := PortNumber;
      Regs.AL := Byte(DTR);
      Intr($14,Regs);
   End;

Procedure HangUp(PortNumber : Word);

   Begin
      SetDTR(PortNumber,False);
      Delay(1000);
      SetDTR(PortNumber,True);
   End;

   Begin
   End.

