Unit FXGraph;

Interface

Uses Graph;

Const FXGrScrnLen = 50;
      MaxStorage  = 10;

Type ScreenType = Array[1..80*FXGrScrnLen] Of Record
                                                 Ch : Char;
                                                 At : Byte;
                                              End;

Var FGrScreen : ScreenType;
    FXGrScrnL : Byte;

Function  FXInit(Mode : Byte) : Boolean;
Procedure FXClose;
Procedure FXProduceScreen;
Procedure FXWrite  (OutStr : String);
Procedure FXWriteLn(OutStr : String);
Procedure FXGotoXY(X,Y : Word);
Function  FXWhereX : Word;
Function  FXWhereY : Word;
Procedure FXWindow(X1,Y1,X2,Y2 : Word);
Procedure FXClrScr;
Procedure FXTextColor(Fore : Word);
Procedure FXTextBackGround(Back : Word);
Procedure FXColor(Fore,Back : Word);
Function  FXForeGround : Word;
Function  FXBackGround : Word;
Procedure FXButton(X1,Y1,X2,Y2 : Word);
Procedure FXClrEol;
Procedure FXDelLine;
Procedure FXInsLine;
Procedure FXStoreArea(X1,Y1,X2,Y2 : Word);
Procedure FXStoreScreen(X1,Y1,X2,Y2 : Word);
Procedure FXRestoreArea;
Function  StoreError : Byte;

Implementation

Type StoreType = Record
                    X1,Y1   : Word;
                    AreaPtr : Pointer;
                    Size    : Word;
                 End;

Var FGrX,FGrY : Word;
    FGrF,FGrB : Word;
    FWX1,FWX2 : Word;
    FWY1,FWY2 : Word;
    WX1,WX2   : Byte;
    WY1,WY2   : Byte;
    Wide,High : Byte;
    InWrite   : Boolean;
    StorePl   : Byte;
    StoreErr  : Byte;
    Store     : Array[1..MaxStorage] Of StoreType;

Procedure BGI_EGAVGA; External;
{$L EGAVGA.OBJ }

Function FXInit(Mode : Byte) : Boolean;

Var Temp : Byte;
    TI1  : Integer;
    TI2  : Integer;

   Begin
      Temp := 0;
      Case Mode Of
            0 : Begin
                   TI1 := EGA;
                   TI2 := EGALo;
                   FXGrScrnL := 25;
                   High := 25;
                End;
            1 : Begin
                   TI1 := EGA;
                   TI2 := EGAHi;
                   FXGrScrnL := 43;
                   High := 43;
                End;
            2 : Begin
                   TI1 := VGA;
                   TI2 := VGALo;
                   FXGrScrnL := 25;
                   High := 25;
                End;
            3 : Begin
                   TI1 := VGA;
                   TI2 := VGAMed;
                   FXGrScrnL := 43;
                   High := 43;
                End;
            4 : Begin
                   TI1 := VGA;
                   TI2 := EGAHi;
                   FXGrScrnL := 50;
                   High := 50;
                End;
         End;
      Temp := Temp + Ord(RegisterBGIDriver(@BGI_EGAVGA) < 0);
      InitGraph(TI1,TI2,'');
      Temp := Temp + Ord (GraphResult <> GrOK);
      FXInit := (Temp=0);
   End;

Procedure FXClose;

   Begin
      CloseGraph;
   End;

Procedure FXProduceScreen;

Var J,I,FG,BG  : Byte;
    LastAt,X,Y : Byte;
    TempStr    : String;

   Begin
      LastAt := 255;
      FXWindow(1,1,80,FXGrScrnL+1);
      For J := 1 To FXGrScrnL Do
         Begin
            TempStr := '';
            X := 1;
            Y := J;
            For I := 1 To 80 Do
               Begin
                  If LastAt <> FGrScreen[((J-1)*80)+I].AT Then
                     Begin
                        FXGotoXY(X,Y);
                        FXColor(FG,BG);
                        FXWrite  (TempStr);
                        FG := FGrScreen[((J-1)*80)+I].AT Mod 16;
                        BG := FGrScreen[((J-1)*80)+I].AT Div 16;
                        X := I;
                        LastAt := FGrScreen[((J-1)*80)+I].AT;
                        TempStr := FGrScreen[((J-1)*80)+I].Ch;
                     End
                  Else
                     TempStr := TempStr + FGrScreen[((J-1)*80)+I].Ch;
               End;
            FXGotoXY(X,Y);
            FXColor(FG,BG);
            FXWrite  (TempStr);
         End;
      FXWindow(1,1,80,FXGrScrnL);
   End;

Procedure DoBar(X1,Y1,X2,Y2,Clr : Word);

   Begin
      SetColor(Clr);
      SetFillStyle(1,Clr);
      Bar(X1,Y1,X2,Y2);
   End;

Procedure HandleScroll;

Var Scrl : Array[1..2566] Of Byte;
    ScLn : Byte;
    Ptr  : Pointer;
    Size : LongInt;

   Begin
      If FXWhereX > Wide Then
         FXGotoXY(1,FXWhereY+1);
      If FXWhereY > High Then
         Begin
            Size := ImageSize(FWX1,FWY1+8,FWX2,FWY2);
            If (Size > MaxAvail) Or (Size > 65535) Then
               Begin
                  For ScLn := FWY1+8 To FWY2 Do
                     Begin
                        GetImage(FWX1,ScLn,FWX2,ScLn+7,Scrl);
                        PutImage(FWX1,ScLn-8,Scrl,NormalPut);
                        ScLn := ScLn + 7;
                     End;
               End
            Else
               Begin
                  GetMem(Ptr,Size);
                  GetImage(FWX1,FWY1+8,FWX2,FWY2,Ptr^);
                  PutImage(FWX1,FWY1,Ptr^,NormalPut);
                  FreeMem(Ptr,Size);
               End;
            FXGotoXY(FXWhereX,High);
            DoBar(FWX1,FGrY,FWX2,FGrY+7,FGrB);
         End
   End;

Procedure FXWrite  (OutStr : String);

Var Temp : String;
    I,FC : Byte;
    Ch   : Char;

   Begin
      InWrite := True;
      Temp := '';
      FC := 0;
      If OutStr='' Then
         Begin
            InWrite := False;
            Exit;
         End;
      For I := 1 To Length(OutStr) Do
         If (FC=0) And (Pos(OutStr[I],#7+#8+#9+#10+#12+#13) > 0) Then FC := I;
      If FC > 0 Then
         Begin
            If FC > 1 Then
               Temp := Copy(OutStr,1,FC-1)
            Else
               Temp := '';
            Ch := OutStr[FC];
            Delete(OutStr,1,FC);
            InWrite := True;
            FXWrite  (Temp);
            InWrite := True;
            Case Ch Of
                  #7 : Begin End;
                  #8 : If FXWhereX > 1 Then FXGotoXY(FXWhereX-1,FXWhereY);
                  #9 : Begin
                          I := ((FXWhereX+8) Div 8) * 8;
                          InWrite := True;
                          If I > Wide Then
                             FXWriteLn('')
                          Else
                             FXGotoXY(I,FXWhereY);
                       End;
                  #10 : Begin
                           I := FXWhereX;
                           FXWriteLn('');
                           InWrite := True;
                           FXGotoXY(I,FXWhereY);
                        End;
                  #12 : FXClrScr;
                  #13 : Begin
                           InWrite := True;
                           FXGotoXY(1,FXWhereY);
                        End;
               End;
            FXWrite  (OutStr);
            InWrite := True;
            OutStr := '';
         End;
      If OutStr='' Then
         Begin
            InWrite := False;
            Exit;
         End;
      If Length(OutStr) >= (((WX2+1-WX1) - FXWhereX)+1) Then
         Begin
            Temp := OutStr;
            Delete(Temp,1,((WX2+1-WX1) - FXWhereX)+1);
            OutStr := Copy(OutStr,1,(((WX2+1-WX1) - FXWhereX)+1));
         End;
      DoBar(FGrX,FGrY,FGrX+(Length(OutStr)*8)-1,FGrY+7,FGrB);
      SetColor(FGrF);
      OutTextXY(FGrX,FGrY,OutStr);
      FXGotoXY(FXWhereX+Length(OutStr),FXWhereY);
      HandleScroll;
      If Temp <> '' Then
         Begin
            InWrite := True;
            FXWrite  (Temp);
         End;
      InWrite := False;
   End;

Procedure FXWriteLn(OutStr : String);

   Begin
      FXWrite(OutStr);
      InWrite := True;
      FXGotoXY(1,FXWhereY+1);
      HandleScroll;
      InWrite := False;
   End;

Procedure FXGotoXY(X,Y : Word);

   Begin
      If Not InWrite Then
         Begin
            If (X<1) Then X := 1;
            If (X>Wide) Then X := Wide;
            If (Y<1) Then Y := 1;
            If (Y>High) Then Y := High;
         End;
      FGrX := FWX1 + ((X-1)*8);
      FGrY := FWY1 + ((Y-1)*8);
   End;

Function  FXWhereX : Word;

   Begin
      FXWhereX := ((FGrX - FWX1) Div 8) + 1;
   End;

Function  FXWhereY : Word;

   Begin
      FXWhereY := ((FGrY - FWY1) Div 8) + 1;
   End;

Procedure FXWindow(X1,Y1,X2,Y2 : Word);

   Begin
      FWX1 := (X1-1) * 8;
      FWY1 := (Y1-1) * 8;
      FWX2 := (X2-1) * 8 + 7;
      FWY2 := (Y2-1) * 8 + 7;
      FGrX := FWX1;
      FGrY := FWY1;
      WX1 := X1;
      WX2 := X2;
      WY1 := Y1;
      WY2 := Y2;
      Wide := (WX2 - WX1) + 1;
      High := (WY2 - WY1) + 1;
   End;

Procedure FXClrScr;

   Begin
      DoBar(FWX1,FWY1,FWX2,FWY2,FGrB);
      FXGotoXY(1,1);
   End;

Procedure FXTextColor(Fore : Word);

   Begin
      FGrF := Fore;
   End;

Procedure FXTextBackGround(Back : Word);

   Begin
      FGrB := Back;
   End;

Procedure FXColor(Fore,Back : Word);

   Begin
      FGrF := Fore;
      FGrB := Back;
   End;

Function  FXForeGround : Word;

   Begin
      FXForeGround := FGrF;
   End;

Function  FXBackGround : Word;

   Begin
      FXBackGround := FGrB;
   End;

Procedure FXButton(X1,Y1,X2,Y2 : Word);

Var BX1,BX2,BY1,BY2 : Integer;

   Begin
      BX1 := FWX1+((X1-1)*8);
      BX2 := FWX1+((X2-1)*8)+7;
      BY1 := FWY1+((Y1-1)*8);
      BY2 := FWY1+((Y2-1)*8)+ 7;
      DoBar(BX1,BY1,BX2,BY2,7);
      SetColor(0);
      Rectangle(BX1,BY1,BX2,BY2);
      Rectangle(BX1+4,BY1+4,BX2-4,BY2-4);
      SetColor(15);
      Line(BX1+1,BY1+1,BX2-1,BY1+1);
      Line(BX1+2,BY1+2,BX2-2,BY1+2);
      Line(BX1+3,BY1+3,BX2-3,BY1+3);
      SetColor(8);
      Line(BX1+3,BY2-3,BX2-3,BY2-3);
      Line(BX1+2,BY2-2,BX2-2,BY2-2);
      Line(BX1+1,BY2-1,BX2-1,BY2-1);
      SetColor(0);
      Line(BX1+1,BY1+2,BX1+1,BY2-2);
      Line(BX1+2,BY1+3,BX1+2,BY2-3);
      Line(BX1+3,BY1+4,BX1+3,BY2-4);
   End;

Procedure FXClrEol;

   Begin
      DoBar(FGrX,FGrY,FWX2,FGrY+7,FGrB);
   End;

Procedure FXDelLine;

Var Scrl : Array[1..2566] Of Byte;
    ScLn : Byte;
    Size : LongInt;
    Ptr  : Pointer;

   Begin
      If FXWhereY<High Then
         Begin
            Size := ImageSize(FWX1,FGrY+8,FWX2,FWY2);
            If (Size > MaxAvail) Or (Size > 65535) Then
               Begin
                  For ScLn := FGrY+8 To FWY2 Do
                     Begin
                        GetImage(FWX1,ScLn,FWX2,ScLn+7,Scrl);
                        PutImage(FWX1,ScLn-8,Scrl,NormalPut);
                        ScLn := ScLn + 7;
                     End;
               End
            Else
               Begin
                  GetMem(Ptr,Size);
                  GetImage(FWX1,FGrY+8,FWX2,FWY2,Ptr^);
                  PutImage(FWX1,FGrY,Ptr^,NormalPut);
                  FreeMem(Ptr,Size);
               End;
         End;
      FXGotoXY(1,FXWhereY);
      DoBar(FWX1,FWY2-7,FWX2,FWY2,FGrB);
   End;

Procedure FXInsLine;

Var Scrl : Array[1..2566] Of Byte;
    ScLn : Byte;
    Size : LongInt;
    Ptr  : Pointer;

   Begin
      If FXWhereY<High Then
         Begin
            Size := ImageSize(FWX1,FGrY,FWX2,FWY2-8);
            If (Size > MaxAvail) Or (Size > 65535) Then
               Begin
                  For ScLn := FWY2-8 DownTo FGrY Do
                     Begin
                        GetImage(FWX1,ScLn,FWX2,ScLn+7,Scrl);
                        PutImage(FWX1,ScLn+8,Scrl,NormalPut);
                        ScLn := ScLn - 7;
                     End;
               End
            Else
               Begin
                  GetMem(Ptr,Size);
                  GetImage(FWX1,FGrY,FWX2,FWY2-8,Ptr^);
                  PutImage(FWX1,FGrY+8,Ptr^,NormalPut);
                  FreeMem(Ptr,Size);
               End;
         End;
      FXGotoXY(1,FXWhereY);
      DoBar(FWX1,FGrY,FWX2,FGrY+7,FGrB);
   End;

Procedure FXStoreArea(X1,Y1,X2,Y2 : Word);

   Begin
      If ImageSize(X1,Y1,X2,Y2) > 65535 Then
         Begin
            StoreErr := 1;
            Exit;
         End;
      If StorePl = MaxStorage Then
         Begin
            StoreErr := 2;
            Exit;
         End;
      If MaxAvail < ImageSize(X1,Y1,X2,Y2) Then
         Begin
            StoreErr := 3;
            Exit;
         End;
      Inc(StorePl);
      GetMem(Store[StorePl].AreaPtr,ImageSize(X1,Y1,X2,Y2));
      Store[StorePl].X1 := X1;
      Store[StorePl].Y1 := Y1;
      Store[StorePl].Size := ImageSize(X1,Y1,X2,Y2);
      GetImage(X1,Y1,X2,Y2,Store[StorePl].AreaPtr^);
   End;

Procedure FXStoreScreen(X1,Y1,X2,Y2 : Word);

   Begin
      X1 := ((X1-1)*8);
      Y1 := ((Y1-1)*8);
      X2 := ((X2-1)*8)+7;
      Y2 := ((Y2-1)*8)+7;
      FXStoreArea(X1,Y1,X2,Y2);
   End;

Procedure FXRestoreArea;

   Begin
      If StorePl=0 Then
         Begin
            StoreErr := 4;
            Exit;
         End;
      PutImage(Store[StorePl].X1,Store[StorePl].Y1,Store[StorePl].AreaPtr^,NormalPut);
      FreeMem(Store[StorePl].AreaPtr,Store[StorePl].Size);
      Dec(StorePl);
   End;

Function StoreError : Byte;

   Begin
      StoreError := StoreErr;
      StoreErr := 0;
   End;

   Begin
      FillChar(FGrScreen,SizeOf(FGrScreen),#0);
      FillChar(Store,SizeOf(Store),#0);
      StorePl := 0;
      StoreErr := 0;
      FGrX := 0;
      FGrY := 0;
      FGrF := 15;
      FGrB := 0;
      FWX1 := 0;
      FWX2 := 639;
      FWY1 := 0;
      FWY2 := 199;
      WX1  := 1;
      WX2  := 80;
      WY1  := 1;
      WY2  := 25;
      Wide := 80;
      High := 25;
      InWrite := False;
   End.

