Unit FXInput;

Interface

Uses DOS,CRT;

Const WhiteSpace     = ' ()"-=~!@#$%^&*+_\/|:;[]{}<>?,.'+Chr(9);
Const FileNameChars  = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890$#&@!%()-_{}`''~^.';
Const PathNameChars  = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890$#&@!%()-_{}`''~^:\.';

Var FXAcceptedIn  : Array[1..10] Of String;
    FXReturnCode  : Byte;
    FXAllowPress  : Array[0..29] Of Boolean;
    FXFillChar    : Char;
    FXInsertMode  : Boolean;
    FXRestore     : Boolean;
    FXLastPlace   : Byte;
    FXEditFG      : Byte;
    FXEditBG      : Byte;
    FXLastCtrlY   : String;
    FXWrappedWord : String;

Function GetString(InString,UseStr : String; Pl,Len,Frmt : Word) : String;

Implementation

Procedure Color(FG,BG : Byte);

   Begin
      TextColor(FG);
      TextBackGround(BG);
   End;

Procedure Cursor(CursorType : Byte);

Var Regs : Registers;

   Begin
      If CursorType > 0 Then
         Begin
            Regs.AX := $100;
            Case CursorType Of
                  0 : Regs.CX := (8 Shl 8)+7;
                  1 : Regs.CX := (6 Shl 8)+7;
                  2 : Regs.CX := (4 Shl 8)+7;
                  3 : Regs.CX := (2 Shl 8)+7;
                  4 : Regs.CX := (0 Shl 8)+7;
               End;
            Intr($10,Regs);
         End
      Else
         Begin
            Regs.AH := 1;
            Regs.CH := $20;
            Regs.CL := 0;
            Intr($10,Regs);
         End;
   End;

Function UpperCase(InString : String) : String;

Var I : Byte;

   Begin
      For I := 1 To Length(InString) Do InString[I] := UpCase(InString[I]);
      UpperCase := InString;
   End;

Function LowerCase(InString : String) : String;

Var I : Byte;

   Begin
      For I := 1 To Length(InString) Do
         If (InString[I] >= 'A') And (InString[I] <= 'Z') Then
            InString[I] := Chr(Ord(InString[I]) + 32);
      LowerCase := InString;
   End;

Function FirstLetterUpCase(InString : String) : String;

Var I : Byte;

   Begin
      InString := LowerCase(InString);
      InString[1] := UpCase(InString[1]);
      For I := 1 To Length(InString) Do
         If (Pos(InString[I],WhiteSpace) > 0) And (I < Length(InString)) Then
            InString[I+1] := UpCase(InString[I+1]);
      FirstLetterUpCase := InString;
   End;

Function WordLeft(InString : String; Pl : Byte) : Byte;

   Begin
      If Pl < 1 Then Pl := 1;
      If Pl > Length(InString) Then Pl := Length(InString);
      If Pl > 1 Then Dec(Pl);
      While (Pos(InString[Pl],WhiteSpace) > 0) And (Pl > 1) Do Dec(Pl);
      While (Pos(InString[Pl],WhiteSpace) = 0) And (Pl > 1) Do Dec(Pl);
      If (Pl > 1) And (Pos(InString[Pl],WhiteSpace) > 0) Then Inc(Pl);
      WordLeft := Pl;
   End;

Function WordRight(InString : String; Pl : Byte) : Byte;

   Begin
      If Pl < 1 Then Pl := 1;
      If Pl > Length(InString) Then Pl := Length(InString);
      If Pl < Length(InString) Then Inc(Pl);
      While (Pos(InString[Pl],WhiteSpace) = 0) And (Pl < Length(InString)) Do Inc(Pl);
      While (Pos(InString[Pl],WhiteSpace) > 0) And (Pl < Length(InString)) Do Inc(Pl);
      If Pl = Length(InString) Then Inc(Pl);
      WordRight := Pl;
   End;

Function GetString(InString,UseStr : String; Pl,Len,Frmt : Word) : String;

Var Done  : Boolean;
    SX,SY : Byte;
    SA,I  : Byte;
    Ch    : Char;
    SaveS : String;

Label DoneLbl;

   Begin
      SaveS := InString;
      Done := False;
      FXReturnCode := 0;
      SX := WhereX;
      SY := WhereY;
      SA := TextAttr;
      Color(FXEditFG,FXEditBG);
      If Pl > Length(InString)+1 Then Pl := Length(InString)+1;
      If Pl < 1 Then Pl := 1;
      Repeat
         Begin
            Cursor(0);
            GotoXY(SX,SY);
            If Length(InString) > Len Then InString[0] := Chr(Len);
            Case Frmt Of
                  1 : InString := UpperCase(InString);
                  2 : InString := LowerCase(InString);
                  3 : InString := FirstLetterUpCase(InString);
               End;
            Write  (InString);
            If Length(InString) < Len Then For I := 1 To Len-Length(InString) Do Write  (FXFillChar);
            GotoXY(SX,SY);
            If Pl > 1 Then Write  (Copy(InString,1,Pl-1));
            If FXInsertMode Then
               Cursor(2)
            Else
               Cursor(1);
            If Pl > Len Then Cursor(0);
            Repeat Until KeyPressed;
            Ch := ReadKey;
            If (Ch=Chr(0)) And KeyPressed Then
               Begin
                  Ch := ReadKey;
                  Case Ord(Ch) Of
                       115  : Pl := WordLeft(InString,Pl);
                       116  : Pl := WordRight(InString,Pl);
                        75  : If Pl > 1 Then Dec(Pl);
                        77  : If Pl < Length(InString)+1 Then Inc(Pl);
                        82  : FXInsertMode := Not FXInsertMode;
                        83  : Delete(InString,Pl,1);
                        71  : Pl := 1;
                        79  : Pl := Length(InString)+1;
                       119  : If FXAllowPress[21] Then
                                 Begin
                                    FXReturnCode := 21;
                                    Goto DoneLbl;
                                 End;
                       117  : If FXAllowPress[22] Then
                                 Begin
                                    FXReturnCode := 22;
                                    Goto DoneLbl;
                                 End;
                       132  : If FXAllowPress[23] Then
                                 Begin
                                    FXReturnCode := 23;
                                    Goto DoneLbl;
                                 End;
                       118  : If FXAllowPress[24] Then
                                 Begin
                                    FXReturnCode := 24;
                                    Goto DoneLbl;
                                 End;
                        73  : If FXAllowPress[6] Then
                                 Begin
                                    FXReturnCode := 6;
                                    Goto DoneLbl;
                                 End;
                        81  : If FXAllowPress[7] Then
                                 Begin
                                    FXReturnCode := 7;
                                    Goto DoneLbl;
                                 End;
                        72  : If FXAllowPress[4] Then
                                 Begin
                                    FXReturnCode := 4;
                                    Goto DoneLbl;
                                 End;
                        80  : If FXAllowPress[5] Then
                                 Begin
                                    FXReturnCode := 5;
                                    Goto DoneLbl;
                                 End;
                        59..68 : If FXAllowPress[Ord(Ch)-48] Then
                                    Begin
                                       FXReturnCode := Ord(Ch)-48;
                                       Goto DoneLbl;
                                    End;
                        Else
                           Begin
                           End;
                     End;
               End
            Else
               Begin
                  If (Ch > Chr(31)) And ((Pos(UpCase(Ch),UseStr) > 0) Or (UseStr = '')) And (Pl <= Len) Then
                     Begin
                        If FXInsertMode Then
                           Insert(Ch,InString,Pl)
                        Else
                           Begin
                              InString[Pl] := Ch;
                              If Pl=Length(InString)+1 Then InString[0] := Chr(Ord(InString[0]) + 1);
                           End;
                        Inc(Pl);
                        If (Pl>Len) And (FXAllowPress[2]) Then
                           Begin
                              FXReturnCode := 2;
                              If (WordLeft(InString,Length(InString)) > 1) And (InString[Length(InString)] <> ' ') Then
                                 Begin
                                    FXWrappedWord := Copy(InString,WordLeft(InString,Length(InString)),
                                       Length(InString)-WordLeft(InString,Length(InString))+1);
                                    InString := Copy(InString,1,WordLeft(InString,Length(InString))-1);
                                    While (InString[Length(InString)]=' ') Do
                                       Delete(InString,Length(InString),1)
                                 End;
                              Goto DoneLbl;
                           End;
                     End;
                  If (Ch = Chr(8)) Then
                     Begin
                        If (Pl > 1) Then
                           Begin
                              If FXInsertMode Then Delete(InString,Pl-1,1);
                              Dec(Pl);
                           End
                        Else
                           If FXAllowPress[3] Then
                              Begin
                                 FXReturnCode := 3;
                                 Goto DoneLbl;
                              End;
                     End;
                  If (Ch = Chr(13)) Then
                     Begin
                        If FXInsertMode Then
                           Begin
                              If FXAllowPress[9] Then
                                 Begin
                                    FXWrappedWord := Copy(InString,PL,Length(InString)-PL+1);
                                    InString := Copy(InString,1,PL-1);
                                    FXReturnCode := 9;
                                    Goto DoneLbl;
                                 End
                              Else
                                 If FXAllowPress[1] Then
                                    Begin
                                       FXReturnCode := 1;
                                       Goto DoneLbl;
                                    End;
                           End
                        Else
                           Begin
                              If FXAllowPress[1] Then
                                 Begin
                                    FXReturnCode := 1;
                                    Goto DoneLbl;
                                 End;
                           End;
                     End;
                  If (Ch = Chr(25)) Then
                     Begin
                        FXLastCtrlY := InString;
                        InString := '';
                        Pl := 1;
                        If FXAllowPress[8] Then
                           Begin
                              FXReturnCode := 8;
                              Goto DoneLbl;
                           End;
                     End;
                  If (Ch = Chr(20)) Then
                     Begin
                        FXLastCtrlY := Copy(InString,Pl,WordRight(InString,Pl)-Pl);
                        Delete(InString,Pl,WordRight(InString,Pl)-Pl);
                     End;
                  If (Ch = Chr(21)) Then
                     Begin
                        Insert(FXLastCtrlY,InString,Pl);
                        Pl := Pl + Length(FXLastCtrlY);
                     End;
                  If (Ch = Chr(27)) And (FXAllowPress[0]) Then
                     Begin
                        If FXRestore Then InString := SaveS;
                        FXReturnCode := 0;
                        Goto DoneLbl;
                     End;
               End;
         End;
      Until Done;
      Case Frmt Of
            1 : InString := UpperCase(InString);
            2 : InString := LowerCase(InString);
            3 : InString := FirstLetterUpCase(InString);
         End;

      DoneLbl:

      GetString := InString;
      Cursor(0);
      FXLastPlace := Pl;
      TextAttr := SA;
      GotoXY(SX,SY);
      If Length(InString) > Len Then InString[0] := Chr(Len);
      Case Frmt Of
            1 : InString := UpperCase(InString);
            2 : InString := LowerCase(InString);
            3 : InString := FirstLetterUpCase(InString);
         End;
      Write  (InString);
      If Length(InString) < Len Then For I := 1 To Len-Length(InString) Do Write  (' ');
      GotoXY(SX,SY);
   End;

   Begin
      FillChar(FXAcceptedIn,SizeOf(FXAcceptedIn),0);
      FXReturnCode  := 0;
      FillChar(FXAllowPress,30,0);
      FXFillChar    := Chr(176);
      FXInsertMode  := False;
      FXRestore     := True;
      FXLastPlace   := 1;
      FXAllowPress[0] := True;
      FXAllowPress[1] := True;
      FXAllowPress[9] := False;
      FXEditFG      := 15;
      FXEditBG      := 5;
      FXLastCtrlY   := '';
      FXWrappedWord := '';
   End.

