Unit FXWindow;

Interface

Uses DOS,CRT;

Const ScreenLns = 50;
      AddToBrdr = 1;
      MaxWindow = 10;

Type BorderType = Array[1..10] Of Char;

Const WindowBorder1  : BorderType = ('','','','','','','','','','');
      WindowBorder2  : BorderType = ('','','','','','','','','','');
      WindowBorder3  : BorderType = ('','','','','','','','','','');
      WindowBorder4  : BorderType = ('','','','','','','','','','');
      WindowBorder5  : BorderType = ('','','','','','','','','','');
      WindowBorder6  : BorderType = ('','','','','','','','','','');
      WindowBorder7  : BorderType = ('','','','','','','','','','');
      WindowBorder8  : BorderType = ('','','','','','','','','','');
      WindowBorder9  : BorderType = ('','','','','','','','','','');
      WindowBorder10 : BorderType = (',','.','`','''','-','-','|','|','|','|');
      WindowBorder11 : BorderType = ('+','+','+','+','-','-','|','|','|','|');
      WindowBorder12 : BorderType = (' ',' ',' ',' ',' ',' ',' ',' ',' ',' ');
      WindowBorder13 : BorderType = (' ','',' ','',' ',' ',' ','',' ',' ');

Type WinTextPtr  = ^WinTextType;
     WinInfoPtr  = ^WinInfoType;
     WinGridPtr  = ^WinGridType;
     WinGridType = Array[0..((160*ScreenLns)-1)] Of Char;
     WinTextType = Record
                      Pos : Array[1..ScreenLns*80] Of Record
                                                         Ch : Char;
                                                         At : Byte;
                                                      End;
                   End;
     WinInfoType = Record
                      WinMin    : Word;
                      WinMax    : Word;
                      WinAttrib : Byte;
                      WinXLoc   : Byte;
                      WinYLoc   : Byte;
                      WinCursor : Byte;
                   End;

Var Screen    : WinTextPtr;
    ScrnGrid  : WinGridPtr;
    WindowNum : Byte;
    CurWindow : Byte;
    CursorVal : Byte;
    DefCursor : Byte;
    WinInfo   : Array[0..MaxWindow] Of WinInfoPtr;
    WinText   : Array[0..MaxWindow] Of WinTextPtr;
    FXScrnLen : Byte;

Procedure BlinkOff;
Procedure BlinkOn;
Procedure CenterCoords(Width : Byte; Var X1,X2 : Byte);
Function WinLength : Byte;
Procedure WriteXY(XLoc,YLoc,FG,BG : Byte; OutStr : String);
Procedure WriteBoth(XLoc,YLoc,FG,BG : Byte; OutStr : String);
Function WindowXLoc : Byte;
Function WindowYLoc : Byte;
Function XRel(X : Byte) : Byte;
Function YRel(Y : Byte) : Byte;
Function WindowXWide : Byte;
Function WindowYWide : Byte;
Procedure Cursor(CursorType : Byte);
Function GridXY(X,Y : Byte) : Word;
Function XYVal(X,Y : Byte) : Integer;
Procedure Color(FG,BG : Byte);
Procedure WriteTrans(X,Y : Byte; OutStr : String);
Procedure ColorBlock(X1,Y1,X2,Y2,FG,BG : Byte);
Procedure DrawWindow(X1,Y1,X2,Y2,FG,BG,Border : Byte; Explode,Shadow : Boolean; Title : String);
Procedure RemoveWindow;
Procedure MoveWindow(X,Y : Integer; Shadow : Boolean);

Implementation

Procedure BlinkOff;

Var Regs : Registers;

   Begin
      Regs.Ax := $1003;
      Regs.Bl := Regs.Bl Xor Regs.Bl;
      Intr($10,Regs);
   End;

Procedure BlinkOn;

Var Regs : Registers;

   Begin
      Regs.Ax := $1003;
      Regs.Bl := 1;
      Intr($10,Regs);
   End;

Procedure CenterCoords(Width : Byte; Var X1,X2 : Byte);

Var I : Byte;

   Begin
      If (X1=1) And (X2=Width) Then Exit;
      I := X1 - 1;
      X1 := X1 - I;
      X2 := X2 - I;
      X1 := X1 + ((Width-X2) Div 2);
      X2 := X2 + ((Width-X2) Div 2);
   End;

Function WinLength : Byte;

   Begin
      WinLength := Hi(WindMax) - Hi(WindMin) + 1;
   End;

Procedure WriteXY(XLoc,YLoc,FG,BG : Byte; OutStr : String);

Var I,J,A : Word;

   Begin
      J := ((YLoc-1)*80)+XLoc;
      A := (BG*16)+FG;
      For I := 1 To Length(OutStr) Do
         Begin
            Screen^.Pos[J-1+I].At := A;
            Screen^.Pos[J-1+I].Ch := OutStr[I];
         End;
   End;

Procedure WriteBoth(XLoc,YLoc,FG,BG : Byte; OutStr : String);

Var I,J,A : Word;

   Begin
      J := ((YLoc-1)*80)+XLoc;
      A := (BG*16)+FG;
      For I := 1 To Length(OutStr) Do
         Begin
            Screen^.Pos[J-1+I].At := A;
            Screen^.Pos[J-1+I].Ch := OutStr[I];
            WinText[CurWindow]^.Pos[J-1+I].At := A;
            WinText[CurWindow]^.Pos[J-1+I].Ch := OutStr[I];
         End;
   End;

Function WindowXLoc : Byte;

   Begin
      WindowXLoc := (Lo(WindMin)-AddToBrdr)+1;
   End;

Function WindowYLoc : Byte;

   Begin
      WindowYLoc := (Hi(WindMin)-1)+1;
   End;

Function XRel(X : Byte) : Byte;

   Begin
      XRel := Lo(WindMin) + X;
   End;

Function YRel(Y : Byte) : Byte;

   Begin
      YRel := Hi(WindMin) + Y;
   End;

Function WindowXWide : Byte;

   Begin
      WindowXWide := ((Lo(WindMax)+AddToBrdr)+1) - ((Lo(WindMin)-AddToBrdr)+1);
   End;

Function WindowYWide : Byte;

   Begin
      WindowYWide := ((Hi(WindMax)+1)+1) - ((Hi(WindMin)-1)+1);
   End;

Procedure Cursor(CursorType : Byte);

Var Regs : Registers;

   Begin
      If CursorType > 0 Then
         Begin
            Regs.AX := $100;
            Case CursorType Of
                  0 : Regs.CX := (8 Shl 8)+7;
                  1 : Regs.CX := (6 Shl 8)+7;
                  2 : Regs.CX := (4 Shl 8)+7;
                  3 : Regs.CX := (2 Shl 8)+7;
                  4 : Regs.CX := (0 Shl 8)+7;
               End;
            Intr($10,Regs);
         End
      Else
         Begin
            Regs.AH := 1;
            Regs.CH := $20;
            Regs.CL := 0;
            Intr($10,Regs);
         End;
      CursorVal := CursorType;
   End;

Function GridXY(X,Y : Byte) : Word;

   Begin
      GridXY := (X*2)+(Y*160)-162;
   End;

Function XYVal(X,Y : Byte) : Integer;

   Begin
      XYVal := (((Y-1)*80)+X);
   End;

Procedure Color(FG,BG : Byte);

   Begin
      TextColor(FG);
      TextBackGround(BG);
   End;

Procedure WriteTrans(X,Y : Byte; OutStr : String);

Var I : Byte;

   Begin
      If Length(OutStr) > 0 Then
         For I := 1 To Length(OutStr) Do
            Screen^.Pos[XYVal(I+X-1,Y)].Ch := OutStr[I];
   End;

Procedure ColorBlock(X1,Y1,X2,Y2,FG,BG : Byte);

Var I,J : Byte;

   Begin
      For J := Y1 To Y2 Do For I := X1 To X2 Do Screen^.Pos[XYVal(I,J)].At := FG+BG*16;
   End;

Procedure DrawWindow(X1,Y1,X2,Y2,FG,BG,Border : Byte; Explode,Shadow : Boolean; Title : String);

Var UserBorder  : BorderType;
    I           : Integer;
    EX1,EX2     : Integer;
    EY1,EY2     : Integer;
    ExplodeStep : Byte;
    DoneExplode : Boolean;
    CenterXWin  : Boolean;
    CenterYWin  : Boolean;

   Procedure ClearBlock(CX1,CY1,CX2,CY2,CFG,CBG : Byte);

   Var J : Integer;

      Begin
         Window(CX1+1,CY1+1,CX2-1,CY2-1);
         Color(CFG,CBG);
         ClrScr;
         Window(1,1,80,FXScrnLen);
         GotoXY(CX1,CY1);
         Write  (UserBorder[1]);
         For J := CX1+1 To CX2-1 Do Write  (UserBorder[5]);
         Write  (UserBorder[2]);
         For J := CY1+1 To CY2-1 Do
            Begin
               GotoXY(CX1,J);
               Write  (UserBorder[7]);
               GotoXY(CX2,J);
               Write  (UserBorder[8]);
            End;
         GotoXY(CX1,CY2);
         Write  (UserBorder[3]);
         For J := CX1+1 To CX2-1 Do Write  (UserBorder[6]);
         Screen^.Pos[XYVal(CX2,CY2)].Ch := UserBorder[4];
         Screen^.Pos[XYVal(CX2,CY2)].At := TextAttr;
      End;

   Begin
      CenterXWin := False;
      CenterYWin := False;
      If (Title <> '') And (Pos(Title[1],'') > 0) Then
         Begin
            If Title[1] = '' Then CenterXWin := True;
            If Title[1] = '' Then CenterYWin := True;
            If Title[1] = '' Then
               Begin
                  CenterXWin := True;
                  CenterYWin := True;
               End;
            Delete(Title,1,1);
         End;
      If (MaxAvail > (SizeOf(WinTextType)+SizeOf(WinInfoType))) And (WindowNum <= MaxWindow) Then
         Begin
            If X1 > X2 Then
               Begin
                  I := X1;
                  X1 := X2;
                  X2 := I;
               End;
            If Y1 > Y2 Then
               Begin
                  I := Y1;
                  Y1 := Y2;
                  Y2 := I;
               End;
            If CenterXWin Then CenterCoords(80,X1,X2);
            If CenterYWin Then CenterCoords(FXScrnLen,Y1,Y2);
            New(WinInfo[WindowNum]);
            New(WinText[WindowNum]);
            WinInfo[WindowNum]^.WinMin := WindMin;
            WinInfo[WindowNum]^.WinMax := WindMax;
            WinInfo[WindowNum]^.WinAttrib := TextAttr;
            WinInfo[WindowNum]^.WinXLoc := WhereX;
            WinInfo[WindowNum]^.WinYLoc := WhereY;
            WinInfo[WindowNum]^.WinCursor := CursorVal;
            WinText[WindowNum]^ := Screen^;
            Cursor(0);
            If Border < 1 Then Border := 1;
            If Border > 13 Then Border := 13;
            Case Border Of
                  1 : UserBorder := WindowBorder1;
                  2 : UserBorder := WindowBorder2;
                  3 : UserBorder := WindowBorder3;
                  4 : UserBorder := WindowBorder4;
                  5 : UserBorder := WindowBorder5;
                  6 : UserBorder := WindowBorder6;
                  7 : UserBorder := WindowBorder7;
                  8 : UserBorder := WindowBorder8;
                  9 : UserBorder := WindowBorder9;
                  10 : UserBorder := WindowBorder10;
                  11 : UserBorder := WindowBorder11;
                  12 : UserBorder := WindowBorder12;
                  13 : UserBorder := WindowBorder13;
               End;
            WindowNum := WindowNum + 1;
            If Explode Then
               Begin
                  DoneExplode := False;
                  EX1 := (((X1+X2) Div 2) - 2);
                  EX2 := (((X1+X2) Div 2) + 2);
                  EY1 := (((Y1+Y2) Div 2) - 2);
                  EY2 := (((Y1+Y2) Div 2) + 2);
                  If ((X1+X2) Mod 2) = 1 Then EX2 := EX2 + 1;
                  If ((Y1+Y2) Mod 2) = 1 Then EY2 := EY2 + 1;
                  If (X2-X1 > -1) And (X2-X1 < 20) Then ExplodeStep := 1;
                  If (X2-X1 > 19) And (X2-X1 < 40) Then ExplodeStep := 2;
                  If (X2-X1 > 39) And (X2-X1 < 60) Then ExplodeStep := 3;
                  If (X2-X1 > 59) And (X2-X1 < 81) Then ExplodeStep := 4;
                  Repeat
                     Begin
                        If EX1 <= X1 Then EX1 := X1;
                        If EX2 >= X2 Then EX2 := X2;
                        If EY1 <= Y1 Then EY1 := Y1;
                        If EY2 >= Y2 Then EY2 := Y2;
                        ClearBlock(EX1,EY1,EX2,EY2,FG,BG);
                        If Shadow Then
                           Begin
                              For I := EX1+2 To EX2+2 Do Screen^.Pos[XYVal(I,EY2+1)].At := 8;
                              For I := EY1+1 To EY2+1 Do
                                 Begin
                                    Screen^.Pos[XYVal(EX2+1,I)].At := 8;
                                    Screen^.Pos[XYVal(EX2+2,I)].At := 8;
                                 End;
                           End;
                        EX1 := EX1 - ExplodeStep;
                        EX2 := EX2 + ExplodeStep;
                        EY1 := EY1 - 1;
                        EY2 := EY2 + 1;
                        If EX1 <= X1 Then EX1 := X1;
                        If EX2 >= X2 Then EX2 := X2;
                        If EY1 <= Y1 Then EY1 := Y1;
                        If EY2 >= Y2 Then EY2 := Y2;
                        If (EX1 = X1) And (EX2 = X2) And (EY1 = Y1) And (EY2 = Y2) Then DoneExplode := True;
                     End;
                  Until DoneExplode;
               End;
            ClearBlock(X1,Y1,X2,Y2,FG,BG);
            If Title <> '' Then
               Begin
                  I := (X1+1+((X2-X1) Div 2)) - ((Length(Title)+4) Div 2);
                  GotoXY(I,Y1);
                  Write  (UserBorder[9]+' '+Title+' '+UserBorder[10]);
               End;
            Window(X1+AddToBrdr,Y1+1,X2-AddToBrdr,Y2-1);
            If Shadow Then
               Begin
                  For I := X1+2 To X2+2 Do Screen^.Pos[XYVal(I,Y2+1)].At := 8;
                  For I := Y1+1 To Y2+1 Do
                     Begin
                        Screen^.Pos[XYVal(X2+1,I)].At := 8;
                        Screen^.Pos[XYVal(X2+2,I)].At := 8;
                     End;
               End;
            GotoXY(1,1);
            Cursor(DefCursor);
         End
      Else
         WriteLn(Chr(7)+'Window Error: Too Many Windows Open!');
   End;

Procedure RemoveWindow;

   Begin
      If WindowNum > 0 Then
         Begin
            Cursor(0);
            WindowNum := WindowNum - 1;
            Screen^ := WinText[WindowNum]^;
            WindMin := WinInfo[WindowNum]^.WinMin;
            WindMax := WinInfo[WindowNum]^.WinMax;
            TextAttr := WinInfo[WindowNum]^.WinAttrib;
            GotoXY(WinInfo[WindowNum]^.WinXLoc,WinInfo[WindowNum]^.WinYLoc);
            Cursor(WinInfo[WindowNum]^.WinCursor);
            Dispose(WinText[WindowNum]);
            Dispose(WinInfo[WindowNum]);
         End
      Else
         WriteLn(Chr(7)+'Window Error: No Windows To Remove!');
   End;

Procedure MoveWindow(X,Y : Integer; Shadow : Boolean);

Var HoldScreen  : WinTextPtr;
    XL,YL       : Byte;
    CursorSave  : Byte;
    I,J         : Integer;
    X1,Y1       : Integer;
    X2,Y2       : Integer;

   Begin
      If WindowNum > 0 Then
         Begin
            New(HoldScreen);
            HoldScreen^ := WinText[WindowNum-1]^;
            CursorSave := CursorVal;
            XL := WhereX;
            YL := WhereY;
            Cursor(0);
            X1 := (Lo(WindMin)-AddToBrdr)+1;
            Y1 := (Hi(WindMin)-1)+1;
            X2 := (Lo(WindMax)+AddToBrdr)+1;
            Y2 := (Hi(WindMax)+1)+1;
            For J := X1 To X2 Do
               For I := Y1 To Y2 Do
                  Begin
                     HoldScreen^.Pos[XYVal(X+J,Y+I)].Ch := Screen^.Pos[XYVal(J,I)].Ch;
                     HoldScreen^.Pos[XYVal(X+J,Y+I)].At := Screen^.Pos[XYVal(J,I)].At;
                  End;
            If Shadow Then
               Begin
                  For I := X1+2 To X2+2 Do HoldScreen^.Pos[XYVal(I+X,Y2+Y+1)].At := 8;
                  For I := Y1+1 To Y2+1 Do
                     Begin
                        HoldScreen^.Pos[XYVal(X2+1+X,I+Y)].At := 8;
                        HoldScreen^.Pos[XYVal(X2+2+X,I+Y)].At := 8;
                     End;
               End;
            Screen^ := HoldScreen^;
            Window((X1+AddToBrdr)+X,(Y1+1)+Y,(X2-AddToBrdr)+X,(Y2-1)+Y);
            GotoXY(XL,YL);
            Cursor(CursorSave);
            Dispose(HoldScreen);
         End
      Else
         WriteLn(Chr(7)+'Window Error: No Window To Move!');
   End;
   
   Begin
      FXScrnLen := WinLength;
      New(Screen);
      New(ScrnGrid);
      If LastMode = 7 Then
         Begin
            Screen   := Ptr($B000,$0000);
            ScrnGrid := Ptr($B000,$0000);
         End
      Else
         Begin
            Screen   := Ptr($B800,$0000);
            ScrnGrid := Ptr($B800,$0000);
         End;
      WindowNum := 0;
      CurWindow := 0;
      CursorVal := 0;
      DefCursor := 1;
   End.

