Unit MousUnit;

Interface

Uses DOS;

Const Multiple = 8;

Type MouseObj = Object
                   Regs         : Registers;
                   Int          : Word;
                   Buttons      : Word;
                   InitOK       : Boolean;
                   LastX        : Word;
                   LastY        : Word;
                   Cursor       : Boolean;
                   HorRange     : Word;
                   VerRange     : Word;
                   Press1       : Boolean;
                   Press2       : Boolean;
                   Press3       : Boolean;
                   PressX       : Word;
                   PressY       : Word;
                   LowHorSense  : Word;
                   HighHorSense : Word;
                   CurHorSense  : Word;
                   LowVerSense  : Word;
                   HighVerSense : Word;
                   CurVerSense  : Word;
                   LowDouSense  : Word;
                   HighDouSense : Word;
                   CurDouSense  : Word;

                   Function  Pressed(BNum : Byte) : Boolean;
                   Function  Init(Inter : Word; Cur : Boolean; Hor,Ver : Word) : Boolean;
                   Function  X : Word;
                   Function  Y : Word;

                   Procedure SetXY(SX,SY : Word);
                   Procedure Handler;
                   Procedure ShowCursor;
                   Procedure HideCursor;
                   Procedure Done;
                   Procedure SetCursor(ScrCh,CurCh : Char; ScrAt,CurAt : Byte);
                   Procedure SetSense(Hor,Ver,Dou : Word);
                   Procedure GetSense(Var Hor,Ver,Dou : Word);
                   Procedure GetSenses;
                End;

Var Mouse : MouseObj;

Implementation

Function MouseObj.Pressed(BNum : Byte) : Boolean;

   Begin
      Regs.AX := $5;
      Regs.BX := BNum-1;
      Intr(Int,Regs);
      Press1 := Odd(Regs.AX Shr 0);
      Press2 := Odd(Regs.AX Shr 1);
      If Buttons=3 Then
         Press3 := Odd(Regs.AX Shr 2)
      Else
         Press3 := False;
      PressX := (Regs.CX Div Multiple) + 1;
      PressY := (Regs.DX Div Multiple) + 1;
      Case BNum Of
            1 : Pressed := Press1;
            2 : Pressed := Press2;
            3 : Pressed := Press3;
         End;
   End;

Function MouseObj.Init(Inter : Word; Cur : Boolean; Hor,Ver : Word) : Boolean;

Var OK : Boolean;

   Begin
      OK := False;
      Int := Inter;
      Regs.AX := $0;
      Intr(Int,Regs);
      OK := Regs.AX = $FFFF;
      If OK Then
         Begin
            Case Regs.BX Of
                  $FFFF : Buttons := 2;
                  $0000 : Buttons := 3;
                  $0003 : Buttons := 3;
               End;
            Regs.AX := $10;
            Regs.CX := 0;
            Regs.DX := Hor*Multiple-1;
            Regs.SI := 0;
            Regs.DI := Ver*Multiple-1;
            Intr(Int,Regs);
            Regs.AX := $3;
            Intr(Int,Regs);
            Press1 := Odd(Regs.BX Shr 0);
            Press2 := Odd(Regs.BX Shr 1);
            If Buttons=3 Then
               Press3 := Odd(Regs.BX Shr 2)
            Else
               Press3 := False;
            Regs.AX := $7;
            Regs.CX := 0;
            Regs.DX := Hor*Multiple-1;
            Intr(Int,Regs);
            HorRange := Hor;
            Regs.AX := $8;
            Regs.CX := 0;
            Regs.DX := Ver*Multiple-1;
            Intr(Int,Regs);
            VerRange := Ver;
            If Cur Then
               Begin
                  Cursor := True;
                  Regs.AX := $1;
                  Intr(Int,Regs);
               End
            Else
               Cursor := False;
            Regs.AX := $4;
            Regs.CX := 1;
            Regs.DX := 1;
            Intr(Int,Regs);
            LastX := 1;
            LastY := 1;
         End;
      Init := OK;
      InitOK := OK;
   End;

Function MouseObj.X : Word;

   Begin
      Handler;
      X := LastX;
   End;

Function MouseObj.Y : Word;

   Begin
      Handler;
      Y := LastY;
   End;

Procedure MouseObj.SetXY(SX,SY : Word);

   Begin
      Regs.AX := $4;
      Regs.CX := SX*Multiple-1;
      Regs.DX := SY*Multiple-1;
      Intr(Int,Regs);
   End;

Procedure MouseObj.Handler;

   Begin
      Regs.AX := $3;
      Intr(Int,Regs);
      Press1 := Odd(Regs.BX Shr 0);
      Press2 := Odd(Regs.BX Shr 1);
      If Buttons=3 Then
         Press3 := Odd(Regs.BX Shr 2)
      Else
         Press3 := False;
      LastX := (Regs.CX Div Multiple) + 1;
      LastY := (Regs.DX Div Multiple) + 1;
   End;

Procedure MouseObj.ShowCursor;

   Begin
      If Not Cursor Then
         Begin
            Cursor := True;
            Regs.AX := $1;
            Intr(Int,Regs);
         End;
   End;

Procedure MouseObj.HideCursor;

   Begin
      If Cursor Then
         Begin
            Cursor := False;
            Regs.AX := $2;
            Intr(Int,Regs);
         End;
   End;

Procedure MouseObj.Done;

   Begin
      If Cursor Then HideCursor;
      Regs.AX := $21;
      Intr(Int,Regs);
   End;

Procedure MouseObj.SetCursor(ScrCh,CurCh : Char; ScrAt,CurAt : Byte);

Var ScrArr : Array[1..2] Of Char;
    CurArr : Array[1..2] Of Char;
    ScrWrd : Word Absolute ScrArr;
    CurWrd : Word Absolute CurArr;

   Begin
      ScrArr[1] := ScrCh;
      ScrArr[2] := Chr(ScrAt);
      CurArr[1] := CurCh;
      CurArr[2] := Chr(CurAt);
      Regs.AX := $0A;
      Regs.BX := 0;
      Regs.CX := ScrWrd;
      Regs.DX := CurWrd;
      Intr(Int,Regs);
   End;

Procedure MouseObj.SetSense(Hor,Ver,Dou : Word);

   Begin
      Regs.AX := $1A;
      Regs.BX := Hor;
      Regs.CX := Ver;
      Regs.DX := Dou;
      Intr(Int,Regs);
   End;

Procedure MouseObj.GetSense(Var Hor,Ver,Dou : Word);

   Begin
      Regs.AX := $1B;
      Intr(Int,Regs);
      Hor := Regs.BX;
      Ver := Regs.CX;
      Dou := Regs.DX;
   End;

Procedure MouseObj.GetSenses;

   Begin
      GetSense(CurHorSense,CurVerSense,CurDouSense);
      SetSense(0,0,0);
      GetSense(LowHorSense,LowVerSense,LowDouSense);
      SetSense(1000,1000,1000);
      GetSense(HighHorSense,HighVerSense,HighDouSense);
      SetSense(CurHorSense,CurVerSense,CurDouSense);
   End;

   Begin
   End.

