Unit Pull2;

Interface

Uses DOS,CRT,Window2,MousUnit;

Type PullConfig = Record
                     BarColor    : Byte;
                     BarHigh     : Byte;
                     BarLow      : Byte;
                     BarSelect   : Byte;
                     MenuColor   : Byte;
                     MenuHigh    : Byte;
                     MenuLow     : Byte;
                     MenuSelect  : Byte;
                     MenuBorder  : Byte;
                     StatusColor : Byte;
                     StatusHigh  : Byte;
                     TimeColor   : Byte;
                     Background  : Byte;
                     PullType    : Byte;
                     ShowTime    : Boolean;
                     FillType    : Char;
                  End;
     MenuType = Record
                   IDName : String[30];
                   IDCode : Integer;
                   HelpSt : String[50];
                   Active : Byte;
                   HiLite : Byte;
                   Key    : Char;
                End;

Var Menu : Array[1..15,0..15] Of MenuType;
    MPlc : Array[1..15] Of Byte;
    MLen : Array[1..15] Of Byte;
    MWid : Byte;
    PCfg : PullConfig;
    MX   : Byte;
    LX   : Byte;
    MKey : String[32];
    MTop : Array[1..15] Of Record
                              X,XTo : Byte;
                              Act   : Boolean;
                           End;
    MT   : Array[1..15] Of Record
                              X,XTo : Byte;
                              Y,YTo : Byte;
                              Act   : Boolean;
                           End;

Procedure SetupScreen;
Function PullDownMenus : Integer;
Procedure AddMenu(Num,Ent : Byte; MenuName : String; MenuHelp : String;
                  Active : Byte; HiLite : Byte; KeyToUse : Char;
                  RetCode : Integer);
Procedure InitMenus;

Implementation

Procedure WriteBoth(X,Y,FG,BG : Byte; Str : String);

   Begin
      WriteXY(X,Y,FG,BG,Str,Win[CurWin].WPtr);
      WriteXY(X,Y,FG,BG,Str,Screen);
   End;

Function Date : String;

Var Year,Month,Day,Dow : Word;
    StrDay             : String[2];
    StrMonth           : String[3];
    StrYear            : String[4];

Type MonthArray = Array[1..12] Of String[3];

Const Months : MonthArray = ('Jan','Feb','Mar','Apr','May','Jun',
                             'Jul','Aug','Sep','Oct','Nov','Dec');

   Begin
      GetDate(Year,Month,Day,Dow);
      Str(Day,StrDay);
      StrMonth := Months[Month];
      Str(Year,StrYear);
      If (Length(StrDay) = 1) Then StrDay := '0' + StrDay;
      Date := StrDay + '-' + StrMonth + '-' + StrYear;
   End;

Function Time : String;

Var Hour,Minute,Second,Hundredth : Word;
    StrHour,StrMinute,StrSecond  : String[2];
    TempStringOut                : String;

   Begin
      GetTime(Hour,Minute,Second,Hundredth);
      Str(Hour:2,StrHour);
      Str(Minute:2,StrMinute);
      Str(Second:2,StrSecond);
      TempStringOut := StrHour + ':' + StrMinute + ':' + StrSecond;
      For Hour := 1 To Length(TempStringOut) Do If TempStringOut[Hour] = ' ' Then TempStringOut[Hour] := '0';
      Time := TempStringOut;
   End;

Function FormatStr(InString : String; Len : Byte) : String;

Var Temp : String;
    I    : Byte;

   Begin
      Temp := '';
      For I := 1 To Len Do Temp := Temp + ' ';
      If Length(InString) > Len Then
         Temp := Copy(InString,1,Len)
      Else
         For I := 1 To Length(InString) Do Temp[I] := InString[I];
      FormatStr := Temp;
   End;

Procedure SetupScreen;

Var I : Byte;
    S : String[80];
    H : Byte;
    J : Byte;

   Begin
      FillChar(MTop,SizeOf(MTop),#0);
      H := TextAttr;
      FillChar(S,81,PCfg.FillType);
      S[0] := Chr(80);
      GotoXY(1,1);
      J := 1;
      For I := 1 To MWid Do
         Begin
            If Menu[I,0].Active=1 Then
               TextAttr := PCfg.BarColor
            Else
               TextAttr := PCfg.BarLow;
            Write  (' '+Menu[I,0].IDName+' ');
            TextAttr := PCfg.BarColor;
            Write  ('');
            MTop[I].Act := True;
            MTop[I].X := J;
            MTop[I].XTo := (WhereX-2);
            J := WhereX;
         End;
      ClrEol;
      J := 1;
      If PCfg.ShowTime Then
        WriteBoth(57,1,PCfg.TimeColor,0,'                       ');
      For I := 1 To MWid Do
         Begin
            If Menu[I,0].Active=1 Then
               TextAttr := PCfg.BarHigh
            Else
               TextAttr := PCfg.BarLow;
            GotoXY(J+Menu[I,0].HiLite,1);
            If Menu[I,0].HiLite > 0 Then Write  (Menu[I,0].IDName[Menu[I,0].HiLite]);
            J := J + Length(Menu[I,0].IDName) + 3;
         End;
      GotoXY(1,2);
      TextAttr := PCfg.Background;
      For I := 2 To ScreenLen-1 Do Write(S);
      TextAttr := PCfg.StatusColor;
      Write  (' Alt-Z For Help ');
      ClrEol;
      GotoXY(70,WhereY);
      Write  ('');
      TextAttr := H;
   End;

Procedure InfoLine;

   Begin
      If Menu[MX,MPlc[MX]].Active <> 2 Then
         WriteBoth(19,ScreenLen,PCfg.StatusColor,0,FormatStr(Menu[MX,MPlc[MX]].HelpSt,50));
   End;

Procedure MenCon;

Var I,J : Byte;

   Begin
      GotoXY(1,1);
      For I := 1 To MLen[MX] Do
         Begin
            TextAttr := PCfg.MenuColor;
            Case Menu[MX,I].Active Of
                  0 : Begin
                         TextAttr := PCfg.MenuLow;
                         Write  (FormatStr(' '+Menu[MX,I].IDName,LX-2));
                         If (I=MPlc[MX]) And (I>0) Then
                            Begin
                               GotoXY(1,WhereY-1);
                               Write  ('>');
                               GotoXY(LX-2,WhereY);
                               Write  ('<');
                            End;
                      End;
                  1 : Begin
                         TextAttr := PCfg.MenuColor;
                         If I=MPlc[MX] Then TextAttr := PCfg.MenuSelect;
                         Write  (FormatStr(' '+Menu[MX,I].IDName,LX-3));
                         If I=MPlc[MX] Then
                            Write  ('')
                         Else
                            Write  (' ');
                         TextAttr := PCfg.MenuHigh;
                         GotoXY(1+Menu[MX,I].HiLite,WhereY-1);
                         If (Menu[MX,I].HiLite > 0) And (I<>MPlc[MX]) Then Write  (Menu[MX,I].IDName[Menu[MX,I].HiLite]);
                         WriteLn('');
                      End;
                  2 : Begin
                         TextAttr := PCfg.MenuBorder;
                         For J := 1 To LX-2 Do Write  ('');
                      End;
               End;
         End;
   End;

Procedure DrawMenu;

Var I,J,B : Byte;

   Begin
      FillChar(MT,SizeOf(MT),#0);
      LX := 0;
      For I := 1 To MLen[MX] Do
         If (Length(Menu[MX,I].IDName) > LX) Then LX := Length(Menu[MX,I].IDName);
      LX := LX + 4;
      B := 1;
      If MX > 1 Then
         For I := 1 To MX-1 Do
            B := B + Length(Menu[I,0].IDName) + 3;
      GotoXY(B,1);
      TextAttr := PCfg.BarSelect;
      Write  (' '+Menu[MX,0].IDName+' ');
      TextAttr := PCfg.MenuBorder;
      Write  ('');
      If (B+LX-1) > 80 Then B := 80 - (B+LX-1);
      DrawWindow(B,2,B+LX-1,2+MLen[MX]+1,Fore(PCfg.MenuBorder),Back(PCfg.MenuBorder),PCfg.PullType,51234,'MENU');
      Window(B+1,3,B+LX-2,2+MLen[MX]+1);
      For I := 1 To MLen[MX] Do
         Begin
            MT[I].Act := True;
            MT[I].X := B+1;
            MT[I].XTo := B+LX-3;
            MT[I].Y := 2+I;
            MT[I].YTo := 2+I;
         End;
      Cursor(0);
      MenCon;
   End;

Function PullDownMenus : Integer;

Var Ch       : Char;
    I,J,X,H  : Byte;
    Done     : Boolean;
    TRet,Q   : Integer;
    T        : String[10];
    PX,PY    : Byte;

   Procedure TopLine(Show : Boolean);

   Var I,B,J : Byte;

      Begin
         FillChar(MTop,SizeOf(MTop),#0);
         J := 1;
         GotoXY(1,1);
         For I := 1 To MWid Do
            Begin
               If Menu[I,0].Active=1 Then
                  TextAttr := PCfg.BarColor
               Else
                  TextAttr := PCfg.BarLow;
               Write  (' '+Menu[I,0].IDName+' ');
               TextAttr := PCfg.BarColor;
               Write  ('');
               MTop[I].Act := True;
               MTop[I].X := J;
               MTop[I].XTo := (WhereX-2);
               J := WhereX;
            End;
         B := 1;
         For I := 1 To MWid Do
            Begin
               GotoXY(B+Menu[I,0].HiLite,1);
               If Menu[I,0].Active=1 Then
                  TextAttr := PCfg.BarHigh
               Else
                  TextAttr := PCfg.BarLow;
               If Menu[I,0].HiLite > 0 Then Write  (Menu[I,0].IDName[Menu[I,0].HiLite]);
               B := B + Length(Menu[I,0].IDName) + 3;
            End;
         If Show Then
            Begin
               B := 1;
               If MX > 1 Then
                  For I := 1 To MX-1 Do
                     B := B + Length(Menu[I,0].IDName) + 3;
               GotoXY(B,1);
               TextAttr := PCfg.BarSelect;
               Write  (' '+Menu[MX,0].IDName+' ');
               If MPlc[MX] > 0 Then
                  Begin
                     TextAttr := PCfg.MenuBorder;
                     Write  ('');
                  End;
            End;
      End;

   Begin
      T := '';
      Done := False;
      TRet := 0;
      Cursor(0);
      Ch := Chr(0);
      X := MX;
      TopLine(True);
      If MPlc[MX] > 0 Then DrawMenu;
      Repeat
         Begin
            If MPlc[MX] > 0 Then MenCon;
            InfoLine;
            If Mouse.InitOk Then Mouse.ShowCursor;
            Repeat
               If (Time<>T) And PCfg.ShowTime Then
                  Begin
                     WriteBoth(57,1,PCfg.TimeColor,0,' '+Date+'  '+Time+' ');
                     T := Time;
                  End;
            Until KeyPressed Or (Mouse.InitOk And (Mouse.Pressed(1) Or Mouse.Pressed(2)));
            If Mouse.InitOk Then Mouse.HideCursor;
            If KeyPressed Then
               Begin
                  Ch := ReadKey;
                  If (Ch=Chr(0)) And KeyPressed Then
                     Begin
                        Ch := ReadKey;
                        Case Ord(Ch) Of
                              72 : Begin
                                      If MPlc[MX] > 0 Then
                                         Begin
                                            Repeat
                                               MPlc[MX] := MPlc[MX] - 1;
                                            Until (Menu[MX,MPlc[MX]].Active<>2) Or (MPlc[MX] = 0);
                                            If MPlc[MX] = 0 Then
                                               Begin
                                                  RemoveWindow;
                                                  TopLine(True);
                                               End;
                                         End;
                                   End;
                              80 : Begin
                                      If (MPlc[MX] < MLen[MX]) And (Menu[MX,0].Active=1) Then
                                         Begin
                                            H := MPlc[MX];
                                            Repeat
                                               MPlc[MX] := MPlc[MX] + 1;
                                            Until (Menu[MX,MPlc[MX]].Active<>2) Or (MPlc[MX] = MLen[MX]);
                                            If (MPlc[MX] > 0) And (H = 0) Then
                                               Begin
                                                  TopLine(True);
                                                  DrawMenu;
                                               End;
                                         End;
                                   End;
                              75 : Begin
                                      If MPlc[MX] > 0 Then
                                         Begin
                                            RemoveWindow;
                                            TopLine(True);
                                         End;
                                      MX := MX - 1;
                                      If MX=0 Then MX := MWid;
                                      TopLine(True);
                                      If MPlc[MX] > 0 Then DrawMenu;
                                   End;
                              77 : Begin
                                      If MPlc[MX] > 0 Then
                                         Begin
                                            RemoveWindow;
                                            TopLine(True);
                                         End;
                                      MX := MX + 1;
                                      If MX > MWid Then MX := 1;
                                      TopLine(True);
                                      If MPlc[MX] > 0 Then DrawMenu;
                                   End;
                           End;
                     End
                  Else
                     Begin
                        Case UpCase(Ch) Of
                     #32,'A'..'Z' : Begin
                                       If MPlc[MX] > 0 Then
                                          Begin
                                             For Q := 1 To MLen[MX] Do
                                                If (Menu[MX,Q].Active=1) And (UpCase(Menu[MX,Q].Key)=UpCase(Ch)) Then
                                                   Begin
                                                      MPlc[MX] := Q;
                                                      Done := True;
                                                      TRet := Menu[MX,MPlc[MX]].IDCode;
                                                   End;
                                          End;
                                       If ((MPlc[MX] > 0) And (Not Done)) Or (MPlc[MX]=0) Then
                                          Begin
                                             For Q := 1 To MWid Do
                                                If (Menu[Q,0].Active=1) And (UpCase(Menu[Q,0].Key)=UpCase(Ch)) And (Q<>MX) Then
                                                   Begin
                                                      If MPlc[MX] > 0 Then
                                                         Begin
                                                            RemoveWindow;
                                                            TopLine(True);
                                                         End;
                                                      MX := Q;
                                                      TopLine(True);
                                                      If MPlc[MX] = 0 Then MPlc[MX] := 1;
                                                      DrawMenu;
                                                   End;
                                          End;
                                    End;
                              #13 : If Menu[MX,MPlc[MX]].Active=1 Then
                                       Begin
                                          If MPlc[MX] = 0 Then
                                             Begin
                                                Repeat
                                                   MPlc[MX] := MPlc[MX] + 1;
                                                Until (Menu[MX,MPlc[MX]].Active<>2) Or (MPlc[MX] = MLen[MX]);
                                                TopLine(True);
                                                DrawMenu;
                                             End
                                          Else
                                             Begin
                                                Done := True;
                                                TRet := Menu[MX,MPlc[MX]].IDCode;
                                             End;
                                       End;
                              #27 : Done := True;
                           End;
                     End;
               End
            Else
               Begin
                  If Mouse.Pressed(1) Then
                     Begin
                        Repeat Until (Not Mouse.Pressed(1));
                        PX := Mouse.PressX;
                        PY := Mouse.PressY;
                        If PY = 1 Then
                           Begin
                              For I := 1 To MWid Do
                                 If (PX >= MTop[I].X) And (PX <= MTop[I].XTo) And (Menu[I,0].Active=1) Then
                                    Begin
                                       If MPlc[MX] > 0 Then
                                          Begin
                                             RemoveWindow;
                                             TopLine(True);
                                          End;
                                       MX := I;
                                       TopLine(True);
                                       If MPlc[MX] = 0 Then MPlc[MX] := 1;
                                       DrawMenu;
                                    End;
                           End
                        Else
                           Begin
                              For I := 1 To MLen[MX] Do
                                 If (PX >= MT[I].X) And (PX <= MT[I].XTo) And (PY = MT[I].Y) And (Menu[MX,I].Active=1) Then
                                    Begin
                                       MPlc[MX] := I;
                                       Done := True;
                                       TRet := Menu[MX,MPlc[MX]].IDCode;
                                    End;
                           End;
                     End
                  Else
                     Begin
                        Repeat Until (Not Mouse.Pressed(2));
                        Done := True;
                     End;
               End;
         End;
      Until Done;
      If MPlc[MX] > 0 Then RemoveWindow;
      WriteBoth(19,ScreenLen,PCfg.StatusColor,0,FormatStr('',50));
      TopLine(False);
      Cursor(1);
      PullDownMenus := TRet;
   End;

Procedure AddMenu(Num,Ent : Byte; MenuName : String; MenuHelp : String;
                  Active : Byte; HiLite : Byte; KeyToUse : Char;
                  RetCode : Integer);

   Begin
      If Ent > MLen[Num] Then MLen[Num] := Ent;
      If Num > MWid Then MWid := Num;
      Menu[Num,Ent].IDName := MenuName;
      Menu[Num,Ent].IDCode := RetCode;
      Menu[Num,Ent].HelpSt := MenuHelp;
      Menu[Num,Ent].Active := Active;
      Menu[Num,Ent].HiLite := HiLite;
      Menu[Num,Ent].Key    := KeyToUse;
   End;

Procedure InitMenus;

Var I : Byte;

   Begin
      MKey := '';
      MX := 1;
      MWid := 1;
      For I := 1 To 10 Do
         Begin
            MPlc[I] := 0;
            MLen[I] := 0;
         End;
      FillChar(Menu,SizeOf(Menu),0);
   End;

   Begin
      With PCfg Do
         Begin
            BarColor := 0 + 7*16;
            BarHigh := 15 + 7*16;
            BarLow := 8 + 7*16;
            BarSelect := 15 + 1*16;
            MenuColor := 15 + 1*16;
            MenuHigh := 14 + 1*16;
            MenuLow := 8 + 1*16;
            MenuSelect := 0 + 7*16;
            MenuBorder := 0 + 1*16;
            StatusColor := 0 + 7*16;
            StatusHigh := 15 + 7*16;
            TimeColor := 15 + 7*16;
            Background := 1;
            PullType := 13;
            ShowTime := True;
            FillType := Chr(176);
         End;
   End.

