Unit Strings;

Interface

Uses DOS;

Function RemoveEnding(InString : String) : String;
Function RawDate : String;
Function Date : String;
Function Time : String;
Function FormatStr(InString : String; Len : Byte) : String;
Function RightStr(InString : String; Len : Byte) : String;
Function CenterString(InString : String; Width : Byte) : String;
Function ConvertUnder(InString : String) : String;
Function UpperCase(InString : String) : String;
Function LowerCase(InString : String) : String;
Function FirstLetterUpCase(InString : String) : String;
Function RemoveSpaces(InString : String) : String;
Function IntToString(InInt : LongInt) : String;
Function StringToInt(InString : String) : LongInt;

Implementation

Function RemoveEnding(InString : String) : String;

   Begin
      While (InString<>'') And (InString[Length(InString)]=' ') Do Delete(InString,Length(InString),1);
      RemoveEnding := InString;
   End;

Function RawDate : String;

Var Year,Month,Day,Dow : Word;
    StrDay             : String[2];
    StrMonth           : String[2];
    StrYear            : String[4];

   Begin
      GetDate(Year,Month,Day,Dow);
      Str(Day,StrDay);
      Str(Month,StrMonth);
      Str(Year,StrYear);
      If (Length(StrDay) = 1) Then StrDay := '0' + StrDay;
      If (Length(StrMonth) = 1) Then StrMonth := '0' + StrMonth;
      RawDate := StrMonth + '-' + StrDay + '-' + Copy(StrYear,3,2);
   End;

Function Date : String;

Var Year,Month,Day,Dow : Word;
    StrDay             : String[2];
    StrMonth           : String[3];
    StrYear            : String[4];

Type MonthArray = Array[1..12] Of String[3];

Const Months : MonthArray = ('Jan','Feb','Mar','Apr','May','Jun',
                             'Jul','Aug','Sep','Oct','Nov','Dec');

   Begin
      GetDate(Year,Month,Day,Dow);
      Str(Day,StrDay);
      StrMonth := Months[Month];
      Str(Year,StrYear);
      If (Length(StrDay) = 1) Then StrDay := '0' + StrDay;
      Date := StrDay + '-' + StrMonth + '-' + StrYear;
   End;

Function Time : String;

Var Hour,Minute,Second,Hundredth : Word;
    StrHour,StrMinute,StrSecond  : String[2];
    TempStringOut                : String;

   Begin
      GetTime(Hour,Minute,Second,Hundredth);
      Str(Hour:2,StrHour);
      Str(Minute:2,StrMinute);
      Str(Second:2,StrSecond);
      TempStringOut := StrHour + ':' + StrMinute + ':' + StrSecond;
      For Hour := 1 To Length(TempStringOut) Do If TempStringOut[Hour] = ' ' Then TempStringOut[Hour] := '0';
      Time := TempStringOut;
   End;

Function FormatStr(InString : String; Len : Byte) : String;

   Begin
      While Length(InString) < Len Do InString := InString + ' ';
      InString[0] := Chr(Len);
      FormatStr := InString;
   End;

Function RightStr(InString : String; Len : Byte) : String;

   Begin
      While Length(InString) < Len Do InString := ' '+InString;
      InString[0] := Chr(Len);
      RightStr := InString;
   End;

Function CenterString(InString : String; Width : Byte) : String;

Var I : Byte;

   Begin
      If Length(InString) < Width Then
         Begin
            I := (Width-Length(InString)) Div 2;
            For I := 1 To I Do InString := ' '+InString;
         End;
      InString := FormatStr(InString,Width);
      CenterString := InString;
   End;

Function ConvertUnder(InString : String) : String;

   Begin
      While Pos('_',InString) > 0 Do InString[Pos('_',InString)] := ' ';
      While Pos(Chr(9),InString) > 0 Do InString[Pos(Chr(9),InString)] := ' ';
      ConvertUnder := InString;
   End;

Function UpperCase(InString : String) : String;

Var I : Byte;

   Begin
      For I := 1 To Length(InString) Do InString[I] := UpCase(InString[I]);
      UpperCase := InString;
   End;

Function LowerCase(InString : String) : String;

Var I : Byte;

   Begin
      For I := 1 To Length(InString) Do
         If (InString[I] >= 'A') And (InString[I] <= 'Z') Then
            InString[I] := Chr(Ord(InString[I]) + 32);
      LowerCase := InString;
   End;

Function FirstLetterUpCase(InString : String) : String;

Var I : Byte;

   Begin
      InString := LowerCase(InString);
      InString[1] := UpCase(InString[1]);
      For I := 1 To Length(InString) Do
         If (InString[I] = ' ') And (I < Length(InString)) Then
            InString[I+1] := UpCase(InString[I+1]);
      FirstLetterUpCase := InString;
   End;

Function RemoveSpaces(InString : String) : String;

   Begin
      While (InString[1] = ' ') Do Delete(InString,1,1);
      While (InString[Length(InString)] = ' ') Do Delete(InString,Length(InString),1);
      While (Pos('  ',InString) > 0) Do Delete(InString,Pos('  ',InString),1);
      RemoveSpaces := InString;
   End;

Function IntToString(InInt : LongInt) : String;

Var TempO : String;

   Begin
      Str(InInt,TempO);
      IntToString := TempO;
   End;

Function StringToInt(InString : String) : LongInt;

Var TempI : LongInt;
    Dummy : Integer;

   Begin
      TempI := 0;
      Val(InString,TempI,Dummy);
      StringToInt := TempI;
   End;

   Begin
   End.

