Unit Window2;

Interface

Uses DOS,CRT;

Const MaxWindows = 500;

Type ScrPtr = ^ScrType;
     ScrType = Array[1..50,1..80] Of Word;
     WinType = Record
                  Act  : Boolean;
                  Sig  : String[11];
                  Num  : Word;
                  X1   : Byte;
                  Y1   : Byte;
                  X2   : Byte;
                  Y2   : Byte;
                  WMin : Word;
                  WMax : Word;
                  Brd  : Byte;
                  BAt  : Byte;
                  Cur  : Byte;
                  At   : Byte;
                  WX   : Byte;
                  WY   : Byte;
                  Siz  : Word;
                  Wide : Word;
                  High : Word;
                  WPtr : Pointer;
               End;

Var Screen    : ScrPtr;
    Win       : Array[1..MaxWindows] Of WinType;
    CurWin    : Byte;
    MouseInfo : Boolean;
    ScreenLen : Byte;

Function  WinErr : Byte;
Function  FindWindow(X,Y : Byte) : Word;
{
1 = ReOrder:      Can't Re-Order First Window
2 = ReOrder:      Window Does Not Exist
3 = Create:       Too Many Windows
4 = Global:       No Windows To Perform Operation On
5 = ReDrawAll:    Not Enough Memory For Action
6 = DrawWindow:   Not Enough Memory To Create Window
7 = DrawWindow:   Too Many Windows
8 = SwitchWindow: Could Not Locate Window To Switch
9 = SetUpWindows: Could Not Allocate Necessary Memory
}

Function Fore(A : Byte) : Byte;
Function Back(A : Byte) : Byte;
Procedure WriteXY(X,Y,FG,BG : Byte; Str : String; SPtr : ScrPtr);
Procedure BlinkOff;
Procedure BlinkOn;
Procedure Cursor(CursorType : Byte);
Procedure Color(FG,BG : Byte);
Procedure DrawWindow(WX1,WY1,WX2,WY2,FG,BG,Brdr : Byte; ID : Word; SID : String);
Procedure SwitchWindow(Num,ID : Word; SID : String);
Procedure RemoveWindow;
Procedure MoveWindow(NX,NY : Byte);
Procedure PutMouseItems(OffBox,Number,Signature,ReSize : Boolean);

Implementation

Type BorderType = Array[1..10] Of Char;

Const WindowBorder1  : BorderType = ('','','','','','','','','','');
      WindowBorder2  : BorderType = ('','','','','','','','','','');
      WindowBorder3  : BorderType = ('','','','','','','','','','');
      WindowBorder4  : BorderType = ('','','','','','','','','','');
      WindowBorder5  : BorderType = ('','','','','','','','',' ',' ');
      WindowBorder6  : BorderType = ('','','','','','','','',' ',' ');
      WindowBorder7  : BorderType = ('','','','','','','','',' ',' ');
      WindowBorder8  : BorderType = ('','','','','','','','',' ',' ');
      WindowBorder9  : BorderType = ('','','','','','','','',' ',' ');
      WindowBorder10 : BorderType = (',','.','`','''','-','-','|','|',' ',' ');
      WindowBorder11 : BorderType = ('+','+','+','+','-','-','|','|',' ',' ');
      WindowBorder12 : BorderType = (' ',' ',' ',' ',' ',' ',' ',' ',' ',' ');
      WindowBorder13 : BorderType = (' ','',' ','',' ',' ',' ','',' ',' ');

Var CursorVal   : Byte;
    WindowError : Byte;

Function Fore(A : Byte) : Byte;

   Begin
      Fore := A Mod 16;
   End;

Function Back(A : Byte) : Byte;

   Begin
      Back := A Div 16;
   End;

Function IntToStr(I : LongInt) : String;

Var T : String;

   Begin
      Str(I,T);
      IntToStr := T;
   End;

Function UpperCase(Str : String) : String;

Var I : Byte;

   Begin
      If Str <> '' Then For I := 1 To Length(Str) Do Str[I] := UpCase(Str[I]);
      UpperCase := Str;
   End;

Function WinErr : Byte;

   Begin
      WinErr := WindowError;
      WindowError := 0;
   End;

Function FindWindow(X,Y : Byte) : Word;

Var I,J : Word;

   Begin
      If CurWin=0 Then
         Begin
            WindowError := 4;
            Exit;
         End;
      J := 0;
      For I := 1 To CurWin Do
         If (J=0) And (X<=Win[I].X2) And (X>=Win[I].X1)
         And (Y<=Win[I].Y2) And (Y>=Win[I].Y1) And (Win[I].Act) Then
            J := I;
      FindWindow := J;
   End;

Procedure WriteXY(X,Y,FG,BG : Byte; Str : String; SPtr : ScrPtr);

Var I : Byte;
    T : Word;
    A : Word;

   Begin
      A := ((BG * 16) + FG) * 256;
      If Str = '' Then Exit;
      For I := 1 To Length(Str) Do
         Begin
            T := A + Ord(Str[I]);
            SPtr^[Y,X+I-1] := T;
         End;
   End;

Procedure BlinkOff;

Var Regs : Registers;

   Begin
      Regs.Ax := $1003;
      Regs.Bl := Regs.Bl Xor Regs.Bl;
      Intr($10,Regs);
   End;

Procedure BlinkOn;

Var Regs : Registers;

   Begin
      Regs.Ax := $1003;
      Regs.Bl := 1;
      Intr($10,Regs);
   End;

Procedure Cursor(CursorType : Byte);

Var Regs : Registers;

   Begin
      If CursorType > 0 Then
         Begin
            Regs.AX := $100;
            Case CursorType Of
                  0 : Regs.CX := (8 Shl 8)+7;
                  1 : Regs.CX := (6 Shl 8)+7;
                  2 : Regs.CX := (4 Shl 8)+7;
                  3 : Regs.CX := (2 Shl 8)+7;
                  4 : Regs.CX := (0 Shl 8)+7;
               End;
            Intr($10,Regs);
         End
      Else
         Begin
            Regs.AH := 1;
            Regs.CH := $20;
            Regs.CL := 0;
            Intr($10,Regs);
         End;
      CursorVal := CursorType;
   End;

Procedure Color(FG,BG : Byte);

   Begin
      TextAttr := (BG*16) + FG;
   End;

Function Width(I1,I2 : Byte) : Byte;

   Begin
      Width := (I2 - I1) + 1;
   End;

Function AreaSize(X1,Y1,X2,Y2 : Byte) : Word;

   Begin
      AreaSize := (Width(X1,X2)*Width(Y1,Y2)) * 2;
   End;

Procedure MoveArea(Dir,X1,Y1,X2,Y2,SX,SY,Wide : Byte; Pntr : Pointer; SPtr : ScrPtr);

Type MemPntr = ^MemType;
     MemType = Array[0..3999] Of Word;

Var Arr : MemPntr;
    J   : Byte;

   Begin
      Arr := Pntr;
      For J := Y1 To Y2 Do
         Begin
            If Dir = 0 Then Move(SPtr^[J,X1],Arr^[((J-Y1)*Wide)],Width(X1,X2)*2);
            If Dir = 1 Then Move(Arr^[((J-Y1+(SY-1))*Wide)+(SX-1)],SPtr^[J,X1],Width(X1,X2)*2);
         End;
   End;

Procedure ReOrder(FromWin : Word);

Var Temp : WinType;
    I    : Word;

   Begin
      If (FromWin = 1) Or (FromWin > CurWin) Then
         Begin
            If FromWin = 1 Then
               WindowError := 1
            Else
               WindowError := 2;
            Exit;
         End;
      Temp := Win[FromWin];
      For I := FromWin-1 DownTo 1 Do Win[I+1] := Win[I];
      Win[1] := Temp;
   End;

Procedure Create;

Var I : Word;

   Begin
      If (CurWin=MaxWindows) Then
         Begin
            WindowError := 3;
            Exit;
         End;
      If CurWin > 0 Then
         For I := CurWin DownTo 1 Do
            Win[I+1] := Win[I];
      Inc(CurWin);
      FillChar(Win[1],SizeOf(WinType),#0);
   End;

Procedure Remove;

Var I : Word;

   Begin
      If (CurWin=0) Then
         Begin
            WindowError := 4;
            Exit;
         End;
      FreeMem(Win[1].WPtr,Win[1].Siz);
      If CurWin > 1 Then
         For I := 1 To CurWin-1 Do
            Win[I] := Win[I+1];
      Dec(CurWin);
      FillChar(Win[CurWin+1],SizeOf(WinType),#0);
   End;

Procedure DoWindowPars;

   Begin
      If CurWin=0 Then
         Begin
            WindowError := 4;
            Exit;
         End;
      With Win[1] Do
         Begin
            WindMin := WMin;
            WindMax := WMax;
            GotoXY(WX,WY);
            TextAttr := At;
            Cursor(Cur);
         End;
   End;

Procedure StoreWindow;

   Begin
      If CurWin=0 Then
         Begin
            WindowError := 4;
            Exit;
         End;
      With Win[1] Do
         Begin
            Cur  := CursorVal;
            At   := TextAttr;
            WX   := WhereX;
            WY   := WhereY;
            WMin := WindMin;
            WMax := WindMax;
            MoveArea(0,X1,Y1,X2,Y2,1,1,Wide,WPtr,Screen);
         End;
   End;

Procedure ReDrawAll;

Var I : Word;
    T : ScrPtr;

   Begin
      If (CurWin=0) Or (MemAvail < 8000) Then
         Begin
            If CurWin = 0 Then
               WindowError := 4
            Else
               WindowError := 5;
            Exit;
         End;
      New(T);
      FillChar(T^,8000,#0);
      For I := CurWin DownTo 1 Do
         MoveArea(1,Win[I].X1,Win[I].Y1,Win[I].X2,Win[I].Y2,1,1,Win[I].Wide,Win[I].WPtr,T);
      Move(T^,Screen^,8000);
      Dispose(T);
   End;

Procedure DrawBox(X1,Y1,X2,Y2,FG,BG,Brdr : Byte);

Var J : Integer;
    U : BorderType;
    T : Word;

   Begin
      If Brdr < 1 Then Brdr := 1;
      If Brdr > 13 Then Brdr := 13;
      Case Brdr Of
            1 : U := WindowBorder1;
            2 : U := WindowBorder2;
            3 : U := WindowBorder3;
            4 : U := WindowBorder4;
            5 : U := WindowBorder5;
            6 : U := WindowBorder6;
            7 : U := WindowBorder7;
            8 : U := WindowBorder8;
            9 : U := WindowBorder9;
            10 : U := WindowBorder10;
            11 : U := WindowBorder11;
            12 : U := WindowBorder12;
            13 : U := WindowBorder13;
         End;
      Window(1,1,80,ScreenLen);
      GotoXY(X1,Y1);
      Write  (U[1]);
      For J := X1+1 To X2-1 Do Write  (U[5]);
      Write  (U[2]);
      For J := Y1+1 To Y2-1 Do
         Begin
            GotoXY(X1,J);
            Write  (U[7]);
            GotoXY(X2,J);
            Write  (U[8]);
         End;
      GotoXY(X1,Y2);
      Write  (U[3]);
      For J := X1+1 To X2-1 Do Write  (U[6]);
      T := (TextAttr*256) + Ord(U[4]);
      Screen^[Y2,X2] := T;
   End;

Procedure DrawWindow(WX1,WY1,WX2,WY2,FG,BG,Brdr : Byte; ID : Word; SID : String);

Var S : Word;

   Begin
      If CurWin > 0 Then StoreWindow;
      Cursor(0);
      S := AreaSize(WX1,WY1,WX2,WY2);
      If (MaxAvail < S) Or (CurWin=MaxWindows) Then
         Begin
            If MaxAvail < S Then
               WindowError := 6
            Else
               WindowError := 7;
            Exit;
         End;
      Create;
      GetMem(Win[1].WPtr,S);
      With Win[1] Do
         Begin
            X1   := WX1;
            Y1   := WY1;
            X2   := WX2;
            Y2   := WY2;
            Num  := ID;
            Sig  := SID;
            Cur  := 0;
            Siz  := S;
            Brd  := Brdr;
            Bat  := (BG * 16) + FG;
            Act  := True;
            Wide := Width(WX1,WX2);
            High := Width(WY1,WY2);
         End;
      If (Brdr>0) And (Brdr<255) Then
         Begin
            Window(WX1+1,WY1+1,WX2-1,WY2-1);
            Color(FG,BG);
            ClrScr;
            DrawBox(WX1,WY1,WX2,WY2,FG,BG,Brdr);
            Window(WX1+1,WY1+1,WX2-1,WY2-1);
         End
      Else
         Begin
            Window(WX1,WY1,WX2,WY2);
            If Brdr=0 Then
               Begin
                  Color(FG,BG);
                  ClrScr;
               End;
         End;
      Win[1].WMin := WindMin;
      Win[1].WMax := WindMax;
      Win[1].WX   := WhereX;
      Win[1].WY   := WhereY;
      Win[1].At   := TextAttr;
      With Win[1] Do MoveArea(0,X1,Y1,X2,Y2,1,1,Wide,WPtr,Screen);
   End;

Procedure SwitchWindow(Num,ID : Word; SID : String);

Var I,J : Word;

   Begin
      J := 0;
      If CurWin<2 Then
         Begin
            WindowError := 4;
            Exit;
         End;
      If (Num > 0) And (Num<=CurWin) And (Win[Num].Act) Then J := Num;
      For I := 1 To CurWin Do
         If (J=0) And (Win[I].Act) Then
            Begin
               If (ID<>0) And (ID=Win[I].Num) Then J := I;
               If (SID<>'') And (UpperCase(SID)=UpperCase(Win[I].Sig)) Then J := I;
            End;
      If J = 0 Then
         Begin
            WindowError := 8;
            Exit;
         End;
      StoreWindow;
      ReOrder(J);
      DoWindowPars;
      With Win[1] Do MoveArea(1,X1,Y1,X2,Y2,1,1,Wide,WPtr,Screen);
   End;

Procedure RemoveWindow;

   Begin
      If CurWin=0 Then
         Begin
            WindowError := 4;
            Exit;
         End;
      Remove;
      ReDrawAll;
      DoWindowPars;
   End;

Procedure MoveWindow(NX,NY : Byte);

Var UX,UY : Integer;
    WX,WY : Byte;
    DX,DY : Byte;

   Begin
      If CurWin = 0 Then
         Begin
            WindowError := 4;
            Exit;
         End;
      StoreWindow;
      WX := 80-Width(Win[1].X1,Win[1].X2)+1;
      WY := ScreenLen-Width(Win[1].Y1,Win[1].Y2)+1;
      If (NX<1) Then NX := 1;
      If (NX>WX) Then NX := WX;
      If (NY<1) Then NY := 1;
      If (NY>WY) Then NY := WY;
      UX := Win[1].X1 - NX;
      UY := Win[1].Y1 - NY;
      Win[1].X1 := Win[1].X1 - UX;
      Win[1].X2 := Win[1].X2 - UX;
      Win[1].Y1 := Win[1].Y1 - UY;
      Win[1].Y2 := Win[1].Y2 - UY;
      WX := Lo(Win[1].WMax); WY := Hi(Win[1].WMax);
      DX := Lo(Win[1].WMin); DY := Hi(Win[1].WMin);
      WX := WX - UX;
      DX := DX - UX;
      WY := WY - UY;
      DY := DY - UY;
      Win[1].WMax := WX + (WY*256);
      Win[1].WMin := DX + (DY*256);
      ReDrawAll;
      DoWindowPars;
   End;

Procedure PutMouseItems(OffBox,Number,Signature,ReSize : Boolean);

Var U : BorderType;
    T : String;

   Begin
      If CurWin = 0 Then
         Begin
            WindowError := 4;
            Exit;
         End;
      If Win[1].Brd < 1 Then Win[1].Brd := 1;
      If Win[1].Brd > 13 Then Win[1].Brd := 13;
      Case Win[1].Brd Of
            1 : U := WindowBorder1;
            2 : U := WindowBorder2;
            3 : U := WindowBorder3;
            4 : U := WindowBorder4;
            5 : U := WindowBorder5;
            6 : U := WindowBorder6;
            7 : U := WindowBorder7;
            8 : U := WindowBorder8;
            9 : U := WindowBorder9;
            10 : U := WindowBorder10;
            11 : U := WindowBorder11;
            12 : U := WindowBorder12;
            13 : U := WindowBorder13;
         End;
      With Win[1] Do
         Begin
            If OffBox Then
               WriteXY(X1+1,Y1,Fore(Bat),Back(Bat),U[9]+''+U[10],Screen);
            If Number Then
               WriteXY(X1+1,Y2,Fore(Bat),Back(Bat),U[9]+IntToStr(Num)+U[10],Screen);
            If Signature Then
               WriteXY(X2-(Length(SIG)+2),Y1,Fore(Bat),Back(Bat),U[9]+SIG+U[10],Screen);
            If ReSize Then
               WriteXY(X2-1,Y2,Fore(Bat),Back(Bat),'',Screen);
         End;
   End;

Procedure SetUpWindows;

Var S : Word;

   Begin
      S := AreaSize(1,1,80,ScreenLen);
      If (MaxAvail < S) Then
         Begin
            WindowError := 9;
            Exit;
         End;
      Create;
      GetMem(Win[1].WPtr,S);
      With Win[1] Do
         Begin
            X1   := 1;
            Y1   := 1;
            X2   := 80;
            Y2   := ScreenLen;
            WX   := WhereX;
            WY   := WhereY;
            At   := TextAttr;
            Num  := 65535;
            Sig  := 'START';
            Cur  := 0;
            Siz  := S;
            WMin := WindMin;
            WMax := WindMax;
            Act  := False;
            Wide := 80;
            High := ScreenLen;
            MoveArea(0,1,1,80,ScreenLen,1,1,80,WPtr,Screen);
         End;
   End;

   Begin
      If LastMode = 7 Then
         Screen := Ptr($B000,$0000)
      Else
         Screen := Ptr($B800,$0000);
      ScreenLen := Hi(WindMax) - Hi(WindMin) + 1;
      CursorVal := 0;
      CurWin := 0;
      WindowError := 0;
      MouseInfo := False;
      FillChar(Win,SizeOf(Win),#0);
      SetUpWindows;
   End.

