Program ZipV;

Uses DOS;

Const Signature = $04034B50;
      ZIPComp   : Array[0..6] Of String[50] =
                  ('Stored   ','Shrunk   ','Reduced 1','Reduced 2',
                   'Reduced 3','Reduced 4','Imploded ');

Type ZIPLocalHdr = Record
                      Signature        : LongInt;
                      VersionToExtract : Integer;
                      BitFlag          : Integer;
                      CompressMethod   : Integer;
                      FileDateTime     : LongInt;
                      CRC32            : LongInt;
                      CompressedSize   : LongInt;
                      UnCompressedSize : LongInt;
                      FilenameLen      : Integer;
                      ExtraFieldLen    : Integer;
                   End;
     ZIPExtraTyp = Array[1..1024] Of Char;

Var LclHdr : ZIPLocalHdr;
    NameEx : ZIPExtraTyp;
    InfoEx : ZIPExtraTyp;
    InFile : File;
    CSize  : LongInt;
    DSize  : LongInt;
    Error  : Integer;
    FTime  : DateTime;
    FName  : String;
    First  : Boolean;
    Files  : Integer;
    FDate  : LongInt;

Function FormatStr(InString : String; Len : Byte) : String;

Var Temp : String;
    I    : Byte;

   Begin
      Temp := '';
      For I := 1 To Len Do Temp := Temp + ' ';
      If Length(InString) > Len Then
         Temp := Copy(InString,1,Len)
      Else
         For I := 1 To Length(InString) Do Temp[I] := InString[I];
      FormatStr := Temp;
   End;

Function MakeDateTime(Num1,Num2,Num3 : Word; SepChar : String) : String;

Var Str1 : String;
    Str2 : String;
    Str3 : String;
    OutS : String;
    I    : Byte;

   Begin
      OutS := '';
      Str(Num1:2,Str1);
      Str(Num2:2,Str2);
      Str(Num3:2,Str3);
      If Length(Str3) = 4 Then Str3 := Copy(Str3,3,2);
      OutS := Str1+SepChar+Str2+SepChar+Str3;
      For I := 1 To Length(OutS) Do If OutS[I] = ' ' Then OutS[I] := '0';
      MakeDateTime := OutS;
   End;

Function UpperCase(InString : String) : String;

Var I : Byte;

   Begin
      For I := 1 To Length(InString) Do InString[I] := UpCase(InString[I]);
      UpperCase := InString;
   End;

Function FormatFileName(InString : String) : String;

   Begin
      If (Pos('.',InString) > 0) And (Pos('.',InString) < 9) Then
         Begin
            While (Pos('.',InString) < 9) Do
               Insert(' ',InString,Pos('.',InString));
         End;
      FormatFileName := InString;
   End;

Function MakeIntoString(InBuf : ZipExtraTyp; BufLen : Integer) : String;

Var Temp : String;
    I    : Integer;

   Begin
      Temp := '';
      For I := 1 To BufLen Do Temp := Temp + InBuf[I];
      MakeIntoString := Temp;
   End;

Function RemovePath(InString : String) : String;

   Begin
      While Pos('/',InString) > 0 Do Delete(InString,1,Pos('/',InString));
      While Pos('\',InString) > 0 Do Delete(InString,1,Pos('\',InString));
      RemovePath := InString;
   End;

Function ReadNextRecord : Boolean;

   Begin
      {$I-}
      Error := 0;
      BlockRead(InFile,LclHdr,SizeOf(LclHdr),Error);
      If Error < SizeOf(LclHdr) Then
         ReadNextRecord := False
      Else
         Begin
            If LclHdr.Signature = Signature Then
                Begin
                   ReadNextRecord := True;
                   If LclHdr.FileNameLen > 0 Then BlockRead(InFile,NameEx,LclHdr.FileNameLen,Error);
                   If LclHdr.ExtraFieldLen > 0 Then Seek(InFile,FilePos(InFile)+LclHdr.ExtraFieldLen);
                   If LclHdr.CompressedSize > 0 Then Seek(InFile,FilePos(InFile)+LclHdr.CompressedSize);
                   ReadNextRecord := (IOResult = 0);
                End
             Else
                ReadNextRecord := False;
         End;
      {$I+}
   End;

   Begin
      First := True;
      Files := 0;
      CSize := 0;
      DSize := 0;
      WriteLn('');
      WriteLn('ZipV Ver 1.0 - By Tom Bradford');
      WriteLn('------------------------------');
      If ParamCount > 0 Then
         FName := ParamStr(1)
      Else
         FName := '';
      If FName = '' Then
         Begin
            WriteLn('Format: ZIPV ZIPFileName[.ZIP]');
            Halt(0);
         End;
      If Pos('.',FName) = 0 Then FName := FName + '.ZIP';
      FName := FExpand(FName);
      Assign(InFile,FName);
      {$I-}
      Reset(InFile,1);
      {$I+}
      If IOResult = 0 Then
         Begin
            WriteLn('Searching File:   '+UpperCase(FormatFileName(RemovePath(FName))));
            WriteLn('');
            While ReadNextRecord Do
               Begin
                  If First Then
                     Begin
                        WriteLn('Filename.Ext   Original    Current  Method     Per%  Date      Time');
                        WriteLn('------------  ---------  ---------  ---------  ----  --------  --------');
                     End;
                  Write  (FormatStr(FormatFileName(RemovePath(MakeIntoString(NameEx,LclHdr.FileNameLen))),12)+'  ');
                  Write  (LclHdr.UncompressedSize:9,'  ');
                  Write  (LclHdr.CompressedSize:9,'  ');
                  Write  (ZipComp[LclHdr.CompressMethod]+'  ');
                  Write  ((100-(100*LclHdr.CompressedSize) Div LclHdr.UnCompressedSize):3);
                  Write  ('%  ');
                  UnPackTime(LclHdr.FileDateTime,FTime);
                  Write  (MakeDateTime(FTime.Month,FTime.Day,FTime.Year,'-')+'  ');
                  Write  (MakeDateTime(FTime.Hour,FTime.Min,FTime.Sec,':'));
                  WriteLn('');
                  First := False;
                  CSize := CSize + LclHdr.CompressedSize;
                  DSize := DSize + LclHdr.UnCompressedSize;
                  Files := Files + 1;
               End;
            If First Then
               WriteLn('This File Does Not Seem To Be ZIPped')
            Else
               Begin
                  WriteLn('------------  ---------  ---------  ---------  ----  --------  --------');
                  Write  (Files:3,' Files     ',DSize:9,'  ',CSize:9,'             ',(100-(100*CSize) Div DSize):3,'%  ');
                  GetFTime(InFile,FDate);
                  UnPackTime(FDate,FTime);
                  Write  (MakeDateTime(FTime.Month,FTime.Day,FTime.Year,'-')+'  ');
                  Write  (MakeDateTime(FTime.Hour,FTime.Min,FTime.Sec,':'));
                  WriteLn('');
               End;
            Close(InFile);
         End
      Else
         WriteLn('ZIP File Not Found');
   End.
