program TGIF;  {example offline GIF decoder mainline}

{**************************************************************************}
{*                    Part of OOBPLUS Distribution                        *}
{**************************************************************************}

{The state of the following define must match the state of the same define
 in GIFVIDEO.PAS}

{$DEFINE UseSVGA}

uses
  DOS,
  OpCrt,
  OpString,
  GIFVideo,
  OfLGIF;

var
  S : String;
  P : Pointer;
  X,L : Word;
  OMode : Word;

begin
    {get filename from command line}
  if ParamCount = 0 then exit;
  S := DefaultExtension(ParamStr(1),'GIF');

    {save the screen}
  if not SaveWindow(1,1,ScreenWidth,ScreenHeight,True,P) then halt;
  GetCursorState(X,L);
  ClrScr;

{$IFDEF UseSVGA}
    {if we're a VGA, find out if SVGA}
  if CurrentDisplay = VGA then begin
    OMode := CurrentMode;
    DetectSVGAType(True);
    TextMode(OMode);
    Write('Video found: '+SVGANames[SVGAType]);
    if SVGAType = vtVESA then with VesaVGAInfo do
      Write(' (',VESASignature,' ',
              Hi(VESAVersion),'.',Lo(VESAVersion),' ',
              OEMStringPtr^,')');
    WriteLn;
    Delay(1000);
  end;
{$ENDIF}

    {do it}
  if DisplayGIFOffline(S) then ;

    {restore things}
  ClrScr;
  RestoreWindow(1,1,ScreenWidth,ScreenHeight,True,P);
  RestoreCursorState(X,L);
end.
