Program Test;
Uses OpCrt,
     OpFrame,
     OpCmd,
     OpString,
     OpPopWin;

Var
   MyMenu,
   PrinterMenu : PopWindow;

Const
     State   : Boolean = True;
     Count   : Byte    = 6;


{$I MYCOLOR.PAS}

Function OnOff(Input : Boolean) : String;
Begin
     If Input then
        OnOff := ' On'
     Else
        OnOff := 'Off';
End;



Begin
     PopCommands.cpOptionsOn(cpEnableMouse);
     If Not PrinterMenu.Init(5,10,50,17, 2, NormalColorSet) then
        WriteLn('Error while trying to initialize pop window')
     Else
     Begin
          With PrinterMenu do
          Begin
               WFrame.AddShadow(shBR,shSeeThru);
               WFrame.SetFrameType(DefWindowFrame);
               ppOptionsOn(ppCapitalize+ppAllowEsc);
               AddHeaders('Spencer Steel Ltd.','Printer Menu');
               AddTopic('Print a single Work Order',1);
               AddTopic('Print a single Purchase Order',2);
               AddTopic('Print inventory list',3);
               AddTopic('Print WO''s on file',4);
               AddTopic('Print PO''s on file',5);
               AddTopic('Return to main menu',6);
          End;
     End;

     If Not MyMenu.Init(20,5,60,14, 2, NormalColorSet) then
        WriteLn('Error while trying to initialize pop window')
     Else
     Begin

          With MyMenu do
          Begin
               WFrame.AddShadow(shBR,shSeeThru);
               ppOptionsOn(ppUseLetters);
               AddHeaders('Spencer Steel Ltd.','Functional Inventory');
               AddTopic('Add/Edit Inventory',1);
               AddTopic('Increase padding to '+Long2Str(Count),2);
               AddTopic('Edit/Delete a Work Order',3);
               AddTopic('Add a Purchase Order',4);
               AddTopic('Edit/Delete a Purchase order',5);
               AddTopic('Reports',6);
               AddTopic('Current State '+OnOff(State),7);
               AddTopic('Exit inventory sytem',8);
          End;
     End;

     FastFill(ScreenWidth*ScreenHeight,#176,1,1,$0F);
     MyMenu.Draw;
     Repeat
           MyMenu.Process;
           Case MyMenu.GetLastChoice of
                1 : ;
                2 : Begin
                         MyMenu.SetPadLength(Count);
                         Inc(Count);
                         MyMenu.ChangeTopic(MyMenu.GetTopicNum(2),'Set Padding to '+Long2Str(Count),True);
                    End;
                3 : ;
                4 : ;
                5 : ;
                6 : Begin
                         PrinterMenu.Draw;
                         Repeat
                               PrinterMenu.Process;
                         Until (PrinterMenu.MaxPicks = PrinterMenu.GetTopicNum(PrinterMenu.GetLastChoice)) or
                               (PrinterMenu.GetLastCommand = ccQuit);
                         PrinterMenu.Erase;
                    End;
              7   : Begin
                         State := Not State;
                         MyMenu.ChangeTopic(MyMenu.GetTopicNum(7),'Current State '+OnOff(State),True);
                    End;
           End;
     Until MyMenu.MaxPicks  = MyMenu.GetLastChoice;
     MyMenu.Done;
     PrinterMenu.Done;
End.





