{$R-,S-,I-}
{$I OPDEFINE.INC}

{$IFDEF UseMouse}
  {$IFDEF UseDrag}
    {$DEFINE UsingDrag}
  {$ELSE}
    {$DEFINE UseDragAnyway} {<--- define this to force use of OPDRAG}
    {$IFDEF UseDragAnyway}
      {$DEFINE UsingDrag}
    {$ENDIF}
  {$ENDIF}
{$ENDIF}

program TSpread;
  {-Test SpreadList object}
uses
  OpCrt,
  OpString,
  OpRoot,
  OpCmd,
  {$IFDEF UseMouse}
  OpMouse,
  {$ENDIF}
  OpFrame,
  OpWindow,
  {$IFDEF UsingDrag}
  OpDrag,
  {$ENDIF}
  OpPick,
  OpSpread;

const
  SpreadSize = 50;  {SpreadSheet is SpreadSize*SpreadSize}
  ItemWidth = 8;    {Each item is ItemWidth characters}
                    {Last character used for vertical divider}

var
  SL : SpreadList;
  {$IFDEF UseDragAnyway}
  PickCommands : DragProcessor;
  {$ENDIF}
  {$IFDEF UsingDrag}
  ZoomHeaderNum : byte;
  HotCode : byte;
  {$ENDIF}

{$F+}
procedure SpreadItem(Item : Word;
                     Mode : pkMode;
                     var IType : pkItemType;
                     var IString : String;
                     PickPtr : PickListPtr);
var
  Row : Word;
  Col : Word;
begin
  with SpreadListPtr(PickPtr)^ do begin
    Row := GetItemRow(Item);
    Col := GetItemCol(Item);
    IString := Long2Str(Row)+','+Long2Str(Col);
  end;
end;
{$F-}

procedure InitCommands;
begin
{$IFDEF UsingDrag}
  {$IFDEF UseDragAnyway}
  {Initialize the new picklist dragprocessor}
  if not PickCommands.Init(@PickKeySet, PickKeyMax) then
    Halt;
  {$ENDIF}
  {See-through mouse cursor}
  PickCommands.SetScreenMask($FFFF);
  PickCommands.SetMouseCursor($7700, $7700, $7700);
{$ELSE}
  {Enable the mouse}
  PickCommands.cpOptionsOn(cpEnableMouse);
  SoftMouseCursor($0000,
                 (Word(ColorMono(DefaultColorSet.MouseColor,
                                 DefaultColorSet.MouseMono)) shl 8)
                  or $04);
{$ENDIF}
end;

procedure InitSpreadSheet;
begin
  SL.InitDeluxe(5, 3, 36, 20,
                DefaultColorSet,
                DefWindowOptions or wBordered,
                ItemWidth, SpreadSize, SpreadSize,
                SpreadItem, SingleChoice,
                DefPickOptions);
  if InitStatus <> 0 then begin
    WriteLn('Error initializing SpreadList');
    Halt;
  end;

{$IFDEF UseDragAnyway}
  {attach the DragProcessor to the PickList}
  SL.SetCommandProcessor(PickCommands);
{$ENDIF}

  SL.EnableDividers(#209, #179, NoFrameChar);
  SL.ResizeWindow(-1, 0);
  SL.wFrame.AddScrollBar(frBB, 0, 0, DefaultColorSet);
  SL.wFrame.AddScrollBar(frRR, 0, 0, DefaultColorSet);

{$IFDEF UsingDrag}
  SL.wFrame.AddCustomHeader(#24, frtr, -1, 0,
                           DefaultColorSet.HeaderColor,
                           DefaultColorSet.HeaderMono);
  SL.wFrame.AddHotRegion(frTR, ZoomHotCode, -1, 0, 1, 1);
  ZoomHeaderNum := SL.wFrame.GetLastHeaderIndex;
  SL.wFrame.AddHotBar(frTT, MoveHotCode);
  SL.wFrame.AddCustomHeader(#240, frbr, 0, 0,
                           DefaultColorSet.FrameColor,
                           DefaultColorSet.FrameMono);
  SL.wFrame.AddHotRegion(frBR, ResizeHotCode, 0, 0, 1, 1);
  {limit the sizeability for demo purposes}
  SL.SetSizeLimits(30, 4, ScreenWidth, ScreenHeight);
{$ELSE}
  {scrolling by line is too slow without dragging}
  SL.pkOptionsOn(pkMousePage);
{$ENDIF}

  {Surround each element with spaces}
  SL.SetPadSize(1, 1);
end;

begin
{$IFDEF UseMouse}
{$IFDEF UsingDrag}
  if not MouseInstalled then begin
    WriteLn('Boring without a mouse');
    Halt;
  end;
{$ENDIF}
{$ENDIF}

  {initialize the screen}
  TextChar := #177;
  ClrScr;

  {Initialize the command processor}
  InitCommands;

  {Initialize the SpreadList object}
  InitSpreadSheet;

  {Set the initial highlight to [20, 20]}
  SL.SetInitialChoice(SL.GetItemNum(20, 20));

  {Process it}
  repeat
    SL.Process;
    {$IFDEF UsingDrag}
    case SL.GetLastCommand of
      ccMouseDown : if HandleMousePress(SL) = ZoomHotCode then
                      if SL.IsZoomed then
                        SL.ChangeHeader(ZoomHeaderNum, #18)
                      else
                        SL.ChangeHeader(ZoomHeaderNum, #24);
    end;
    {$ENDIF}
  until SL.GetLastCommand in [ccQuit, ccError];
  SL.Erase;
  SL.Done;
end.
