(****************************************************************)
(*                                                              *)
(* Saving a file from Raster Master in XGF format and using the *)
(* BINOBJ program to convert it to an object file allows as to  *)
(* include the image as a part of the executable.               *)
(*                                                              *)
(* eg.                                                          *)
(*     DOS>BINOBJ DISK.XGF DISK.OBJ DISK                        *)
(*                                                              *)
(* Using the above format we create a procedure name DISK and   *)
(* link the object file.                                        *)
(*                                                              *)
(* Procedure Disk; External;                                    *)
(* {$L DISK.OBJ}                                                *)
(*                                                              *)
(****************************************************************)


Program DisObj;
 Uses Graph;
Var
 Gd   : Integer;
 Gm   : Integer;
 Img  : Pointer;

Procedure Disk; External;
{$L DISK.OBJ}                              (* Link DISK.OBJ             *)

Begin
 Gd:=EGA;
 Gm:=EGAhi;
 InitGraph(Gd,Gm,'');                      (* Set path where EGAVGA.BGI *)
                                           (* is located                *)
 SetFillStyle(SolidFill,Blue);
 Bar(0,0,639,349);

 Img:=@Disk;                               (* Pass the address of the   *)
                                           (* procedure to the pointer  *)

 PutImage(300,120,Img^,NormalPut);         (* Display image             *)

 ReadLn;                                   (* Wait for enter key        *)

 CloseGraph;                               (* Close graphics            *)
End.