PROGRAM ibmcomt;

{Simple test program for IBMCOM.  Acts like a dumb terminal at a fixed
speed and with no commands except for Alt-X, to exit the program.
Obviously, it doesn't test all of IBMCOM, but it tests the most
important parts -- receiving and sending characters.}


USES
  Crt, ibmcom;


{Read a key from the keyboard.  If it's an ordinary key, the ascii code
is returned in ch1 and ch2 is #0.  If it's a function key, ch1 is 0 and
the scan code is in ch2.}

PROCEDURE read_key (VAR ch1, ch2: Char);
BEGIN
  ch1 := ReadKey;
  IF ch1 = #0 THEN
    ch2 := ReadKey
  ELSE
    ch2 := #0;
END;


CONST
  port          = 1;
  initial_speed = 19200;

VAR
  result   : Word;
  exit_prog: Boolean;
  ch1, ch2 : Char;
  ch3      : Char;

BEGIN

clrscr;

Writeln('Simple Terminal');
write('Port: ',port);
writeln(' Speed Set To: ',initial_speed);
writeln('Enter Alt-X to exit Program');


  ComInstall (port, result);
  IF result <> 0 THEN
    BEGIN
    CASE result OF
      1: Writeln ('Invalid port number: ', port);
      2: Writeln ('No hardware for port ', port);
      3: Writeln ('Driver already installed');
    ELSE
      Writeln ('Unexpected ComInstall error ', result);
      END;
    Exit;
    END;
  ComRaiseDTR;
  ComSetSpeed (initial_speed);
  ComSetParity (ComNone, 1);
  exit_prog := False;

  REPEAT
    IF KeyPressed THEN
      BEGIN
      read_key (ch1, ch2);
      IF ch1 <> #0 THEN
        ComTx (ch1)
      ELSE
        CASE ch2 OF
          #45: {Alt-X}
            exit_prog := True;
          END;
      END;
    ch3 := ComRx;
    IF ch3 <> #0 THEN
      Write (ch3);
  UNTIL exit_prog;
END.
