{*
*   Demo.pas
*
*   A demo of TV TOOLS.
*
*   Copyright 1992 by Richard W. Hansen
*
*}

program TV;
{$F-}
{$X+}
{$V-}
{$S-}
{$R-}

{$I TVDEFS.INC}

uses
  Crt, Dos,
  Objects, Drivers, Views, Menus, Dialogs, App, MsgBox, StdDlg,
  TvApp, TvConst, TvMenus, TvViews, TvDialog, TvInput;

const
  MaxLines          = 600;

  cmFileOpen        = 100;
  cmNewText         = 101;
  cmNewWin          = 102;
  cmNewFormatText   = 103;
  cmNewAsciiHex     = 104;
  cmNewDialog       = 105;
  cmNewEditLine     = 106;
  cmAbout           = 107;
  cmSetup           = 108;
  cmTestPct         = 109;
  cmTestPrt         = 110;
  cmTestList        = 111;
  cmTestWrite       = 112;
  cmTestBtn         = 113;
  cmTool1           = 1000;
  cmTool2           = cmTool1 + 1;
  cmTool3           = cmtool2 + 1;
  cmTool4           = cmTool3 + 1;
  cmTool5           = cmTool4 + 1;
  cmTool6           = cmTool5 + 1;
  cmTool7           = cmTool6 + 1;
  cmItem1           = cmMarkStart;
  cmItem2           = cmItem1 + 1;
  cmItem3           = cmItem2 + 1;
  cmItem4           = cmItem3 + 1;

  WinCount          : Integer =   0;


var
  LineCount : Integer;
  Lines     : array[0..MaxLines - 1] of PString;
  Buf       : Array[0..16383] of Char;
  BufSize   : Word;
  BufName   : PathStr;


type
  TMyApp = object(TNewApplication)
    Constructor Init;
    Procedure   HandleEvent(var Event: TEvent); virtual;
    Procedure   InitMenuBar; virtual;
    Procedure   InitStatusLine; virtual;
    Procedure   NewDialog;
    Procedure   NewWindow;
    Procedure   NewText;
    Procedure   NewFormatText;
    Procedure   NewAsciiHex;
    Procedure   NewEditLine;
    Procedure   OpenFile;
    Procedure   ReadFile(FileToRead : PathStr);
    Procedure   Setup;
    Procedure   About;
    Procedure   PercentTest;
    Procedure   PrintTest;
    Procedure   ListTest;
    Procedure   WritelnText;
    Procedure   Test3D;
    Procedure   InitDeskTop; virtual;
  end;


  PInterior = ^TInterior;
  TInterior = object(TScroller)
    constructor Init(var Bounds: TRect; AHScrollBar,
      AVScrollBar: PScrollBar);
    procedure Draw; virtual;
  end;


  PDemoWindow = ^TDemoWindow;
  TDemoWindow = object(TNewWindow)
    Interior: PInterior;
    constructor Init(Bounds: TRect; WinTitle: String; WindowNo: Word);
    function MakeInterior(Bounds: TRect): PInterior;
  end;

  PPctDialog  = ^TPctDialog;
  TPctDialog  = Object(TPercentDialog)
    Procedure   Process;                                Virtual;
  end;


  PPrtDialog  = ^TPrtDialog;
  TPrtDialog  = Object(TPrintDialog)
    X : Word;

    Procedure   Process;                                Virtual;
  end;


{ TInterior }
constructor TInterior.Init(var Bounds: TRect; AHScrollBar,
                           AVScrollBar: PScrollBar);
  begin
    TScroller.Init(Bounds, AHScrollBar, AVScrollBar);
    Options := Options or ofFramed;
    SetLimit(128, LineCount);
  end;

procedure TInterior.Draw;

  var
    Color: Byte;
    I, Y: Integer;
    B: TDrawBuffer;

  begin
    Color := GetColor(1);
    for Y := 0 to Size.Y - 1 do
    begin
      MoveChar(B, ' ', Color, Size.X);
      i := Delta.Y + Y;
      if (I < LineCount) and (Lines[I] <> nil) then
        MoveStr(B, Copy(Lines[I]^, Delta.X + 1, Size.X), Color);
      WriteLine(0, Y, Size.X, 1, B);
    end;
  end;


{ TDemoWindow }
constructor TDemoWindow.Init(Bounds: TRect; WinTitle: String; WindowNo: Word);
  begin
    TNewWindow.Init(Bounds, WinTitle, WindowNo{wnNoNumber});
    GetExtent(Bounds);
    Interior := MakeInterior(Bounds);
    Insert(Interior);
  end;

function TDemoWindow.MakeInterior(Bounds: TRect): PInterior;

  var
    HScrollBar, VScrollBar: PScrollBar;
    R : TRect;
    P : PInterior;

  begin
    R.Assign(Bounds.B.X-1, Bounds.A.Y+1, Bounds.B.X, Bounds.B.Y-1);
    VScrollBar := New(PScrollBar, Init(R));
    VScrollBar^.Options := VScrollBar^.Options or ofPostProcess;
    Insert(VScrollBar);
    R.Assign(Bounds.A.X+1, Bounds.B.Y-1, Bounds.B.X-1, Bounds.B.Y);
    HScrollBar := New(PScrollBar, Init(R));
    HScrollBar^.Options := HScrollBar^.Options or ofPostProcess;
    Insert(HScrollBar);
    Bounds.Grow(-1,-1);
    P := New(PInterior, Init(Bounds, HScrollBar, VScrollBar));
    P^.GrowMode := gfGrowHiX + gfGrowHiY;
    MakeInterior := P;
  end;


{ TPctDialog }
Procedure TPctDialog.Process;
  begin
    { here is where the works gets done, in this case we just
      delay a bit then bump the counter
    }
    if (RunState > 0) and (RunState < cmCancelJob) then
    begin
      if (RunState <> cmPauseJob) then
      begin
        Delay(5);
        Increment;

        if (Count = 500) then
          ChangeMessage('Half way there')
        else if (Count >= Total) then
        begin
          RunState := cmJobComplete;
          Delay(1000);
        end;
      end;
    end;
  end;


{ TPrtDialog }
Procedure TPrtDialog.Process;

  var
    N : String[5];

  begin
    { Here is where the works gets done. In this case we print a line then
      exit.
    }
    Case RunState of
      cmStartJob : {DO SETUP AND START PRINTING}
        begin
          RunState := cmContinueJob;
        end;

      cmContinueJob : {PRINT NEXT LINE}
        begin
          Inc(X);
          Delay(100); {print line here}
          Str(X,N);
          ChangeMessage('Printing Line ' + N);

          if (X = 250) then
            RunState := cmJobComplete;
        end;

      cmPauseJob : {DO NOTHING}
        ;

      cmJobComplete,
      cmCancelJob : {SHUT DOWN}
        ;
    end;
  end;


{ TMyApp }
constructor TMyApp.Init;

  var
    Event : TEVent;
    P     : PToolBar;
    R     : TRect;

  begin
    TNewApplication.Init;
    ReadFile('READ.ME');
    NewFormatText;
    Event.What := evCommand;
    Event.Command := cmAbout;
    PutEvent(Event);
  end;

procedure TMyApp.InitDesktop;

  var
    P     : PToolBar;
    R     : TRect;

  begin
    DoubleDelay := DoubleDelay DIV 2;
    {!!! TOOL BARS ARE ONLY BETA VERSIONS, SO USE AT YOUR OWN RISK }
    TNewApplication.InitDesktop;
    { TOOL BARS SHOULD ALWAYS BE THE FIRST THING INSERTED INTO THE
      DESKTOP!
    }
    R.Assign(0,0, 8,4);
    P := New(PToolBar, Init(R, True));
    P^.AddTool('  Save  '^M'File', CmTool1);
    P^.AddTool('  Open  '^M'File', CmTool2);
    P^.AddTool('  New   '^M'File', CmTool3);
    P^.AddTool('  Edit  ', CmTool4);
    P^.AddTool('  Cut   ', CmTool5);
    P^.AddTool(' Paste  ', CmTool6);
    Desktop^.Insert(P);
  end;

procedure TMyApp.HandleEvent(var Event: TEvent);

  var
    R : TRect;

  begin
    TApplication.HandleEvent(Event);

    if Event.What = evCommand then
    begin
      case Event.Command of
        cmAbout         : About;
        cmNewWin        : NewWindow;
        cmNewDialog     : NewDialog;
        cmNewText       : NewText;
        cmNewFormatText : NewFormatText;
        cmNewAsciiHex   : NewAsciiHex;
        cmNewEditLine   : NewEditLine;
        cmFileOpen      : OpenFile;
        cmSetup         : Setup;
        cmTestPct       : PercentTest;
        cmTestPrt       : PrintTest;
        cmTestList      : ListTest;
        cmTestWrite     : WritelnText;
        cmTestBtn       : Test3D;
        cmTool1         : MessageBox('SAVE TOOL', nil, mfInformation+ mfOkButton);
        cmTool2         : MessageBox('OPEN TOOL', nil, mfInformation+ mfOkButton);
        cmTool3         : MessageBox('NEW TOOL', nil, mfInformation+ mfOkButton);
        cmTool4         : MessageBox('EDIT TOOL', nil, mfInformation+ mfOkButton);
        cmTool5         : MessageBox('CUT TOOL', nil, mfInformation+ mfOkButton);
        cmTool6         : MessageBox('PASTE TOOL', nil, mfInformation+ mfOkButton);
        cmTile          :
          begin
            Desktop^.GetExtent(R);
            Desktop^.Tile(R);
          end;
        cmCascade       :
          begin
            Desktop^.GetExtent(R);
            Desktop^.Cascade(R);
          end;
        cmItem1..cmItem4:
          PNewMenuBar(MenuBar)^.ResetMarkers(cmItem1, cmItem4, Event.Command);
      else
        Exit;
      end;

      ClearEvent(Event);
    end;
  end;

procedure TMyApp.InitMenuBar;

  var
    R : TRect;
    S : String[3];

  begin
    S := ' ';
    (* Uncomment this to try check mark menus with a different marker.
    TvMenus.Marker    := 'ON ';
    Tvmenus.NoMarker  := 'OFF';
    TvMenus.MarkerLen := 3;
    S := '   ';
    *)

    GetExtent(R);
    R.B.Y := R.A.Y + 1;
    MenuBar := New(PNewMenuBar, Init(R,
    NewMenu(
      NewSubMenu('~~', hcNoContext,
      NewMenu(
        NewItem('~A~bout...',               '',     kbNoKey,  cmAbout,          hcNoContext,
        nil)),
      NewSubMenu('~F~ile', hcNoContext,
      NewMenu(
        NewItem('~O~pen...',                'F3',   kbF3,     cmFileOpen,       hcNoContext,
        NewLine(
        NewItem('E~x~it',                   'Alt-X',kbAltX,   cmQuit,           hcNoContext,
        nil)))),
      NewSubMenu('~W~indow', hcNoContext,
      NewMenu(
        NewItem('~N~ext',                   'F6',   kbF6,     cmNext,           hcNoContext,
        NewItem('~Z~oom',                   'F5',   kbF5,     cmZoom,           hcNoContext,
        NewItem('~T~ile',                   '',     kbNoKey,  cmTile,           hcNoContext,
        NewItem('~C~ascade',                '',     kbNoKey,  cmCascade,        hcNoContext,
        nil))))),
      NewSubMenu('~T~est', hcNoContext,
      NewMenu(
        NewItem('~D~ata Entry...',          '',     kbNoKey,  cmNewEditLine,    hcNoContext,
        NewItem('~M~essage Dialog...',      'F2',   kbF2,     cmNewDialog,      hcNoContext,
        NewItem('Standard File ~V~iewer',   'F4',   kbF4,     cmNewWin,         hcNoContext,
        NewItem('~T~ext Window',            'F7',   kbF7,     cmNewText,        hcNoContext,
        NewItem('~F~ormatted File Viewer',  'F8',   kbF8,     cmNewFormatText,  hcNoContext,
        NewItem('~A~scii/Hex Editor',       'F9',   kbF9,     cmNewAsciiHex,    hcNoContext,
        NewItem('~P~rogress Dialog',        '',     kbNoKey,  cmTestPct,        hcNoContext,
        NewItem('P~r~int Dialog',           '',     kbNoKey,  cmTestPrt,        hcNoContext,
        NewItem('~3~D Controls',            '',     kbNoKey,  cmTestBtn,        hcNoContext,
        NewItem('~W~riteln to Window',      '',     kbNoKey,  cmTestWrite,      hcNoContext,
        NewSubMenu('~C~heck Marks', hcNoContext,
        NewMenu(
          NewMarkedItem(S + 'Item 1',       '',     kbNoKey,  cmItem1,          hcNoContext,
          NewMarkedItem(S + 'Item 2',       '',     kbNoKey,  cmItem2,          hcNoContext,
          NewMarkedItem(S + 'Item 3',       '',     kbNoKey,  cmItem3,          hcNoContext,
          NewMarkedItem(S + 'Item 4',       '',     kbNoKey,  cmItem4,          hcNoContext,
          nil))))),
        nil)))))))))))),
      NewSubMenu('~O~ptions', hcNoContext,
      NewMenu(
        NewItem('~S~etup',                  '',     kbNoKey,  cmSetup,          hcNoContext,
        nil)),
      nil)))))
    )));

    PNewMenuBar(MenuBar)^.SetMarker(cmItem1);
  end;

procedure TMyApp.InitStatusLine;

  var
    R : TRect;

  begin
    GetExtent(R);
    R.A.Y := R.B.Y - 1;
    StatusLine := New(PStatusLine, Init(R,
      NewStatusDef(0, $FFFF,
        NewStatusKey('', kbF10, cmMenu,
        NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
        NewStatusKey('~Alt-F3~ Close', kbAltF3, cmClose,
        nil))),
      nil)
    ));
  end;

Procedure TMyApp.ListTest;
  begin
  end;

Procedure TMyApp.WritelnText;

  var
    W : PTextWindow;
    R : TRect;

  begin
    R.Assign(0, 0, 60, 13);
    W := New(PTextWindow, Init(R, 'Standard Output', wnNoNumber,
                               ofVScrollBar or ofHScrollBar, 25));
    DeskTop^.Insert(W);

    { redirect stnadard writes to a window }
    AssignOutput(Output, W);
    Rewrite(Output);
    Writeln('THIS TEXT IS DISPLAYED THROUGH THE STANDARD WRITE AND');
    Writeln('WRITELN STATEMENTS.');
    Write('THE STANDARD OUTPUT HAS BEEN REDIRECTED TO THIS WINDOW.');
    { restore standard output }
    Close(Output);
    Assign(Output, '');
    Rewrite(Output);
  end;

Procedure TMyApp.PercentTest;

  var
    Dlg : TPctDialog;

  begin
    Dlg.Init('', 'Your Message Here', 1000, mfOKPauseCancel OR mfMessageLine);
    DeskTop^.ExecView(@Dlg);
  end;

Procedure TMyApp.PrintTest;

  var
    Dlg : TPrtDialog;

  begin
    Dlg.Init('PRINT', '', mfOKPauseCancel OR mfMessageLine);
    DeskTop^.ExecView(@Dlg);
  end;

Procedure TMyApp.About;

  var
    Dialog : TMessageDialog;

  begin
    Dialog.Init(mfInformation + mfOKButton);
    Dialog.AddMessage('');
    Dialog.AddMessage('              ͻ    ');
    Dialog.AddMessage('          Ŀ');
    Dialog.AddMessage('          Ĵ');
    Dialog.AddMessage('           TV TOOL BOX ');
    Dialog.AddMessage('          ');
    Dialog.AddMessage('');
    Dialog.AddMessage(' Tools for Turbo Vision Programmers ');
    Dialog.AddMessage('');
    Dialog.AddMessage('   Copyright 1992, Richard Hansen');
    Dialog.AddMessage('');
    Dialog.Process;
    Dialog.Done;
  end;

Procedure TMyApp.Setup;

  var
    Dlg     : PDialog;
    R       : TRect;
    Control : PView;
    Command : Word;
    MState  : Word;

  begin
    R.Assign(0,0,53,12);
    New(Dlg, Init(R, 'Setup'));

    with Dlg^ do
    begin
      Options := Options OR ofCentered;
      R.Assign(2,2,51,3);
      Control := New(PCheckboxes, Init(R,
        NewSItem('Turn mouse cursor off when keyboard is used',Nil)));
      PCluster(Control)^.Value := 0;
      Insert(Control);

      R.Assign(10,8,18,10);
      Insert(New(PButton, Init(R, '~O~K', cmOK, bfDefault)));

      R.Assign(29,8,41,10);
      Insert(New(PButton, Init(R, '~C~ancel', cmCancel, bfNormal)));

      SelectNext(False);

      if (ValidView(Dlg) <> nil) then
      begin
        if ToggleMouse then
          MState  := 1
        else
          MState := 0;

        Dlg^.SetData(MState);
        Command := DeskTop^.ExecView(Dlg);

        if (Command <> cmCancel) then
        begin
          Dlg^.GetData(MState);

          if (MState = 1) then
            SetMouseToggle(True)
          else
            SetMouseToggle(False);
        end;
      end;
    end;
  end;

procedure TMyApp.ReadFile(FileToRead : PathStr);

  var
    F : Text;
    S : String;

  begin
    ShowBusy;
    LineCount := 0;
    Assign(F, FileToRead);
    {$I-}
    Reset(F);
    {$I+}

    if IOResult <> 0 then
    begin
      Writeln('Cannot open ', FileToRead);
      Halt(1);
    end;

    BufName := FileToRead;
    BufSize := 0;
    FillChar(Buf, SizeOf(Buf), 0);

    while not Eof(F) and (LineCount < MaxLines) do
    begin
      Readln(F, S);
      Lines[LineCount] := NewStr(S);
      Inc(LineCount);

      if (BufSize + Length(S) < SizeOf(Buf)) then
      begin
        Inc(Byte(S[0]));
        S[Byte(S[0])] := #13;
        Move(S[1], Buf[BufSize], Byte(S[0]));
        Inc(BufSize, Length(S));
      end;
    end;

    Close(F);
    CLearBusy;
  end;

procedure TMyApp.OpenFile;

  var
    FileName  : PathStr;
    D         : PFileDialog;

  begin
    {$IFDEF NEW_FILE_DIALOG}
    D := New(PNewFileDialog, Init('*.*', 'Open a File',
                                  'File~n~ame',
                                  fdOpenButton + fdHelpButton, 100));
    {$ELSE}
    D := New(PFileDialog, Init('*.*', 'Open a File',
                               'File~n~ame',
                                fdOpenButton + fdHelpButton, 100));
    {$ENDIF}

    if ValidView(D) <> nil then
    begin
      if Desktop^.ExecView(D) <> cmCancel then
      begin
        D^.GetFileName(FileName);
        EnableCommands([cmNewWin..cmNewAsciiHex]);
        DisableCommands([cmFileOpen]);
        ReadFile(FileName);
      end;

      Dispose(D, Done);
    end;
  end;

procedure TMyApp.NewDialog;

var
  Dialog : TMessageDialog;

begin
  Dialog.Init(mfInformation + mfOKButton);
  Dialog.AddMessage('');
  Dialog.AddMessage(' -------------- TMessageDialog -------------- ');
  Dialog.AddMessage(' It is simple to add text, just make a call');
  Dialog.AddMessage(' to the TMessageDialog.AddMessage method! The');
  Dialog.AddMessage(' message box will size itself to the amount');
  Dialog.AddMessage(' of text that is added.');
  Dialog.AddMessage(' -------------------------------------------- ');
  Dialog.Process;
  Dialog.Done;
end;

procedure TMyApp.NewWindow;
var
  Window: PDemoWindow;
  R: TRect;
begin
  Inc(WinCount);
  R.Assign(0, 0, 45, 13);
  R.Move(Random(34), Random(11));
  Window := New(PDemoWindow, Init(R, 'Standard Viewer: ' + BufName, wnNoNumber));
  Window^.Options := Window^.Options OR ofTileable;
  DeskTop^.Insert(Window);
end;

procedure TMyApp.NewAsciiHex;

  var
    Window: PEditBuffWindow;
    R     : TRect;

  begin
    Inc(WinCount);
    R.Assign(1,1, 64,16);
    Window := New(PEditBuffWindow, Init(R, 'Ascii/Hex Editor: ' + BufName,
                                        WinCount, ofPosIndicator,
                                        @Buf, SizeOf(Buf)));
    Window^.Options := Window^.Options OR ofTileable;
    DeskTop^.Insert(Window);
  end;

procedure TMyApp.NewText;

  var
    R       : TRect;
    i       : Byte;
    S       : String[3];
    TextWin : PTextWindow;
    Event   : TEvent;

  begin
    Inc(WinCount);
    R.Assign(0, 0, 60, 13);
    R.Move(Random(19), Random(10));
    TextWin := New(PTextWindow, Init(R, 'Text Window', WinCount,
                                    ofVScrollBar or ofHScrollBar, 25));
    TextWin^.Options := TextWin^.Options OR ofTileable;
    DeskTop^.Insert(TextWin);

    TextWin^.Write('');
    TextWin^.Write(' Ŀ ');
    TextWin^.Write('  THIS MAY NOT LOOK LIKE MUCH HERE, BUT CHECK OUT THE    ');
    TextWin^.Write('  EXAMPLE CODE AND YOU WILL SEE THAT THIS IS A TEXT      ');
    TextWin^.Write('  DISPLAY WINDOW WITHOUT A CUSTOMIZED DRAW METHOD. JUST  ');
    TextWin^.Write('  THE THING FOR A LITTLE QUICK AND EASY TEXT DISPLAY!    ');
    TextWin^.Write('  OPEN THE DATA ENTRY DIALOG, ENTER SOME DATA, AND HIT   ');
    TextWin^.Write('  "OK" WHEN THIS WINDOW IS OPEN.                         ');
    TextWin^.Write('  ');
    TextWin^.Write('');
  end;

procedure TMyApp.NewFormatText;

  var
    Window      : PNewWindow;
    R           : TRect;
    AVScrollBar : PScrollBar;

  begin
    Inc(WinCount);
    R.Assign(0, 0, Desktop^.Size.X, Desktop^.Size.Y);
    Window := New(PNewWindow, Init(R, 'Formatted Text Scroller: ' + BufName, WinCount));
    Window^.Options := Window^.Options OR ofTileable OR ofCentered;

    Window^.GetExtent(R);
    R.Assign(R.B.X-1, R.A.Y+1, R.B.X, R.B.Y-1);
    AVScrollBar := New(PScrollBar, Init(R));
    AVScrollBar^.Options := AVScrollBar^.Options or ofPostProcess;
    Window^.Insert(AVScrollBar);

    Window^.GetExtent(R);
    R.Grow(-1, -1);
    Window^.Insert(New(PFormattedTextScroller,
                       Init(R, AVscrollbar, @Buf, BufSize)));

    DeskTop^.Insert(Window);
  end;

Function Test(P : Pointer; ID : Word): Boolean;   FAR;
  begin
    MessageBox('POST EDIT ROUTINE: '^M'You just entered ' + PEditLine(P)^.Data^, nil, mfError + mfOkButton);
    { Return TRUE to stay, FALSE to leave the field }
    Test := False;
  end;

procedure TMyApp.NewEditLine;

  type
    DataRec = record
      S1 : String[10];
      S2 : String[21];
      S3 : String[21];
      S4 : String[21];
      S5 : String[21];
      I1 : Word;
      I2 : Integer;
      H1 : LongInt;
      S6 : String[8];
      S7 : String[8];
      S8 : String[10];
      S9 : String[10];
      R1 : Real;
      V1 : Word;
      V2 : Word;
    end;

  var
    Dialog : PEntryDialog;
    R      : TRect;
    E      : PEditLine;
    P      : PNewRadioButtons;
    L      : PLabel;
    S      : String[80];
    Data   : DataRec;

  begin
    R.Assign(0,0, 75,17);
    Dialog := New(PEntryDialog, Init(R, 'Data Entry'));


    With Dialog^ do
    begin
      Options := Options or ofCentered;
      R.Assign(2,1, 14,2);
      E := New(PEditLine, Init(R, '99/99/9999'));
      Insert(E);
      {E^.SetEditFlag(efLJustify, True);}
      R.Assign(2,2, 19,3);
      Insert(New(PEditLine, Init(R, '(999) 999-9999 [9999]')));
      R.Assign(2,4, 26,5);
      Insert(New(PEditLine, Init(R, '(999) 999-9999 [9999]')));

      R.Assign(2,6, 19,7);
      E := New(PEditLine, Init(R, '(999) 999-9999 [9999]'));
      Insert(E);
      R.Assign(2,5, 19,6);
      L := New(PLabel, Init(R, '~L~ocked Field', E));
      Insert(L);
      E^.AddLabel(L);
      E^.Lock;

      R.Assign(2,8, 19,9);
      E := New(PEditLine, Init(R, '(999) 999-9999 [9999]'));
      Insert(E);
      R.Assign(2,7, 19,8);
      L := New(PLabel, Init(R, '~U~nlocked Field', E));
      Insert(L);
      E^.AddLabel(L);

      R.Assign(2,10, 10,11);
      E := New(PWordEdit, Init(R, '99999', 0, 10000));
      Insert(E);
      E^.SetEditFlag(efLJustify, True);
      R.Assign(2,9, 19,10);
      L := New(PLabel, Init(R, 'U~n~signed Integer', E));
      Insert(L);
      E^.AddLabel(L);

      R.Assign(2,12, 11,13);
      E := New(PIntegerEdit, Init(R, '######', -10000, 10000));
      Insert(E);
      E^.SetEditFlag(efRJustify, True);
      R.Assign(2,11,  19,12);
      L := New(PLabel, Init(R, '~S~igned Integer', E));
      Insert(L);
      E^.AddLabel(L);

      R.Assign(30,2, 37,3);
      E := New(PHexEdit, Init(R, '&&&&&', $0000, $FFFF));
      Insert(E);
      R.Assign(30,1,  47,2);
      Insert(New(PLabel, Init(R, '~H~exadecimal', E)));

      R.Assign(30,4, 40,5);
      E := New(PEditLine, Init(R, 'XXXXXXXX'));
      E^.SetEditFlag(efHide, True);
      Insert(E);
      R.Assign(30,3, 47,4);
      Insert(New(PLabel, Init(R, '~P~assword', E)));

      R.Assign(30,6, 40,7);
      E := New(PEditLine, Init(R, 'XXXXXXXX'));
      E^.PadChar := '_';
      E^.SetEditFlag(efTrim, True);
      Insert(E);

      R.Assign(30,8, 42,9);
      E := New(PEditLine, Init(R, 'UUUUUUUUUU'));
      Insert(E);
      E^.SetEditFlag(efRequired, True);
      R.Assign(30,7, 53,8);
      Insert(New(PLabel, Init(R, 'Any Char ~F~orce Upper', E)));

      R.Assign(30,10, 42,11);
      E := New(PEditLine, Init(R, 'llllllllll'));
      Insert(E);
      E^.SetEditFlag(efLJustify, True);
      E^.SetPostEdit(@TEST);
      R.Assign(30,9, 53,10);
      Insert(New(PLabel, Init(R, '~A~lpha Only Force Lower', E)));

      R.Assign(30,12, 41,13);
      E := New(PRealEdit, Init(R, '#####.###', 0.0, 0.0));
      Insert(E);
      R.Assign(30,11, 53,12);
      Insert(New(PLabel, Init(R, '~F~loating point', E)));

      { add radio buttons }
      R.Assign(57,2,68,6);
      P := New(PNewRadioButtons, Init(R,
        NewSItem('~O~ne',
        NewSItem('~T~wo',
        NewSItem('Th~r~ee',
        NewSItem('~F~our',Nil))))));
      PCluster(P)^.Value := 0;
      Insert(P);
      R.Assign(58,1, 71,2);
      L := New(PLabel, Init(R, 'L~o~cked', P));
      Insert(L);
      P^.AddLabel(L);
      P^.Lock;

      R.Assign(57,8,68,12);
      P := New(PNewRadioButtons, Init(R,
        NewSItem('~O~ne',
        NewSItem('~T~wo',
        NewSItem('Th~r~ee',
        NewSItem('~F~our',Nil))))));
      PCluster(P)^.Value := 0;
      Insert(P);
      R.Assign(58,7, 71,8);
      L := New(PLabel, Init(R, 'Unlocked', P));
      Insert(L);
      P^.AddLabel(L);

      R.Assign(15,14, 23,16);
      Insert(New(PButton, Init(R, 'O~K~', cmOk, bfDefault)));

      R.Assign(30,14, 44,16);
      Insert(New(PButton, Init(R, '~C~ancel', cmCancel, bfNormal)));

      SelectNext(False);
    end;

    if (DeskTop^.ExecView(Dialog) <> cmCancel) then
    begin
      Dialog^.GetData(Data);

      with Data do
      begin
        Message(Desktop, evBroadcast, cmDisplayClr, nil);
        S := '<<< HERE IS WHAT YOU JUST ENTERED IN THE DIALOG BOX >>>';
        Message(Desktop, evBroadcast, cmDisplayStr, @S);
        Message(Desktop, evBroadcast, cmDisplayStr, @S1);
        Message(Desktop, evBroadcast, cmDisplayStr, @S2);
        Message(Desktop, evBroadcast, cmDisplayStr, @S3);
        Message(Desktop, evBroadcast, cmDisplayStr, @S4);
        Message(Desktop, evBroadcast, cmDisplayStr, @S5);
        Str(I1, S);
        Message(Desktop, evBroadcast, cmDisplayStr, @S);
        Str(I2, S);
        Message(Desktop, evBroadcast, cmDisplayStr, @S);
        Str(H1, S);
        Message(Desktop, evBroadcast, cmDisplayStr, @S);
        Message(Desktop, evBroadcast, cmDisplayStr, @S6);
        Message(Desktop, evBroadcast, cmDisplayStr, @S7);
        Message(Desktop, evBroadcast, cmDisplayStr, @S8);
        Message(Desktop, evBroadcast, cmDisplayStr, @S9);
        Str(R1:9:3, S);
        Message(Desktop, evBroadcast, cmDisplayStr, @S);
      end;
    end;

    Dispose(Dialog);
  end;

Procedure TMyApp.Test3D;

  var
    Dialog : P3DDialog;
    R      : TRect;
    P      : PView;

  begin
    R.Assign(0,0,42,20);
    New(Dialog, Init(R, '3D Controls'));

    with Dialog^ do
    begin
      Options := Options or ofCentered;

      { these are the inputline bounds, the outline will adjust
       its bounds as needed
      }
      R.Assign(3,3, 14,4);
      P := New(P3DOutline, Init(R));
      Insert(P);

      P := New(P3DInputLine, Init(R, 15));
      Insert(P);

      R.Assign(3,2, 11,3);
      P := New(PLabel, Init(R, '~T~ext 2', P));
      Insert(P);

      R.Assign(3,6, 14,7);
      P := New(P3DOutline, Init(R));
      Insert(P);

      P := New(P3DInputLine, Init(R, 15));
      Insert(P);

      R.Assign(3,5, 11,6);
      P := New(PLabel, Init(R, '~T~ext 1', P));
      Insert(P);

      { 3D Buttons }
      R.Assign(24,2,36,5);
      Insert(New(P3DButton, Init(R, 'OK', cmOK, bfDefault)));

      R.Assign(24,5,36,8);
      Insert(New(P3DButton, Init(R, '~C~ancel', cmCancel, bfNormal)));

      R.Assign(24,8,36,12);
      Insert(New(P3DButton, Init(R, '~O~pen'^M'File', cmYes, bfNormal)));

      R.Assign(24,12,36,16);
      Insert(New(P3DButton, Init(R, '~S~ave'^M'File', cmNo, bfNormal)));

      SelectNext(False);
    end;

    DeskTop^.ExecView(Dialog);
    Dispose(Dialog);
  end;


var
  MyApp : TMyApp;

begin
  MyApp.Init;
  MyApp.Run;
  MyApp.Done;
end.