{*
*
*   Copyright (c) 1992 by Richard W. Hansen
*
*   This source code will compile.
*   Unpacked source is available to registered users.
*
*}
UNIT TvInput;{$V-}{$X+}{$I TVDEFS.INC}INTERFACE USES Dialogs,Drivers,Objects,Views,MsgBox,{$IFDEF USE_TVSCROLL}TvScroll,
{$ENDIF}TvConst,TvString,TvType;CONST HideChar:Char='*';DecimalPt='.';CommaChar=',';Left=True;Right=False;
C3DInputLine=#45#45#46#47;TYPE P3DInputLine=^T3DInputLine;T3DInputLine=Object(TInputLine)Constructor Init(var Bounds:TRect;
AMaxLen:Integer);Function GetPalette:PPalette;Virtual;end;PEditLine=^TEditLine;{$IFDEF USE_TVSCROLL}
TEditLine=Object(TScrollInputLine){$ELSE}TEditLine=Object(TInputLine){$ENDIF}PadChar:Char;XPos:Byte;First:Byte;Mask:PString;
ID:Word;LLabel:PView;PostEdit:Pointer;EditFlags:Word;Constructor Init(var Bounds:TRect;EditMask:String);
Destructor Done;Virtual;Procedure Merge(var St:String;Justify:Boolean);Virtual;Function Remove(St:String):String;
Function CanScroll(ScrollLeft:Boolean):Boolean;Procedure Draw;Virtual;Procedure SelectAll(Enable:Boolean);
Procedure SetState(AState:Word;Enable:Boolean);Virtual;Function NextPos(Pos:Integer):Integer;Virtual;
Function PrevPos(Pos:Integer):Integer;Virtual;Function HomePos:Integer;Virtual;Procedure SetData(var Rec);Virtual;
Procedure GetData(var Rec);Virtual;Function DataSize:Word;Virtual;Function EditToMaskPos(Pos:Integer):Integer;
Function MaskToEditPos(Pos:Integer):Integer;Procedure DeleteMarked;Procedure InsertChar(Ch:Char);Virtual;
Procedure HandleEvent(var Event:TEvent);Virtual;Function Valid(Command:Word):Boolean;Virtual;
Procedure SetPostEdit(P:Pointer);Function Empty:Boolean;Virtual;Procedure SetEditFlag(AFlag:Word;Enable:Boolean);
Procedure AddLabel(ALabel:PView);Procedure Lock;Procedure UnLock;Procedure SetID(AFieldID:Word);Function GetID:Word;
{$IFDEF HAVE_RTL}Procedure Select;Virtual;{$ENDIF}end;PNumericEdit=^TNumericEdit;TNumericEdit=Object(TEditLine)
ErrCode:Integer;Procedure HandleEvent(var Event:TEvent);Virtual;Function Valid(Command:Word):Boolean;Virtual;
Function OutOfRange:Boolean;Virtual;Function OutOfRangeMsg:String;Virtual;end;PLongEdit=^TLongEdit;
TLongEdit=Object(TNumericEdit)Min:LongInt;Max:LongInt;Constructor Init(var Bounds:TRect;EditMask:String;AMin:LongInt;
AMax:LongInt);Function DataSize:Word;Virtual;Procedure GetData(var Rec);Virtual;Procedure SetData(var Rec);Virtual;
Function OutOfRange:Boolean;Virtual;Function OutOfRangeMsg:String;Virtual;end;PIntegerEdit=^TIntegerEdit;
TIntegerEdit=Object(TLongEdit)Constructor Init(var Bounds:TRect;EditMask:String;AMin:Integer;AMax:Integer);
Function DataSize:Word;Virtual;Procedure GetData(var Rec);Virtual;Procedure SetData(var Rec);Virtual;end;
PWordEdit=^TWordEdit;TWordEdit=Object(TLongEdit)Constructor Init(var Bounds:TRect;EditMask:String;AMin:Word;AMax:Word);
Function DataSize:Word;Virtual;Procedure GetData(var Rec);Virtual;Procedure SetData(var Rec);Virtual;end;
PByteEdit=^TByteEdit;TByteEdit=Object(TLongEdit)Constructor Init(var Bounds:TRect;EditMask:String;AMin:Byte;AMax:Byte);
Function DataSize:Word;Virtual;Procedure GetData(var Rec);Virtual;Procedure SetData(var Rec);Virtual;end;PHexEdit=^THexEdit;
THexEdit=Object(TLongEdit)Procedure SetData(var Rec);Virtual;Function OutOfRangeMsg:String;Virtual;end;
PFloatEdit=^TFloatEdit;TFloatEdit=Object(TNumericEdit)DP:Byte;Constructor Init(var Bounds:TRect;EditMask:String);
Procedure HandleEvent(var Event:TEvent);Virtual;Procedure Merge(var St:String;Justify:Boolean);Virtual;end;{$IFOPT N+}
PDoubleEdit=^TDoubleEdit;TDoubleEdit=Object(TFloatEdit)Min:Double;Max:Double;Constructor Init(var Bounds:TRect;
EditMask:String;AMin:Double;AMax:Double);Function DataSize:Word;Virtual;Procedure GetData(var Rec);Virtual;
Procedure SetData(var Rec);Virtual;Function OutOfRange:Boolean;Virtual;Function OutOfRangeMsg:String;Virtual;end;{$ENDIF}
PRealEdit=^TRealEdit;TRealEdit=Object(TFloatEdit)Min:Real;Max:Real;Constructor Init(var Bounds:TRect;EditMask:String;
AMin:Real;AMax:Real);Function DataSize:Word;Virtual;Procedure GetData(var Rec);Virtual;Procedure SetData(var Rec);Virtual;
Function OutOfRange:Boolean;Virtual;Function OutOfRangeMsg:String;Virtual;end;
PEntryDialog=^TEntryDialog;{$IFDEF USE_TVSCROLL}TEntryDialog=Object(TScrollDialog){$ELSE}TEntryDialog=Object(TDialog){$ENDIF}
Constructor Init(var Bounds:TRect;ATitle:TTitleStr);Function FindField(ID:Word):Pointer;Procedure LockField(ID:Word;
Enable:Boolean);Procedure HandleEvent(var Event:TEvent);Virtual;{$IFDEF USE_TVSCROLL}Procedure Insert(P:PView);{$ENDIF}end;
PNewCheckBoxes=^TNewCheckBoxes;TNewCheckBoxes=Object(TCheckBoxes)PostEdit:Pointer;ID:Word;LLabel:PView;EditFlags:Word;
Constructor Init(var Bounds:TRect;AStrings:PSItem);Procedure SetPostEdit(P:Pointer);Function Empty:Boolean;Virtual;
Procedure SetEditFlag(AFlag:Word;Enable:Boolean);Procedure AddLabel(ALabel:PView);Procedure Lock;Procedure UnLock;
Procedure SetID(AFieldID:Word);Function GetID:Word;{$IFDEF HAVE_RTL}Procedure Select;Virtual;{$ENDIF}
Procedure HandleEvent(var Event:TEvent);Virtual;Function Valid(Command:Word):Boolean;Virtual;Procedure SetState(AState:Word;
Enable:Boolean);Virtual;end;PNewRadioButtons=^TNewRadioButtons;TNewRadioButtons=Object(TRadioButtons)PostEdit:Pointer;
ID:Word;LLabel:PView;EditFlags:Word;Constructor Init(var Bounds:TRect;AStrings:PSItem);Procedure SetPostEdit(P:Pointer);
Function Empty:Boolean;Virtual;Procedure SetEditFlag(AFlag:Word;Enable:Boolean);Procedure AddLabel(ALabel:PView);
Procedure Lock;Procedure UnLock;Procedure SetID(AFieldID:Word);Function GetID:Word;{$IFDEF HAVE_RTL}Procedure Select;Virtual;
{$ENDIF}Procedure HandleEvent(var Event:TEvent);Virtual;Function Valid(Command:Word):Boolean;Virtual;
Procedure SetState(AState:Word;Enable:Boolean);Virtual;end;CONST AnyChar='X';ForceUp='U';ForceLo='L';AlphaOnly='a';
UpperAlpha='u';LowerAlpha='l';NumberOnly='#';DigitOnly='9';HexOnly='&';
EditMaskChars:TCharSet=[AnyChar,ForceUp,ForceLo,AlphaOnly,UpperAlpha,LowerAlpha,NumberOnly,DigitOnly,HexOnly];
AnyCharSet:TCharSet=[#32..#255];AlphaOnlySet:TCharSet=['0'..'9','A'..'Z','a'..'z',' '];DigitOnlySet:TCharSet=['0'..'9'];
NumberOnlySet:TCharSet=['0'..'9','-'];HexOnlySet:TCharSet=['0'..'9','A'..'F','a'..'f','$'];
DateMaskSet:TCharSet=['m','M','d','D','y','Y',DateSlash];IMPLEMENTATION Function LoCase(C:Char):Char;begin
    ASM
          mov   al,C
          cmp   al,'A'
          jb    @1
          cmp   al,'Z'
          ja    @1
          add   al,'a' - 'A'
      @1: mov   @RESULT,al
end;end;Constructor T3DInputLine.Init(var Bounds:TRect;AMaxLen:Integer);var R:TRect;P:PView;begin
TInputLine.Init(Bounds,AMaxLen);end;Function T3DInputLine.GetPalette:PPalette;Const
P:String[Length(C3DInputLine)]=C3DInputLine;begin GetPalette:=@P;end;Constructor TEditLine.Init(var Bounds:TRect;
EditMask:String);var i:Byte;x:Byte;begin x:=0;for i:=1 to Byte(EditMask[0])do if(EditMask[i]in EditMaskChars)then Inc(x);
TInputLine.Init(Bounds,x);Mask:=NewStr(EditMask);First:=1;PadChar:=' ';While(First<=Length(Mask^))and
not(EditMask[First]in EditMaskChars)do Inc(First);PostEdit:=nil;LLabel:=nil;ID:=0;EditFlags:=0;
EventMask:=EventMask or evBroadcast;end;Destructor TEditLine.Done;begin TInputLine.Done;DisposeStr(Mask);end;
Function TEditLine.DataSize:Word;begin DataSize:=Length(Mask^)+1;end;Procedure TEditLine.SetData(var Rec);begin
DisposeStr(Data);Data:=NewStr(Remove(String(Rec)));SelectAll(True);end;Procedure TEditLine.GetData(var Rec);var Temp:String;
SaveFlag:Word;begin SaveFlag:=EditFlags;EditFlags:=EditFlags and NOT efHide;Merge(Temp,True);EditFlags:=SaveFlag;
Move(Temp,Rec,DataSize);end;Procedure TEditLine.Merge(var St:String;Justify:Boolean);var i,j:Byte;Temp:String;begin j:=0;
for i:=1 to Byte(Mask^[0])do begin if(Mask^[i]in EditMaskChars)then begin if(j<Byte(Data^[0]))Then begin Inc(j);
if((EditFlags and efHide)<>0)then St[i]:=HideChar else St[i]:=Data^[j];end else begin St[i]:=PadChar;end;end else begin
St[i]:=Mask^[i];end;end;Byte(St[0]):=i;if Justify then begin if((EditFlags and efRJustify)<>0)then begin TrimCh(St,PadChar);
LeftPadCh(St,MaxLen,PadChar);end else if((EditFlags and efLJustify)<>0)then begin TrimCh(St,PadChar);
PadCh(St,MaxLen,PadChar);end else if((EditFlags and efTrim)<>0)then TrimCh(St,PadChar)else PadCh(St,MaxLen,PadChar);end;end;
Function TEditLine.Remove(St:String):String;var i,j:Byte;Temp:String;begin j:=0;for i:=1 to Byte(St[0])do begin
if(Mask^[i]in EditMaskChars)then begin Inc(j);Temp[j]:=St[i];end end;Byte(Temp[0]):=i;Remove:=Temp;end;
Procedure TEditLine.Draw;var St:String;Color:Byte;B:TDrawBuffer;L,R:Integer;begin Merge(St,(State and sfSelected=0));
if(State and sfFocused=0)then Color:=GetColor(1)else Color:=GetColor(2);MoveChar(B,' ',Color,Size.X);
MoveStr(B[1],Copy(St,FirstPos,Size.X-2),Color);if CanScroll(Right)then MoveChar(B[Size.X-1],#16,GetColor(4),1);
if State and sfSelected<>0 then begin if CanScroll(Left)then MoveChar(B[0],#17,GetColor(4),1);L:=SelStart-FirstPos+1;
if(L<1)then L:=1;R:=SelEnd-FirstPos+1;if(R>Size.X-1)then R:=Size.X-1;if(L<R)then MoveChar(B[L],#0,GetColor(3),R-L+1);end;
WriteLine(0,0,Size.X,Size.Y,B);SetCursor(CurPos-FirstPos+1,0);end;Procedure TEditLine.SelectAll(Enable:Boolean);begin
CurPos:=HomePos;XPos:=MaskToEditPos(CurPos);FirstPos:=1;SelStart:=1;if Enable and(Length(Data^)>0)then SelEnd:=Length(Mask^)
else SelEnd:=1;DrawView;end;Procedure TEditLine.SetState(AState:Word;Enable:Boolean);begin TView.SetState(AState,Enable);
if(AState=sfSelected)or ((AState=sfActive)and(State and sfSelected<>0))then SelectAll(Enable)else if(AState=sfDisabled)then
if(LLabel<>nil)then LLabel^.SetState(sfDisabled,Enable);end;Function TEditLine.NextPos(Pos:Integer):Integer;var x:Integer;
begin x:=Pos+1;While(x<=Length(Mask^))and not(Mask^[x]in EditMaskChars)do Inc(x);if(x<=Length(Mask^)+1)then NextPos:=x else
NextPos:=Pos;end;Function TEditLine.PrevPos(Pos:Integer):Integer;var x:Integer;begin x:=Pos-1;
While(x>0)and not(Mask^[x]in EditMaskChars)do Dec(x);if(x>0)then PrevPos:=x else PrevPos:=Pos;end;
Function TEditLine.HomePos:Integer;begin HomePos:=First;end;Function TEditLine.EditToMaskPos(Pos:Integer):Integer;var
x:Integer;Count:Integer;begin Count:=0;for x:=1 to Pos do Repeat Inc(Count);Until(Mask^[Count]in EditMaskChars);
EditToMaskPos:=Count;end;Function TEditLine.MaskToEditPos(Pos:Integer):Integer;var x:Integer;Count:Integer;begin Count:=0;
for x:=1 to Pos do if(Mask^[x]in EditMaskChars)then Inc(Count);MaskToEditPos:=Count;end;Procedure TEditLine.DeleteMarked;
begin if(SelStart<>SelEnd)then begin Delete(Data^,SelStart,SelEnd-SelStart+1);XPos:=SelStart;CurPos:=EditToMaskPos(XPos);end;
end;Function TEditLine.CanScroll(ScrollLeft:Boolean):Boolean;begin if((EditFlags and efRJustify)<>0)then CanScroll:=False
else if ScrollLeft then CanScroll:=(FirstPos>1)else CanScroll:=((Length(Mask^)-FirstPos+1)>(Size.X-2));end;
Procedure TEditLine.InsertChar(Ch:Char);begin if(State and sfCursorIns<>0)then Delete(Data^,XPos,1)else DeleteMarked;
if(Length(Data^)<MaxLen)then begin if(FirstPos>CurPos)then FirstPos:=CurPos;Insert(Ch,Data^,XPos);if(XPos<=MaxLen)then begin
Inc(XPos);CurPos:=NextPos(CurPos);end;end;end;Procedure TEditLine.HandleEvent(var Event:TEvent);
Function MouseScroll(var Dir:Boolean):Boolean;var Mouse:TPoint;begin MakeLocal(Event.Where,Mouse);if(Mouse.X<=0)then begin
MouseScroll:=True;Dir:=Left;end else if(Mouse.X>=Size.X-1)then begin MouseScroll:=True;Dir:=Right;end else begin
MouseScroll:=False;end;end;Function MousePos:Integer;var Pos:Integer;Mouse:TPoint;begin MakeLocal(Event.Where,Mouse);
if(Mouse.X<1)then Mouse.X:=1;Pos:=Mouse.X+FirstPos-1;if(Pos<1)then Pos:=1 else if(Pos>EditToMaskPos(Length(Data^)))then
Pos:=EditToMaskPos(Length(Data^));if not(Mask^[Pos]in EditMaskChars)then Pos:=NextPos(Pos);
if not(Mask^[Pos]in EditMaskChars)then Pos:=PrevPos(Pos);MousePos:=Pos;end;Procedure Scroll(Dir:Boolean);begin
if CanScroll(Dir)then begin if(Dir=Left)then begin Dec(XPos);Dec(FirstPos);CurPos:=PrevPos(CurPos);end else begin Inc(XPos);
Inc(FirstPos);CurPos:=NextPos(CurPos);end;end;end;var Anchor:Integer;x:Integer;ValidCh:Boolean;ScrollDir:Boolean;Temp:String;
begin TView.HandleEvent(Event);Case Event.What of evMouseDown:begin if(State and sfSelected=0)then 
else if MouseScroll(ScrollDir)then begin Repeat Scroll(ScrollDir);DrawView;Until not MouseEvent(Event,evMouseAuto);end 
else if Event.Double then begin SelectAll(True);end else begin Anchor:=MousePos;Repeat if(Event.What=evMouseAuto)then begin
if MouseScroll(ScrollDir)then Scroll(ScrollDir);end else begin CurPos:=MousePos;XPos:=MaskToEditPos(CurPos);end;
if(CurPos<Anchor)then begin SelStart:=CurPos;SelEnd:=Anchor;end else begin SelStart:=Anchor;SelEnd:=CurPos;end;DrawView;
Until not MouseEvent(Event,evMouseMove+evMouseAuto);end;ClearEvent(Event);end;evKeyDown:begin
Case CtrlToArrow(Event.KeyCode)of kbLeft:begin if(XPos>1)then begin Dec(XPos);CurPos:=PrevPos(CurPos);end;end;kbRight:begin
if(XPos<=Length(Data^))then if(XPos<=MaxLen)then begin Inc(XPos);CurPos:=NextPos(CurPos);end;end;kbHome:begin XPos:=1;
CurPos:=HomePos;end;kbEnd:begin XPos:=Length(Data^);CurPos:=NextPos(EditToMaskPos(XPos));Inc(XPos);end;kbBack:begin
if(XPos>1)then begin Dec(XPos);CurPos:=PrevPos(CurPos);Delete(Data^,XPos,1);if(FirstPos>1)then Dec(FirstPos);end;end;kbDel:
begin if(SelStart=SelEnd)then Delete(Data^,XPos,1)else DeleteMarked;end;kbIns:begin
SetState(sfCursorIns,State and sfCursorIns=0);end;else Case Event.CharCode of ' '..#255:begin Case(Mask^[CurPos])of HexOnly:
begin ValidCh:=Event.CharCode in HexOnlySet;end;DigitOnly:begin ValidCh:=Event.CharCode in DigitOnlySet;end;AnyChar:begin
ValidCh:=True;end;ForceUp:begin Event.CharCode:=UpCase(Event.CharCode);ValidCh:=True;end;ForceLo:begin
Event.CharCode:=LoCase(Event.CharCode);ValidCh:=True;end;AlphaOnly:begin ValidCh:=Event.CharCode in AlphaOnlySet;end;
UpperAlpha:begin Event.CharCode:=UpCase(Event.CharCode);ValidCh:=Event.CharCode in AlphaOnlySet;end;LowerAlpha:begin
Event.CharCode:=LoCase(Event.CharCode);ValidCh:=Event.CharCode in AlphaOnlySet;end;NumberOnly:begin
ValidCh:=Event.CharCode in NumberOnlySet;end;else ValidCh:=False;end;if ValidCh then begin InsertChar(Event.CharCode);end;
end;^Y:begin Data^:='';XPos:=1;CurPos:=HomePos;end;else Exit;end;end;SelStart:=1;SelEnd:=1;if(FirstPos>CurPos)then begin
if(CurPos=HomePos)then FirstPos:=1 else FirstPos:=CurPos;end;x:=CurPos-Size.X+2;if(FirstPos<x)then FirstPos:=x;DrawView;
ClearEvent(Event);end;evBroadcast:begin Case Event.Command of cmLoseFocus:begin if(PostEdit<>nil)then begin 
if PostEditFunc(PostEdit)(@Self,ID)then begin ClearEvent(Event);Event.InfoPtr:=@Self;end;end else if not Valid(cmOK)then begin
ClearEvent(Event);Event.InfoPtr:=@Self;end;end;cmIdentify:if(Event.InfoWord=ID)then begin ClearEvent(Event);
Event.InfoPtr:=@Self;end;end;end;end;end;Function TEditLine.Valid(Command:Word):Boolean;var Name:String;begin Valid:=True;
if(Command<>cmCancel)and(Command<>cmValid)then begin if((EditFlags AND efRequired)<>0)and Empty then begin Name:='';
if(LLabel<>nil)then begin Name:=PLabel(LLabel)^.Text^;Strip(Name,['~']);Name:=Name+^M;end;
ErrorMsg:=Name+'Field is required.';Message(Owner,evBroadcast,cmFieldError,@ErrorMsg);Valid:=False;Select;SelectAll(True);end 
else Valid:=TInputLine.Valid(Command);end else begin Valid:=TInputLine.Valid(Command);end;end;{$IFDEF HAVE_RTL}
Procedure TEditLine.Select;begin if(Owner^.Current<>@Self)then begin
if(Message(Owner^.Current,evBroadcast,cmLoseFocus,nil)=nil)then TInputLine.Select;end else TInputLine.Select;end;{$ENDIF}
Procedure TEditLine.SetEditFlag(AFlag:Word;Enable:Boolean);begin if Enable then EditFlags:=EditFlags or AFlag else
EditFlags:=EditFlags and not AFlag;end;Procedure TEditLine.AddLabel(ALabel:PView);begin LLabel:=ALabel;end;
Procedure TEditLine.Lock;begin SetState(sfDisabled,True);end;Procedure TEditLine.UnLock;begin SetState(sfDisabled,False);end;
Procedure TEditLine.SetID(AFieldID:Word);begin ID:=AFieldID;end;Function TEditLine.GetID:Word;begin GetID:=ID;end;
Function TEditLine.Empty:Boolean;begin Empty:=AllBlanks(Data^);end;Procedure TEditLine.SetPostEdit(P:Pointer);begin
PostEdit:=P;end;Procedure TNumericEdit.HandleEvent(var Event:TEvent);var ValidCh:Boolean;begin if(Event.What=evKeyDown)then
begin Case Event.CharCode of ' '..#255:begin Case(Mask^[CurPos])of DigitOnly:ValidCh:=(Event.CharCode in DigitOnlySet);
NumberOnly:ValidCh:=(Event.CharCode in NumberOnlySet);HexOnly:ValidCh:=(Event.CharCode in HexOnlySet);else ValidCh:=False;
end;if not ValidCh then ClearEvent(Event)else Case Event.CharCode of '-','$':begin if(Length(Data^)>0)then begin
if(Data^[1]<>Event.CharCode)and(Length(Data^)<MaxLen)then begin Insert(Event.CharCode,Data^,1);CurPos:=NextPos(CurPos);end 
else if(Data^[1]=Event.CharCode)then begin Delete(Data^,1,1);CurPos:=PrevPos(CurPos);end;XPos:=MaskToEditPos(CurPos);
DrawView;ClearEvent(Event);end;end;end;end;end;end;TEditLine.HandleEvent(Event);end;
Function TNumericEdit.Valid(Command:Word):Boolean;var Name:String;begin Valid:=True;
if(Command<>cmCancel)and(Command<>cmValid)then begin if OutOfRange then begin Valid:=False;Select;Name:='';
if(LLabel<>nil)then begin Name:=PLabel(LLabel)^.Text^;Strip(Name,['~']);Name:=Name+^M;end;ErrorMsg:=Name+OutOfRangeMsg;
Message(Owner,evBroadcast,cmFieldError,@ErrorMsg);SelectAll(True);end else Valid:=TEditLine.Valid(Command);end else begin
Valid:=TEditLine.Valid(Command);end;end;Function TNumericEdit.OutOfRangeMsg:String;begin
OutOfRangeMsg:='Entry is not in valid range';end;Function TNumericEdit.OutOfRange:Boolean;begin OutOfRange:=False;end;
Constructor TLongEdit.Init(var Bounds:TRect;EditMask:String;AMin:LongInt;AMax:LongInt);begin
TNumericEdit.Init(Bounds,EditMask);if(AMin<=AMax)then begin Min:=AMin;Max:=AMax;end else begin Min:=AMax;Max:=AMin;end;end;
Function TLongEdit.OutOfRange:Boolean;var Value:LongInt;begin OutOfRange:=False;if(Min<>0)or(Max<>0)then begin
TLongEdit.GetData(Value);if(ErrCode<>0)or(Value<Min)or(Value>Max)then OutOfRange:=True end;end;
Function TLongEdit.OutOfRangeMsg:String;var MinStr,MaxStr:String[11];begin Str(Min,MinStr);Str(Max,MaxStr);
OutOfRangeMsg:='Range is '+MinStr+' to '+MaxStr;end;Function TLongEdit.DataSize:Word;begin DataSize:=SizeOf(LongInt);end;
Procedure TLongEdit.GetData(var Rec);begin if(Data^='')or(Data^='$')or(Data^='-')then Data^:='0';
Val(Data^,LongInt(Rec),ErrCode);if(ErrCode<>0)then LongInt(Rec):=0;end;Procedure TLongEdit.SetData(var Rec);begin
if(Min<>0)and(Max<>0)then if((LongInt(Rec)<Min)or(LongInt(Rec)>Max))then LongInt(Rec):=0;Str(LongInt(Rec),Data^);
SelectAll(True);end;Procedure THexEdit.SetData(var Rec);var S:String[9];begin Data^:=HexString(LongInt(Rec));SelectAll(True);
end;Function THexEdit.OutOfRangeMsg:String;var MinStr,MaxStr:String[16];begin
OutOfRangeMsg:='Range is '+HexString(Min)+' to '+HexString(Max);end;Constructor TIntegerEdit.Init(var Bounds:TRect;
EditMask:String;AMin:Integer;AMax:Integer);begin TLongEdit.Init(Bounds,EditMask,AMin,AMax);end;
Function TIntegerEdit.DataSize:Word;begin DataSize:=SizeOf(Integer);end;Procedure TIntegerEdit.GetData(var Rec);var L:LongInt;
begin TLongEdit.GetData(L);Integer(Rec):=L;end;Procedure TIntegerEdit.SetData(var Rec);var L:LongInt;begin L:=Integer(Rec);
TLongEdit.SetData(L);end;Constructor TWordEdit.Init(var Bounds:TRect;EditMask:String;AMin:Word;AMax:Word);begin
TLongEdit.Init(Bounds,EditMask,AMin,AMax);end;Function TWordEdit.DataSize:Word;begin DataSize:=SizeOf(Word);end;
Procedure TWordEdit.GetData(var Rec);var L:LongInt;begin TLongEdit.GetData(L);Word(Rec):=L;end;
Procedure TWordEdit.SetData(var Rec);var L:LongInt;begin L:=Word(Rec);TLongEdit.SetData(L);end;
Constructor TByteEdit.Init(var Bounds:TRect;EditMask:String;AMin:Byte;AMax:Byte);begin
TLongEdit.Init(Bounds,EditMask,AMin,AMax);end;Function TByteEdit.DataSize:Word;begin DataSize:=SizeOf(Byte);end;
Procedure TByteEdit.GetData(var Rec);var L:LongInt;begin TLongEdit.GetData(L);Byte(Rec):=L;end;
Procedure TByteEdit.SetData(var Rec);var L:LongInt;begin L:=Byte(Rec);TLongEdit.SetData(L);end;
Constructor TFloatEdit.Init(var Bounds:TRect;EditMask:String);var x:Byte;begin x:=Pos(DecimalPt,EditMask);if(x<>0)then
Delete(EditMask,x,1);TNumericEdit.Init(Bounds,EditMask);if(x<>0)then begin DP:=Length(EditMask)+1-x;FreeMem(Data,MaxLen+1);
GetMem(Data,MaxLen+2);Data^:='';end else begin DP:=0;end;end;Procedure TFloatEdit.HandleEvent(var Event:TEvent);var x:Byte;
begin Case Event.What of evKeyDown:begin Case CtrlToArrow(Event.KeyCode)of kbBack:begin if(XPos>1)then
if(Data^[XPos-1]=DecimalPt)then ClearEvent(Event);end;kbDel:begin if(XPos<=Length(Data^))then if(Data^[XPos]=DecimalPt)then
ClearEvent(Event);end;else Case Event.CharCode of DecimalPt:begin if(DP=0)then begin ClearEvent(Event);end 
else if(Pos(DecimalPt,Data^)<>0)then begin XPos:=Pos(DecimalPt,Data^);CurPos:=NextPos(EditToMaskPos(XPos));Inc(XPos);
ClearEvent(Event);DrawView;end else begin InsertChar(DecimalPt);ClearEvent(Event);DrawView;end;end;'0'..'9':begin
if(DP<>0)then begin x:=Pos(DecimalPt,Data^);if(x<>0)then if(XPos>x)then if((Length(Data^)-x)=DP)then ClearEvent(Event);end;
end;end;end;end;end;TNumericEdit.HandleEvent(Event);end;Procedure TFloatEdit.Merge(var St:String;Justify:Boolean);begin
TNumericEdit.Merge(St,Justify);end;{$IFOPT N+}Constructor TDoubleEdit.Init(var Bounds:TRect;EditMask:String;AMin:Double;
AMax:Double);begin TFloatEdit.Init(Bounds,EditMask);if(AMin<=AMax)then begin Min:=AMin;Max:=AMax;end else begin Min:=AMax;
Max:=AMin;end;end;Function TDoubleEdit.OutOfRange:Boolean;var Value:Double;begin OutOfRange:=False;
if(Min<>0.0)or(Max<>0.0)then begn GetData(Value);if(ErrCode<>0)or(Value<Min)or(Value>Max)then OutOfRange:=True end;end;
Function TDoubleEdit.OutOfRangeMsg:String;var MinStr,MaxStr:String[20];W:Byte;begin if(DP>0)then W:=20-DP-1 else W:=20;
Str(Min:W:DP,MinStr);Str(Max:W:DP,MaxStr);OutOfRangeMsg:='Range is '+MinStr+' to '+MaxStr;end;
Function TDoubleEdit.DataSize:Word;begin DataSize:=SizeOf(Double);end;Procedure TDoubleEdit.GetData(var Rec);begin
if(Data^='')or(Data^='$')or(Data^='-')then Data^:='0';Val(Data^,Double(Rec),ErrCode);if(ErrCode<>0)then Double(Rec):=0;end;
Procedure TDoubleEdit.SetData(var Rec);var W:Byte;begin if(DP>0)then W:=MaxLen-DP-1 else W:=MaxLen;if(Min<>0)and(Max<>0)then
if((Double(Rec)<Min)or(Double(Rec)>Max))then Double(Rec):=0;Str(Double(Rec):W:DP,Data^);SelectAll(True);end;{$ENDIF}
Constructor TRealEdit.Init(var Bounds:TRect;EditMask:String;AMin:Real;AMax:Real);begin TFloatEdit.Init(Bounds,EditMask);
if(AMin<=AMax)then begin Min:=AMin;Max:=AMax;end else begin Min:=AMax;Max:=AMin;end;end;
Function TRealEdit.OutOfRange:Boolean;var Value:Real;begin OutOfRange:=False;if(Min<>0.0)or(Max<>0.0)then begin
TRealEdit.GetData(Value);if(ErrCode<>0)or(Value<Min)or(Value>Max)then OutOfRange:=True end;end;
Function TRealEdit.OutOfRangeMsg:String;var MinStr,MaxStr:String[20];W:Byte;begin if(DP>0)then W:=20-DP-1 else W:=20;
Str(Min:W:DP,MinStr);Str(Max:W:DP,MaxStr);OutOfRangeMsg:='Range is '+MinStr+' to '+MaxStr;end;
Function TRealEdit.DataSize:Word;begin DataSize:=SizeOf(Real);end;Procedure TRealEdit.GetData(var Rec);begin
if(Data^='')or(Data^='$')or(Data^='-')then Data^:='0';Val(Data^,Real(Rec),ErrCode);if(ErrCode<>0)then Real(Rec):=0;end;
Procedure TRealEdit.SetData(var Rec);var W:Byte;begin if(DP>0)then W:=MaxLen-DP-1 else W:=MaxLen;if(Min<>0)and(Max<>0)then
if((Real(Rec)<Min)or(Real(Rec)>Max))then Real(Rec):=0;Str(Real(Rec):W:DP,Data^);SelectAll(True);end;
Constructor TEntryDialog.Init(var Bounds:TRect;ATitle:TTitleStr);begin TDialog.Init(Bounds,ATitle);
EventMask:=EventMask or evBroadcast;end;{$IFDEF USE_TVSCROLL}Procedure TEntryDialog.Insert(P:PView);begin
TScrollDialog.InsertToScroll(P);end;{$ENDIF}Function TEntryDialog.FindField(ID:Word):Pointer;
Function CheckID(P:PView):Boolean;FAR;var Event:TEvent;begin Event.What:=evBroadcast;Event.Command:=cmIdentify;
Event.InfoWord:=ID;P^.HandleEvent(Event);CheckID:=(Event.What=evNothing);end;begin FindField:=FirstThat(@CheckID);end;
Procedure TEntryDialog.LockField(ID:Word;Enable:Boolean);var P:PView;begin P:=FindField(ID);if(P<>nil)then
P^.SetState(sfDisabled,Enable);end;Procedure TEntryDialog.HandleEvent(var Event:TEvent);begin TDialog.HandleEvent(Event);
if(Event.What=evBroadcast)then if(Event.Command=cmFieldError)then MessageBox(ErrorMsg,nil,mfError+mfOkButton);end;
Constructor TNewCheckBoxes.Init(var Bounds:TRect;AStrings:PSItem);begin TCheckBoxes.Init(Bounds,AStrings);PostEdit:=nil;
LLabel:=nil;ID:=0;EditFlags:=0;EventMask:=EventMask or evBroadcast;end;Function TNewCheckBoxes.Empty:Boolean;begin
Empty:=(Value=0);end;Procedure TNewCheckBoxes.SetEditFlag(AFlag:Word;Enable:Boolean);begin if Enable then
EditFlags:=EditFlags or AFlag else EditFlags:=EditFlags and not AFlag;end;Procedure TNewCheckBoxes.AddLabel(ALabel:PView);
begin LLabel:=ALabel;end;Procedure TNewCheckBoxes.Lock;begin SetState(sfDisabled,True);end;Procedure TNewCheckBoxes.UnLock;
begin SetState(sfDisabled,False);end;Procedure TNewCheckBoxes.SetID(AFieldID:Word);begin ID:=AFieldID;end;
Function TNewCheckBoxes.GetID:Word;begin GetID:=ID;end;Procedure TNewCheckBoxes.SetPostEdit(P:Pointer);begin PostEdit:=P;end;
Function TNewCheckBoxes.Valid(Command:Word):Boolean;var Name:String;begin Valid:=True;
if(Command<>cmCancel)and(Command<>cmValid)then begin if((EditFlags AND efRequired)<>0)and Empty then begin
ErrorMsg:=^M'Field is required.';Message(Owner,evBroadcast,cmFieldError,@ErrorMsg);Valid:=False;Select;end;end else begin
Valid:=TCheckBoxes.Valid(Command);end;end;{$IFDEF HAVE_RTL}Procedure TNewCheckBoxes.Select;begin if(Owner^.Current<>@Self)then
begin if(Message(Owner^.Current,evBroadcast,cmLoseFocus,nil)=nil)then TCheckBoxes.Select;end else TCheckBoxes.Select;end;
{$ENDIF}Procedure TNewCheckBoxes.SetState(AState:Word;Enable:Boolean);begin TCheckBoxes.SetState(AState,Enable);
if(AState=sfDisabled)then if(LLabel<>nil)then LLabel^.SetState(sfDisabled,Enable);end;
Procedure TNewCheckBoxes.HandleEvent(var Event:TEvent);begin TCheckBoxes.HandleEvent(Event);Case Event.What of evMouseDown:
begin if(State and sfSelected=0)then ClearEvent(Event);end;evBroadcast:begin Case Event.Command of cmLoseFocus:begin
if(PostEdit<>nil)then begin if PostEditFunc(PostEdit)(@Self,ID)then begin ClearEvent(Event);Event.InfoPtr:=@Self;end;end 
else if not Valid(cmOK)then begin ClearEvent(Event);Event.InfoPtr:=@Self;end;end;cmIdentify:if(Event.InfoWord=ID)then begin
ClearEvent(Event);Event.InfoPtr:=@Self;end;end;end;end;end;Constructor TNewRadioButtons.Init(var Bounds:TRect;
AStrings:PSItem);begin TRadioButtons.Init(Bounds,AStrings);PostEdit:=nil;LLabel:=nil;ID:=0;EditFlags:=0;
EventMask:=EventMask or evBroadcast;end;Function TNewRadioButtons.Empty:Boolean;begin Empty:=False;end;
Procedure TNewRadioButtons.SetEditFlag(AFlag:Word;Enable:Boolean);begin if Enable then EditFlags:=EditFlags or AFlag else
EditFlags:=EditFlags and not AFlag;end;Procedure TNewRadioButtons.AddLabel(ALabel:PView);begin LLabel:=ALabel;end;
Procedure TNewRadioButtons.Lock;begin SetState(sfDisabled,True);end;Procedure TNewRadioButtons.UnLock;begin
SetState(sfDisabled,False);end;Procedure TNewRadioButtons.SetID(AFieldID:Word);begin ID:=AFieldID;end;
Function TNewRadioButtons.GetID:Word;begin GetID:=ID;end;Procedure TNewRadioButtons.SetPostEdit(P:Pointer);begin PostEdit:=P;
end;Function TNewRadioButtons.Valid(Command:Word):Boolean;var Name:String;begin Valid:=True;
if(Command<>cmCancel)and(Command<>cmValid)then begin if((EditFlags AND efRequired)<>0)and Empty then begin
ErrorMsg:=^M'Field is required.';Message(Owner,evBroadcast,cmFieldError,@ErrorMsg);Valid:=False;Select;end;end else begin
Valid:=TRadioButtons.Valid(Command);end;end;{$IFDEF HAVE_RTL}Procedure TNewRadioButtons.Select;begin
if(Owner^.Current<>@Self)then begin if(Message(Owner^.Current,evBroadcast,cmLoseFocus,nil)=nil)then TRadioButtons.Select;end 
else TRadioButtons.Select;end;{$ENDIF}Procedure TNewRadioButtons.SetState(AState:Word;Enable:Boolean);begin
TRadioButtons.SetState(AState,Enable);if(AState=sfDisabled)then if(LLabel<>nil)then LLabel^.SetState(sfDisabled,Enable);end;
Procedure TNewRadioButtons.HandleEvent(var Event:TEvent);begin TRadioButtons.HandleEvent(Event);Case Event.What of
evMouseDown:begin if(State and sfSelected=0)then ClearEvent(Event);end;evBroadcast:begin Case Event.Command of cmLoseFocus:
begin if(PostEdit<>nil)then begin if PostEditFunc(PostEdit)(@Self,ID)then begin ClearEvent(Event);Event.InfoPtr:=@Self;end;
end else if not Valid(cmOK)then begin ClearEvent(Event);Event.InfoPtr:=@Self;end;end;cmIdentify:if(Event.InfoWord=ID)then
begin ClearEvent(Event);Event.InfoPtr:=@Self;end;end;end;end;end;END.
