{**************************************************************************
                          WordUp Graphics Toolkit
                                 Demo File

 This program will open graphics mode 320*200 with 256 colors and draw some
 lines on the screen using the WGT line command and the BGI LINE.

 Notice the difference in speeds, particularly with the horizontal lines.
 **************************************************************************}

USES Graph,WGT;

VAR
   grDriver, grMode : INTEGER;
   x, y, ctr : INTEGER;
   p : PALETTE;     { This is a type specific to WGT }

BEGIN
     { Initialize graphics (see demo file #1) }
     grDriver := INSTALLUSERDRIVER('VGA256',NIL);
     grMode := 0;
     INITGRAPH(grDriver,grMode,'c:\tp\bgi');

     { First load the demo palette file }
     Load_Palette('demo.pal',p);

     { Use WGT's SETCOLOR to change the current drawing color,
       it also controls Borland's graphics functions}


     FOR ctr := 1 to 10 DO BEGIN     {Repeat 10 times}
         _SETCOLOR(RANDOM(256));     {Using different colors}

         FOR x := 0 TO 319 DO BEGIN
         _Line(x,0,x,199);       { Use WGT to draw 320 vertical lines }
         END;

     END;


     FOR ctr := 1 to 10 DO BEGIN
         _SETCOLOR(RANDOM(256));
         FOR X := 0 TO 319 DO BEGIN
         LINE(x,0,x,199);        { Use BGI to draw 320 vertical lines }
         END;
     END;

     SETCOLOR(30);
     OUTTEXT('Press Return');
     READLN;                     { Wait for user to hit return }

     _ClearDevice(0);            { Clear the screen using color #0 }

     FOR ctr := 1 to 10 DO BEGIN
         _SETCOLOR(RANDOM(256));
         FOR y := 0 TO 199 DO BEGIN
         _Line(0,y,319,y);       { Use WGT to draw 200 horizontal lines }
         END;
     END;


     FOR ctr := 1 to 10 DO BEGIN          {Repeat 10 times}
         _SETCOLOR(RANDOM(256));          {Using different colors}

         FOR y := 0 TO 199 DO BEGIN
         LINE(0,y,319,y);        { Use BGI to draw 200 horizontal lines }
         END;

     END;


     _SETCOLOR(30);
     OUTTEXT('Press Return');
     READLN;

     { Now close the graphics system }

     CLOSEGRAPH;
END.