{**************************************************************************
                          WordUp Graphics Toolkit
                                 Demo File
                             Benchmark Testing

 This file allows you to time the various routines in the WGT as compared
 to the BGI. Simply replace the two indicated lines in the main part of the
 program with commands such as:
         CIRCLE         ,       _CIRCLE
         RECTANGLE      ,       _RECTANGLE
         BOX            ,       _BOX
         LINE           ,       _LINE
         PUTPIXEL       ,       _PUTPIXEL
         GETPIXEL       ,       _GETPIXEL
 **************************************************************************}

USES DOS, Graph, WGT;

VAR
   grDriver, grMode : INTEGER;
   ctr : INTEGER;
   p : PALETTE;     { This is a type specific to WGT }
   h, h1, m, m1, s, s1, s100, s1001 : word; {Timing variables}
   h2,h3,m2, m3,s2, s3, s1002,s1003 : word;


FUNCTION SortTime (sthr, finhr, stmin, finmin,
                 stsec, finsec, sts100, fins100 : word) : integer;

{  This function returns the difference of two times in  }
{   hundredths of a second. (Must be less than 32767)    }

VAR
    time : integer;

BEGIN

    { Check whether time goes over midnight }

    IF (sthr = 23) and (finhr = 0) THEN
      finhr := 24;

    { Compute time in stages to prevent overflow }

    SortTime :=(((finhr - sthr) * 60 + (finmin - stmin)) * 60
                   + (finsec - stsec)) * 100 + (fins100 - sts100)
END;


BEGIN
     { Initialize graphics (see demo file #1) }
     grDriver := INSTALLUSERDRIVER('VGA256',NIL);
     grMode := 0;
     INITGRAPH(grDriver,grMode,'c:\tp\bgi');

     { First load the demo palette file }
     Load_Palette('demo.pal',p);

     _SETCOLOR(50);
     GetTime (h, m, s, s100);   { Get start time of WGT routine }
             { Place your benchmark routine on the next line (WGT version) }
             for ctr:=0 to 199 do _line(0,ctr,319,ctr);

     GetTime (h1, m1, s1, s1001); { Get finish time }


     _SETCOLOR(100);
     GetTime (h2, m2, s2, s1002);
             { Place the benchmark routine here with the BGI version }
             for ctr:=0 to 199 do line(0,ctr,319,ctr);

     GetTime (h3, m3, s3, s1003);


     { Now close the graphics system }

     CLOSEGRAPH;

     {Display times}

     writeln ('Time to do the routine (in hundredths of a second) WGT:',
               SortTime (h, h1, m, m1, s, s1, s100, s1001) : 6);

     writeln ('Time to do the routine (in hundredths of a second) BGI:',
               SortTime (h2, h3, m2, m3, s2, s3, s1002, s1003) : 6);
END.