{**************************************************************************
                          WordUp Graphics Toolkit
                                 Demo File

 This program shows how the REGIONFILL command works. The screen is filled
 with random pixels, and the user selects a fill point with the mouse.
 **************************************************************************}

{First we must tell the compiler to use whatever memory it can}

{$M 65520,0,655360}

USES Graph,WGT;

VAR
   grDriver, grMode : integer;
   x, y, button : integer;

BEGIN
     grDriver := INSTALLUSERDRIVER('VGA256',NIL);
     grMode := 0;
     INITGRAPH(grDriver,grMode,'c:\tp\bgi');

     {Place 20,000 random pixels on the screen}
     for x:=1 to 20000 do _putpixel(random(320),random(200),40);

     mouse_on;

     {Now wait until the user hits the left mouse button, then fill the
      screen starting from that point. Press the right mouse button to
      end the program.}

     repeat
           mouse(x,y,button);
           if button=1 then begin
              mouse_off;
              _setcolor(30);
              regionfill(x,y);
              mouse_on;
           end;
     until button=2;

     {Note: After the program runs, hit CTRL-F4 and enter MEMORY_USAGE.
            This will tell you how much memory the fill required for that
            particular run. Try changing the number of pixels, or drawing
            some circles, etc. instead. }

     CLOSEGRAPH;
END.