{**************************************************************************
                          WordUp Graphics Toolkit
                                Demo File
                     Loading blocks and Simple Text Output


 This file demonstrates LOAD, RESIZE and FREE _block commands. The user
 positions the mouse on the screen and hits the left button. A loaded image
 is then resized to fit within the defined area of the screen. The right
 hand button ends the program.
 **************************************************************************}

USES Graph,WGT,CRT;

VAR
   x, y, button, oldx, oldy, grDriver, grMode : INTEGER;
   installed : BOOLEAN;
   ch : CHAR;
   image : POINTER;             { Pointer to our loaded graphics block }
   p : PALETTE;                 { This is a type specific to WGT }

BEGIN
     CLRSCR;
     WRITELN('Press right mouse button to end the program.');
     DELAY(6000);

     { Initialize graphics (see demo file #1) }
     grDriver := INSTALLUSERDRIVER('VGA256',NIL);
     grMode := 0;
     INITGRAPH(grDriver,grMode,'c:\tp\bgi');

     _ClearDevice(0);

     Load_Palette('c:\tp\wgt\face.pal',p);   { Load palette and set it }
     Set_Palette_Block(0,255,p);

     image:=NIL;                             { Pointer must be initialized }
     Load_Block('c:\tp\wgt\face.blk',image); { Load from file into memory  }

     {*******************************************************************}
     { After running the program once, remove the REMARK brackets from   }
     { the next line and notice how the image is flipped.                }
     {Flip_Block( image, vertical );                                     }


     mouse_init(installed, button);          { Initialize mouse }
     mouse_on;                               { Display cursor   }
     oldx:=-1;            { Set previous coordinates so display is updated }
     oldy:=-1;

     REPEAT
           mouse(x,y,button);     { Read in x,y and button status }

           IF ( x <> oldx ) OR ( y <> oldy ) THEN BEGIN     { If moved }

              mouse_off;                { Disable cursor while updating }

              _setcolor(0);             { Erase old lines with black }
              _line(oldx,0,oldx,oldy);
              _line(0,oldy,oldx,oldy);

              _setcolor(30);            { Draw new lines with white }
              _line(x,0,x,y);
              _line(0,y,x,y);

              oldx:=x;                  { Set new coordinates }
              oldy:=y;
              mouse_on;                 { Display cursor again }
           END;

           { Now check to see if the left button is pressed }

           IF ( button=1 ) AND ( x > 0 ) AND ( y > 0 ) THEN BEGIN

              mouse_off;                 { Disable cursor }

              resize_block(0,0,x-1,y-1,image);   { Draw face within area }

              _textcolor(50);                    { Set text color }
              texttransparent(mask);           { Do not display background }
              _outtextxy(100,190,'Press any key.');

              REPEAT UNTIL KEYPRESSED;        { Input a key }
              ch:=READKEY;

              _cleardevice(0);            { Clear screen and re-initialize }
              oldx:=-1;
              oldy:=-1;
              mouse_on;
           END;

     UNTIL button=2;       { Right hand button ends the program }

     Free_Block( image );  { Deallocate the memory used by the block }

     { Now close the graphics system }

     CLOSEGRAPH;
END.