{**************************************************************************
                          WordUp Graphics Toolkit
                                Demo File

 This program initializes a second screen in memory and loads a PCX image
 onto that screen. When the mouse is moved, a 20*20 section of the second
 screen is copied onto the first. The left button causes the entire second
 screen to be dissolved onto the visual screen.
 **************************************************************************}

USES Graph,WGT,CRT;
CONST cursor : mousemap = (0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                           $07C0,$0440,$07C0,$0100,$0100,$0100,$0100,$FFFF,
                           $0100,$0100,$0100,$0280,$0440,$0820,$1010,$2008);
                           {This bitmap is of a stick figure. No Mask.}

VAR
   x, y, button, oldx, oldy, grDriver, grMode : INTEGER;
   second : SCREENPTR;
   installed : BOOLEAN;
   p : PALETTE;                 { This is a type specific to WGT }

BEGIN
     CLRSCR;
     WRITELN('Press right mouse button to end the program.');
     DELAY(6000);

     { Initialize graphics (see demo file #1) }
     grDriver := INSTALLUSERDRIVER('VGA256',NIL);
     grMode := 0;
     INITGRAPH(grDriver,grMode,'c:\tp\bgi');

     _ClearDevice(0);

     Load_Palette('c:\tp\wgt\mickey.pal',p);   { Load palette and set it }
     Set_Palette_Block(0,255,p);

     second:=NIL;                     { Initialize variable }
     Init_Screen(second);             { Reserve memory for screen 2 }
     currentscreen:=second;           { Set  operations to screen 2 }
     LoadPCX('c:\tp\wgt\mickey.pcx'); { Load PCX onto current page  }
     currentscreen:=basescreen;       { Set  operations to visual page }


     mouse_init(installed, button);          { Initialize mouse }
     mouse_cursor(8,8,cursor);               { New cursor shape }
     mouse_on;                               { Display cursor   }
     oldx:=-1;            { Set previous coordinates so display is updated }
     oldy:=-1;

     REPEAT
           mouse(x,y,button);     { Read in x,y and button status }

           IF ( x <> oldx ) OR ( y <> oldy ) THEN BEGIN     { If moved }

              mouse_off;                { Disable cursor while updating }

              Copy_Screen(x,y,x+19,y+19,second,x,y,basescreen);
              { Copies a 20*20 section of page 2 to visual screen }

              oldx:=x;                  { Set new coordinates }
              oldy:=y;
              mouse_on;                 { Display cursor again }
           END;

           { Now check to see if the left button is pressed }

           IF ( button=1 ) THEN BEGIN

              mouse_off;                { Disable cursor }

              Patches(7,second,0);      { Dissolve page 2 with highest res }
                                        { 0 is delay between each copy     }

              DELAY(1000);              { Wait for a bit and clear screen  }
              _cleardevice(0);

              mouse_on;
           END;

     UNTIL button=2;       { Right hand button ends the program }

     Remove_Screen(second);

     { Now close the graphics system }

     CLOSEGRAPH;
END.