IMPLEMENTATION MODULE Screen;

FROM SYSTEM IMPORT ADDRESS, ASSEMBLER, ADR, SEG, OFS;
FROM System IMPORT Move;

PROCEDURE SaveScreen(VAR s:ScreenData);
    VAR sadd,vptr:ADDRESS;
    BEGIN
        vptr:=ADR(s);
        sadd.SEG:=47104;
        sadd.OFS:=0;
        Move(sadd,vptr,6600);
    END SaveScreen;

PROCEDURE RestoreScreen(VAR s:ScreenData);
    VAR sadd,vptr:ADDRESS;
    BEGIN
        vptr:=ADR(s);
        sadd.SEG:=47104;
        sadd.OFS:=0;
        Move(vptr,sadd,6600);
    END RestoreScreen;

PROCEDURE GetPosition(VAR v,h:CARDINAL);
    BEGIN
        ASM
            XOR BH,BH
            MOV AH,3
            LES DI,v
            MOV ES:[DI],DH
            LES DI,h
            MOV ES:[DI],DL
        END;
    END GetPosition;

PROCEDURE GetChar(VAR ch:CHAR; VAR fc,bc:CARDINAL);
    VAR atrib:CARDINAL;
    BEGIN
        atrib:=0;
        ASM
            MOV AH,8
            XOR BH,BH
            INT 10H
            LES DI,ch
            MOV ES:[DI],AL
            MOV atrib,AH
        END;
        bc:=atrib DIV 16;
        fc:=atrib MOD 16;
    END GetChar;

PROCEDURE PrintScreen();
    BEGIN
        ASM
            INT 5
        END;
     END PrintScreen;

PROCEDURE CursorOff();
    BEGIN
        ASM
            MOV CH,32
            MOV AH,1
            INT 10H
        END;
    END CursorOff;

END Screen.