'                       QNRFEE (for $TOKTRAX, release 4)
'        ͻ
'                   Quick & Reilly Commission Calculator           
'        Ķ
'         Quick and Reilly, Inc. can in no way be held responsible 
'                for the content or accuracy of this program.      
'        ͼ
'---------------------------------------------------------------------------
' The following sample program estimates Quick & Reilly commissions for
' common stock purchases based on their 1991 schedule of charges.
' Any modifications will require the QuickBASIC or BASIC PDS compiler.
'---------------------------------------------------------------------------
' QNRFEE can be used standalone, although it was designed for use by
' the $TOKTRAX (v4) Stock Tracking System to estimate transaction fees.
' The result of the calculation is saved to a file called CALC.FEE if
' the /FILE parameter is used, otherwise results are sent to the screen.
' $TOKTRAX issues the /FILE command and reads CALC.FEE for its estimates.
'---------------------------------------------------------------------------
'Syntax:
' QNRFEE shares price [symbol] [/FILE]
'Description:
' shares = number of shares transacted
' price  = price per share
'    The command line MUST specify both of these, in order. For example,
'    the line   QNRFEE 200 15.25  instructs the program to calculate
'    the commission on 200 shares of stock transacted at $15.25 per share.
' symbol = optional symbol to display with output.
' /FILE sends output to file CALC.FEE instead of screen.
'---------------------------------------------------------------------------
errcode% = 0                                    'set error code to 0

type$ = "Estimated Quick and Reilly Stock Commission = $###,###.##"

text$ = COMMAND$                                'copy command line to text$

file% = INSTR(text$, "/FILE")                   'test if output to file
IF file% > 0 THEN
    MID$(text$, file%, 5) = "     "             'remove /FILE from command line
    END IF

text$ = LTRIM$(RTRIM$(text$))                   'remove leading and trailing
                                                'spaces from the command line
                                                'and assign to text$ variable

space% = INSTR(text$, " ")                      'locate position of the space
IF space% = 0 THEN errcode% = 1: GOTO errexit   'branch to ERREXIT if no space
                                                '  (less than 2 parameters)

shares = ABS(VAL(LEFT$(text$, space%)))         'get number of shares
                                                'doesn't allow 0 or negative #

text$ = LTRIM$(RIGHT$(text$, LEN(text$) - space%))
                                                'remove shares from command line

space% = INSTR(text$, " ")                      'locate position of the space to
                                                '  determine if a symbol was passed
IF space% THEN
    price = ABS(VAL(LEFT$(text$, space%)))      'get price
    sym$ = RIGHT$(text$, LEN(text$) - space%)
    ELSE
    price = ABS(VAL(RIGHT$(text$, LEN(text$) - space%)))
    sym$ = "shares"
    END IF                                      'doesn't allow 0 or negative #

amount = shares * price                         'total cost of stock

SELECT CASE amount                              'calculate the fee
    CASE 0 TO 2500:
            fee = 22 + amount * .014
    CASE 2500 TO 6000:
            fee = 38 + amount * .0045
    CASE 6000 TO 22000:
            fee = 59 + amount * .0025
    CASE 22000 TO 50000:
            fee = 77 + amount * .0017
    CASE 50000 TO 500000:
            fee = 120 + amount * .00085
    CASE ELSE:
            fee = 205 + amount * .00068
    END SELECT
minimum = 37.5                                 'overriding minimum charge
IF fee < minimum THEN fee = minimum

mincharge = shares * .06                        'get total minimum charge
IF shares > 1000 THEN
    mincharge = mincharge + .03 * (shares - 1000)
    END IF
IF fee < mincharge THEN fee = mincharge

maxcharge = 49                                  'calc total maximum charge
IF shares > 100 THEN maxcharge = maxcharge + .5 * (shares - 100)
IF fee > maxcharge THEN fee = maxcharge

IF price < 1 THEN fee = 37 + amount * .03       'fee for "penny stocks"

'---------------------------------------------------------------------------
finis:
IF file% THEN                                       'If /FILE specified
    f% = FREEFILE                                   '  save result to file
    OPEN "CALC.FEE" FOR OUTPUT AS #f%               '  for $tokTraX to read
    PRINT #f%, fee
    CLOSE #f%
  ELSE
    PRINT
    PRINT "                       QNRFEE (for $TOKTRAX, release 4)"
    PRINT "        ͻ"
    PRINT "                   Quick & Reilly Commission Calculator           "
    PRINT "        Ķ"
    PRINT "         Quick and Reilly, Inc. can in no way be held responsible "
    PRINT "                for the content or accuracy of this program.      "
    PRINT "        ͼ"
    COLOR 15
    PRINT TAB(4); USING type$; fee; : PRINT "  (for"; shares; sym$; ")"
                                                    'else print to screen
  END IF

'---------------------------------------------------------------------------
errexit:
IF errcode% AND NOT file% THEN
    CLS : SOUND 500, 2: SOUND 100, 2
    LOCATE 5, 1
    PRINT "        ͻ"
    PRINT "                      QNRFEE (for $TOKTRAX, release 4)            "
    PRINT "        Ķ"
    PRINT "          QNRFEE estimates Quick & Reilly broker commissions for  "
    PRINT "          common stocks, based on their 1991 fee schedule. Quick  "
    PRINT "          and Reilly, Inc. can in no way be held responsible for  "
    PRINT "          the content or accuracy of this program.                "
    PRINT "        Ķ"
    PRINT "          Syntax: QNRFEE SHARES PRICE [SYMBOL] [/FILE]            "
    PRINT "            where SHARES is the number of shares transacted       "
    PRINT "                  PRICE is the stock price per share              "
    PRINT "                  SYMBOL optionally displays stock symbol         "
    PRINT "                  /FILE optionally prevents output to screen,     "
    PRINT "                    instead saving output to file CALC.FEE.       "
    PRINT "        ͼ"
    END IF

END



