
; Public Domain - credits to Matthew Staben, Staben Technologies
;                                            811 West 14th Avenue
;                                            Spokane, WA  99204
;                                            March 10, 1993
;
;                 YOU MAY DO ANYTHING YOU WANT WITH THIS CODE.

.Model Small
.Code

ismtask         DB      0                       ; zero if none
timeslice       DB      0                       ; timeslicing release
old_1ch_vector  dd      0
timer		DW	0

new_1ch_vector  proc    far
		

                sti                             ; renable 8088 irq, the
                                                ; 8088 (80x86) will disable
                                                ; when called.  The 8259
                                                ; will not allow anything
                                                ; to interrupt until
                                                ; this routine is done
                push ax
                push bx
                push cx
                push dx
                push si
                push di
                push bp
                push ds
                push es

                ;note call to old vecter is an intersegment far call
		
                pushf                           ; push flags to simulate int
                call cs:old_1ch_vector          ; chain old routine
		
	            mov al,20h                      ; send eoi to 8259
                mov dx,20h
                out dx,al

                ; check for multitasking
                cmp     [cs:ismtask], 00h
                je      no_release
                ;
                ; hmm, now release a timeslice if the count is hi enuf!!
                ;
                inc     [cs:timeslice]
                cmp     [cs:timeslice], 003h    ; 3 = 3/18.2 (1/6)
                jb      no_release              ; adjust as necessary
       release:
                cmp     [cs:ismtask], 02h
                je      release_desqview
                mov     ax, 01680h        ; OS/2/ Windows timslice release call
                int     02Fh
                mov     [cs:timeslice], 00h
                jmp     no_release
       release_desqview:
                mov     ax, 0101Ah           ; Switch to DV's stack.
                int     015h
                mov     ax, 01000h           ; Give up time-slice.
                int     015h
                mov     ax, 01025h           ; Restore local stack.
                int     015h
       no_release:
				
bye_bye:
                

                pop es
                pop ds
                pop bp
                pop di
                pop si
                pop dx
                pop cx
                pop bx
                pop ax
                iret
                endp



;----------------------------------------------------------------------------
_1ch_install    proc

                cli                             ; disable interrupts
                                                ; while diddling vectors

                ; get old vector and save it
                mov ah, 35h                     ; get vector
                mov al, 1ch                     ; of int 1ch
                int 21h
                mov  word ptr old_1ch_vector, bx
                mov  word ptr old_1ch_vector + 2, es

                push ds                         ; save ds, int 25h uses it

                ; get address of new vector and install it
                mov dx, cs
                mov ds, dx
                mov dx,  offset new_1ch_vector
                mov ah, 25h                     ; set vector
                mov al, 1ch                     ; of 1ch
                int 21h

                pop ds
                sti                             ; reenable interrupts
                ret
                endp

;----------------------------------------------------------------------------
main            proc
                call _1ch_install
                mov	[timer], 0h

                ;
                ; first, we check for various multitasking systems
                ; DESQVIEW
                ; OS/2
                ; WINDOWS
                ;
                 
                mov     [cs:ismtask], 00h       ; set to none
                
                ; check for DESQVIEW
                
                mov     cx, 'DE'
                mov     dx, 'SQ'
                mov     ax, 02B01h       ; DOS set date function.
                int     021h
                cmp     al, 0FFh         ; Did DOS report the invalid date?
                jnz     @@desqview       ; If not, we've got Desqview.

                ; check for OS/2
                
                mov     ah, 030h         ; DOS get version fn.
                int     021h

                cmp     al, 014h         ; 20 decimal.
                jb      @@no_OS2
                mov     [cs:ismtask], 01h

            @@no_OS2:
            
                ; check for Windows
                
                mov     ax, 01600h
                int     02Fh
                cmp     al, 00h
                jz      begin_init
                cmp     al, 080h
                jz      begin_init
                cmp     al, 01h           ; Windows/386 2.x; not supported.
                jz      begin_init
                cmp     al, 0FFh          ; Windows/386 2.x; not supported.
                cmp     al, 03h           ; At least Win 3.0?
                jb      begin_init
                mov     [cs:ismtask], 01h
                jmp     begin_init
        @@desqview:
                mov     [cs:ismtask], 02h
        begin_init:                
                ; terminate and stay resident
                mov dx, ((offset pgm_length + 15) / 16) + 20
                mov ah, 31h
                mov al, 00h
                int 21h
                endp

pgm_length      equ $ - main                    ; remove un-needed code

                end  main                       ; specify start location


