; 28lines.asm : Set 28 lines video modus for VGA displays
; Works with Turbo Pascal 6.0/7.0 + Borland Pascal 7.0 DOS IDEs!
; Olaf Hess, Hof Kappelberg 1, D - 3509 Altmorschen, Germany
; CompuServe 100031,3536

.8086

dos_int macro func ; Int 21h call
        mov ax, func
        int 21h
    endm

video_int macro func ; Int 10h call
        mov ax, func
        int 10h
    endm

code segment
        assume cs: code, ds: code, es: nothing, ss: nothing
        org 100h ; COM program

    start:
        jmp begin

oldint10 dd ?   ; Old Int 10h routine
action   db ?   ; Flag for calling set_28lines

int10handler proc far ; Int 10h handler

        jmp short int10

int10id db "28"     ; Program id string

    int10:
        sti         ; Enable interrupts
        push ds     ; Save ds
        push cs     ; ds = cs
        pop ds

        cmp cs:action, 1 ; Called by itself?
        je CallOld       ; Yes => call old interrupt

        cmp ax, 0003h    ; Set video modus 03h?
        je SetLines      ; Yes: Set 28 lines
        cmp ax, 0083h    ; Set video modus 83h?
        je SetLines      ; Yes: Set 28 lines

    CallOld:
        pushf
        call cs:[oldint10] ; Call original Int 10h handler
        jmp exit           ; Jump to end

    SetLines:
        push ax
        push bx
        push cx
        push dx
        mov cs:action, 1

        ; Insert you own routine to set a video modus here
        video_int 0003h ; Necessary to change the video modus!
        xor bl, bl      ; Table 1
        video_int 1111h ; Set BIOS 8x14 mono font

        mov cs:action, 0
        pop dx
        pop cx
        pop bx
        pop ax

    exit:
        pop ds  ; Pop registers from stack
        ret 2   ; Jump back, release stack
int10handler endp

; The following code can be overwritten after initializing the program
transient   equ this byte

okmessage   db "28Lines V4.0: Program resident installed.", 10, 13
            db "Uninstall by calling it again.", 10, 13, "$"
uninstmsg   db "28Lines V4.0: Program removed from memory.", 10, 13, "$"

    begin:  ; Of we go
        ; Get interrupt vectors
        dos_int 3510h
        cmp word ptr es:[bx+2], "82" ; Already installed
        jnz install     ; No ->> install

        ; Set Int 10h to old routine
        cli
        mov dx, word ptr es:oldint10
        mov ax, word ptr es:oldint10 + 2
        mov ds, ax
        dos_int 2510h
        sti

        dos_int 4900h ; Release occupied memory
        mov es, word ptr es:[2Ch] ; Release PSP
        dos_int 4900h

        push cs ; ds = cs
        pop ds
        video_int 0003h ; Set 28 line video modus

        mov dx, offset uninstmsg
        dos_int 0900h ; Display message

        dos_int 4C00h   ; End program

    install:
        mov cs:action, 0 ; Initialize flag

        ; Set Int 10h to new routine
        cli
        mov word ptr oldint10, bx
        mov word ptr oldint10 + 2, es
        mov dx, offset int10handler
        dos_int 2510h
        sti

        video_int 0003h ; Activate 28 lines
        mov dx, offset okmessage ; Display message
        dos_int 0900h

        ; End program resident
        mov dx, offset transient
        mov cl, 4
        shr dx, cl
        inc dx
        dos_int 3100h
code    ends
end     start
; End of 28LINES.ASM
