{ This program sets the screen resolution in text mode to non-standard
  modes like 80x30, 94x34, etc.
  Call it without parameters for a complete listing of the possible values. }

{ This program was originally published in the September 1991 issue of the
  German computer magazine c't on pages 222 - 226. }

{ Attention:
  EMode uses the VGA-monitor about 10% beyond it's original specifications.
  Use it with care! If the monitor makes a funny sound after invoking one
  of EMode's enhanced modes turn the monitor off immediately!
  Usage is on your own risk! }

{ This program is copyright (c) 1991 by

  Olaf Kummer

  and

  Verlag Heinz Heise GmbH & Co KG
  Helstorfer Strasse 7
  P.O. Box 61 04 07
  3000 Hannover 61
  Germany

  Tel.: (49) (0) 511 535 20
  Fax.: (49) (0) 511 535 212 9 }

{ It is hereby declared that whoever who uses this program does so on his
  or her own risk. The copyright holder is not liable for any damages
  resulting of the use of this program. }

{ The commercial usage of this program is only admissible with written
  permission by the copyright holder. }

{ In German:
  Eine Haftung fr die Richigkeit der Verffentlichung kann trotz
  sorgfltiger Prfung durch die Redaktion vom Herausgeber nicht bernommen
  werden.
  Die gewerbliche Nutzung des Programmes ist nur mit schriftlicher
  Genehmigung des Herausgebers zulssig. }

{$A-,B-,D-,E-,F-,I-,L+,N-,O-,R-,S-,V+}
{$M 1024,0,0}
PROGRAM EMode;
USES DOS;

FUNCTION HasVGA: Boolean;
VAR Reg : DOS.Registers;
BEGIN
    Reg.AX := $1A00; { Get info byte }
    Intr ($10, Reg); { VGA with VGA-monitor? }
    HasVGA := (Reg.AL = $1A) AND
                    ((Reg.BL = 7) OR (Reg.BL = 8));
END; { HasVGA }

PROCEDURE VGA_Off;
BEGIN
    INLINE ($FA);       { CLI - Disable interrupts }
    Port [$3C4] := 0;   { Turn off sequenzer }
    Port [$3C5] := 1;
    Port [$3D4] := 23;  { Set CRT-reset }
    Port [$3D5] := Port [$3D5] AND 127;
    Port [$3D4] := 17;  { Release CRT-registers 0-7 }
    Port [$3D5] := Port [$3D5] AND 127;
END; { VGA_Off }

PROCEDURE VGA_On;
BEGIN
    Port [$3D4] := 17;  { Lock CRTC-registers 0-7 }
    Port [$3D5] := Port [$3D5] OR 128;
    Port [$3D4] := 23;  { Release CRTC-reset }
    Port [$3D5] := Port [$3D5] OR 128;
    Port [$3C4] := 0;   { Turn on sequenzer }
    Port [$3C5] := 3;
    INLINE ($FB);       { STI - Enable interrupts }
END; { VGA_On }

PROCEDURE VGA_94_Columns;
VAR Dummy : Byte;
BEGIN
    Port [$3C2] := (Port [$3CC] AND $F3) OR 4;  { Choose 720 PEL }
    Port [$3C4] := 1;   { Turn 8-dot-mode on }
    Port [$3C5] := Port [$3C5] OR 1;
    Port [$3D4] := 0;   { Horizontal total - 5 }
    Port [$3D5] := 108;
    Port [$3D4] := 1;   { Hor. display enable end - 1 }
    Port [$3D5] := 93;
    Port [$3D4] := 2;   { Start horizontal blanking }
    Port [$3D5] := 94;
    Port [$3D4] := 3;   { End horizontal blanking }
    Port [$3D5] := 128 + 15;
    Port [$3D4] := 4;   { Start horizontal retrace }
    Port [$3D5] := 98;
    Port [$3D4] := 5;   { End horizontal retrace }
    Port [$3D5] := 128 + 14;
    Port [$3D4] := 19;  { Logical line width }
    Port [$3D5] := 94 DIV 2;
    Dummy := Port [$3DA];   { Horizontal PEL panning }
    Port [$3C0] := 19;
    Port [$3C0] := 0;
    Port [$3C0] := 32;  { Re-activate attribute controller }
    Port [$3C0] := 32;
END; { VGA_94_Columns }

PROCEDURE Set_480_Lines;
BEGIN
    Port [$3C2] := Port [$3CC] OR 192;  { Set sync-polarity }
    Port [$3D4] := 6;   { Vertical total }
    Port [$3D5] := 11;
    Port [$3D4] := 7;   { CRT overflow }
    Port [$3D5] := 62;
    Port [$3D4] := 9;   { Maximum scan line }
    Port [$3D5] := 79;
    Port [$3D4] := 16;  { Start vertical retrace }
    Port [$3D5] := 234;
    Port [$3D4] := 17;  { End vertical retrace }
    Port [$3D5] := 140;
    Port [$3D4] := 18;  { Vert. display enable end }
    Port [$3D5] := 223;
    Port [$3D4] := 21;  { Start vertical blanking }
    Port [$3D5] := 231;
    Port [$3D4] := 22;  { End vertical blanking }
    Port [$3D5] := 4;
END; { Set_480_Lines }

PROCEDURE CharHeight (Size: Byte);
BEGIN
    Mem [0:$485] := Size;   { Inform BIOS }
    Port [$3D4] := 9;       { Maximum scan line }
    Port [$3D5] := (Port [$3D5] AND $E0) + Size - 1;
    Port [$3D4] := 10;      { Cursor start }
    IF Size <= 12 THEN Port [$3D5] := Size - 2
                  ELSE Port [$3D5] := Size - 3;
    Port [$3D4] := 11;      { Cursor end }
    IF Size <= 12 THEN Port [$3D5] := Size - 1
                  ELSE Port [$3D5] := Size - 2;
END; { CharHeight }

PROCEDURE SetVGAModus (Zeilen, Spalten: LongInt);
VAR Reg : DOS.Registers;
BEGIN
    { Choose 350 or 400 lines, if 480 lines then start with 400 }
    WITH Reg DO
    BEGIN
        AH := $12;
        BL := $30;
        IF Zeilen = 43 THEN AL := 1 ELSE AL := 2;
    END; { with }
    Intr ($10, Reg);
    { Choose 40 or 80 columns, if 94 columns the start with 80 }
    WITH Reg DO
    BEGIN
        AH := 0;
        IF Spalten = 40 THEN AL := 1 ELSE AL := 3;
    END; { with }
    Intr ($10, Reg);
    { Copy suitable character-table to video-RAM }
    WITH Reg DO
    BEGIN
        AH := $11;
        BL := 0;
        CASE Zeilen OF
            25, 30 : AL := 4;
            34     : AL := 1;
            ELSE AL := 2;
        END; { case }
    END; { with }
    Intr ($10, Reg);
    VGA_Off; { Set the VGA registers, turn display off }
    IF Spalten = 94 THEN VGA_94_Columns; { Set 94 columns }
    IF Zeilen IN [30, 34, 60] THEN
        Set_480_Lines;  { Set 480 lines }
    CASE Zeilen OF  { Inform adapter about character height }
        25, 30 : CharHeight (16);
        34     : CharHeight (14);
        ELSE CharHeight (8);
    END; { case }
    VGA_On; { Turn display on again }
    { Inform BIOS about the screen size }
    Mem [0:$44A] := Spalten;
    Mem [0:$484] := Zeilen - 1;
END; { SetVGAModus }

PROCEDURE GetParameter (VAR Zeilen, Spalten: LongInt);
VAR Error : Integer;
BEGIN
    { Get command line parameters }
    Val (ParamStr (1), Spalten, Error);
    IF ((Spalten <> 40) AND (Spalten <> 80) AND (Spalten <> 94)) OR
       (Error <> 0) THEN
    BEGIN
        Writeln (ParamStr (1), ' columns not supported.');
        Halt (0);
    END; { if }
    Val (ParamStr (2), Zeilen, Error);
    IF ((Zeilen <> 25) AND (Zeilen <> 30) AND (Zeilen <> 34) AND
        (Zeilen <> 43) AND (Zeilen <> 50) AND (Zeilen <> 60)) OR
       (Error <> 0) THEN
    BEGIN
        Writeln (ParamStr (2), ' rows not supported.');
        Halt (0);
    END; { if }
END; { GetParameter }

PROCEDURE HelpText;
BEGIN
    Writeln ('EMODE V0.3 - Enhanced text modes for VGA adaptors ',
             '(c)1991 Olaf Kummer + c''t'#13#10);
    Writeln ('Syntax: EMODE [Columns] [Rows]'#13#10);
    Writeln ('The following values are valid values for columns and ',
             'rows:');
    Writeln ('[Columns]: 40  80  94');
    Writeln ('[Rows]   : 25  30  34  43  50  60'#13#10);
    Writeln ('This program must only be run on systems ',
             'with a VGA compatible adaptor.');
    IF NOT HasVGA THEN
        Writeln ('No VGA graphics adaptor installed.');
END; { HelpText }

VAR Zeilen, Spalten: LongInt;

BEGIN { EMode }
    IF (ParamCount = 2) AND HasVGA THEN
    BEGIN
        GetParameter (Zeilen, Spalten);
        SetVGAModus (Zeilen, Spalten);
    END
    ELSE HelpText;
END. { EMode }

