program CustChip;
{ A shell to provide custom chipset support. This code will make the
  chipset's shadow ram writable before running ROMFNT }

{ Use this program if your chipset is not directly supported by ROMFNT, but
  you know the registers and bits to set to control the read only status
  bits in the chipset configuration registers. This information is usually
  found in the technical specifications for the chipset}

{ by Heinz-Dieter Sander 100031,1457 and Tim Godfrey 72617,2125 }

{$M 16384,0,65536} {leave some memory for ROMFNT to run in}
uses crt, dos;

{Customize these values for your specific chipset - These are for UMC 481}
const idxport :word = $22; {index port - write register value pointer here}
      umcdata :word = $24; {data port - read/write data after writing index}

procedure setbit (index, mask, val: byte);
var x:byte;

begin
  port [idxport] := index;
  x := (port [umcdata] and not mask) or val;

  port [idxport] := index;
  port [umcdata] := x;
end;

var exec_params :string;
    pcnt :integer;

begin
  if paramcount > 0 then
   begin
    exec_params := ' -Z '; (* -Z is special option for use w/ ROMFNT *)
    for pcnt := 2 to paramcount do
      exec_params := exec_params+' '+paramstr(pcnt); {pass thru param string}

{Customize these values for your specific chipset - These are for UMC 481}
       { index, mask,value}
    setbit($9E, $03, $00); (* set shadow ram in C000-C7FF to read/write *)
    setbit($9C, $03, $00); (* set shadow ram in C000-C7FF to not cacheable *)

    exec(paramstr(1), exec_params);

{Customize these values for your specific chipset - These are for UMC 481}
    setbit($9E, $03, $03); (* set shadow ram in C000-C7FF to readonly *)
    setbit($9C, $03, $03); (* set shadow ram in C000-C7FF to cacheable again *)
  end;
end.
