; DEMO4.CTL
; Showing the features of the system

- (ONCE)
LOADLOGO ^EBATSYMBOL^ 3
DATA 221,0,24,28,60,62,63,127,127,127,255,255,255,239,206,132,128
DATA 222,66,126,126,126,126,255,255,255,255,255,255,255,255,126,60,24
DATA 224,0,24,56,60,124,252,254,254,254,255,255,255,247,115,33,1

- (GLOBAL)
SET LOGO ^P25,50^C2^EBATSYMBOL^^C4What ^C1is^C4 The DEMO System?
KEY (ESC) POP               /* Pop back to previous screen
KEY (A-C) CALL @COLOR       /* Switch display to color set
KEY (A-M) CALL @MONO        /* Switch display to monochrome set

- (SET1) Defaults for full-screen functions
KEY (HOME)         FIELD FIRST
KEY (UP),(LEFT)    FIELD -1
KEY (DOWN),(RIGHT) FIELD +1
KEY (END)          FIELD LAST

- *MENUW.001
PAUSE DEMO  .1
BUFFER (SPACE)(SPACE)(SPACE)(SPACE)(SPACE)(SPACE)(SPACE)
KEY (ANY)      SCREEN  1
/.

















                                                              
                                                               
                        
                  ߱ ۱۱  
                          ۱۱    
                           ߱     
                  
                           
./

/* ------------------------------------------------------

- *MENUW.002
KEY (ANY)      SCREEN  1
/.














                                                              
                                                               
                        
                  ߱ ۱۱  
                          ۱۱    
                           ߱     
                  
                           
./

/* ------------------------------------------------------

- *MENUW.003
KEY (ANY)      SCREEN  1
/.











                                                              
                                                               
                        
                  ߱ ۱۱  
                          ۱۱    
                           ߱     
                  
                           
./

/* ------------------------------------------------------

- *MENUW.004
KEY (ANY)      SCREEN  1
/.








                                                              
                                                               
                        
                  ߱ ۱۱  
                          ۱۱    
                           ߱     
                  
                           
./

/* ------------------------------------------------------

- *MENUW.005
KEY (ANY)      SCREEN  1
/.





                                                              
                                                               
                        
                  ߱ ۱۱  
                          ۱۱    
                           ߱     
                  
                           
./

/* ------------------------------------------------------

- *MENUW.006
KEY (ANY)      SCREEN  1
/.


                                                              
                                                               
                        
                  ߱ ۱۱  
                          ۱۱    
                           ߱     
                  
                           
./

/* ------------------------------------------------------

- *MENUW.007
KEY (ANY)      SCREEN  1
/.
                                                              
                                                               
                        
                  ߱ ۱۱  
                          ۱۱    
                           ߱     
                  
                           
./

- *000 Central menu
SET TOP
SET CURSOR ^C2-->
SET KEYS (SET1)
KEY A,@1        CALL *001                /* Why use it?
KEY B,@2        CALL *002                /* How to create the input screens
KEY C,@3        CALL *003                /* Compilation vs viewing
KEY D,@4        CALL *004                /* Full-screen features
KEY E,@5        CALL *005                /* DOS functions
KEY F,@6        CALL *006                /* Environmental variables
KEY G,@7        CALL *007                /* SET commands
KEY H,@8        CALL *008                /* Reviewing the screen colors
KEY I,@9        CALL *009                /* Other stuff
KEY J,@10       CALL @GRAPHIC            /* Do a GIF
KEY X,@11,(ESC) GOTO @QUIT               /* Quit demo
/.
This subsystem shows the various features of The DEMO System.  See which:

             ^K   A. Why would you want to use The DEMO System?
             ^K   B. How to create the input screens
             ^K   C. Compilation vs viewing
             ^K   D. Full-screen features (incl self-running demos)
             ^K   E. DOS functions (including prompting)
             ^K   F. Environmental variables
             ^K   G. SET commands
             ^K   H. Reviewing the screen colors
             ^K   I. Other stuff
             ^K   J. Try a graphic (TSHOW BUGS.GIF)

             ^K   X. Quit demo
./

- *001 Why would you use The DEMO System
KEY X,(ESC) POP KEY1
/.
What sort of things can you do with The DEMO System?  Well, there are ^C2lots^C0 of
things you can do with it!  Some ideas:

  ^C1-^C0 Create demonstration programs to show people how a bulletin board,
         data base program, or anything other text-based system works.
         You can even design demonstrations for products on hardware
         that the user may not have (like a CD-ROM) so they can better
         determine whether they need to buy the hardware or not.
  ^C1-^C0 Design tutorials to show people how to do things.  You can define
         any keys to do anything you want so you can simulate most
         applications.
  ^C1-^C0 Create help systems.
  ^C1-^C0 Create menuing systems.  You can duplicate most of the features
         of a product like AUTOMENU.

Press ^C1X^C0 or ^C1Esc^C0 to return.

./

- *002 How to create the input screens
KEY X,(ESC) POP KEY2
/.
                                ^C1Creating screens

The DEMO System runs off a series of ASCII text screens, initially stored as
separate text files.  These screens can be created using screen-capture
facilities or be typed in (like these were).  Once created, you can imbed colors
(up to 8 color combinations per screen) and define keyboard entry zones.

The individual screens are referenced in a control file which tells the program
what screens to bring in and which keys cause the system to go to other screens
or do other operations.  For example,

                ; Sample control file
                - PAGE.001 First screen (has options A to C, then X to quit)
                KEY A GOTO PAGE.002
                KEY B GOTO PAGE.003
                KEY C GOTO PAGE.004
                KEY X QUIT
                - PAGE.002 Option A
                ...

The screens are brought in, checked, and combined at compilation time (see this
option).

Press ^C1X^C0 or ^C1Esc^C0 to go back.
./

- *003 Compilation vs viewing
KEY X,(ESC) POP KEY3
/.
                           ^C1Compilation vs Viewing

The DEMO System consists of two programs.

The ^C2compiler^C0 (DEMOMAKE) reviews your control card file for syntax errors.
It tokenizes what it can.  It then reads all of your text screens and searches
for control codes in that file.  At the end of this process, the program takes
all of your files including the control card file and creates a single data file
which is then concatenated to the end of the actual The DEMO System viewer.

The combined ^C2viewer^C0/data program is what you give your customers.  They
can't tamper with the screens at all.

The shareware fee is required for the use of the compiler, not the viewer.  As a
result, you can distribute the results of your compilations to anyone without
charge.

Press ^C1X^C0 or ^C1Esc^C0 to go back.
./

- *004 Full-screen features
SET CURSOR ^C2(^T10)
KEY (HOME)  FIELD FIRST
KEY (UP)    FIELD -3
KEY (DOWN)  FIELD +3
KEY (LEFT)  FIELD -1
KEY (RIGHT) FIELD +1
KEY (END)   FIELD LAST
KEY A,@1    CALL @SELECT A
KEY F,@2    CALL @SELECT F
KEY K,@3    CALL @SELECT K
KEY B,@4    CALL @SELECT B
KEY G,@5    CALL @SELECT G
KEY L,@6    CALL @SELECT L
KEY C,@7    CALL @SELECT C
KEY H,@8    CALL @SELECT H
KEY M,@9    CALL @SELF_RUN
KEY D,@10   CALL @SELECT D
KEY I,@11   CALL @SELECT I
KEY E,@13   CALL @SELECT E
KEY J,@14   CALL @SELECT J
KEY X,@15   POP KEY4
KEY (ESC)   NONE
/.
This is an example of what you can do with The DEMO System's full-screen
selections.  You can have the program branch according to the choices selected.
Select an option using either cursor keys or the letter of the option.  Also
note that there is an example of a self-running demo below (option M) which
demos a system where you'd want to press a series of keystrokes for them.

        ^K  Option A       ^K  Option F         ^K  Option K
        ^K  Option B       ^K  Option G         ^K  Option L
        ^K  Option C       ^K  Option H         ^K  SelfRunM
        ^K  Option D       ^K  Option I         ^K
        ^K  Option E       ^K  Option J         ^K  E^C1X^C0it



   ^C2                                                                 ^C2
   ^C2 Notice that the Esc key doesn't work in this screen.  You can   ^C2
   ^C2 enable or disable any keys as desired.                          ^C2
   ^C2                                                                 ^C2
./

- *005 DOS functions
SET KEYS   (SET1)
SET SETTINGS (SET1)
SET CURSOR ^C3(^T1)
KEY 1,@1        CALL @DOS ^EDIR^
KEY 2,@2        CALL @WRITE
KEY 3,@3        CALL @PLAY
KEY 4,@4        CALL @PROMPT
KEY 5,@5        CALL @SAVE
KEY L,@6        CALL *005A
KEY X,@7,(ESC)  POP KEY5
/.
The DEMO System provides direct access to all sorts of DOS functions within your
control card files.  You can use RUN commands to get anything not supported.
Some examples are provided below:

  ^K^C11^C0. (DOS) You can do any (small) DOS function you need to do or go to the
     DOS shell itself.  Bigger functions can be done with batch files that
     notice whether The DEMO System has created a given batch file to be run.
  ^K^C12^C0. (WRITE) and (DELETE) You can write lines to a text file (e.g. a batch
     file) if you want to.
  ^K^C13^C0. (PLAY) You can add PLAY commands to your files.  This can simulate
     modem dialing or be used to alert people to errors or whatever.
  ^K^C14^C0. (PROMPT) You can prompt a user for information.
  ^K^C15^C0. (SAVE) You can save the screen to a file.

  ^K^C1L^C0. List all available DOS and other action commands.

  ^K^C1X^C0. Return to previous menu

./

- *005A List of DOS and other action commands.
KEY X,(ESC) POP KEY6
/.
A quick list of the DOS and other action commands that functions worked into The
DEMO System include the following.  Remember that anything that's not here can
be done using the RUN option.

  ASSIGN var value                PAUSE [ seconds ]
  BUFFER chars                    PAUSEA [ seconds ]
  CALL screen [ KEYn | parms ]    PAUSE BREAK { ON | OFF }
  CD directory                    PAUSE DELAY seconds
  CDD drive:\directory            PLAY string
  CLS                             PLAY { ON | OFF }
  COPY file1 file2                POP [ TOP | 1 to 20 | KEYn ]
  DELETE file                     PROMPT var pattern string
  DISPLAY { MONO | COLOR }        PROMPTA var pattern string
  DRIVE letter                    QUIT [ return_code ]
  ECHO [ string[@] ]              RD directory
  ECHOA [ string[@] ]             REDRAW
  FIELD change                    RUN [ string ]
  GOTO screen [ KEYn | parms ]    RUNA [ string ]
  KEYPRESS                        SAVE filename
  LOADLOGO ...                    SCREEN change
  LOCATE row col                  WRITE filename string
  MD directory

Press ^C1X^C0 or ^C1Esc^C0 to go back.
./

- *006 Environmental variables
KEY X,(ESC) POP KEY6
/.
                           ^C1Environmental variables

The DEMO System allows you to pass and act on DOS environmental variables as
well as certain variables that are maintained by the viewer.  These variables
are resolved at viewing time (not during compilation) and can be displayed on
the screen, written to a file, or whatever.  They include:

   ^C1DATE^C0    The current system date           : ^EDATE^
   ^C1TIME^C0    The current system time           : ^ETIME^
   ^C1ETIME^C0   Elapsed time since program began  : ^EETIME^
   ^C1DIR^C0     The current DOS directory         : ^EDIR^
   ^C1INITDIR^C0 The initials DOS directory        : ^EINITDIR^
   ^C11^C0-^C19^C0     Passable parameters

For debugging purposes, you can also display the following:

   ^C1FNAME^C0   The original filename of your input text screen : ^EFNAME^
   ^C1FDESC^C0   Any desc for this page : ^EFDESC^
   ^C1FPAGE^C0   The screen number                               : ^EFPAGE^
   ^C1FIELD^C0   The current field position on the screen        : ^EFIELD^
   ^C1ROW^C0 and ^C1COL^C0  The cursor row and column                  : ^EROW^ ^ECOL^

Press ^C1X^C0 or ^C1Esc^C0 to go back.
./

- *007 SET commands
KEY X,(ESC) POP KEY7
/.
                                  ^C1SET commands

The DEMO System provides the ability to set certain conditions and defaults at
compilation time.  These can be set for single screens, a series of screens, or
all screens.  They include:

  SET CASE { ON | OFF }   Whether input case matters
  SET CLS { ON | OFF }    Whether to clear the screen before display
  SET COLOR settings      What colors to use if a color monitor is detected
  SET CURSOR string       What cursor to use for each prompt
  SET KEYS CLEAR          Clears previously defined key assignments
  SET KEYS SETn           Sets screen's keys to match some template
  SET LOGO string         Any text you want displayed on every screen?
  SET MONO settings       What colors to use if a monochrome monitor is
                            used (or simply to provide an alternative color set)
  SET SETTINGS SETn       Sets screen's other settings to match some template
  SET TOP screen          Determine the maximum screen that a use can pop
                            back to

Press ^C1X^C0 or ^C1Esc^C0 to go back.
./

- *008 Reviewing the screen colors
KEY X,(ESC) POP KEY8
/.
                          Reviewing the screen colors

The following color sets are set by default in The DEMO System.  You can switch
between the color and monochrome settings by using Alt-C (color) and Alt-M
(monochrome).

        ^C0 This is color set 0
        ^C1 This is color set 1
        ^C2 This is color set 2
        ^C3 This is color set 3
        ^C4 This is color set 4
        ^C5 This is color set 5
        ^C6 This is color set 6
        ^C7 This is color set 7


Press ^C1X^C0 or ^C1Esc^C0 to go back.
./

- *009 Other stuff
SET CLS OFF
KEY (ESC),(ELSE)  POP KEY9
/.

















  ^C2 ͻ ^C0
  ^C2  Another screen.  Notice it didn't clear the old one first?            ^C0
  ^C2 Ķ ^C0
  ^C2  Just wanted to show you that!  Press a key please.                    ^C0
  ^C2 ͼ ^C0
./

/* ---------------------------- labels ----------------------------------------

- @COLOR Switching display to color set
DISPLAY COLOR
REDRAW
POP

- @DOS Demonstrating some DOS functions
LOCATE 15 1
ECHOA We're about to hop into DOS and do a DIR command.
ECHOA Note that we could have cleared the screen this time but we didn't.
ECHOA Also note that it's going to a different screen.  Ready?
RUNA DIR *.EXE /W
ECHOA Press a key please
PAUSEA
ECHO ^P20,1We're back!  Now we hop into DOS itself.  Say ^C1EXIT^C0 to return.
RUN
ECHO We're about to copy your AUTOEXEC.BAT file as KILLME.NOW
ECHO Note that you can have the cursor stay in place@
RUN COPY C:\AUTOEXEC.BAT C:\KILLME.NOW
ECHO We're back!  Press a key when ready to continue.
PAUSE
ECHO Let's try some of the directory commands.  Creating directory #T#
MD ^EINITDIR^\#T#
CD ^EINITDIR^\#T#
ECHO Now running DIR.  Note your subdirectory name:
RUN DIR
ECHO Now resetting the directory back to ^EINITDIR^
CD ^EINITDIR^
RD ^EINITDIR^\#T#
ECHO Just removed #T#.  Press a key
PAUSE
POP

- @GRAPHIC Loading a graphic file
/* Note that none of The DEMO System options while you're
/* in another program.
RUN TSHOW BUGS.GIF  /* TSHOW is one of those freebie GIF viewers
/* Have to reload the symbol because the program probably screwed it
/* up.
LOADLOGO CLEAR
LOADLOGO ^EBATSYMBOL^ 3
DATA 221,0,24,28,60,62,63,127,127,127,255,255,255,239,206,132,128
DATA 222,66,126,126,126,126,255,255,255,255,255,255,255,255,126,60,24
DATA 224,0,24,56,60,124,252,254,254,254,255,255,255,247,115,33,1
POP

- @MONO Switching display to Monochrome and redrawing screen
DISPLAY MONO
REDRAW
POP

- @PLAY Seeing how the PLAY commands work
CLS
ECHO Let's try some play command stuff.  Testing...
PLAY mb t180 o2 p2 p8 l8 ggg l2 e- p24 p8 l8 fff l2 d
ECHO That should still be playing.  Press a key when ready.
PAUSE
POP

- @PROMPT Testing the various PROMPT options
/* Prompting the user for input.
CLS
ECHO Okay.  Let's prompt the user for something.
ECHO The pattern here is "NNNUU" -- three digits, and two letters
PROMPT ^EUSERID^ NNNUU ^C2Enter your user ID? ^C1
ECHO ^C0
ECHO      The result is ^EUSERID^
ECHO The next one uses the pattern "XXX-UUU-BBB" -- B must be Y/N/T/F
PROMPT ^EANOTHER^ XXX-UUU-BBB ^C2Enter something? ^C1
ECHO ^C0
ECHO      The result was ^EANOTHER^
ECHO The next one uses the pattern "MM/DD/YY"
PROMPT ^EDAT^ MM/dd/yy Enter a date? ^
ECHO ^C0
ECHO       The result was ^EDAT^
ECHO The next one uses the pattern "FILESPEC"
ASSIGN ^EX^
PROMPT ^EX^ Filespec Enter a filespec? ^
ECHO ^C0
ECHO       The result was ^EX^
ECHO The next one uses the pattern "VFILESPEC"
ASSIGN ^EX^
PROMPT ^EX^ VFilespec Enter a filespec? ^
ECHO ^C0
ECHO       The result was ^EX^
ECHO The next one uses the pattern "PATH"
ASSIGN ^EX^
PROMPT ^EX^ PATH Enter a sample path? ^
ECHO ^C0
ECHO       The result was ^EX^
ECHO The next one uses the pattern "VPATH"
ASSIGN ^EX^
PROMPT ^EX^ VPATH Enter a valid path? ^
ECHO ^C0
ECHO       The result was ^EX^
ECHO Press a key please
PAUSE
POP

- @QUIT Quitting
LOADLOGO CLEAR
ECHO ^C0
CLS
ECHO Thanks for your interest in The DEMO System
QUIT 5         /* Setting the return code to 5

- @SAVE Saving the current screen some place
ECHO ^P20,1You can use device names instead of file names if you want.
ASSIGN ^ENAME^
PROMPT ^ENAME^ FILESPEC ^C2Save screen under what DOS file name?
SAVE ^ENAME^
POP

- @SELECT Common subroutine showing what option you picked
ECHO ^P20,1You selected the ^E1^ option at ^ETIME^.  Press a key now.
PAUSE
POP

- @SELF_RUN  Self-running demo example
ECHO ^P24,1Showing a self-running demo@
PAUSE 1
PAUSE DEMO 0.4
PAUSE BREAK OFF
BUFFER (HOME)
BUFFER (RIGHT)(RIGHT)(RIGHT)(RIGHT)
ECHO ^P25,1Hopping around still...@
BUFFER (UP)(LEFT)(LEFT)(ENTER)
PLAY mb t180 o2 p2 p8 l8 ggg l2 e- p24 p8 l8 fff l2 d
PAUSE BREAK ON
ECHO ^P24,1Feel free to press Esc to stop this@
BUFFER (UP)(UP)(UP)(UP)(UP)(UP)(UP)(UP)(UP)(UP)(UP)
REDRAW
POP

- @WRITE Showing how to write functions work
CLS
ECHO We're writing something to a file called C:\KILLME.NOW
ECHO It includes environmental variables for Time, Date, and your system PROMPT
DELETE C:\KILLME.NOW
WRITE C:\KILLME.NOW This is the first line
WRITE C:\KILLME.NOW And the second
WRITE C:\KILLME.NOW Current date:       ^EDATE^
WRITE C:\KILLME.NOW Current time:       ^ETIME^
WRITE C:\KILLME.NOW Elapsed time:       ^EETIME^
WRITE C:\KILLME.NOW Your system PROMPT: ^EPROMPT^
ECHO Now let's see what the file looks like.
RUN TYPE C:\KILLME.NOW
ECHO Press a key when ready.
PAUSE
POP

