program wrapBBS__FILE_ID_DIZ;  { FILE_ID.DIZ }
                               { is an 8 line by 44 character wide file      }
                               { placed in ZIP's to describe their contents. }
                               { It is mainly used on BBS's, which usually   }
                               { have programs to read it and use it as the  }
                               { published file description.  Thus, the      }
                               { program is described consistently from      }
                               { board to board, no matter who uploads it.   }
                               { THE PRECEDING IS HOW ONE ACTUALLY APPEARS!  }
uses dos;
const
   progdata = 'DIZZY- Free DOS utility: FILE_ID.DIZ off-line reformatter.';
   progdat2 = 'V1.00: July 14, 1993. (c) 1993 by David Daniel Anderson - Reign Ware.';
   usage = 'Usage:  DIZZY file_id.diz [or current "working" name(s)]';
var
   dirinfo         : searchrec;
   spath           : pathstr;
   sdir            : dirstr;
   sname           : namestr;
   sext            : extstr;

   infile, outfile : text;

   sfn, dfn, tfn   : string[64];
   filesdone       : array[1..512] of string[64];

   done            : boolean;
   i, nmdone       : word;

procedure showhelp;
begin
   writeln(usage);
   halt;
end;

procedure openfiles(var sfile, dfile : text; name1, name2 : string);
begin
     assign(sfile,name1);
{$i-} reset(sfile); {$i+}
     if (ioresult <> 0) then
     begin
         writeln('Unable to open "', name1, '".');
         showhelp;
     end;

     assign(dfile,name2);
     rewrite(dfile);
end;

function squeezestr(longstr : string) : string;
begin
    while ((longstr <> '') and (pos('  ',longstr) <> 0)) do
          delete(longstr,pos('  ',longstr),1);

    while ((longstr <> '') and (longstr[length(longstr)] = ' ')) do
          delete(longstr,length(longstr),1);

    while ((longstr <> '') and ((longstr[1] = ' ') or (longstr[1] = '|'))) do
          delete(longstr,1,1);
    squeezestr := longstr;
end;

function wrapline(var thefile : text; theline : string) : string;
var
   parta,partb  : string;
   breakchar    : string[1];
begin
     parta := copy(theline,1,45);
     partb := copy(theline,46,(length(theline)-45));
     breakchar := copy(parta,length(parta),1);
     delete(parta,length(parta),1);

     if (breakchar = '-') then begin
          partb := breakchar + partb;
          breakchar := copy(parta,length(parta),1);
          delete(parta,length(parta),1);
     end;
     while ((breakchar <> ' ')
        and (breakchar <> '-')) do
     begin
          partb := breakchar + partb;
          breakchar := copy(parta,length(parta),1);
          delete(parta,length(parta),1);
     end;
     if (breakchar = '-') then
        parta := parta + breakchar;

     writeln(thefile,parta);
     partb := squeezestr(partb);
     wrapline := partb;
end;

procedure makenewfile(var source, dest : text);
var
    crnline,
    freshline : string;

begin {p}
     crnline := '';
{r1} repeat
        readln(source,freshline);
        freshline := squeezestr(freshline);

{i1}    if freshline <> '' then
{i2a}       if ((crnline[length(crnline)] = '-')
            and (crnline[length(crnline) - 1] <> ' ')) then
                 crnline := crnline + freshline
{i2b}       else
                 if crnline = '' then
                    crnline := crnline + freshline
                 else
                    crnline := crnline + ' ' + freshline;

{w1}    while length(crnline) >= 45 do
                 crnline := wrapline(dest,crnline);

{r1} until eof(source);
{i3} if (length(crnline) > 3) then
        writeln(dest,crnline);
end;  {p}

begin {main}
     writeln(progdata);
     writeln(progdat2);
     writeln;
     if paramcount <> 1 then
        showhelp;

     nmdone := 1;
     for i := 1 to 512 do
         filesdone[i] := '';

     spath := paramstr(1);

     fsplit(fexpand(spath),sdir,sname,sext);
     if (sname = '') then
         showhelp;

     findfirst(spath, archive, dirinfo);

     while doserror = 0 do
     begin
          sfn := sdir+dirinfo.name;
          done := false;
          for i := 1 to 512 do
              if sfn = filesdone[i] then
              done := true;

          if done = false then begin
              filesdone[nmdone] := sfn;
              dfn := 'd!#$_$#!.dzy';
              tfn := 't!#$_$#!.dzy';

              write('Wrapping ',sfn);

              openfiles(infile,outfile,sfn,dfn);
              makenewfile(infile,outfile);

              writeln(', done!');

              close (infile);
              close (outfile);
              rename(infile,tfn);
              rename(outfile,sfn);
              erase (infile);
              nmdone := nmdone + 1;
          end;
          findnext(dirinfo);
     end;
end. {main}
