FILEX(1)                 USER COMMANDS                   FILEX(1)



NAME
     filex - determine the type of a file by examining its name
     and extension.

SYNOPSIS
     file [ -1abdfnqR? ] target ...

DESCRIPTION
     filex studies the filename extension and tells what kind of
     files and what programs usually use that specific extension.

     filex uses the database file extensio.txt or any other user
     defined data file to look up the extension information.

OPTIONS
     -1   Show and study each different file extension only once.

     -a   Show All known possibilities.

     -b filename.ext
          Identify only given filename extension, these Bogus files
          don't have to exist.

     -d   Show the current Directory name at the beginning.

     -f   Don't handle hidden or system files (Force).

     -n   Show only unknown files (Noise).

     -q   Show only known files (Quiet).

     -R   Recurse through all subdirectories.

     -?   Info.

     -*   Debug.

EXAMPLES
     Do the following command at the root of your harddisk:

          filex -1ndR . > test

     and if you find in the file "test" any file extensions you
     know to belong to some program or a common file type, please
     let me know them, too, to be added to the extension list.

     Command line options can be given separated or together and
     the switch can be either unixlike "-" or DOSlike "/".

     filex -1 -n *.*
     filex /1 /n *.*
     filex -n1   *.*
     filex /n -1 *.*

     You can have several targets specified on command line.

     filex -b file.a file.b file.c

ENVIRONMENT
     Environment variable FILEX can be set to point to any valid
     File Extension Database.

FILES
     extensio.txt

     First Filex checks if environment variable FILEX exists and
     then if a file named "extensio.txt" exist in any directory
     specified in the PATH.

     Format of File Extansion Database is the following:
     - first character of every line is . (period, ASCII 46)
     - then max three characters (extension)
     - TAB character (horizontal TAB, ASCII 9)
     - max 63 characters (description of extension)

HISTORY
     1.0 30-Jan-93    original version based on file.btm (jambtm02.zip)
     1.1 28-Feb-93    red-black tree functions & large memory model
     1.2 27-Jun-93    2x faster start up (64K data limit)

SEE ALSO
     Robert Sedgewick: "Algorithms in C" ISBN 0-201-51425-7
     for info about self-balancing binary trees (red-black trees).

     Ricki's File, File39

     Filex is not perfect, but it's a perfect companion for a fully
     unixlike File utility. At the moment I know two good ones:

     garbo.uwasa.fi:/pc/unix/file10.zip by Richard Breuer
     Specially directed to DOS files and can give extra info

     ftp.luth.se:/pub/os2/all/unix/unixutils/file39.zip (Darrel Hankerson)
     fully unix compatible == linux file util port

BUGS
     If file has a wrong filename extension, filex obviously makes
     a wrong identification.

STATUS
     This program is Freeware. Use, share and enjoy.



Jouni Miettunen * jon@stekt.oulu.fi * Oulu * Finland * Europe * 1993
