IMPLEMENTATION MODULE EnvirOps;

(* Environment-Operations *)
(* Alle Proceduren geben TRUE zurck, wenn die Operation erfolgreich war.
   error wird TRUE, wenn dir bergebene Stringvariable zu klein war, um
   den gefundenen String aufzunehmen *)

FROM Lib IMPORT CommandType, Environment, IncAddr;
FROM Str IMPORT Length, Pos, Slice, Caps, CHARSET, Copy,
                Item, CharPos;
FROM FIO IMPORT Exists;
FROM FIOR IMPORT ExpandPath, MakePath;
FROM MyStr IMPORT PosCaps;




PROCEDURE FindEnvironmentVar( name: ARRAY OF CHAR; VAR value: ARRAY OF CHAR;
                              VAR error: BOOLEAN ): BOOLEAN;

(* Sucht im Environment nach einer Variable, deren Name in name bergeben wird,
   und gibt deren Inhalt in value zurck. *)

  VAR   cptr : CommandType;
        n, l : CARDINAL;
        found: BOOLEAN;
  BEGIN
    Caps( name );               (* Name in Grobuchstaben umwandeln *)
    n := 0;                     (* Variablen initialisieren *)
    found := FALSE;
    error := FALSE;
    value[0] := CHR(0);
    REPEAT                      (* Environment absuchen ab Eintrag 0 *)
      cptr := Environment( n ); (* cptr hat Pointer auf Eintrag *)
      IF Length( cptr^ ) > 0 THEN   (* Nullstring = Ende des Environments *)
        found := Pos( cptr^, name ) = 0;
      END;
      INC (n );
    UNTIL found OR (Length( cptr^ ) = 0);
    IF found THEN              (* Zeichen nach dem "=" in value kopieren *)
      n := CharPos( cptr^, '=' ) + 1;  (* Startposition in n *)
      l := Length( cptr^ ) - n ;   (* Zahl der Zeichen in l *)
      IF l > HIGH( value ) THEN    (* String value gro genug? *)
        error := TRUE;
      ELSE
        Slice( value, cptr^, n, l );
      END;
    END;
    RETURN found AND NOT error;
  END FindEnvironmentVar;

PROCEDURE FindPath( VAR path : ARRAY OF CHAR; VAR error: BOOLEAN ): BOOLEAN;

(* Gibt den gesetzten PATH zurck, falls vorhanden *)
  BEGIN
    RETURN FindEnvironmentVar( 'PATH', path, error );
  END FindPath;

PROCEDURE FindExecPath (VAR path : ARRAY OF CHAR; VAR error: BOOLEAN ): BOOLEAN;

(* Gibt den Pfad zurck, von dem das Programm gestartet wurde, ohne den
   Programmnamen, abgeschlossen mit einem \. Funktioniert nur mit DOS 3.x.
   Der ExecPath steht nach dem Ende des Environments (markiert durch
   zwei Nullbytes) und wird mit 01H 00H eingeleitet *)
  VAR   cptr : CommandType;
        n, l : CARDINAL;
        found: BOOLEAN;
  BEGIN
    n := 0;                     (* Variablen initialisieren *)
    found := FALSE;
    error := FALSE;
    path[0]  := CHR(0);
    REPEAT                      (* Ende des Environment suchen *)
      cptr := Environment( n ); (* cptr hat Pointer auf Eintrag *)
      INC (n );
    UNTIL Length( cptr^ ) = 0;
    IncAddr( cptr, 1 );         (* cptr sollte jetzt auf den String 01H 00H
                                   zeigen. Falls nicht, haben wir es wohl mit
                                   einer lteren Dos-Version zu tun, die den
                                   ExecPath nicht ans Environment anhngt *)
    found := (cptr^[0] = CHR(1)) AND (Length( cptr^ ) = 1);
    IF found THEN
      IncAddr( cptr, 2);        (* cptr zeigt jetzt auf den ExecPath *)
      n := Length( cptr^ ) ;
      REPEAT                    (* such das letzte Auftreten des Pfadseparators *)
        DEC( n );
      UNTIL (cptr^[n] IN CHARSET{'\', '/', ':'}) OR (n = 0);
      IF n > HIGH( path ) THEN
        error := TRUE
      ELSIF n = 0 THEN
        found := FALSE          (* der ExecPath enthlt IMMER einen Laufwerks-
                                   bezeichner, d.h. n mu mindestens 1 sein,
                                   sonst ist was faul *)
      ELSE
        Slice( path, cptr^, 0, n+1 );
      END;
    END;
    RETURN found AND NOT error;
  END FindExecPath;

PROCEDURE FindFile ( filename: ARRAY OF CHAR; VAR path: ARRAY OF CHAR;
                     VAR error: BOOLEAN ): BOOLEAN;

(* Sucht eine Datei, deren Namen bergeben wird, zunchst im default directory,
   dann auf dem ExecPath und zuletzt auf den in der PATH-Variablen definierten
   Directories. Falls gefunden, wird der volle Pfad in path zurckgegeben,
   inclusive des Dateinamens und der Rckgabewert wird TRUE. *)
  VAR found : BOOLEAN;
      searchstr, pathstr: ARRAY [0..256] OF CHAR;
      n  : CARDINAL;

  PROCEDURE Search;
    BEGIN
      MakePath( searchstr, searchstr, filename );
      found := Exists( searchstr );
      IF found THEN
        IF Length( searchstr ) > HIGH( path ) THEN
          error := TRUE
        ELSE
          Copy( path, searchstr )
        END
      END;
    END Search;

  BEGIN (* FindFile *)
    (* erster Anlauf: suche im default directory *)
    found := FALSE;
    error := FALSE;
    path[0] := CHR(0);
    IF Exists( filename ) THEN
      found := TRUE;
      ExpandPath( filename, path );
      error := PosCaps( path, filename ) = MAX(CARDINAL);
    ELSE
      (* if filename contains part of a path, don't search further *)
      IF (CharPos( filename, '\' ) # MAX(CARDINAL)) OR
         (CharPos( filename, ':' ) # MAX(CARDINAL)) THEN
         RETURN FALSE
      END;
      IF FindExecPath( searchstr, error ) THEN
      (* zweiter Anlauf, suche auf dem ExecPath.
         searchstr ist mit Sicherheit lang genug fr den Pfad *)
         Search;
      END;
    END;
    IF NOT found THEN
      (* dritter Anlauf, suche auf dem PATH. Das ist etwas komplizierter,
         da PATH ja mehrere Directories enthalten kann, die durch ";"
         getrennt sind *)
      IF FindPath( pathstr, error ) THEN
        n := 0;
        REPEAT
          Item( searchstr, pathstr, CHARSET{CHR(9), ' ',';' }, n );
          INC( n );
          IF Length( searchstr ) > 0 THEN
            Search;
          END;
        UNTIL found OR (Length( searchstr) = 0);
      END;
    END;
    RETURN found AND NOT error;
  END FindFile;

END EnvirOps.
