IMPLEMENTATION MODULE MyStr;
  (* Own string handling procedures *)

FROM Str IMPORT Delete, Length, CharPos, Compare, Pos;

PROCEDURE Trim (VAR S: ARRAY OF CHAR ; trim_front, trim_back: BOOLEAN );
  (* removes any blanks from begin and/or end of string *)
  VAR  i, l : CARDINAL;
  BEGIN
    IF trim_front THEN
      l := Length( S );
      i := 0;
      WHILE (i < l) AND ((S[i] = ' ') OR (S[i] = 11C)) DO
        INC( i );
      END;
      IF i > 0 THEN
        Delete( S, 0, i );
        IF S[0] = ' ' THEN S[0] := 0C END;
      END
    END;
    IF trim_back THEN
      i := Length( S );
      WHILE (i > 0) AND ((S[i-1] = ' ') OR (S[i-1] = 11C)) DO
        S[i-1] := 0C;
        DEC( i );
      END; (* WHILE (i > 0) AND (S[i] = ' ') *)
    END; (* trim_back *)
  END Trim;

CONST
  LowCaseChars = 'abcdefghijklmnopqrstuvwxyz';
  UpCaseChars= 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';

PROCEDURE UpperCase( ch: CHAR ): CHAR;
  (* uppercasing of letters including county specific letters *)
  VAR 
    i: CARDINAL;
  BEGIN
    i := CharPos( LowCaseChars, ch );
    IF i # MAX(CARDINAL) THEN
      ch := UpCaseChars[i];
    END;
    RETURN ch;
  END UpperCase;

PROCEDURE LowerCase( ch: CHAR ): CHAR;
  (* lowercasing of letters including county specific letters *)
  VAR 
    i: CARDINAL;
  BEGIN
    i := CharPos( UpCaseChars, ch );
    IF i # MAX(CARDINAL) THEN
      ch := LowCaseChars[i];
    END;
    RETURN ch;
  END LowerCase;

TYPE
  ChangeProc = PROCEDURE( CHAR ): CHAR;

PROCEDURE ChangeCase( VAR S: ARRAY OF CHAR; P: ChangeProc; maxlen: CARDINAL );
  VAR n: CARDINAL; 
  BEGIN
    IF maxlen > 0 THEN
      FOR n:= 0 TO maxlen-1 DO 
        S[n] := P( S[n] );
      END; (* FOR *)
    END;
  END ChangeCase;
  
PROCEDURE Caps( VAR S: ARRAY OF CHAR );
  BEGIN
    ChangeCase( S, UpperCase, Length( S )  );
  END Caps;

PROCEDURE Lows( VAR S: ARRAY OF CHAR );
  BEGIN
    ChangeCase( S, LowerCase, Length( S ) );
  END Lows;

PROCEDURE LowsN( VAR S: ARRAY OF CHAR; maxlen: CARDINAL );
  BEGIN
    ChangeCase( S, LowerCase, maxlen );
  END LowsN;

PROCEDURE CapsN( VAR S: ARRAY OF CHAR; maxlen: CARDINAL );
  BEGIN
    ChangeCase( S, UpperCase, maxlen );
  END CapsN;

PROCEDURE CompareCaps( s1, s2: ARRAY OF CHAR ): INTEGER;
  (* case-insensitive compare *)
  BEGIN
    ChangeCase( s1, LowerCase, Length( s1 ) );
    ChangeCase( s2, LowerCase, Length( s2 ) );
    RETURN Compare( s1, s2 );
  END CompareCaps;


PROCEDURE PosCaps( str, substr: ARRAY OF CHAR ): CARDINAL;
  (* case-insensitive Pos *)
  BEGIN
    ChangeCase( str, LowerCase, Length( str ) );
    ChangeCase( substr, LowerCase, Length( substr ) );
    RETURN Pos( str, substr );
  END PosCaps;
END MyStr.

