;CADET Global Variables, edit values below to set permanent defaults
(SETQ CADETP 1.6190) ;Text pitch factor, default 1.619, range 1.0 to 2.0
(SETQ CADETT 1.0000) ;Table tolerance factor, default 1.5, range 0.1 to 2.0
(SETQ CADETC NIL) ;Enable COM port resets, T = enable, NIL = disable
(SETQ CADETM T) ;Disable memory management, T = disable, NIL = enable
(SETQ CADETS NIL) ;Sort by LLH coordinates, T = LLH, NIL = insert point
(SETQ CADETR NIL) ;Enable restore files, T = enable, NIL = disable
(SETQ CADETB T) ;T = R10 Ext. AutoLISP/AutoCAD 386, NIL = R9/R10 Reg. AutoLISP
(SETQ CADETL "C:/WASCO/") ;CADET's Lisp file directory, see CADET Manual
(SETQ CADETD "C:/WASCO/") ;CADET's Read/Write Directory, see CADET Manual
;CADET CC, CI, etc. functions below may be renamed, but Wts? functions may not:
(defun C:CC () (setq CADET@ "C") (WtsC40)) ;Cadet-Create Table
(defun C:CN () (setq CADET@ "N") (WtsC40)) ;Cadet-Notes
(defun C:CI () (setq CADET@ "I") (WtsC40)) ;Cadet-Import
(defun C:CE () (setq CADET@ "E") (WtsE40)) ;Cadet-Edit
(defun C:CET () (setq CADET@ "T") (WtsE40)) ;Cadet-Edit Table
(defun C:CEN () (setq CADET@ "O") (WtsE40)) ;Cadet-Edit Notes
(defun C:CEA () (setq CADET@ "B") (WtsE40)) ;Cadet-Edit Attributes
(defun C:CEG () (setq CADET@ "G") (WtsE40)) ;Cadet-Edit Global
(defun C:CS () (setq CADET@ "S") (WtsP40)) ;Cadet-SetText
(defun C:CP () (setq CADET@ "P") (WtsP40)) ;Cadet-PlusText
(defun C:CM () (setq CADET@ "M") (WtsP40)) ;Cadet-MultiText
(defun C:CJ () (setq CADET@ "J") (WtsJ40)) ;Cadet-JustifyText
(defun C:CA () (setq CADET@ "A") (WtsJ40)) ;Cadet-AlignText
(defun C:CR () (setq CADET@ "R") (WtsR40)) ;Cadet-Restore
(defun C:CX () (setq CADET@ "X") (WtsM40)) ;Cadet-External File
;CADET code below this point must not be modified:
(defun C:CADET () (setq CADET@ "_") (WtsM40)) ;Cadet command line menu
(if (and (getvar "worlducs") (getenv "CADET")) (SETQ CADETD (getenv "CADET")))
(defun WtsLsp (st / fh st2 st3)
  (setq st3 (if CADETB "Cadet40x" st) st2 (if CADETL (strcat CADETL st3) st3))
  (if (getvar "worlducs") ;R10+
    (progn (prompt "\nLoading...")(load st2)(prompt " Loaded.")
      (eval (list (read st))))
    (progn (setq fh (open "CadetLd.scr" "w"))(princ (strcat "(load \"" st2
    "\") (" st ") ") fh)(setq fh (close fh))(command "script" "CadetLd")(princ)))
)
(defun WtsC40 () (WtsLsp "WtsC40"))
(defun WtsE40 () (WtsLsp "WtsE40"))
(defun WtsP40 () (WtsLsp "WtsP40"))
(defun WtsJ40 () (WtsLsp "WtsJ40"))
(defun WtsR40 () (WtsLsp "WtsR40"))
(defun WtsM40 () (WtsLsp "WtsM40"))
(princ) ;end of file
