;-------------------- TITLE.LSP ----------------------------
;by    : Sundar.S
;date  : 11. Feb. 1991.
;----------------------------------------------------------
(defun ds (s) (* (getvar "dimscale") s))
(defun err () (prompt "\nText won't fit..."))

(defun input ()
    (prompt "\n\tEnter Drawing Title.... \t")
    (setq fld (getstring T "\nFirst line of description: "))
    (while (> (strlen fld) 58)   ; 58 is the maximum string that would
           (err)                 ; fit in the given label.
           (setq fld (getstring T "\nFirst line of description: "))
    )
    (setq sld (getstring T "\nSecond line of description: "))
    (while (> (strlen sld) 58)
           (err)
           (setq sld (getstring T "\nSecond line of description: "))
    )
    (setq tld (getstring T "\nThird line of description: "))
    (while (> (strlen tld) 58)
           (err)
           (setq tld (getstring T "\nThird line of description: "))
    )
    (setq cust (getstring T "\nCustomer: "))
    (while (> (strlen cust) 58)
           (err)
           (setq cust (getstring T "\nCustomer: "))
    )
    (setq dr  (getstring T "\nDrawn by: "))
    (setq datee (substr (rtos (getvar "cdate")) 1 8)
          datee (strcat (substr datee 7) "."
                        (substr datee 5 2) "."
                        (substr datee 3 2)
                 )
    )
    (setq date (getstring (strcat "\nDate <" datee ">: ")))
    (while (> (strlen date) 10)
           (err)
           (setq date (getstring (strcat "\nDate <" datee ">: ")))
    )
    (if (= date "") (setq date datee))
    (setq sf (getvar "dimscale"))
    (if (= sf 1.0)
        (setq sf "NTS")
        (setq sf (strcat "1 : " (rtos (fix sf))))
    )
    (setq sc (getstring T (strcat "\nScale <" sf ">: ")))
    (if (= sc "") (setq sc sf))
    (setq dwgno (getstring "\nDrawing number: "))
    (while (or (> (strlen dwgno) 13) (= (strlen dwgno) 0))
           (princ "\n\t*** Drawing Number Invalid *** ")
           (setq dwgno (getstring "\nDrawing number: "))
    )
    (initget 4)
    (setq rev  (getint "\nRevision no. <0>: "))
    (initget 4)
    (setq shno (getint "\nSheet number <1>: "))
    (initget 4)
    (setq nosh (getint "\nNo. of sheets <1>: "))
    (if (= rev nil)  (setq rev "0")  (setq rev  (itoa rev)))
    (if (= shno nil) (setq shno "1") (setq shno (itoa shno)))
    (if (= nosh nil) (setq nosh "1") (setq nosh (itoa nosh)))
    (setq dwg
      (getstring (strcat "\nDrawing file name <" (getvar "dwgname") ">: "))
    )
    (while (> (strlen dwg) 8)
           (princ "\t\n *** INVALID FILE NAME ***")
           (setq dwg (getstring
                (strcat "\nDrawing file name <" (getvar "dwgname") ">: ")))
           )
           (if (= dwg "") (setq dwg (getvar "dwgname"))
    )
    (setq fno (getstring "\nFloppy diskette number: "))
    (while (= fno "")
           (setq fno (getstring "\nFloppy diskette number: "))
    )
    (setq wt (getstring "\nTotal weight: "))    ; only for dbase record.
 )

 (defun writing ()
    (setq txt "text")
    (command txt "m" (list (ds 774) (ds 46)) (ds 2.5) "0" fld
     ;'(774 46) is the middle point of the given label.
             txt "m" (list (ds 774) (ds 40)) (ds 2.5) "0" sld
             txt "m" (list (ds 774) (ds 33)) (ds 2.5) "0" tld
             txt "m" (list (ds 774) (ds 27)) (ds 2.5) "0"
             (strcat "CUSTOMER: " (strcase cust))
             txt (list (ds 694) (ds 44.5) ) (ds 2) "0" dr
             txt (list (ds 699) (ds 37)) (ds 2) "0" date
             txt (list (ds 699) (ds 29.5)) (ds 2) "0" sc
             txt "m" (list (ds 813) (ds 11)) (ds 2.5) "0" rev
             txt (list (ds 829) (ds 14.5)) (ds 2.5) "0" shno
             txt (list (ds 829) (ds 7.5)) (ds 2.5) "0" nosh
             txt (list (ds 689) (ds 51)) (ds 2.5) "90"
             (strcase (strcat fno "/" dwg))
    )
    (setq p (list (ds 717) (ds 11)) n 1)
    (if (/= dwgno nil)
        (progn
            (repeat (strlen dwgno)
                    (command txt "m" p (ds 3) "0" (substr dwgno n 1))
                    (setq n (1+  n))
                    (setq p (polar p 0 (ds 7.08)))
           ; 7.08 is the distance between two digits in the drawing number.
             )
         )
    )
    (prin1)
)

(defun struc (count str / tt dd )
    (setq tt "")
    (if (> count (strlen str))
        (progn
            (setq tt
                (repeat (- count (strlen str))
                        (setq tt (strcat tt (chr 32)))
                )
            )
            (setq dd (strcase (strcat str tt)))
        )
        (setq dd (strcase (substr str 1 count)))
    )
    (setq txt (strcat txt dd))
)

(defun dbplus ()
    (setq txt "")
    (setq file (open "title.prn" "a"))
    (struc 60 fld) (struc 60 sld) (struc 60 tld) (struc 60 cust) (struc 15 dr)
    (struc 10 date) (struc 11 sc) (struc 16 dwgno) (struc 2 rev)
    (struc 2 shno) (struc 2 nosh) (struc 8 dwg) (struc 5 fno) (struc 8 wt)
    (princ txt file)
    (princ "\n" file)
    (close file)
)

(defun c:title ()
   (setvar "cmdecho" 0)
   (setvar "blipmode" 0)
   (setvar "highlight" 0)
   (command "undo" "g")
   (input)
   (writing)
   (dbplus)
   (command "undo" "e")
   (prin1)
)

