/* Allow ALIAS clause on most commands */

#command SET RELATION                                                   ;
         [<add:ADDITIVE>]                                               ;
         [TO <key1> INTO <(alias1)>                                ]    ;
         ALIAS <a>                                                      ;
                                                                        ;
      => if ( !<.add.> )                                                ;
       ;    <a> -> (dbClearRel())                                       ;
       ; end                                                            ;
                                                                        ;
       ; <a> -> (dbSetRelation( <(alias1)>, <{key1}>, <"key1"> ))

#command REINDEX              ALIAS <a> => <a> -> ( dbReindex() )
#command SET ORDER TO <n>     ALIAS <a> => <a> -> ( dbSetOrder( <n> ) )
#command SET ORDER TO         ALIAS <a> => <a> -> ( dbSetOrder(0) )
#command APPEND BLANK         ALIAS <a> => <a> -> ( dbAppend() )
#command PACK                 ALIAS <a> => <a> -> ( __dbPack() )
#command ZAP                  ALIAS <a> => <a> -> ( __dbZap() )
#command UNLOCK               ALIAS <a>  => <a> -> ( dbUnlock() )
#command UNLOCK ALL           ALIAS <a>  => <a> -> ( dbUnlockAll() )
#command COMMIT               ALIAS <a>  => <a> -> ( dbCommitAll() )
#command GOTO <n>             ALIAS <a>  => <a> -> ( dbGoto(<n>) )
#command GO <n>               ALIAS <a>  => <a> -> ( dbGoto(<n>) )
#command GOTO TOP             ALIAS <a>  => <a> -> ( dbGoTop() )
#command GO TOP               ALIAS <a>  => <a> -> ( dbGoTop() )
#command GOTO BOTTOM          ALIAS <a>  => <a> -> ( dbGoBottom() )
#command GO BOTTOM            ALIAS <a>  => <a> -> ( dbGoBottom() )
#command SEEK <xpr>           ALIAS <a>  => <a> -> ( dbSeek( <xpr> ) )
/* note FIND not included */
#command CONTINUE             ALIAS <a>  => <a> -> ( __dbContinue() )
#command LOCATE                                                         ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [ALL]                                                          ;
         ALIAS <a>                                                      ;
                                                                        ;
      => <a> -> ( __dbLocate( <{for}>, <{while}>, <next>, <rec>, <.rest.> ) )
#command SET FILTER TO        ALIAS <a>  => <a> -> ( dbClearFilter(NIL) )
#command SET FILTER TO <xpr>  ALIAS <a>  => <a> -> ( dbSetFilter( <{xpr}>, <"xpr"> ) )

#command SET FILTER TO <x:&>  ALIAS <a>                                 ;
      => if ( Empty(<(x)>) )                                            ;
       ;    <a> -> ( dbClearFilter()                                    ;
       ; else                                                           ;
       ;    <a> -> ( dbSetFilter( <{x}>, <(x)> )                        ;
       ; end
#command DELETE                                                         ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [ALL]                                                          ;
         ALIAS <a>                                                      ;
                                                                        ;
      => <a> -> ( DBEval(                                               ;
                 {|| dbDelete() },                                      ;
                 <{for}>, <{while}>, <next>, <rec>, <.rest.>            ;
               ) )
#command RECALL                                                         ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [ALL]                                                          ;
         ALIAS <a>                                                      ;
      => <a> -> ( DBEval(                                                        ;
                 {|| dbRecall()},                                       ;
                 <{for}>, <{while}>, <next>, <rec>, <.rest.>            ;
               ) )
#command DELETE               ALIAS <a>  =>  <a> -> ( dbDelete() )
#command RECALL               ALIAS <a>  =>  <a> -> ( dbRecall() )
#command SORT [TO <(file)>] [ON <fields,...>]                           ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [ALL]                                                          ;
         ALIAS <a>                                                      ;
      => <a> -> ( __dbSort(                                                      ;
                   <(file)>, { <(fields)> },                            ;
                   <{for}>, <{while}>, <next>, <rec>, <.rest.>          ;
                 ) )
#command TOTAL [TO <(file)>] [ON <key>]                                 ;
         [FIELDS <fields,...>]                                          ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [ALL]                                                          ;
         ALIAS <a>                                                      ;
      => <a> -> ( __dbTotal(                                                     ;
                    <(file)>, <{key}>, { <(fields)> },                  ;
                    <{for}>, <{while}>, <next>, <rec>, <.rest.>         ;
                  ) )
#command UPDATE [FROM <(alias)>] [ON <key>]                             ;
         [REPLACE <f1> WITH <x1> [, <fn> WITH <xn>]]                    ;
         [<rand:RANDOM>]                                                ;
         ALIAS <a>                                                      ;
      => <a> -> ( __dbUpdate(                                                    ;
                     <(alias)>, <{key}>, <.rand.>,                      ;
                     {|| _FIELD-><f1> := <x1> [, _FIELD-><fn> := <xn>]} ;
                   ) )
#command JOIN [WITH <(alias)>] [TO <file>]                              ;
         [FIELDS <fields,...>]                                          ;
         [FOR <for>]                                                    ;
         ALIAS <a>                                                      ;
      => <a> -> ( __dbJoin( <(alias)>, <(file)>, { <(fields)> }, <{for}> ) )
#command COUNT [TO <var>]                                               ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [ALL]                                                          ;
         ALIAS <a>                                                      ;
      => <var> := 0                                                     ;
       ; <a> -> ( DBEval(                                                        ;
                 {|| <var> := <var> + 1},                               ;
                 <{for}>, <{while}>, <next>, <rec>, <.rest.>            ;
               ) )
#command SUM [ <x1> [, <xn>]  TO  <v1> [, <vn>] ]                       ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [ALL]                                                          ;
         ALIAS <a>                                                      ;
      => <v1> := [ <vn> := ] 0                                          ;
       ; <a> -> ( DBEval(                                                        ;
                 {|| <v1> := <v1> + <x1> [, <vn> := <vn> + <xn> ]},     ;
                 <{for}>, <{while}>, <next>, <rec>, <.rest.>            ;
               ) )
#command AVERAGE [ <x1> [, <xn>]  TO  <v1> [, <vn>] ]                   ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [ALL]                                                          ;
         ALIAS <a>                                                      ;
      => M->__Avg := <v1> := [ <vn> := ] 0                              ;
                                                                        ;
       ; <a> -> ( DBEval(                                                        ;
                 {|| M->__Avg := M->__Avg + 1,                          ;
                 <v1> := <v1> + <x1> [, <vn> := <vn> + <xn>] },         ;
                 <{for}>, <{while}>, <next>, <rec>, <.rest.>            ;
               )                                                        ;
                                                                        ;
       ; <v1> := <v1> / M->__Avg [; <vn> := <vn> / M->__Avg ]
#command LIST [<list,...>]                                              ;
         [<off:OFF>]                                                    ;
         [<toPrint: TO PRINTER>]                                        ;
         [TO FILE <(toFile)>]                                           ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [ALL]                                                          ;
         ALIAS <a>                                                      ;
      => <a> -> ( __dbList(                                                      ;
                   <.off.>, { <{list}> }, .t.,                          ;
                   <{for}>, <{while}>, <next>, <rec>, <.rest.>,         ;
                   <.toPrint.>, <(toFile)>                              ;
                 ) )
#command DISPLAY [<list,...>]                                           ;
         [<off:OFF>]                                                    ;
         [<toPrint: TO PRINTER>]                                        ;
         [TO FILE <(toFile)>]                                           ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [<all:ALL>]                                                    ;
         ALIAS <a>                                                      ;
      => <a> -> ( __DBList(                                                      ;
                   <.off.>, { <{list}> }, <.all.>,                      ;
                   <{for}>, <{while}>, <next>, <rec>, <.rest.>,         ;
                   <.toPrint.>, <(toFile)>                              ;
                 ) )
#command REPORT FORM <frm>                                              ;
         [HEADING <heading>]                                            ;
         [<plain: PLAIN>]                                               ;
         [<noeject: NOEJECT>]                                           ;
         [<summary: SUMMARY>]                                           ;
         [<noconsole: NOCONSOLE>]                                       ;
         [<print: TO PRINTER>]                                          ;
         [TO FILE <(toFile)>]                                           ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [ALL]                                                          ;
         ALIAS <a>                                                      ;
      => <a> -> ( __ReportForm(                                                  ;
                       <(frm)>, <.print.>, <(toFile)>, <.noconsole.>,   ;
                       <{for}>, <{while}>, <next>, <rec>, <.rest.>,     ;
                       <.plain.>, <heading>,                            ;
                       <.noeject.>, <.summary.>                         ;
                     ) )
#command LABEL FORM <lbl>                                               ;
         [<sample: SAMPLE>]                                             ;
         [<noconsole: NOCONSOLE>]                                       ;
         [<print: TO PRINTER>]                                          ;
         [TO FILE <(toFile)>]                                           ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [ALL]                                                          ;
         ALIAS <a>                                                      ;
      => <a> -> ( __LabelForm(                                                   ;
                      <(lbl)>, <.print.>, <(toFile)>, <.noconsole.>,    ;
                      <{for}>, <{while}>, <next>, <rec>, <.rest.>,      ;
                      <.sample.>                                        ;
                    ) )

// NOTE:  CLOSE <alias> must precede the others
#command CLOSE <alias>          => <alias>->( dbCloseArea() )

#command CLOSE                  => dbCloseArea()
#command CLOSE DATABASES        => dbCloseAll()
#command CLOSE ALTERNATE        => Set(_SET_ALTFILE, "")
#command CLOSE FORMAT           => __SetFormat(NIL)
#command CLOSE INDEXES          => dbClearIndex()
#command CLOSE INDEXES ALIAS <a> => <a> -> (dbClearIndex())
#command CLOSE ALIAS <a>        => <a> -> (dbCloseArea())
#command CLOSE PROCEDURE        =>

#command CLOSE ALL                                                      ;
                                                                        ;
      => CLOSE DATABASES                                                ;
       ; SELECT 1                                                       ;
       ; CLOSE FORMAT

/* SETs with SAVE TO clauses */

#include "set.ch"

#command SET EXACT <x:ON,OFF,&>                     SAVE TO <y>         ;
      => <y> := Set( _SET_EXACT, <(x)> )

#command SET EXACT (<x>)                            SAVE TO <y>         ;
      => <y> := Set( _SET_EXACT, <x> )

#command SET FIXED <x:ON,OFF,&>                     SAVE TO <y>         ;
      => <y> := Set( _SET_FIXED, <(x)> )

#command SET FIXED (<x>)                            SAVE TO <y>         ;
      => <y> := Set( _SET_FIXED, <x> )

#command SET DECIMALS TO <x>                        SAVE TO <y>         ;
      => <y> := Set( _SET_DECIMALS, <x> )

#command SET DECIMALS TO                            SAVE TO <y>         ;
      => <y> := Set( _SET_DECIMALS, 0 )

#command SET PATH TO <*path*>                       SAVE TO <y>         ;
      => <y> := Set( _SET_PATH, <(path)> )

#command SET PATH TO                                SAVE TO <y>         ;
      => <y> := Set( _SET_PATH, "" )

#command SET DEFAULT TO <(path)>                    SAVE TO <y>         ;
      => <y> := Set( _SET_DEFAULT, <(path)> )

#command SET DEFAULT TO                             SAVE TO <y>         ;
      => <y> := Set( _SET_DEFAULT, "" )

#command SET CENTURY <x:ON,OFF,&>                   SAVE TO <y>         ;
      => <y> := __SetCentury( <(x)> )

#command SET CENTURY (<x>)                          SAVE TO <y>         ;
      => <y> := __SetCentury( <x> )

#command SET EPOCH TO <year>                        SAVE TO <y>         ;
      => <y> := Set( _SET_EPOCH, <year> )

#command SET DATE FORMAT [TO] <c>                   SAVE TO <y>         ;
      => <y> := Set( _SET_DATEFORMAT, <c> )

#define  _DFSETA(x, z)  <y> := Set(_SET_DATEFORMAT, iif(__SetCentury(), x, z))

#command SET DATE [TO] AMERICAN                     SAVE TO <y>         ;
      => _DFSETA( "mm/dd/yyyy", "mm/dd/yy" )

#command SET DATE [TO] ANSI                         SAVE TO <y>         ;
      => _DFSETA( "yyyy.mm.dd", "yy.mm.dd" )

#command SET DATE [TO] BRITISH                      SAVE TO <y>         ;
      => _DFSETA( "dd/mm/yyyy", "dd/mm/yy" )

#command SET DATE [TO] FRENCH                       SAVE TO <y>         ;
      => _DFSETA( "dd/mm/yyyy", "dd/mm/yy" )

#command SET DATE [TO] GERMAN                       SAVE TO <y>         ;
      => _DFSETA( "dd.mm.yyyy", "dd.mm.yy" )

#command SET DATE [TO] ITALIAN                      SAVE TO <y>         ;
      => _DFSETA( "dd-mm-yyyy", "dd-mm-yy" )

#command SET DATE [TO] JAPANESE                     SAVE TO <y>         ;
      => _DFSETA( "yyyy/mm/dd", "yy/mm/dd" )

#command SET DATE [TO] USA                          SAVE TO <y>         ;
      => _DFSETA( "mm-dd-yyyy", "mm-dd-yy" )

#command SET ALTERNATE <x:ON,OFF,&>                 SAVE TO <y>         ;
      => <y> := Set( _SET_ALTERNATE, <(x)> )

#command SET ALTERNATE (<x>)                        SAVE TO <y>         ;
      => <y> := Set( _SET_ALTERNATE, <x> )

#command SET ALTERNATE TO                           SAVE TO <y>         ;
      => <y> := Set( _SET_ALTFILE, "" )

#command SET ALTERNATE TO <(file)> [<add: ADDITIVE>] SAVE TO <y>        ;
      => <y> := Set( _SET_ALTFILE, <(file)>, <.add.> )

#command SET CONSOLE <x:ON,OFF,&>                   SAVE TO <y>         ;
      => <y> := Set( _SET_CONSOLE, <(x)> )

#command SET CONSOLE (<x>)                          SAVE TO <y>         ;
      => <y> := Set( _SET_CONSOLE, <x> )

#command SET MARGIN TO <x>                          SAVE TO <y>         ;
      => <y> := Set( _SET_MARGIN, <x> )

#command SET MARGIN TO                              SAVE TO <y>         ;
      => <y> := Set( _SET_MARGIN, 0 )

#command SET PRINTER <x:ON,OFF,&>                   SAVE TO <y>         ;
      => <y> := Set( _SET_PRINTER, <(x)> )

#command SET PRINTER (<x>)                          SAVE TO <y>         ;
      => <y> := Set( _SET_PRINTER, <x> )

#command SET PRINTER TO                             SAVE TO <y>         ;
      => <y> := Set( _SET_PRINTFILE, "" )

#command SET PRINTER TO <(file)> [<add: ADDITIVE>]  SAVE TO <y>         ;
      => <y> := Set( _SET_PRINTFILE, <(file)>, <.add.> )

#command SET DEVICE TO SCREEN                       SAVE TO <y>         ;
      => <y> := Set( _SET_DEVICE, "SCREEN" )

#command SET DEVICE TO PRINTER                      SAVE TO <y>         ;
      => <y> := Set( _SET_DEVICE, "PRINTER" )

#command SET COLOR TO [<*spec*>]                    SAVE TO <y>         ;
      => <y> := SetColor( #<spec> )

#command SET COLOR TO ( <c> )                       SAVE TO <y>         ;
      => <y> := SetColor( <c> )

#command SET COLOUR TO <*spec*>                     SAVE TO <y>         ;
      => SET COLOR TO <spec> SAVE TO <y>

#command SET CURSOR <x:ON,OFF,&>                    SAVE TO <y>         ;
      => <y> := SetCursor( if(Upper(<(x)>) == "ON", 1, 0) )

#command SET CURSOR (<x>)                           SAVE TO <y>         ;
      => <y> := SetCursor( if(<x>, 1, 0) )

#command SET BELL <x:ON,OFF,&>                      SAVE TO <y>         ;
      => <y> := Set( _SET_BELL, <(x)> )

#command SET BELL (<x>)                             SAVE TO <y>         ;
      => <y> := Set( _SET_BELL, <x> )

#command SET CONFIRM <x:ON,OFF,&>                   SAVE TO <y>         ;
      => <y> := Set( _SET_CONFIRM, <(x)> )

#command SET CONFIRM (<x>)                          SAVE TO <y>         ;
      => <y> := Set( _SET_CONFIRM, <x> )

#command SET ESCAPE <x:ON,OFF,&>                    SAVE TO <y>         ;
      => <y> := Set( _SET_ESCAPE, <(x)> )

#command SET ESCAPE (<x>)                           SAVE TO <y>         ;
      => <y> := Set( _SET_ESCAPE, <x> )

#command SET INTENSITY <x:ON,OFF,&>                 SAVE TO <y>         ;
      => <y> := Set( _SET_INTENSITY, <(x)> )

#command SET INTENSITY (<x>)                        SAVE TO <y>         ;
      => <y> := Set( _SET_INTENSITY, <x> )

#command SET SCOREBOARD <x:ON,OFF,&>                SAVE TO <y>         ;
      => <y> := Set( _SET_SCOREBOARD, <(x)> )

#command SET SCOREBOARD (<x>)                       SAVE TO <y>         ;
      => <y> := Set( _SET_SCOREBOARD, <x> )

#command SET DELIMITERS <x:ON,OFF,&>                SAVE TO <y>         ;
      => <y> := Set( _SET_DELIMITERS, <(x)> )

#command SET DELIMITERS (<x>)                       SAVE TO <y>         ;
      => <y> := Set( _SET_DELIMITERS, <x> )

#command SET DELIMITERS TO <c>                      SAVE TO <y>         ;
      => <y> := Set( _SET_DELIMCHARS, <c> )

#command SET DELIMITERS TO DEFAULT                  SAVE TO <y>         ;
      => <y> := Set( _SET_DELIMCHARS, "::" )

#command SET DELIMITERS TO                          SAVE TO <y>         ;
      => <y> := Set( _SET_DELIMCHARS, "::" )

#command SET WRAP <x:ON,OFF,&>                      SAVE TO <y>         ;
      => <y> := Set( _SET_WRAP, <(x)> )

#command SET WRAP (<x>)                             SAVE TO <y>         ;
      => <y> := Set( _SET_WRAP, <x> )

#command SET MESSAGE TO <n> [<cent: CENTER, CENTRE>] SAVE TO <y>        ;
      => <y> := {Set( _SET_MESSAGE, <n> ), Set( _SET_MCENTER, <.cent.> ) }

#command SET MESSAGE TO                             SAVE TO <y>         ;
      => <y> := {Set( _SET_MESSAGE, 0 ), Set( _SET_MCENTER, .f. ) }

#command SET TYPEAHEAD TO <n>                       SAVE TO <y>         ;
      => <y> := Set( _SET_TYPEAHEAD, <n> )

#command SET KEY <n> TO <proc>                      SAVE TO <y>         ;
      => <y> := SetKey( <n>, {|p, l, v| <proc>(p, l, v)} )

#command SET KEY <n> TO <proc> ( [<list,...>] )     SAVE TO <y>         ;
      => SET KEY <n> TO <proc> SAVE TO <y>

#command SET KEY <n> [TO]                           SAVE TO <y>         ;
      => <y> := SetKey( <n>, NIL )

#command SET FUNCTION <n> [TO] [<c>]                SAVE TO <y>         ;
      => <y> := __SetFunction( <n>, <c> )

#command SET EXCLUSIVE <x:ON,OFF,&>                 SAVE TO <y>         ;
      =>  <y> := Set( _SET_EXCLUSIVE, <(x)> )

#command SET EXCLUSIVE (<x>)                        SAVE TO <y>         ;
      =>  <y> := Set( _SET_EXCLUSIVE, <x> )

#command SET SOFTSEEK <x:ON,OFF,&>                  SAVE TO <y>         ;
      =>  <y> := Set( _SET_SOFTSEEK, <(x)> )

#command SET SOFTSEEK (<x>)                         SAVE TO <y>         ;
      =>  <y> := Set( _SET_SOFTSEEK, <x> )

#command SET UNIQUE <x:ON,OFF,&>                    SAVE TO <y>         ;
      =>  <y> := Set( _SET_UNIQUE, <(x)> )

#command SET UNIQUE (<x>)                           SAVE TO <y>         ;
      =>  <y> := Set( _SET_UNIQUE, <x> )

#command SET DELETED <x:ON,OFF,&>                   SAVE TO <y>         ;
      =>  <y> := Set( _SET_DELETED, <(x)> )

#command SET DELETED (<x>)                          SAVE TO <y>         ;
      =>  <y> := Set( _SET_DELETED, <x> )

#command SET ORDER TO <n>                           SAVE TO <y>         ;
      => <y> := dbSetOrder( <n> )

#command SET ORDER TO                               SAVE TO <y>         ;
      => <y> := dbSetOrder(0)


