#define LOOPING .y.
#define ENDWHILE END
#define CRLF chr(13)+chr(10)
#define CTRL_Z chr(26)
#define CR chr(13)
#define LF chr(10)
#define FORMFEED chr(12)

#xcommand INT86 <int>                                                   ;
          [AX <ax>]                                                     ;
          [BX <bx>]                                                     ;
          [CX <cx>]                                                     ;
          [DX <dx>]                                                     ;
          [AL <al>]                                                     ;
          [AH <ah>]                                                     ;
          [BL <bl>]                                                     ;
          [BH <bh>]                                                     ;
          [CL <cl>]                                                     ;
          [CH <ch>]                                                     ;
          [DL <dl>]                                                     ;
          [DH <dh>]                                                     ;
      =>  pInt86(<int>, <ax>, <bx>, <cx>, <dx>, <ah>, <al>, <bh>, <bl>,;
                 <ch>, <cl>, <dh>, <dl>)

#command COMPUTE  [INTO ] <tarray>                                      ;
                  FROM <farray>                                         ;
                  [FOR <for>]                                           ;
                  [WHILE <while>]                                       ;
                  [NEXT <next>]                                         ;
                  [RECORD <rec>]                                        ;
                  [<rest:REST>]                                         ;
                  [ALL]                                                 ;
            =>    <tarray> := {},                                       ;
                  aEval(<farray>, {||aAdd(<tarray>, 0)})

#command USE                    => dbClearRel()                         ;
                                 ; dbCloseArea()

#command CLOSE                  => USE

#command @ <row>, <col> GET <var>                                    ;
            [PICTURE <pic>]                                          ;
            [VALID <valid>]                                          ;
            [WHEN <when>]                                            ;
            [COLOR <color>]                                          ;
            [MESSAGE <message>]                                      ;
            [POPUP <pop>]                                            ;
            [EXIT [WITH] <exitkey>]                                  ;
            [<date: DATESET>]                                        ;
            [IDLE <idleB>]                                           ;
            [MEMO [AT] <memoTR>, <memoTC>, <memoBR>, <memoBC>]       ;
                                                                     ;
         => SetPos( <row>, <col> ); aAdd( GetList,                   ;
            _GET_( <var>, <(var)>, <pic>, <{valid}>, <{when}> ) )    ;
            ; aTail(GetList):reader := {|oGet| vGet(oGet)}           ;
            [ ; aTail(GetList):colorDisp( <color> ) ]                ;
            ; aTail(GetList):cargo := {}                             ;
            [; aAdd(aTail(GetList):cargo, {"M", <"message"> } ) ]    ;
            [; aAdd(aTail(GetList):cargo, {"E", <(exitkey)> } ) ]    ;
            [; aAdd(aTail(GetList):cargo, {"I", <{idleB}> } ) ]      ;
            [; aAdd(aTail(GetList):cargo, {"P", <{pop}> } ) ]        ;
            [; aAdd(aTail(GetList):cargo, {"Z", { <memoTR>, <memoTC>, <memoBR>, <memoBC> } } ) ; aTail(GetList):picture := ""] ;
            [; iif( <.date.>, aAdd(aTail(GetList):cargo, {"D"} ), ) ]

#command READ [IDLE <bExec> [TIME <nSecs>] ]                         ;
      => iReadIdle( [ <{bExec}> ] [, <nSecs>] )                      ;
       ; ReadModal(GetList)                                          ;
       ; GetList := {}

#command DEFAULT <var1> TO <val1> [, <varN> TO <valN>]               ;
                                                                     ;
         => iif( <var1> = NIL, <var1> := <val1> ,)                   ;
            [; iif( <varN> = NIL, <varN> := <valN> ,)]

#command ADDRECORD            => fAddRecord()
#command ADDRECORD ALIAS <a>  => <a> -> ( fAddRecord() )
#command LOCK                 => fLockRec()
#command LOCK ALIAS <a>       => <a> -> ( fLockRec() )

/* #xtranslate INDICES => INDEXES */

#command INITIALIZE <var1> TO <val1> [, <varN> TO <valN>]            ;
                                                                     ;
         => iif( Type( <"var1"> ) = "U", <var1> := <val1> ,)         ;
            ; [iif( Type( <"varN"> ) = "U", <varN> := <valN> ,)]

#command FORCETYPE <AnyType1> TO <SetType1> [, <AnyTypeN> TO <SetTypeN>]     ;
            => pSetType({|uNewValue|iif(uNewValue=NIL,                       ;
                        <AnyType1>, <AnyType1> := uNewValue)}, <"SetType1">) ;
             [;pSetType({|uNewValue|iif(uNewValue=NIL,                       ;
                        <AnyTypeN>, <AnyTypeN> := uNewValue)}, <"SetTypeN">)]

#command ENDFUNCTION    => RETURN NIL
#command ENDPROCEDURE   => RETURN

#command SET SAVETIME TO <n>                 => pSetSaver( <n> )
#command SET SAVETIME TO                     => pSetSaver( 0 )
#command SET SAVEBLOCK TO <todo>             => pSetSaver( , <{todo}> )
#command SET SAVEBLOCK TO                    => pSetSaver( , Default() )

#command BEGIN BLOCK    => WHILE LOOPING
#command ENDBLOCK       => EXIT; ENDWHILE
#command END BLOCK      => EXIT; ENDWHILE

#command BROWSE               => fBrowse()
#command BROWSE ALIAS <a>     => <a> -> ( fBrowse() )

#command WRITE LINE TO <nFile> ;
         => fWrite( <nFile> , CRLF ) 

#command WRITE [<line: LINE>] <cLine> TO <nFile> ;
         => fWrite( <nFile> , <cLine> +iif( <.line.> , CRLF, "") )
