/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      DISTRIBUTE ONLY WITH SHAREWARE
    Winston-Salem NC 27116            VERSION OF THIS PRODUCT.
    Fax: 919/760-1003

*/

/* THIS PROGRAM HAS NOT BEEN SET TO BECKNERVISION'S CLIPPER 5 STANDARD */

#include "beckner.inc"

*BecknerVision dBase On-Site Assistant
*Copyright (c)1989 John Wm Beckner - All Rights Reserved

EXTERNAL NetName

#include "beckner.inc"

FUNCTION bvAssist(cFileName, cIndices)
   PRIVATE cFilter := "", cVersion := '5.1', lUseColor, nWRow, nWCol
   PRIVATE nStartRec, nEndRec, cScreen, lChanged := .n., lAbort := .n.
   PRIVATE cDBFName, cNTXStr
   SET EXCLUSIVE OFF
   iShare(.y.)
   cScreen := vSave()
   SET CURSOR on
   SET KEY -6 to red_alert
   SET KEY -8 to ctrl_w
   STORE 0 to nWRow, nWCol, nStartRec, nEndRec
   SET TYPEAHEAD to 200
   cDBFName := space(20)
   IF cFileName!=NIL
      KEYBOARD chr(13)
      cDBFName := sSetLength(cFileName,20)
   ENDIF
   IF iscolor()
      lUseColor := .y.
      SET COLOR to bg,b/w
   ELSE
      lUseColor := .n.
      SET COLOR to
   ENDIF
   cNTXStr := space(50)
   IF cIndices!=NIL
      cNTXStr := cIndices
      KEYBOARD chr(13)
   ENDIF
   WHILE LOOPING
      iif(file('\bvdbase.dbf'), fKill('\bvdbase.db?'), NIL)
      new_dbf := .n.
      CLS
      @ 1,0 say 'BecknerVision dBase On-Site Assistant '+cVersion
      @ 2,0 say 'Copyright (c)1989, 1991 John Wm Beckner - All Rights Reserved'
      @ 3,0 to 23,79 double
      IF '.'$cDBFName
         cDBFName := left(cDBFName,at('.',cDBFName)-1)
      ENDIF
      IF len(cDBFName)<20
         cDBFName := cDBFName+left(space(20),20-len(cDBFName))
      ENDIF
      IF len(cNTXStr)<50
         cNTXStr := sSetLength(cNTXStr,50)
      ENDIF
      @ 4,1 say 'Filename:' get cDBFName picture '@!K'
      @ 4,col()+3 say '(<F7> Emergency/<F8> Abort/<F9> ctrl-W)'
      @ 5,1 say 'Indices: ' get cNTXStr picture '@!K'
      READ
      cDBFName := trim(cDBFName)
      IF empty(cDBFName)
         yes := .y.
         @ 24,0 say chr(7)+'Quit (Y/N)? ' get yes picture 'Y'
         READ
         IF yes
            vRestore(cScreen)
            QUIT
         ELSE
            LOOP
         ENDIF
      ENDIF
      IF '?'$cDBFName.or.'*'$cDBFName
         dirchk(cDBFName)
         LOOP
      ENDIF
      IF !'.'$cDBFName
         cDBFName := trim(cDBFName)+'.DBF'
      ENDIF
      IF !file(cDBFName)
         yes := .n.
         @ 24,0 say chr(7)+'Create empty database (Y/N)?' get yes picture 'Y'
         READ
         @ 24,0
         IF yes
            new_dbf := .y.
         ELSE
            @ 24,0 say chr(7)+'File not found!  Press any key to continue...'
            inkey(30)
            @ 24,0
            LOOP
         ENDIF
      ENDIF
      IF new_dbf
         yes := .y.
         @ 24,0 say chr(7)+'Use STRUCT.DBF' GET YES PICT 'y'
         READ
         @ 24,0
         IF yes
            COPY FILE \struct.dbf to \bvdbase.dbf
            CREATE (cDBFName) from \struct
            USE \bvdbase exclusive
            new_dbf := .n.
         ELSE
            CREATE \bvdbase
         ENDIF
      ELSE
         fShare(cDBFName)
         cNTXStr := trim(cNTXStr)
         IF !empty(cNTXStr)
            ntemp := cNTXStr
            WHILE !empty(ntemp)
               nt := sParse(@ntemp,',')
               nt += iif('.'$nt,'','.ntx')
               IF !file(nt)
                  cr_ntx := .n.
                  @ 24,0 say chr(7)+'Create new index (Y/N)?' get cr_ntx picture 'Y'
                  READ
                  @ 24,0
                  IF !cr_ntx
                     LOOP
                  ENDIF
                  ke := space(50)
                  @ 24,0 say chr(7)+'Key expression:' get ke
                  READ
                  @ 24,0
                  ke := trim(ke)
                  @ 24,0 say chr(7)+'Indexing...'
                  inde on &(ke) to (cNTXStr)
                  @ 24,0
                  SET INDEX to
               ENDIF
            ENDWHILE
         ENDIF
         COPY STRUCTURE EXTENDED to \bvdbase
         USE \bvdbase excl
      ENDIF
      SET MESSAGE to 24
      lChanged := .n.
      WHILE LOOPING
         lAbort := .n.
         IF lUseColor
            SET COLOR to bg,b/w
         ELSE
            SET COLOR to
         ENDIF
         @ 24,0
         IF new_dbf
            DO dbf_a
            LOOP
         ENDIF
         SET KEY -7 to
         @ 6,1 clear to 22,78
         IF lChanged
            SET COLOR to i*
            @ 3,0 to 23,79 double
            IF lUseColor
               SET COLOR to bg,b/w
            ELSE
               SET COLOR to
            ENDIF
         ENDIF
         GO TOP
         IF !empty(cFilter)
            @ 22,70 say 'FILTER'
         ENDIF
         @ 6,1 prompt 'A. Add    ' message 'Adds a new field to the exisiting database'
         @ 7,1 prompt 'B. Delete ' message 'Removes an existing field from the current database'
         @ 8,1 prompt 'C. Change ' message [Lets you change a field's parameters]
         @ 9,1 prompt 'D. Display' message 'Displays the structure of the current database'
         @ 10,1 prompt 'E. Print  ' message 'Prints the database structure on the printer'
         @ 11,1 prompt 'F. Ed/Add ' message 'Edit an actual record from the database or Add a new record'
         @ 12,1 prompt 'G. Rep/Del' message 'Replace or delete DATA in actual database records'
         @ 13,1 prompt 'H. Struct ' message 'Create Structure file'
         @ 14,1 prompt 'I. ZapAll ' message 'ZAP ALL DATA!!!'
         @ 15,1 prompt 'J. Browse ' message 'dBase style record browse'
         @ 16,1 prompt 'K. Pack   ' message 'Actually pack all data'
         @ 17,1 prompt 'L. Append ' message 'Adds records to the current database from another file'
         @ 18,1 prompt 'M. Sets   ' message 'Toggle logical Set values'
         @ 19,1 prompt 'N. Stat/++' message 'Statistics about the file, Expression evaluation'
         @ 20,1 prompt 'Q. Quit   ' message 'Quits this database file'
         opt := 4
         MENU to opt
         @ 24,0
         @ 6,1 clear to 22,78
         IF opt=15
            DO chk_chg
            EXIT
         ENDIF
         IF opt=0
            LOOP
         ENDIF
         a := chr(64+opt)
         SET KEY -7 to reg_abt
         DO CASE
         CASE a='A'
            DO dbf_a
         CASE a='B'
            DO dbf_b
         CASE a='C'
            DO dbf_c
         CASE a='D'
            DO dbf_d
         CASE a='E'
            DO dbf_e
         CASE a='F'
            DO dbf_f
         CASE a='G'
            DO dbf_g
         CASE a='H'
            DO dbf_h
         CASE a='I'
            DO dbf_i
         CASE a='J'
            DO dbf_j
         CASE a='K'
            DO dbf_k
         CASE a='L'
            DO dbf_l
         CASE a='M'
            DO dbf_m
         CASE a='N'
            DO dbf_n
         ENDCASE
      ENDWHILE
   ENDWHILE
ENDFUNCTION

***** Add field
PROCEDURE dbf_a
   WHILE LOOPING
      WHILE LOOPING
         @ 6,1 clear to 14,70
         @ 6,1 say 'Adding a field'
         fld_name := '          '
         GO BOTTOM
         @ 8,1 say 'Last field:'
         @ 8,col()+1 say field_name
         @ 8,col()+1 say field_type
         @ 8,col()+1 say field_len
         @ 8,col()+1 say field_dec
         @ 10,1 say 'Enter field name .......' get fld_name picture '@! AXXXXXXXXX'
         @ 10,col()+2 say '(<F6> to change last)'
         fld_type := 'C'
         @ 11,1 say 'Field type (C/N/L/M/D) .' get fld_type picture '@! A' valid fld_type$'CNLMDR'
         @ 11,col()+2 say '(R/epeat last)'
         SET KEY -5 to modlast
         READ
         SET KEY -5 to
         IF lAbort .or. empty(fld_name)
            //RETURNX
         ENDIF
         LOCATE FOR fld_name==field_name
         IF found()
            @ 24,0 say chr(7)+'Field name already exists as field #'+str(recno(),3)+'.  Press any key...'
            inkey(30)
            @ 24,0
            LOOP
         ENDIF
         fld_dec := 0
         IF fld_type='M'
            fld_len := 10
         ELSEIF fld_type='D'
            fld_len := 8
         ELSEIF fld_type='L'
            fld_len := 1
         ELSEIF fld_type='R'
            GO BOTTOM
            fld_type := field_type
            fld_len := field_len
            fld_dec := field_dec
            @ 12,1 say 'REPEATING:'
            @ 12,col()+2 say fld_type
            @ 12,col()+1 say fld_len
            @ 12,col()+1 say fld_dec
         ELSE
            fld_len := 0
            @ 12,1 say 'Field length ...........' get fld_len picture '999'
            IF fld_type='N'
               @ 13,1 say 'Field decimals .........' get fld_dec picture '999'
            ENDIF
            READ
            IF lAbort
               RETURN
            ENDIF
         ENDIF
         yes := .y.
         @ 14,1 say 'Accept (Y/N)?' get yes picture 'Y'
         READ
         IF yes
            EXIT
         ENDIF
      ENDWHILE
      APPEND BLANK
      REPLACE field_name with fld_name,field_type with fld_type,field_len with fld_len,field_dec with fld_dec
      lChanged := .y.
      IF new_dbf
         USE
         CREATE (cDBFName) from \bvdbase
         USE
         USE \bvdbase excl
         EXIT
      ENDIF
   ENDWHILE
   new_dbf := .n.
ENDPROCEDURE

***** Check FOR changes and make 'em
PROCEDURE chk_chg
   IF !lChanged
      RETURN
   ENDIF
   lChanged := .n.
   @ 3,0 to 23,79 double
   SET COLOR to i*
   @ 11,11 say '* * *   C H A N G E   I M P L E M E N T A T I O N   * * *'
   IF lUseColor
      SET COLOR to bg,b/w
   ELSE
      SET COLOR to
   ENDIF
   USE
   CREATE bvtemp from \bvdbase
   APPEND FROM (cDBFName)
   USE
   ERASE (cDBFName)
   RENAME bvtemp.dbf to (cDBFName)
   IF file('bvtemp.dbt')
      b := substr(cDBFName,1,len(cDBFName)-1)+'t'
      ERASE (b)
      RENAME bvtemp.dbt to (b)
   ENDIF
   fShare(cDBFName)
   ERASE \bvdbase.dbf
   COPY stru exte to \bvdbase
   USE \bvdbase excl
   @ 11,11 say space(64)
ENDPROCEDURE

*****DELETE A FIELD
PROCEDURE dbf_b
   rec := 0
   @ 6,1 say 'Field # to delete ...' get rec picture '999'
   READ
   IF lAbort
      RETURN
   ENDIF
   IF rec<1 .or. rec>reccount()
      @ 24,0 say chr(7)+'Invalid field #.  Press any key to continue...'
      inkey(30)
      @ 24,0
      RETURN
   ENDIF
   GO rec
   @ 8,1 say field_name
   @ 8,col()+2 say field_type
   @ 8,col()+2 say field_len
   @ 8,col()+2 say field_dec
   yes := .n.
   @ 10,1 say 'Delete this field (Y/N)?' get yes picture 'Y'
   READ
   IF yes .and. !lAbort
      DELETE
      @ 24,0 say chr(7)+'Packing...'
      PACK
      @ 24,0
      lChanged := .y.
   ENDIF
ENDPROCEDURE

***** CHANGE FIELDS
PROCEDURE dbf_c
   rec := 0
   @ 6,1 say 'Starting field #' get rec picture '999'
   READ
   IF lAbort
      RETURN
   ENDIF
   @ 6,1 clear to 6,70
   IF rec<1 .or. rec>reccount()
      @ 24,0 say chr(7)+'Field # out of range.  Press any key to continue...'
      inkey(30)
      @ 24,0
      RETURN
   ENDIF
   GO rec
   WHILE LOOPING
      @ 6,1 say 'Field name ........' get field_name picture '@!'
      @ 7,1 say 'Type (C/L/N/D/M) ..' get field_type picture '@! A' valid field_type$'CLNDM'
      @ 8,1 say 'Length ............' get field_len valid (field_type='L'.and.field_len=1).or.(field_type='M'.and.field_len=10).or.(field_type='D'.and.field_len=8).or.field_type$'NC'
      @ 9,1 say 'Decimals ..........' get field_dec
      READ
      IF recno()<reccount() .and. !lAbort
         nxt := .y.
         @ 11,1 say 'Next field (Y/N)?' get nxt picture 'Y'
         READ
         IF nxt
            SKIP
            LOOP
         ENDIF
      ENDIF
      lChanged := .y.
      RETURN
   ENDWHILE
ENDPROCEDURE

***** DISPLAY STRUCTURE
PROCEDURE dbf_d
   nLineCtr := 6
   start_no := 1
   @ 24,0 say 'Starting field # to display:' get start_no picture '999'
   @ 24,col()+1 say '(0=reverse display)'
   READ
   @ 24,0
   IF start_no<0 .or. start_no>reccount()
      @ 24,0 say 'Invalid field #.'
      inkey(5)
      @ 24,0
      RETURN
   ENDIF
   IF start_no=0
      rev_order := .y.
      GO BOTTOM
   ELSE
      rev_order := .n.
      GO start_no
   ENDIF
   WHILE !(eof() .or. (bof() .and. rev_order))
      @ 6,1 clear to 22,78
      WHILE !(eof() .or. (rev_order .and. bof())) .and. nLineCtr<=20
         IF rev_order .and. nLineCtr=6 .and. reccount()=recno()
            @ nLineCtr,3 say '**end**'
            nLineCtr++
            LOOP
         ENDIF
         @ nLineCtr,1 say recno() picture '999'
         @ nLineCtr,col()+2 say field_name
         @ nLineCtr,col()+2 say field_type
         @ nLineCtr,col()+2 say field_len
         @ nLineCtr,col()+2 say field_dec
         nLineCtr++
         IF rev_order
            SKIP -1
         ELSE
            SKIP
         ENDIF
      ENDWHILE
      IF eof() .or. (bof() .and. rev_order)
         @ row()+1,3 say '**end**'
      ENDIF
      nLineCtr := 6
      @ 22,1 say 'PRESS ANY KEY TO CONTINUE...'
      x_x := inkey(0)
      IF lAbort .or. x_x=-7
         EXIT
      ENDIF
   ENDWHILE
ENDPROCEDURE

*****PRINT STRUCTURE
PROCEDURE dbf_e
   GO TOP
   SET PRINT on
   SET CONSOLE off
   @ 24,0 say chr(7)+'Printing...'
   ? 'Structure FOR',cDBFName
   ?
   WHILE !eof()
      ? transform(recno(),'999'),field_name,''
      DO CASE
      CASE field_type='C'
         ?? 'Character',field_len
      CASE field_type='D'
         ?? 'Date'
      CASE field_type='M'
         ?? 'Memo'
      CASE field_type='N'
         ?? 'Numeric  ',field_len,iif(field_dec=0,'',field_dec)
      CASE field_type='L'
         ?? 'Logical'
      ENDCASE
      SKIP
   ENDWHILE
   ?
   @ 24,0
   SET PRINT off
   SET CONSOLE on
ENDPROCEDURE


***** EDIT/ADD A RECORD
PROCEDURE dbf_f
   MEMVAR cFilter
   DO chk_chg
   ae := 'A'
   @ 24,0 say chr(7)+'A/dd or E/dit ...' get ae picture '@! A' valid ae$'AE'
   READ
   IF lAbort
      RETURN
   ENDIF
   @ 24,0
   IF ae='E'
      rec := 0
      @ 24,0 say chr(7)+'Record #' get rec picture '99999'
      READ
      IF lAbort
         RETURN
      ENDIF
      @ 24,0
      SELECT b
      fShare(cDBFName)
      IF !empty(cFilter)
         SET FILTER to &(cFilter)
      ENDIF
      IF rec<1 .or. rec>reccount()
         @ 24,0 say chr(7)+'Max rec is #'+str(reccount(),5)+'.   Press any key to continue...'
         inkey(30)
         @ 24,0
         USE
         SELECT a
         RETURN
      ENDIF
      IF !empty(cNTXStr)
         o_indices()
      ENDIF
      GO rec
      fLockRec()
   ELSE
      SELECT b
      fShare(cDBFName)
      IF !empty(cFilter)
         SET FILTER to &(cFilter)
      ENDIF
      IF !empty(cNTXStr)
         o_indices()
      ENDIF
      fAddRecord()
      rec := recno()
   ENDIF
   nLineCtr := 6
   SELECT a
   WHILE !eof()
      @ 6,1 clear to 20,77
      WHILE !eof() .and. nLineCtr<=20
         a := trim(field_name)
         IF field_len>65
            @ nLineCtr,1 say field_name get b->&a. picture '@S65'
         ELSE
            @ nLineCtr,1 say field_name get b->&a.
         ENDIF
         nLineCtr++
         SKIP
      ENDWHILE
      READ
      IF lAbort
         EXIT
      ENDIF
      nLineCtr := 6
   ENDWHILE
   SELECT b
   UNLOCK
   USE
   SELECT a
ENDPROCEDURE


***** PRESS <CTRL-W>
PROCEDURE ctrl_w
   KEYBOARD chr(23)
ENDPROCEDURE


***** REGULAR ABORT
PROCEDURE reg_abt
   KEYBOARD chr(23)
   lAbort := .y.
ENDPROCEDURE


***** RED ALERT, ABORT NOW
PROCEDURE red_alert
   IF lChanged
      yes := .n.
      SET COLOR to i*
      @ 11,11 say 'WARNING!  Changes have been made.  Abandon changes (Y/N)?' get yes picture 'Y'
      READ
      IF lUseColor
         SET COLOR to bg,b/w
      ELSE
         SET COLOR to
      ENDIF
      IF !yes
         DO chk_chg
      ENDIF
   ENDIF
   vRestore(cScreen)
   QUIT
ENDPROCEDURE

***** REPLACING DATA
PROCEDURE dbf_g
   MEMVAR cFilter
   DO chk_chg
   @ 6,1 say 'REPLACING DATA'
   no_flds := 1
   rtype := 'C'
   @ 8,1 say '# of fields to replace (99=delete) .............' get no_flds picture '99' rang 0,99
   @ 9,1 say 'Replace C/urrent, A/ll or by F/ilter (C/A/F) ...' get rtype picture '@! A' valid rtype$'CAF'
   READ
   IF lAbort
      RETURN
   ENDIF
   IF no_flds=0
      @ 24,0 say chr(7)+'You specified 0 fields to replace.  Press any key to continue...'
      inkey(30)
      @ 24,0
      RETURN
   ENDIF
   IF rtype='F'
      flt := space(254)
      @ 10,1 say 'Enter filter:' get flt picture '@S40'
      READ
      IF lAbort
         RETURN
      ENDIF
   ENDIF
   IF no_flds<99
      nCtr := 1
      WHILE nCtr<=no_flds
         a := str(no_flds,iif(no_flds<10,1,2))
         fld&a. := space(10)
         data&a. := space(254)
         @ 12,1 clear to 20,78
         @ 12,1 say nCtr picture '99'
         @ 13,1 say 'Field name .....' get fld&a. picture '@!'
         @ 14,1 say 'Replacement data' get data&a. picture '@S55'
         READ
         IF lAbort
            RETURN
         ENDIF
         LOCATE FOR fld&a.==field_name
         IF !found()
            @ 24,0 say chr(7)+'Field name not found.  Press any key to retry...'
            inkey(30)
            @ 24,0
            LOOP
         ENDIF
         nCtr++
      ENDWHILE
   ENDIF
   @ 12,1 clear to 20,78
   SELECT b
   fShare(cDBFName)
   IF !empty(cNTXStr)
      o_indices()
   ENDIF
   IF !empty(cFilter)
      SET FILTER to &(cFilter)
   ENDIF
   IF rtype='C'
      rec := 0
      @ 12,1 say 'Record #' get rec picture '999999'
      READ
      IF lAbort
         USE
         SELECT a
         RETURN
      ENDIF
      IF rec<1.or.rec>reccount()
         USE
         SELECT a
         @ 24,0 say chr(7)+'Invalid record #.  Press any key to continue...'
         inkey(30)
         @ 24,0
         RETURN
      ENDIF
      GO rec
      fLockRec()
      IF no_flds=99
         DELETE
      ELSE
         DO cur_REPLACE
      ENDIF
      UNLOCK
   ELSE
      @ 24,0 say reccount() picture '999,999'
      WHILE !eof()
         @ 24,10 say recno() picture '999,999'
         IF rtype='F'
            IF !(&flt.)
               SKIP
               LOOP
            ENDIF
         ENDIF
         fLockRec()
         IF no_flds=99
            DELETE
         ELSE
            DO cur_REPLACE
         ENDIF
         UNLOCK
         SKIP
      ENDWHILE
   ENDIF
   USE
   SELECT a
   @ 24,0
ENDPROCEDURE


PROCEDURE cur_REPLACE
   priv nCtr,a,b,c
   nCtr := 1
   WHILE nCtr<=no_flds
      a := str(nCtr,iif(nCtr<10,1,2))
      b := trim(fld&a.)
      c := trim(data&a.)
      fLockRec()
      REPLACE &(b) with &(c)
      UNLOCK
      nCtr++
   ENDWHILE
ENDPROCEDURE


***** CREATE STRUCTURE FILE
PROCEDURE dbf_h
   @ 24,0
   @ 24,0 say 'Creating structure file \STRUCT.DBF...'
   COPY to \struct
   @ 24,0
ENDPROCEDURE


***** ZAP ALL DATA
PROCEDURE dbf_i
   IF !vIsSure()
      RETURN
   ENDIF
   SELECT b
   fNoShare(cDBFName)
   IF !empty(cNTXStr)
      o_indices()
   ENDIF
   set safe off
   ZAP
   PACK
   USE
   SELECT a
ENDPROCEDURE


***** BROWSE
PROCEDURE dbf_j
   MEMVAR cFilter
   DO chk_chg
   SELECT b
   scr := savescreen(0,0,24,79)
   fNoShare(cDBFName)
   IF !empty(cNTXStr)
      o_indices()
   ENDIF
   IF !empty(cFilter)
      SET FILTER to &(cFilter)
   ENDIF
   rec := 1
   SEEK_str := space(50)
   @ 6,1 say 'BROWSING'
   @ 8,1 say 'Starting record #' get rec picture '999999'
   @ 9,1 say 'Seek string:     ' get SEEK_str
   READ
   SEEK_str := trim(SEEK_str)
   IF rec=999999
      GO TOP
   ELSEIF rec<1 .or. rec>reccount()
      @ 24,0 say chr(7)+'Illegal record number.  Press any key to continue...'
      inkey(30)
      @ 24,0
      USE
      SELECT a
      RETURN
   ELSEIF !empty(SEEK_str)
      SEEK &SEEK_str.
   ELSE
      go rec
   ENDIF
   CLS
   SET KEY -2 to set_st
   SET KEY -3 to set_end
   SET KEY -4 to activ
   @ 0, 0
   @ 24,0 say '<F3>=Set start record  <F4>=Set end record  <F5>=Activate block commands'
   fBrowse()
   @ 24,0
   SET KEY -4 to
   SET KEY -3 to
   SET KEY -2 to
   USE
   restscreen(0,0,24,79,scr)
   SELECT a
   UNLOCK
ENDPROCEDURE


***** SET START RECORD
PROCEDURE set_st
   nStartRec := recno()
   @ 0,5 say nStartRec picture '9,999,999'
ENDPROCEDURE


***** SET END RECORD
PROCEDURE set_end
   nEndRec := recno()
   @ 0,15 say nEndRec picture '9,999,999'
ENDPROCEDURE


***** ACTIVATE BLOCK COMMANDS
PROCEDURE activ
   LOCAL x,a, nCurSel
   IF nStartRec=0.or.nEndRec=0
      RETURN
   ENDIF
   nCurSel := Select()
   @ 24,0
   @ 24,0 say 'D/elete  C/opy  A/bort'
   x := inkey(10)
   @ 24,0
   @ 24,0 say '<F3>=Set start record  <F4>=Set end record  <F5>=Activate block commands'
   a := upper(chr(x))
   IF a="D"
      GO nStartRec
      WHILE nEndRec<>recno()
         DELETE
         SKIP
      ENDWHILE
      DELETE
   ELSEIF a="C"
      GO nStartRec
      COPY to bv$$$ whil nEndRec<>recno()
      COPY NEXT 1 to xx$$$
      SELECT 122
      USE bv$$$ excl
      APPEND FROM xx$$$
      ERASE xx$$$.dbf
      IF file('xx$$$.dbt')
         ERASE xx$$$.dbt
      ENDIF
      SELECT (Select(nCurSel))
   ENDIF
   STORE 0 to nStartRec, nEndRec
   @ 0,5 say space(30)
ENDPROCEDURE


***** PACK DATA
PROCEDURE dbf_k
   DO chk_chg
   SELECT b
   fNoShare(cDBFName)
   IF !empty(cNTXStr)
      o_indices()
   ENDIF
   @ 24,0 say 'Packing...'
   PACK
   USE
   @ 24,0 say 'Warning!  Indices may have to be reindexed.'
   inkey(5)
   @ 24,0
   SELECT a
ENDPROCEDURE


***** APPEND RECORDS
PROCEDURE dbf_l
   DO chk_chg
   SELECT b
   fShare(cDBFName)
   IF !empty(cNTXStr)
      o_indices()
   ENDIF
   apfile := space(40)
   @ 24,0 say 'File to append from ...' get apfile picture '@!'
   READ
   @ 24,0
   apfilter := space(200)
   @ 24,0 say 'Append from filter ...' get apfilter picture '@S60'
   READ
   apfilter := trim(apfilter)
   IF empty(apfilter)
      apfilter := '.y.'
   ENDIF
   apfile := trim(apfile)
   IF !'.'$apfile
      apfile := apfile+'.DBF'
   ENDIF
   @ 24,0
   IF !file(apfile)
      @ 24,0 say chr(7)+'Not found'
      inkey(10)
      @ 24,0
      USE
      SELECT a
      RETURN
   ENDIF
   @ 24,0 say 'Appending records...'
   APPEND FROM (apfile) FOR (apfilter)
   USE
   @ 24,0
   SELECT a
ENDPROCEDURE


***** Sets
PROCEDURE dbf_m
   MEMVAR cFilter
   @ 6,1 say 'Enter the number preceding the SET VALUE to toggle:'
   WHILE LOOPING
      @ 8,1 say ' 1. Bell .......................'
      @ 8,col()+1 say iif(set(26), 'On ', 'Off')
      @ row()+1,1 say ' 2. Confirm ....................'
      @ row(),col()+1 say iif(set(27), 'On ', 'Off')
      @ row()+1,1 say ' 3. Cursor .....................'
      @ row(),col()+1 say iif(set(16)>0, 'On ', 'Off')
      @ row()+1,1 say ' 4. Deleted ....................'
      @ row(),col()+1 say iif(set(11), 'On ', 'Off')
      @ row()+1,1 say ' 5. Exact ......................'
      @ row(),col()+1 say iif(set(1), 'On ', 'Off')
      @ row()+1,1 say ' 6. Filter ..................... '+cFilter
      @ row()+1,1 say ' 7. Print ......................'
      @ row(),col()+1 say iif(set(23), 'On ', 'Off')
      @ row()+1,1 say ' 8. Scoreboard .................'
      @ row(),col()+1 say iif(set(32), 'On ', 'Off')
      @ row()+1,1 say ' 9. Softseek ...................'
      @ row(),col()+1 say iif(set(9), 'On ', 'Off')
      @ row()+1,1 say '10. Unique .....................'
      @ row(),col()+1 say iif(set(10), 'On ', 'Off')
      @ row()+1,1 say '11. Wrap .......................'
      @ row(),col()+1 say iif(set(35), 'On ', 'Off')
      xopt := 0
      @ 21,1 say 'Option # to toggle (0=quit):' get xopt picture '99'
      READ
      DO CASE
      CASE xopt=0
         EXIT
      CASE xopt=1
         set(26, !set(26))
      CASE xopt=2
         set(27, !set(27))
      CASE xopt=3
         set(16, !set(16))
      CASE xopt=4
         set(11, !set(11))
      CASE xopt=5
         set(1, !set(1))
      CASE xopt=6
         cFilter := cFilter+space(254-len(cFilter))
         @ 24,0 say 'Current filter: ' get cFilter picture '@KS60'
         READ
         cFilter := trim(cFilter)
         @ 24,0
      CASE xopt=7
         set(23, !set(23))
      CASE xopt=8
         set(32, !set(32))
      CASE xopt=9
         set(9, !set(9))
      CASE xopt=10
         set(10, !set(10))
      CASE xopt=11
         set(35, !set(35))
      ENDCASE
   ENDWHILE
ENDPROCEDURE


***** STATS
PROCEDURE dbf_n
   MEMVAR cFilter
   opt := 1
   @ 24,0 prompt 'Info'
   @ 24,col()+1 prompt 'Count'
   @ 24,col()+1 prompt 'Avg'
   @ 24,col()+1 prompt 'Sum'
   @ 24,col()+1 prompt 'Expr'
   @ 24,col()+1 prompt 'Generators'
   @ 24,col()+1 prompt 'Orphanage'
   @ 24,col()+1 prompt 'Reindex'
   @ 24,col()+1 prompt 'Print'
   @ 24,col()+1 prompt 'Dupl'
   MENU to opt
   @ 24,0
   IF opt=0
      RETURN
   ENDIF
   SELECT b
   fShare(cDBFName)
   IF !empty(cFilter)
      SET FILTER to &(cFilter)
   ENDIF
   DO CASE
   CASE opt=1
      @ 7,40 clear to 20,76
      @ 7,40 say '# records ....'
      @ 8,40 say '# fields .....'
      @ 9,40 say 'Record length '
      @ 7,55 say reccount() picture '9,999,999'
      USE
      SELECT a
      @ 8,55 say reccount() picture '9,999,999'
      SUM field_len to x
      @ 9,55 say x+1 picture '9,999,999'
      @ 24,0 say 'Press any key to continue...'
      inkey(0)
      @ 24,0
      @ 7,40 clear to 20,76
      RETURN
   CASE opt=2
      @ 24,0 say 'Counting...'
      COUNT to x
      @ 24,12 say x picture '9,999,999'
      inkey(0)
      @ 24,0
      USE
      SELECT a
      RETURN
   CASE opt=3
      fld := space(10)
      @ 24,0 say 'Field name or # (precede # with "#"):' get fld picture '@!'
      READ
      IF left(fld,1)="#"
         fld := field(val(substr(fld,2,9)))
      ENDIF
      fld := trim(fld)
      @ 24,0
      @ 24,0 say 'Averaging '+fld+' ...'
      AVERAGE &fld. to x
      @ 24,col()+1 say x
      USE
      SELECT a
      inkey(0)
      RETURN
   CASE opt=4
      fld := space(10)
      @ 24,0 say 'Field name or # (precede # with "#"):' get fld picture '@!'
      READ
      IF left(fld,1)="#"
         fld := field(val(substr(fld,2,9)))
      ENDIF
      fld := trim(fld)
      @ 24,0
      @ 24,0 say 'Summing '+fld+' ...'
      SUM &fld. to x
      @ 24,col()+1 say x
      USE
      SELECT a
      inkey(0)
      RETURN
   CASE opt=5
      exp := space(254)
      @ 24,0 say 'Expression:' get exp picture '@S60'
      READ
      @ 24,0
      exp := trim(exp)
      @ 24,0 say &(exp)
   CASE opt=6
      @ 24,0
      @ 24,0 prompt 'Word Processor'
      @ 24,col()+2 prompt 'Report Generator'
      @ 24,col()+2 prompt 'Label Generator'
      @ 24,col()+2 prompt 'Forms Generator'
      opt := 1
      MENU to opt
      SAVE SCREEN
      IF opt=1
         BecknerWP()
         CLOSE DATA
         SELECT a
         fNoShare('\bvdbase')
      ELSEIF opt=4
         BecknerFG()
         CLOSE DATA
         SELECT a
         fShare('\bvdbase')
      ELSEIF opt!=0
         pRepGen()
         CLOSE DATA
         SELECT a
         fShare('\bvdbase')
      ENDIF
      RESTORE SCREEN
      @ 24,0
   CASE opt=7
      SELECT b
      USE
      secondary := space(200)
      @ 24,0
      @ 24,0 say 'Secondary files:' get secondary picture '@!S50'
      READ
      @ 24,0
      cfn := 'ACCT_NO   '
      @ 24,0 say 'Common field name:' get cfn picture '@!'
      READ
      orphanage(cDBFName,cNTXStr,secondary,cfn)
   CASE opt=8
      IF empty(cNTXStr)
         pBeep()
      ELSE
         SELECT b
         USE
         fNoShare(cDBFName)
         o_indices()
         REINDEX
      ENDIF
   CASE opt=9
      SET CONSOLE off
      SET PRINT on
      ? 'Print file:',cDBFName,cNTXStr
      ? 'Filter:',cFilter
      ? 'Date/Time:',date(),time()
      ?
      ? 'Field list: Recno() '
      FOR x=1 to fcount()
         ?? field(x),''
      NEXT
      ?
      WHILE !eof()
         FOR x := 1 to fcount()
            aa := field(x)
            ?? &aa.,''
         NEXT
         ?
         SKIP
      ENDWHILE
   CASE opt=10
      @ 24, 0
      cExpr := space(500)
      @ 24, 0 say "Index Expression:" get cExpr picture "@S55"
      READ
      @ 24, 0
      cExpr := Trim(cExpr)
      IF !Empty(cExpr)
         vMessageOn("Creating temporary index...")
         INDEX ON (cExpr) to BEC$0
         vMessageOff()
      ENDIF
      GO TOP
      @ 24, 0
      @ 24, 0 say lastrec() picture "99,999,999"
      DECLARE aOldValue[nLen := fCount()]
      FOR nCtr := 1 to nLen
         aOldValue[nCtr] := FieldGet(nCtr)
         IF ValType(aOldValue[nCtr])="N"
            aOldValue[nCtr]++
         ENDIF
      NEXT
      WHILE !eof()
         @ 24, 15 say RecNo() picture "99,999,999"
         lDeleteIt := .y.
         FOR nCtr := 1 to nLen
            IF aOldValue[nCtr]!=FieldGet(nCtr)
               lDeleteIt := .n.
               EXIT
            ENDIF
         NEXT
         IF lDeleteIt
            fLockRec()
            DELETE
            UNLOCK
         ENDIF
         FOR nCtr := 1 to nLen
            aOldValue[nCtr] := FieldGet(nCtr)
         NEXT
         SKIP
      ENDWHILE
      @ 24, 0
   ENDCASE
   pBeep()
   USE
   SELECT a
   IF opt<6
      inkey(0)
   ENDIF
ENDPROCEDURE


FUNCTION dirchk(cWildCard)
   PRIVATE aFiles, nCtr, nLineCtr, nCount
   cWildCard := trim(cWildCard)
   IF cWildCard==''
      cWildCard := '*.DBF'
   ENDIF
   IF !'.'$cWildCard
      cWildCard += '.DBF'
   ENDIF
   nCount := len(aFiles := directory(cWildCard))
   nCtr := 1
   nLineCtr := 9
   WHILE nCtr<=nCount
      @ 9,1 clear to 20,78
      WHILE nCtr++<nCount .and. nLineCtr<=20
         @ nLineCtr,2 say aFiles[nCtr, 1]
         @ row(),15 say aFiles[nCtr, 2] picture '99,999,999'
         @ row(),26 say aFiles[nCtr, 3]
         @ row(),35 say aFiles[nCtr, 4]
         @ row(),45 say aFiles[nCtr, 5]
         nLineCtr++
      ENDWHILE
      @ 22,1 say 'PRESS ANY KEY TO CONTINUE'
      x_x := inkey(0)
      IF lAbort .or. x_x=-7
         EXIT
      ENDIF
      nLineCtr := 9
   ENDWHILE
   RETURN .y.
ENDFUNCTION

FUNCTION modlast
   fld_type := 'R'
   newstuff := oldstuff := space(10)
   CLEAR GETS
   @ 15,1 say 'Old:' get oldstuff picture '@!'
   @ 16,1 say 'New:' get newstuff picture '@!'
   READ
   fld_name := strtran(field_name,trim(oldstuff),trim(newstuff))
   @ 15,1 clear to 16,30
   RETURN .y.
ENDFUNCTION

FUNCTION orphanage()
   LOCAL lFound
   para mainfile,ntxfile,filelist,checkfld
   priv aa,cursel,nCtr
   cursel := select()
   SELECT 0
   fShare(mainfile,'MAIN')
   o_indices()
   SET ORDER to 0
   checkfld := trim(checkfld)
   WHILE !empty(filelist)
      aa := sParse(@filelist,'/')
      SELECT 0
      fShare(aa,'DATA')
      @ 24,0
      @ 24,0 say aa
      @ 24,20 say reccount() picture '9,999,999'
      nCtr := 0
      WHILE !eof()
         @ 24,40 say recno() picture '9,999,999'
         IF deleted()
            SKIP
            LOOP
         ENDIF
         SELECT main
         lFound := .y.
         IF IndexOrd()=0
            IF Data->&CheckFld.>0 .and. Data->&CheckFld.<=LastRec()
               dbGoto(Data->&CheckFld.)
               IF Deleted()
                  lFound := .n.
               ENDIF
            ELSE
               lFound := .n.
            ENDIF
         ELSE
            SEEK data->&checkfld.
            lFound := Found()
         ENDIF
         IF !lFound
            SELECT data
            fLockRec()
            DELETE
            UNLOCK
            nCtr++
            @ 24,60 say nCtr picture '9,999,999'
         ENDIF
         SELECT data
         SKIP
      ENDWHILE
      USE
      SELECT main
   ENDWHILE
   @ 24,0
   USE
   SELECT (cursel)
   RETURN 0
ENDFUNCTION

FUNCTION o_indices
   IF !','$cNTXStr
      SET INDEX to (cNTXStr)
      RETURN 0
   ENDIF
   n := cNTXStr
   DO CASE
   CASE sCount(',',n)=0
      SET INDEX to (sParse(@n,',')),;
      (n)
   CASE sCount(',',n)=1
      SET INDEX to (sParse(@n,',')),;
      (sParse(@n,',')),;
      (n)
   CASE sCount(',',n)=2
      SET INDEX to (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (n)
   CASE sCount(',',n)=3
      SET INDEX to (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (n)
   CASE sCount(',',n)=4
      SET INDEX to (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (n)
   CASE sCount(',',n)=5
      SET INDEX to (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (n)
   CASE sCount(',',n)=6
      SET INDEX to (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (n)
   CASE sCount(',',n)=7
      SET INDEX to (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (n)
   CASE sCount(',',n)=8
      SET INDEX to (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (n)
   CASE sCount(',',n)=9
      SET INDEX to (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (n)
   CASE sCount(',',n)=10
      SET INDEX to (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (n)
   CASE sCount(',',n)=11
      SET INDEX to (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (n)
   CASE sCount(',',n)=12
      SET INDEX to (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (n)
   CASE sCount(',',n)=13
      SET INDEX to (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (sParse(@n,',')),;
      (n)
   ENDCASE
   RETURN 0
ENDFUNCTION
