/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990, 1991, 1992 BecknerVision Inc - All Rights Reserved

    Written by John Wm Beckner        THIS NOTICE MUST NOT BE REMOVED
    BecknerVision Inc
    PO Box 11945                      DISTRIBUTE ONLY WITH SHAREWARE
    Winston-Salem NC 27116            VERSION OF THIS PRODUCT.
    Fax: 919/760-1003

*/

#include "beckner.inc"
#include "alias.ch"
#include "inkey.ch"

#define EXAMPLE_HDR '#include "beckner.inc"'+CRLF+"FUNCTION TestFunc()"+CRLF+"   LOCAL "

FUNCTION Documentor(cPrefix)
   LOCAL cVersion := "0.2", cTemp, nOption
	DEFAULT cPrefix TO "u:\docs\ng"
	cPrefix := StrTran(cPrefix+"\", "\\", "\")
	SET KEY K_F9	TO pCtrlW
	SET DELETED ON
	vBackground(Chr(176))
	iif(IsColor(), SetColor("b/w, gr+/n, , , n+/w"),)
	vTitle({"BecknerVision Library Documentor",;
			"Written by John Wm Beckner",;
			"Copyright (c)1992 BecknerVision Inc - All Rights Reserved",;
			"Version "+cVersion})
	vMessageOn("Initializing...")
	IF !File("\DocFunc.dbf")
		cTemp := "\DocFunc/FuncID/N/4//FuncName/C/20/ReturnVal/C/26/HelpFile/C/8/"
		cTemp += "ReturnDesc/C/50/FuncDesc/M/Examples/M/SeeAlso/C/200/"
		cTemp += "FuncDesc1/C/50"
		fCreateDBF(cTemp)
	ENDIF
	IF !File("\DocArg.dbf")
		cTemp := "\DocArg/FuncID/N/4//ArgSeqNo/N/3//ArgDesc/M/Optional/L/"
		cTemp += "Default/C/20/ArgName/C/20"
		fCreateDBF(cTemp)
	ENDIF
	fShare("\DocArg", "Argument")
	IF !File("\DocArg.ntx")
		INDEX ON Argument->FuncID TO \DocArg
	ENDIF
	SET INDEX TO \DocArg
	fShare("\DocFunc", "Library")
	IF !File("\DocFunc.ntx")
		INDEX ON Library->HelpFile+Library->FuncName TO \DocFunc
	ENDIF
	SET INDEX TO \DocFunc
	vMessageOff()
	WHILE LOOPING
      nOption := vMenu("T/Add/Copy/Browse/Generate/Exit")
		DO CASE
			CASE nOption=1
				AddFunc()
         CASE nOption=2
            CopyFunc()
         CASE nOption=3
				Library->(fBrowse())
         CASE nOption=4
				Generate(cPrefix)
         CASE nOption=5
				EXIT
		ENDCASE
	ENDWHILE
ENDFUNCTION

STATIC FUNCTION AddFunc()
	LOCAL aRC, GetList := {}, nCtr, cHelpFile
	GO BOTTOM ALIAS Library
	cHelpFile 			:= Library->HelpFile
	ADDRECORD ALIAS Library
	Library->FuncID 	:= RecNo()
	Library->HelpFile	:= cHelpFile
	Library->Examples := EXAMPLE_HDR
	vSave(9, 78)
	aRC := vWindow(9, 78, .y., "Function Information")
	@ aRC[1],  aRC[2] SAY "ID # ............." GET Library->FuncID
	@ Row()+1, aRC[2] SAY "Filename ........." GET Library->HelpFile
	@ Row()+1, aRC[2] SAY "Name ............." GET Library->FuncName
	@ Row()+1, aRC[2] SAY "1-line description" GET Library->FuncDesc1
	@ Row()+1, aRC[2] SAY "Description ......" GET Library->FuncDesc;
			MEMO AT 3, 3, 8, 75
	@ Row()+1, aRC[2] SAY "Return value ....." GET Library->ReturnVal
	@ Row()+1, aRC[2] SAY "Return description" GET Library->ReturnDesc
	@ Row()+1, aRC[2] SAY "Examples ........." GET Library->Examples;
			MEMO AT 16, 2, MaxRow(), 76
	@ Row()+1, aRC[2] SAY "See also ........." GET Library->SeeAlso;
			PICTURE "@S50"
	READ
	UNLOCK ALIAS Library
	vRestore()
	nCtr := 0
	vSave(5, 78)
	aRC := vWindow(5, 78, .y., "Arguments for "+Trim(Library->FuncName)+"()")
	WHILE LOOPING
		ADDRECORD ALIAS Argument
		Argument->FuncID 		:= Library->FuncID
		Argument->ArgSeqNo	:= ++nCtr
		@ aRC[1],  aRC[2] SAY "Argument #"+sMake(nCtr)
		@ Row()+1, aRC[2] SAY "Name ..............." GET Argument->ArgName
		@ Row()+1, aRC[2] SAY "Description ........" GET Argument->ArgDesc;
				MEMO AT 15, 10, 20, 60
		@ Row()+1, aRC[2] SAY "Optional (Y/N)? ...." GET Argument->Optional;
				PICTURE "Y"
		@ Row()+1, aRC[2] SAY "Default value ......" GET Argument->Default
		READ
		UNLOCK ALIAS Argument
		IF Empty(Argument->ArgName)
			EXIT
		ENDIF
	ENDWHILE
	DELETE ALIAS Argument
	vRestore()
ENDFUNCTION

STATIC FUNCTION CopyFunc()
   LOCAL aRC, GetList := {}, nCtr, cHelpFile, cName, cDesc1, cDesc, cRetVal
   LOCAL cRetDesc, cExamples, cSeeAlso
	GO BOTTOM ALIAS Library
	cHelpFile 			:= Library->HelpFile
   fBrowse()
   cName     := Library->FuncName
   cDesc1    := Library->FuncDesc1
   cDesc     := Library->FuncDesc
   cRetVal   := Library->ReturnVal
   cRetDesc  := Library->ReturnDesc
   cExamples := Library->Examples
   cSeeAlso  := Library->SeeAlso
   ADDRECORD ALIAS Library
   Library->FuncID     := RecNo()
   Library->HelpFile   := cHelpFile
   Library->FuncName   := cName
   Library->FuncDesc1  := cDesc1
   Library->FuncDesc   := cDesc
   Library->ReturnVal  := cRetVal
   Library->ReturnDesc := cRetDesc
   Library->Examples   := cExamples
   Library->SeeAlso    := cSeeAlso
   vSave(9, 78)
	aRC := vWindow(9, 78, .y., "Function Information")
	@ aRC[1],  aRC[2] SAY "ID # ............." GET Library->FuncID
	@ Row()+1, aRC[2] SAY "Filename ........." GET Library->HelpFile
	@ Row()+1, aRC[2] SAY "Name ............." GET Library->FuncName
	@ Row()+1, aRC[2] SAY "1-line description" GET Library->FuncDesc1
	@ Row()+1, aRC[2] SAY "Description ......" GET Library->FuncDesc;
			MEMO AT 3, 3, 8, 75
	@ Row()+1, aRC[2] SAY "Return value ....." GET Library->ReturnVal
	@ Row()+1, aRC[2] SAY "Return description" GET Library->ReturnDesc
	@ Row()+1, aRC[2] SAY "Examples ........." GET Library->Examples;
			MEMO AT 16, 2, MaxRow(), 76
	@ Row()+1, aRC[2] SAY "See also ........." GET Library->SeeAlso;
			PICTURE "@S50"
	READ
	UNLOCK ALIAS Library
	vRestore()
	nCtr := 0
	vSave(5, 78)
	aRC := vWindow(5, 78, .y., "Arguments for "+Trim(Library->FuncName)+"()")
	WHILE LOOPING
		ADDRECORD ALIAS Argument
		Argument->FuncID 		:= Library->FuncID
		Argument->ArgSeqNo	:= ++nCtr
		@ aRC[1],  aRC[2] SAY "Argument #"+sMake(nCtr)
		@ Row()+1, aRC[2] SAY "Name ..............." GET Argument->ArgName
		@ Row()+1, aRC[2] SAY "Description ........" GET Argument->ArgDesc;
				MEMO AT 15, 10, 20, 60
		@ Row()+1, aRC[2] SAY "Optional (Y/N)? ...." GET Argument->Optional;
				PICTURE "Y"
		@ Row()+1, aRC[2] SAY "Default value ......" GET Argument->Default
		READ
		UNLOCK ALIAS Argument
		IF Empty(Argument->ArgName)
			EXIT
		ENDIF
	ENDWHILE
	DELETE ALIAS Argument
	vRestore()
ENDFUNCTION

STATIC FUNCTION Generate(cPrefix)
	LOCAL nExpertHelp, cLastFile := Chr(1), cArgList, nCtr, nTemp
	vMessageOn("Generating HyperText files...")
	GO TOP ALIAS Library
	WHILE !Library->(eof())
		IF cLastFile!=Library->HelpFile
			cLastFile := Library->HelpFile
			iif(nExpertHelp!=NIL, fClose(nExpertHelp),)
			nExpertHelp := fCreate(cPrefix+cLastFile+".txt")
		ENDIF
		fWriteLine(nExpertHelp, "!short: "+sSetLength(Trim(Library->FuncName)+;
				"()", 20)+Trim(Library->FuncDesc1))
		fWriteLine(nExpertHelp, "'"+Replicate("-", 78))
		fWriteLine(nExpertHelp, "^b"+Trim(Library->FuncName)+"()"+"^b")
		fWriteLine(nExpertHelp, Trim(Library->FuncDesc1))
		fWriteLine(nExpertHelp, Replicate(Chr(196), 78))
		fWriteLine(nExpertHelp)
		fWriteLine(nExpertHelp, "^bSyntax^b")
		fWriteLine(nExpertHelp)
		fWrite(nExpertHelp, "    "+Trim(Library->FuncName)+"(")
		cArgList := ""
		SEEK Library->FuncID ALIAS Argument
		IF Argument->(Found())
			WHILE Library->FuncID=Argument->FuncID .and. !Argument->(eof())
				cArgList += iif(Argument->Optional, "[", "")+"<"+;
						Trim(Argument->ArgName)+">"+iif(Argument->Optional, "]",;
						"")+", "
				SKIP ALIAS Argument
			ENDWHILE
		ENDIF
		cArgList := Left(cArgList, Len(cArgList)-2)+"^u) --> "+;
				Trim(Library->ReturnVal)
		FOR nCtr := 1 TO mlCount(cArgList, 50)
			fWriteLine(nExpertHelp, iif(nCtr>1, Space(24), "")+;
					"^u"+Trim(MemoLine(cArgList, 50, nCtr))+"^u")
		NEXT
		fWriteLine(nExpertHelp)
		fWriteLine(nExpertHelp, "^bArguments^b")
		fWriteLine(nExpertHelp)
		SEEK Library->FuncID ALIAS Argument
		IF Argument->(Found())
			WHILE Library->FuncID=Argument->FuncID .and. !Argument->(eof())
				nTemp := mlCount(Argument->ArgDesc, 50)-1
				fWriteLine(nExpertHelp, "    ^b<"+Trim(Argument->ArgName)+">^b is "+;
						Trim(MemoLine(Argument->ArgDesc, 50, 1))+iif(nTemp>1, "",;
						iif(!Empty(Argument->Default),;
						" ["+Trim(Argument->Default)+"]", "")))
				FOR nCtr := 2 TO nTemp
					fWriteLine(nExpertHelp, Space(15)+;
					Trim(MemoLine(Argument->ArgDesc,	50, nCtr)))
				NEXT
				iif(nTemp>1, fWriteLine(nExpertHelp, Space(15)+;
						Trim(MemoLine(Argument->ArgDesc, 50, nTemp))+;
						iif(!Empty(Argument->Default), " ["+;
						Trim(Argument->Default)+"]", "")),)
				fWriteLine(nExpertHelp)
				SKIP ALIAS Argument
			ENDWHILE
		ELSE
			fWriteLine(nExpertHelp, "    none")
			fWriteLine(nExpertHelp)
		ENDIF
		fWriteLine(nExpertHelp, "^bReturns^b")
		fWriteLine(nExpertHelp)
		fWriteLine(nExpertHelp, "    "+Trim(Library->FuncName)+"() returns "+;
				Trim(Library->ReturnDesc))
		fWriteLine(nExpertHelp)
		fWriteLine(nExpertHelp, "^bDescription^b")
		fWriteLine(nExpertHelp)
		FOR nCtr := 1 TO mlCount(Library->FuncDesc, 72)
			fWriteLine(nExpertHelp, "    "+MemoLine(Library->FuncDesc, 72, nCtr))
		NEXT
		fWriteLine(nExpertHelp)
		fWriteLine(nExpertHelp, "^bExamples^b")
		fWriteLine(nExpertHelp)
		FOR nCtr := 1 TO mlCount(Library->Examples)
			fWriteLine(nExpertHelp, "    "+MemoLine(Library->Examples, 72, nCtr))
		NEXT
		iif(!Empty(Library->SeeAlso), fWriteLine(nExpertHelp, "!seealso: "+;
				Trim(Library->SeeAlso)),)
		fWriteLine(nExpertHelp, "'"+Replicate("-", 78))
		SKIP ALIAS Library
	ENDWHILE
	fClose(nExpertHelp)
	vMessageOff()
ENDFUNCTION

FUNCTION fFields2Get()
	LOCAL nCtr, aStructure := dbStruct(), nFields := Len(aStructure)
	LOCAL GetList[nFields]
	FOR nCtr := 1 TO nFields
		GetList[nCtr]			:= GetNew()
		GetList[nCtr]:block		:= FieldWBlock(FieldName(nCtr), Select())
		GetList[nCtr]:cargo		:= {}
		GetList[nCtr]:reader	:= {|oGet| vGet(oGet)}
	NEXT
	RETURN GetList
ENDFUNCTION
